/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.directory.SearchControls;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.ldap.LDAPFilterQueryBuilder;
import org.wso2.carbon.user.core.model.ExpressionAttribute;
import org.wso2.carbon.user.core.model.ExpressionCondition;
import org.wso2.carbon.user.core.model.ExpressionOperation;

public class LDAPSearchSpecification {
    private static final String EQUALS_SIGN = "=";
    private static final String SERVICE_NAME_ATTRIBUTE = "sn";
    private static final String VALUE_SEPARATOR = ",";
    private RealmConfiguration realmConfig;
    private SearchControls searchControls = new SearchControls();
    private String searchBases = null;
    private LDAPFilterQueryBuilder ldapFilterQueryBuilder = null;
    private boolean isUsernameFiltering = false;
    private boolean isClaimFiltering = false;
    private boolean isGroupFiltering = false;
    private boolean isMultiGroupFiltering = false;
    private boolean isMemberOfPropertyFound = false;
    private boolean isMemberShipPropertyFound = false;

    public LDAPSearchSpecification(RealmConfiguration realmConfig, List<ExpressionCondition> expressionConditions) throws UserStoreException {
        this.realmConfig = realmConfig;
        this.searchControls.setSearchScope(2);
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName()) && this.isGroupFiltering) {
                this.isMultiGroupFiltering = true;
                continue;
            }
            if (ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName())) {
                this.isGroupFiltering = true;
                continue;
            }
            if (ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                this.isUsernameFiltering = true;
                continue;
            }
            this.isClaimFiltering = true;
        }
        this.setLDAPSearchParamters(expressionConditions);
    }

    private void setLDAPSearchParamters(List<ExpressionCondition> expressionConditions) throws UserStoreException {
        ArrayList<String> returnedAttributes = new ArrayList<String>();
        if (this.isGroupFiltering) {
            this.checkForMemberOfAttribute(expressionConditions, returnedAttributes);
            if (!this.isMemberOfPropertyFound) {
                this.checkForMembershipAttribute(returnedAttributes);
            }
        } else {
            this.searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
            returnedAttributes.add(this.realmConfig.getUserStoreProperty("UserNameAttribute"));
            returnedAttributes.add(SERVICE_NAME_ATTRIBUTE);
        }
        if (CollectionUtils.isNotEmpty(returnedAttributes)) {
            this.searchControls.setReturningAttributes(returnedAttributes.toArray(new String[0]));
        }
        this.searchFilterBuilder(this.isGroupFiltering, this.isMultiGroupFiltering, expressionConditions);
    }

    private void checkForMembershipAttribute(List<String> returnedAttributes) throws UserStoreException {
        String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
        if (StringUtils.isEmpty((String)membershipProperty)) {
            throw new UserStoreException("Please set member of attribute or membership attribute");
        }
        this.isMemberShipPropertyFound = true;
        this.searchBases = this.realmConfig.getUserStoreProperty("GroupSearchBase");
        returnedAttributes.add(membershipProperty);
    }

    private void checkForMemberOfAttribute(List<ExpressionCondition> expressionConditions, List<String> returnedAttributes) {
        String memberOfProperty;
        boolean isEqOperationFound = false;
        boolean otherOperationsFound = false;
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName()) && ExpressionOperation.EQ.toString().equals(expressionCondition.getOperation())) {
                isEqOperationFound = true;
                continue;
            }
            if (!ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName()) || ExpressionOperation.EQ.toString().equals(expressionCondition.getOperation())) continue;
            otherOperationsFound = true;
        }
        if (isEqOperationFound && !otherOperationsFound && StringUtils.isNotEmpty((String)(memberOfProperty = this.realmConfig.getUserStoreProperty("MemberOfAttribute")))) {
            this.isMemberOfPropertyFound = true;
            this.searchBases = this.realmConfig.getUserStoreProperty("UserSearchBase");
            returnedAttributes.add(this.realmConfig.getUserStoreProperty("UserNameAttribute"));
        }
    }

    private void searchFilterBuilder(boolean isGroupFiltering, boolean isMultiGroupFiltering, List<ExpressionCondition> expressionConditions) throws UserStoreException {
        String userPropertyName = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String groupPropertyName = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
        String memberOfAttributeName = this.realmConfig.getUserStoreProperty("MemberOfAttribute");
        String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
        this.initiateLDAPQueryBuilder(isGroupFiltering);
        for (ExpressionCondition expressionCondition : expressionConditions) {
            StringBuilder property;
            String attributeName = expressionCondition.getAttributeName();
            StringBuilder value = new StringBuilder(expressionCondition.getAttributeValue());
            String operation = expressionCondition.getOperation();
            boolean isMembershipMultiGroupFilters = false;
            if (ExpressionAttribute.ROLE.toString().equals(attributeName)) {
                if (this.isMemberOfPropertyFound) {
                    property = this.getMemberOfProperty(groupPropertyName, memberOfAttributeName, value, operation);
                } else if (isMultiGroupFiltering && !this.isMemberOfPropertyFound) {
                    property = new StringBuilder(groupPropertyName);
                    isMembershipMultiGroupFilters = true;
                } else {
                    property = new StringBuilder(groupPropertyName);
                }
            } else if (ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName()) ? (property = this.getUserNameProperty(userPropertyName, memberAttributeName, value, operation)) == null : (property = this.getClaimProperty(expressionCondition)) == null) continue;
            ExpressionCondition condition = new ExpressionCondition(operation, String.valueOf(property), String.valueOf(value));
            this.ldapFilterQueryBuilder.addFilter(condition, isMembershipMultiGroupFilters);
        }
    }

    private void initiateLDAPQueryBuilder(boolean isGroupFiltering) {
        this.ldapFilterQueryBuilder = isGroupFiltering && this.isMemberShipPropertyFound ? new LDAPFilterQueryBuilder(this.realmConfig.getUserStoreProperty("GroupNameListFilter")) : new LDAPFilterQueryBuilder(this.realmConfig.getUserStoreProperty("UserNameListFilter"));
    }

    private StringBuilder getMemberOfProperty(String groupPropertyName, String memberOfAttributeName, StringBuilder value, String operation) throws UserStoreException {
        if (!ExpressionOperation.EQ.toString().equals(operation)) {
            throw new UserStoreException("MemberOf attribute only support 'EQ' filter operation.");
        }
        StringBuilder property = new StringBuilder(memberOfAttributeName).append(EQUALS_SIGN).append(groupPropertyName);
        value.append(VALUE_SEPARATOR).append(this.realmConfig.getUserStoreProperty("GroupSearchBase"));
        return property;
    }

    private StringBuilder getUserNameProperty(String userPropertyName, String memberAttributeName, StringBuilder value, String operation) {
        StringBuilder property;
        if (this.isMemberShipPropertyFound) {
            property = this.getMembershipProperty(userPropertyName, memberAttributeName, value, operation);
            if (property == null) {
                return null;
            }
        } else {
            property = new StringBuilder(userPropertyName);
        }
        return property;
    }

    private StringBuilder getMembershipProperty(String userPropertyName, String memberAttributeName, StringBuilder value, String operation) {
        StringBuilder property = new StringBuilder(memberAttributeName).append(EQUALS_SIGN).append(userPropertyName);
        if (ExpressionOperation.CO.toString().equals(operation) || ExpressionOperation.EW.toString().equals(operation)) {
            return null;
        }
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            value.append(VALUE_SEPARATOR).append(this.realmConfig.getUserStoreProperty("UserSearchBase"));
        }
        return property;
    }

    private StringBuilder getClaimProperty(ExpressionCondition expressionCondition) {
        if (this.isMemberShipPropertyFound) {
            return null;
        }
        StringBuilder property = new StringBuilder(expressionCondition.getAttributeName());
        return property;
    }

    public SearchControls getSearchControls() {
        return this.searchControls;
    }

    public String getSearchBases() {
        return this.searchBases;
    }

    public boolean isGroupFiltering() {
        return this.isGroupFiltering;
    }

    public boolean isUsernameFiltering() {
        return this.isUsernameFiltering;
    }

    public boolean isClaimFiltering() {
        return this.isClaimFiltering;
    }

    public boolean isMemberOfPropertyFound() {
        return this.isMemberOfPropertyFound;
    }

    public boolean isMemberShipPropertyFound() {
        return this.isMemberShipPropertyFound;
    }

    public String getSearchFilterQuery() {
        return this.ldapFilterQueryBuilder.getSearchFilterQuery();
    }
}

