/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.dto.CorrelationLogDTO;
import org.wso2.carbon.user.core.ldap.LdapContextWrapper;
import org.wso2.carbon.user.core.ldap.NonVerifyingSSLSocketFactory;
import org.wso2.carbon.user.core.ldap.SRVRecord;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;

public class LDAPConnectionContext {
    private static Log log = LogFactory.getLog(LDAPConnectionContext.class);
    private Hashtable environment;
    private SortedMap<Integer, SRVRecord> dcMap;
    private Hashtable environmentForDNS;
    private String DNSDomainName;
    private boolean readOnly = false;
    private static final String CONNECTION_TIME_OUT = "LDAPConnectionTimeout";
    private static final String READ_TIME_OUT = "ReadTimeout";
    private static final Log correlationLog = LogFactory.getLog((String)"correlation");
    private static String initialContextFactoryClass = "com.sun.jndi.dns.DnsContextFactory";
    private static final String CORRELATION_LOG_CALL_TYPE_VALUE = "ldap";
    private static final String CORRELATION_LOG_INITIALIZATION_METHOD_NAME = "initialization";
    private static final String CORRELATION_LOG_INITIALIZATION_ARGS = "empty";
    private static final int CORRELATION_LOG_INITIALIZATION_ARGS_LENGTH = 0;
    private static final String CORRELATION_LOG_SEPARATOR = "|";
    private static final String CORRELATION_LOG_SYSTEM_PROPERTY = "enableCorrelationLogs";
    public static final String CIRCUIT_STATE_OPEN = "open";
    public static final String CIRCUIT_STATE_CLOSE = "close";
    private String ldapConnectionCircuitBreakerState;
    private long thresholdTimeoutInMilliseconds;
    private long thresholdStartTime;
    private boolean startTLSEnabled;

    public LDAPConnectionContext(RealmConfiguration realmConfig) throws UserStoreException {
        String binaryAttribute;
        String DNSUrl = realmConfig.getUserStoreProperty("URLOfDNS");
        if (DNSUrl != null) {
            this.DNSDomainName = realmConfig.getUserStoreProperty("DNSDomainName");
            if (this.DNSDomainName == null) {
                throw new UserStoreException("DNS is enabled, but DNS domain name not provided.");
            }
            this.environmentForDNS = new Hashtable();
            this.environmentForDNS.put("java.naming.factory.initial", initialContextFactoryClass);
            this.environmentForDNS.put("java.naming.provider.url", DNSUrl);
            this.populateDCMap();
            String readOnlyString = realmConfig.getUserStoreProperty("ReadOnly");
            if (readOnlyString != null) {
                this.readOnly = Boolean.parseBoolean(readOnlyString);
            }
        }
        String rawConnectionURL = realmConfig.getUserStoreProperty("ConnectionURL");
        String connectionURL = null;
        if (rawConnectionURL != null) {
            String portInfo = rawConnectionURL.split(":")[2];
            String port = null;
            if (portInfo.contains("${") && portInfo.contains("}")) {
                port = Integer.toString(CarbonUtils.getPortFromServerConfig((String)portInfo));
            }
            connectionURL = port != null ? rawConnectionURL.replace(portInfo, port) : realmConfig.getUserStoreProperty("ConnectionURL");
        }
        String connectionName = realmConfig.getUserStoreProperty("ConnectionName");
        String connectionPassword = realmConfig.getUserStoreProperty("ConnectionPassword");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection Name :: " + connectionName + ", Connection URL :: " + connectionURL));
        }
        this.environment = new Hashtable();
        String initialContextFactory = realmConfig.getUserStoreProperty("LDAPInitialContextFactory");
        if (initialContextFactory == null || initialContextFactory.isEmpty()) {
            initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
        }
        this.environment.put("java.naming.factory.initial", initialContextFactory);
        this.environment.put("java.naming.security.authentication", "simple");
        this.environment.put("org.wso2.carbon.context.RequestBaseContext", "true");
        if (connectionName != null) {
            this.environment.put("java.naming.security.principal", connectionName);
        }
        if (connectionPassword != null) {
            this.environment.put("java.naming.security.credentials", connectionPassword);
        }
        if (connectionURL != null) {
            this.environment.put("java.naming.provider.url", connectionURL);
        }
        boolean isLDAPConnectionPoolingEnabled = false;
        String value = realmConfig.getUserStoreProperty("ConnectionPoolingEnabled");
        if (value != null && !value.trim().isEmpty()) {
            isLDAPConnectionPoolingEnabled = Boolean.parseBoolean(value);
        }
        this.environment.put("com.sun.jndi.ldap.connect.pool", isLDAPConnectionPoolingEnabled ? "true" : "false");
        if (realmConfig.getUserStoreProperty("Referral") != null) {
            this.environment.put("java.naming.referral", realmConfig.getUserStoreProperty("Referral"));
        }
        if ((binaryAttribute = realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary")) != null) {
            this.environment.put("java.naming.ldap.attributes.binary", binaryAttribute);
        }
        String connectTimeout = realmConfig.getUserStoreProperty(CONNECTION_TIME_OUT);
        String readTimeout = realmConfig.getUserStoreProperty(READ_TIME_OUT);
        if (connectTimeout != null && !connectTimeout.trim().isEmpty()) {
            this.environment.put("com.sun.jndi.ldap.connect.timeout", connectTimeout);
        } else {
            this.environment.put("com.sun.jndi.ldap.connect.timeout", "5000");
        }
        if (StringUtils.isNotEmpty((String)readTimeout)) {
            this.environment.put("com.sun.jndi.ldap.read.timeout", readTimeout);
        } else {
            this.environment.put("com.sun.jndi.ldap.read.timeout", "5000");
        }
        boolean isSSLCertificateValidationEnabled = true;
        String valueForSSLCertificateValidationEnabled = realmConfig.getUserStoreProperty("SSLCertificateValidationEnabled");
        if (StringUtils.isNotEmpty((String)valueForSSLCertificateValidationEnabled)) {
            isSSLCertificateValidationEnabled = Boolean.parseBoolean(valueForSSLCertificateValidationEnabled);
        }
        if (!isSSLCertificateValidationEnabled) {
            this.environment.put("java.naming.ldap.factory.socket", NonVerifyingSSLSocketFactory.class.getName());
        }
        this.startTLSEnabled = Boolean.parseBoolean(realmConfig.getUserStoreProperty("StartTLSEnabled"));
        String retryWaitingTime = realmConfig.getUserStoreProperty("ConnectionRetryDelay");
        this.thresholdTimeoutInMilliseconds = StringUtils.isNotEmpty((String)retryWaitingTime) ? this.getThresholdTimeoutInMilliseconds(retryWaitingTime) : 120000L;
        this.ldapConnectionCircuitBreakerState = CIRCUIT_STATE_CLOSE;
        this.thresholdStartTime = 0L;
    }

    public DirContext getContext() throws UserStoreException {
        DirContext context = null;
        switch (this.ldapConnectionCircuitBreakerState) {
            case "open": {
                long circuitOpenDuration = System.currentTimeMillis() - this.thresholdStartTime;
                if (circuitOpenDuration >= this.thresholdTimeoutInMilliseconds) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying to obtain LDAP connection, connection URL: " + this.environment.get("java.naming.provider.url") + " when circuit breaker state: " + this.ldapConnectionCircuitBreakerState + " and circuit breaker open duration: " + circuitOpenDuration + "ms."));
                        }
                        context = this.getDirContext();
                        this.ldapConnectionCircuitBreakerState = CIRCUIT_STATE_CLOSE;
                        this.thresholdStartTime = 0L;
                        break;
                    }
                    catch (UserStoreException e) {
                        log.error((Object)("Error occurred while obtaining LDAP connection. Connection URL: " + this.environment.get("java.naming.provider.url")), (Throwable)((Object)e));
                        this.thresholdStartTime = System.currentTimeMillis();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("LDAP connection circuit breaker state set to: " + this.ldapConnectionCircuitBreakerState));
                        }
                        throw new UserStoreException("Error occurred while obtaining LDAP connection.", (Throwable)((Object)e));
                    }
                }
                throw new UserStoreException("LDAP connection circuit breaker is in open state for " + circuitOpenDuration + "ms and has not reach the threshold timeout: " + this.thresholdTimeoutInMilliseconds + "ms, hence avoid establishing the LDAP connection.");
            }
            case "close": {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LDAP connection circuit breaker state: " + this.ldapConnectionCircuitBreakerState + ", so trying to obtain the LDAP connection, connection URL: " + this.environment.get("java.naming.provider.url")));
                    }
                    context = this.getDirContext();
                    break;
                }
                catch (UserStoreException e) {
                    log.error((Object)("Error occurred while obtaining LDAP connection. Connection URL: " + this.environment.get("java.naming.provider.url")), (Throwable)((Object)e));
                    log.error((Object)"Trying again to get connection.");
                    try {
                        context = this.getDirContext();
                        break;
                    }
                    catch (Exception e1) {
                        log.error((Object)"Error occurred while obtaining connection for the second time.", (Throwable)e1);
                        this.ldapConnectionCircuitBreakerState = CIRCUIT_STATE_OPEN;
                        this.thresholdStartTime = System.currentTimeMillis();
                        throw new UserStoreException("Error occurred while obtaining LDAP connection, LDAP connection circuit breaker state set to: " + this.ldapConnectionCircuitBreakerState, e1);
                    }
                }
            }
            default: {
                throw new UserStoreException("Unknown LDAP connection circuit breaker state.");
            }
        }
        return context;
    }

    private DirContext getDirContext() throws UserStoreException {
        LdapContext context = null;
        if (this.dcMap == null) {
            try {
                context = this.getLdapContext(this.environment, null);
            }
            catch (NamingException e) {
                log.error((Object)("Error obtaining connection. " + e.getMessage()), (Throwable)e);
                log.error((Object)"Trying again to get connection.");
                try {
                    context = this.getLdapContext(this.environment, null);
                }
                catch (Exception e1) {
                    log.error((Object)("Error obtaining connection for the second time" + e.getMessage()), (Throwable)e);
                    throw new UserStoreException("Error obtaining connection. " + e.getMessage(), e);
                }
            }
        } else if (this.dcMap != null && this.dcMap.size() != 0) {
            try {
                Integer firstKey = this.dcMap.firstKey();
                SRVRecord firstRecord = (SRVRecord)this.dcMap.get(firstKey);
                this.environment.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(firstRecord));
                context = this.getLdapContext(this.environment, null);
            }
            catch (NamingException e) {
                log.error((Object)("Error obtaining connection to first Domain Controller." + e.getMessage()), (Throwable)e);
                log.info((Object)"Trying to connect with other Domain Controllers");
                for (Integer integer : this.dcMap.keySet()) {
                    try {
                        SRVRecord srv = (SRVRecord)this.dcMap.get(integer);
                        this.environment.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(srv));
                        context = this.getLdapContext(this.environment, null);
                        break;
                    }
                    catch (NamingException e1) {
                        if (integer != this.dcMap.lastKey()) continue;
                        log.error((Object)("Error obtaining connection for all " + integer + " Domain Controllers." + e.getMessage()), (Throwable)e);
                        throw new UserStoreException("Error obtaining connection. " + e.getMessage(), e);
                    }
                }
            }
        }
        return context;
    }

    @Deprecated
    public void updateCredential(String connectionPassword) {
        this.environment.put("java.naming.security.credentials", connectionPassword);
    }

    public void updateCredential(Object connectionPassword) throws UserStoreException {
        Secret connectionPasswordObj;
        try {
            connectionPasswordObj = Secret.getSecret((Object)connectionPassword);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        byte[] passwordBytes = connectionPasswordObj.getBytes();
        this.environment.put("java.naming.security.credentials", Arrays.copyOf(passwordBytes, passwordBytes.length));
        connectionPasswordObj.clear();
    }

    private void populateDCMap() throws UserStoreException {
        try {
            InitialDirContext dnsContext = new InitialDirContext(this.environmentForDNS);
            String DNSServiceName = "_ldap._tcp." + this.DNSDomainName;
            Attributes attributes = dnsContext.getAttributes(DNSServiceName, new String[]{"SRV"});
            Attribute srvRecords = attributes.get("SRV");
            NamingEnumeration<?> srvValues = srvRecords.getAll();
            this.dcMap = new TreeMap<Integer, SRVRecord>();
            while (srvValues.hasMore()) {
                String host;
                String port;
                String weight;
                String value = srvValues.next().toString();
                SRVRecord srvRecord = new SRVRecord();
                String[] valueItems = value.split(" ");
                String priority = valueItems[0];
                if (priority != null) {
                    int priorityInt = Integer.parseInt(priority);
                    srvRecord.setPriority(priorityInt);
                }
                if ((weight = valueItems[1]) != null) {
                    srvRecord.setWeight(Integer.parseInt(weight));
                }
                if ((port = valueItems[2]) != null) {
                    srvRecord.setPort(Integer.parseInt(port));
                }
                if ((host = valueItems[3]) != null) {
                    srvRecord.setHostName(host);
                }
                this.dcMap.put(srvRecord.getPriority(), srvRecord);
            }
            for (SRVRecord srvRecord : this.dcMap.values()) {
                Attributes hostAttributes = dnsContext.getAttributes(srvRecord.getHostName(), new String[]{"A"});
                Attribute hostRecord = hostAttributes.get("A");
                srvRecord.setHostIP((String)hostRecord.get());
            }
        }
        catch (NamingException e) {
            log.error((Object)("Error obtaining information from DNS Server" + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Error obtaining information from DNS Server " + e.getMessage(), e);
        }
    }

    private String getLDAPURLFromSRVRecord(SRVRecord srvRecord) {
        String ldapURL = null;
        ldapURL = this.readOnly ? "ldap://" + srvRecord.getHostIP() + ":" + srvRecord.getPort() : "ldaps://" + srvRecord.getHostIP() + ":" + srvRecord.getPort();
        return ldapURL;
    }

    @Deprecated
    public LdapContext getContextWithCredentials(String userDN, String password) throws UserStoreException, NamingException, AuthenticationException {
        LdapContext context = null;
        switch (this.ldapConnectionCircuitBreakerState) {
            case "open": {
                long circuitOpenDuration = System.currentTimeMillis() - this.thresholdStartTime;
                if (circuitOpenDuration >= this.thresholdTimeoutInMilliseconds) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying to obtain LDAP connection, connection URL: " + this.environment.get("java.naming.provider.url") + " when circuit breaker state: " + this.ldapConnectionCircuitBreakerState + " and circuit breaker open duration: " + circuitOpenDuration + "ms."));
                        }
                        context = this.getLdapContextWithCredentials(userDN, password);
                        this.ldapConnectionCircuitBreakerState = CIRCUIT_STATE_CLOSE;
                        this.thresholdStartTime = 0L;
                        break;
                    }
                    catch (UserStoreException e) {
                        log.error((Object)("Error occurred while obtaining LDAP connection. Connection URL: " + this.environment.get("java.naming.provider.url")), (Throwable)((Object)e));
                        this.thresholdStartTime = System.currentTimeMillis();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("LDAP connection circuit breaker state set to: " + this.ldapConnectionCircuitBreakerState));
                        }
                        throw new UserStoreException("Error occurred while obtaining LDAP connection.", (Throwable)((Object)e));
                    }
                }
                throw new UserStoreException("LDAP connection circuit breaker is in open state for " + circuitOpenDuration + "ms and has not reach the threshold timeout: " + this.thresholdTimeoutInMilliseconds + "ms, hence avoid establishing the LDAP connection.");
            }
            case "close": {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LDAP connection circuit breaker state: " + this.ldapConnectionCircuitBreakerState + ", so trying to obtain the LDAP connection. Connection URL: " + this.environment.get("java.naming.provider.url")));
                    }
                    context = this.getLdapContextWithCredentials(userDN, password);
                    break;
                }
                catch (UserStoreException e) {
                    log.error((Object)("Error occurred while obtaining LDAP connection. Connection URL: " + this.environment.get("java.naming.provider.url")), (Throwable)((Object)e));
                    log.error((Object)"Trying again to get connection.");
                    try {
                        context = this.getLdapContextWithCredentials(userDN, password);
                        break;
                    }
                    catch (Exception e1) {
                        log.error((Object)"Error occurred while obtaining connection for the second time.", (Throwable)e1);
                        this.ldapConnectionCircuitBreakerState = CIRCUIT_STATE_OPEN;
                        this.thresholdStartTime = System.currentTimeMillis();
                        throw new UserStoreException("Error occurred while obtaining LDAP connection, LDAP connection circuit breaker state set to: " + this.ldapConnectionCircuitBreakerState, e1);
                    }
                }
            }
            default: {
                throw new UserStoreException("Unknown LDAP connection circuit breaker state.");
            }
        }
        return context;
    }

    private LdapContext getLdapContextWithCredentials(String userDN, String password) throws NamingException, UserStoreException {
        Hashtable<String, String> tempEnv = new Hashtable<String, String>();
        for (Object key : this.environment.keySet()) {
            if ("java.naming.security.principal".equals((String)key) || "java.naming.security.credentials".equals((String)key) || "java.naming.security.authentication".equals((String)key)) continue;
            tempEnv.put((String)key, (String)this.environment.get(key));
        }
        tempEnv.put("java.naming.security.authentication", "none");
        return this.getContextForEnvironmentVariables(tempEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext getContextWithCredentials(String userDN, Object password) throws UserStoreException, NamingException {
        Secret credentialObj;
        try {
            credentialObj = Secret.getSecret((Object)password);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        try {
            Hashtable<String, Object> tempEnv = new Hashtable<String, Object>();
            for (Object key : this.environment.keySet()) {
                tempEnv.put((String)key, this.environment.get(key));
            }
            tempEnv.put("java.naming.security.principal", userDN);
            tempEnv.put("java.naming.security.credentials", credentialObj.getBytes());
            LdapContext ldapContext = this.getContextForEnvironmentVariables(tempEnv);
            return ldapContext;
        }
        finally {
            credentialObj.clear();
        }
    }

    private LdapContext getContextForEnvironmentVariables(Hashtable<?, ?> environment) throws UserStoreException, NamingException {
        LdapContext context = null;
        Hashtable<Object, Object> tempEnv = new Hashtable<Object, Object>();
        tempEnv.putAll(environment);
        if (this.dcMap == null) {
            context = this.getLdapContext(tempEnv, null);
        } else if (this.dcMap != null && this.dcMap.size() != 0) {
            try {
                Integer firstKey = this.dcMap.firstKey();
                SRVRecord firstRecord = (SRVRecord)this.dcMap.get(firstKey);
                tempEnv.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(firstRecord));
                context = this.getLdapContext(tempEnv, null);
            }
            catch (AuthenticationException e) {
                throw e;
            }
            catch (NamingException e) {
                log.error((Object)"Error obtaining connection to first Domain Controller.", (Throwable)e);
                log.info((Object)"Trying to connect with other Domain Controllers");
                for (Integer integer : this.dcMap.keySet()) {
                    try {
                        SRVRecord srv = (SRVRecord)this.dcMap.get(integer);
                        tempEnv.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(srv));
                        context = this.getLdapContext(environment, null);
                        break;
                    }
                    catch (AuthenticationException e1) {
                        throw e1;
                    }
                    catch (NamingException e1) {
                        if (integer != this.dcMap.lastKey()) continue;
                        throw new UserStoreException("Error obtaining connection for all " + integer + " Domain Controllers.", e1);
                    }
                }
            }
        }
        return context;
    }

    private DirContext getDirContext(Hashtable<?, ?> environment) throws NamingException {
        if (Boolean.parseBoolean(System.getProperty(CORRELATION_LOG_SYSTEM_PROPERTY))) {
            Class[] proxyInterfaces = new Class[]{DirContext.class};
            long start = System.currentTimeMillis();
            InitialDirContext context = new InitialDirContext(environment);
            Object proxy = Proxy.newProxyInstance(LDAPConnectionContext.class.getClassLoader(), proxyInterfaces, (InvocationHandler)new LdapContextInvocationHandler(context));
            long delta = System.currentTimeMillis() - start;
            CorrelationLogDTO correlationLogDTO = new CorrelationLogDTO();
            correlationLogDTO.setStartTime(start);
            correlationLogDTO.setDelta(delta);
            correlationLogDTO.setEnvironment(environment);
            correlationLogDTO.setMethodName(CORRELATION_LOG_INITIALIZATION_METHOD_NAME);
            correlationLogDTO.setArgsLength(0);
            correlationLogDTO.setArgs(CORRELATION_LOG_INITIALIZATION_ARGS);
            this.logDetails(correlationLogDTO);
            return (DirContext)proxy;
        }
        return new InitialDirContext(environment);
    }

    private LdapContext getLdapContext(Hashtable<?, ?> environment, Control[] connectionControls) throws NamingException, UserStoreException {
        if (Boolean.parseBoolean(System.getProperty(CORRELATION_LOG_SYSTEM_PROPERTY))) {
            Class[] proxyInterfaces = new Class[]{LdapContext.class};
            long start = System.currentTimeMillis();
            LdapContext context = this.initializeLdapContext(environment, connectionControls);
            Object proxy = Proxy.newProxyInstance(LDAPConnectionContext.class.getClassLoader(), proxyInterfaces, (InvocationHandler)new LdapContextInvocationHandler(context));
            long delta = System.currentTimeMillis() - start;
            CorrelationLogDTO correlationLogDTO = new CorrelationLogDTO();
            correlationLogDTO.setStartTime(start);
            correlationLogDTO.setDelta(delta);
            correlationLogDTO.setEnvironment(environment);
            correlationLogDTO.setMethodName(CORRELATION_LOG_INITIALIZATION_METHOD_NAME);
            correlationLogDTO.setArgsLength(0);
            correlationLogDTO.setArgs(CORRELATION_LOG_INITIALIZATION_ARGS);
            this.logDetails(correlationLogDTO);
            return (LdapContext)proxy;
        }
        return this.initializeLdapContext(environment, connectionControls);
    }

    private LdapContext initializeLdapContext(Hashtable<?, ?> environment, Control[] connectionControls) throws NamingException, UserStoreException {
        if (this.startTLSEnabled) {
            return LdapContextWrapper.startTLS(environment, connectionControls);
        }
        return new InitialLdapContext(environment, connectionControls);
    }

    private void logDetails(CorrelationLogDTO correlationLogDTO) {
        String providerUrl = "No provider url found";
        String principal = "No principal found";
        if (correlationLogDTO.getEnvironment().containsKey("java.naming.provider.url")) {
            providerUrl = (String)this.environment.get("java.naming.provider.url");
        }
        if (this.environment.containsKey("java.naming.security.principal")) {
            principal = (String)this.environment.get("java.naming.security.principal");
        }
        if (correlationLog.isInfoEnabled()) {
            ArrayList<String> logPropertiesList = new ArrayList<String>();
            logPropertiesList.add(Long.toString(correlationLogDTO.getDelta()));
            logPropertiesList.add(CORRELATION_LOG_CALL_TYPE_VALUE);
            logPropertiesList.add(Long.toString(correlationLogDTO.getStartTime()));
            logPropertiesList.add(correlationLogDTO.getMethodName());
            logPropertiesList.add(providerUrl);
            logPropertiesList.add(principal);
            logPropertiesList.add(Integer.toString(correlationLogDTO.getArgsLength()));
            logPropertiesList.add(correlationLogDTO.getArgs());
            correlationLog.info((Object)this.createFormattedLog(logPropertiesList));
        }
    }

    private String createFormattedLog(List<String> logPropertiesList) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String property : logPropertiesList) {
            sb.append(property);
            if (count < logPropertiesList.size() - 1) {
                sb.append(CORRELATION_LOG_SEPARATOR);
            }
            ++count;
        }
        return sb.toString();
    }

    private long getThresholdTimeoutInMilliseconds(String retryWaitingTime) throws UserStoreException {
        try {
            return Long.parseLong(retryWaitingTime);
        }
        catch (NumberFormatException e) {
            throw new UserStoreException("Error occurred while parsing ConnectionRetryDelay property value. value: ConnectionRetryDelay");
        }
    }

    static {
        String initialContextFactoryClassSystemProperty = System.getProperty("java.naming.factory.initial");
        if (initialContextFactoryClassSystemProperty != null && initialContextFactoryClassSystemProperty.length() > 0) {
            initialContextFactoryClass = initialContextFactoryClassSystemProperty;
        }
    }

    private class LdapContextInvocationHandler
    implements InvocationHandler {
        private Object previousContext;

        public LdapContextInvocationHandler(Object previousContext) {
            this.previousContext = previousContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long start = System.currentTimeMillis();
            Object result = method.invoke(this.previousContext, args);
            long delta = System.currentTimeMillis() - start;
            String methodName = method.getName();
            int argsLength = 0;
            if (args != null) {
                argsLength = args.length;
            }
            if (!StringUtils.equalsIgnoreCase((String)LDAPConnectionContext.CIRCUIT_STATE_CLOSE, (String)methodName)) {
                CorrelationLogDTO correlationLogDTO = new CorrelationLogDTO();
                correlationLogDTO.setStartTime(start);
                correlationLogDTO.setDelta(delta);
                correlationLogDTO.setEnvironment(((DirContext)this.previousContext).getEnvironment());
                correlationLogDTO.setMethodName(methodName);
                correlationLogDTO.setArgsLength(argsLength);
                correlationLogDTO.setArgs(this.stringify(args));
                LDAPConnectionContext.this.logDetails(correlationLogDTO);
            }
            return result;
        }

        private String stringify(Object[] arr) {
            StringBuilder sb = new StringBuilder();
            if (arr == null) {
                sb.append("null");
            } else {
                sb.append(" ");
                for (int i = 0; i < arr.length; ++i) {
                    Object o = arr[i];
                    if (o == null) continue;
                    sb.append(o.toString());
                    if (i >= arr.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
    }
}

