/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.jdbc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLTimeoutException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.PaginatedSearchResult;
import org.wso2.carbon.user.core.common.RoleBreakdown;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.dto.RoleDTO;
import org.wso2.carbon.user.core.jdbc.JDBCRoleContext;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreConstants;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.ExpressionAttribute;
import org.wso2.carbon.user.core.model.ExpressionCondition;
import org.wso2.carbon.user.core.model.ExpressionOperation;
import org.wso2.carbon.user.core.model.OperationalCondition;
import org.wso2.carbon.user.core.model.SqlBuilder;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JDBCRealmUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.Secret;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class JDBCUserStoreManager
extends AbstractUserStoreManager {
    private static Log log = LogFactory.getLog(JDBCUserStoreManager.class);
    private static final String QUERY_FILTER_STRING_ANY = "*";
    private static final String SQL_FILTER_STRING_ANY = "%";
    private static final String SQL_FILTER_CHAR_ESCAPE = "\\";
    public static final String QUERY_BINDING_SYMBOL = "?";
    private static final String CASE_INSENSITIVE_USERNAME = "CaseInsensitiveUsername";
    private static final String SHA_1_PRNG = "SHA1PRNG";
    protected DataSource jdbcds;
    protected Random random;
    protected int maximumUserNameListLength;
    protected int queryTimeout;
    private static final String DB2 = "db2";
    private static final String MSSQL = "mssql";
    private static final String ORACLE = "oracle";
    private static final String MYSQL = "mysql";
    private static final String POSTGRESQL = "postgresql";
    private static final int MAX_ITEM_LIMIT_UNLIMITED = -1;

    public JDBCUserStoreManager() {
        this.jdbcds = null;
        this.random = new Random();
        this.maximumUserNameListLength = -1;
        this.queryTimeout = -1;
    }

    public JDBCUserStoreManager(RealmConfiguration realmConfig, int tenantId) throws UserStoreException {
        this.jdbcds = null;
        this.random = new Random();
        this.maximumUserNameListLength = -1;
        this.queryTimeout = -1;
        this.realmConfig = realmConfig;
        this.tenantId = tenantId;
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        if (realmConfig.getUserStoreProperty("ReadGroups") != null) {
            this.readGroupsEnabled = Boolean.parseBoolean(realmConfig.getUserStoreProperty("ReadGroups"));
        }
        if (log.isDebugEnabled()) {
            if (this.readGroupsEnabled) {
                log.debug((Object)("ReadGroups is enabled for " + this.getMyDomainName()));
            } else {
                log.debug((Object)("ReadGroups is disabled for " + this.getMyDomainName()));
            }
        }
        if (realmConfig.getUserStoreProperty("WriteGroups") != null) {
            this.writeGroupsEnabled = Boolean.parseBoolean(realmConfig.getUserStoreProperty("WriteGroups"));
        } else if (!this.isReadOnly()) {
            this.writeGroupsEnabled = true;
        }
        this.maximumUserNameListLength = this.getMaxUserNameListLength();
        this.queryTimeout = this.getSQLQueryTimeoutLimit();
        if (log.isDebugEnabled()) {
            if (this.writeGroupsEnabled) {
                log.debug((Object)("WriteGroups is enabled for " + this.getMyDomainName()));
            } else {
                log.debug((Object)("WriteGroups is disabled for " + this.getMyDomainName()));
            }
        }
        if (realmConfig.getUserStoreProperty("InternalJDBCRolesOnly") != null) {
            boolean internalRolesOnly = Boolean.parseBoolean(realmConfig.getUserStoreProperty("InternalJDBCRolesOnly"));
            if (internalRolesOnly) {
                this.readGroupsEnabled = false;
                this.writeGroupsEnabled = false;
            } else {
                this.readGroupsEnabled = true;
                this.writeGroupsEnabled = true;
            }
        }
        if (this.writeGroupsEnabled) {
            this.readGroupsEnabled = true;
        }
        this.initUserRolesCache();
    }

    public JDBCUserStoreManager(DataSource ds, RealmConfiguration realmConfig, int tenantId, boolean addInitData) throws UserStoreException {
        this(realmConfig, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        this.jdbcds = ds;
        this.dataSource = ds;
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("User Management Data Source is null");
        }
        this.doInitialSetup();
        this.persistDomain();
        if (addInitData && realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended " + System.currentTimeMillis()));
        }
    }

    public JDBCUserStoreManager(DataSource ds, RealmConfiguration realmConfig) throws UserStoreException {
        this(realmConfig, -1234);
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        this.jdbcds = ds;
    }

    public JDBCUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        this(realmConfig, properties, claimManager, profileManager, realm, tenantId, false);
    }

    public JDBCUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId, boolean skipInitData) throws UserStoreException {
        block10: {
            this(realmConfig, tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Started " + System.currentTimeMillis()));
            }
            this.claimManager = claimManager;
            this.userRealm = realm;
            try {
                this.jdbcds = this.loadUserStoreSpacificDataSoruce();
                if (this.jdbcds == null) {
                    this.jdbcds = (DataSource)properties.get("um.datasource");
                }
                if (this.jdbcds == null) {
                    this.jdbcds = DatabaseUtil.getRealmDataSource(realmConfig);
                    properties.put("um.datasource", this.jdbcds);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The jdbcDataSource being used by JDBCUserStoreManager :: " + this.jdbcds.hashCode()));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)"Loading JDBC datasource failed", (Throwable)e);
            }
        }
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("User Management Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        realmConfig.setUserStoreProperties(JDBCRealmUtil.getSQL(realmConfig.getUserStoreProperties()));
        this.persistDomain();
        this.doInitialSetup();
        if (!skipInitData && realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        this.initUserRolesCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended " + System.currentTimeMillis()));
        }
    }

    private DataSource getJDBCDataSource() throws UserStoreException {
        if (this.jdbcds == null) {
            this.jdbcds = this.loadUserStoreSpacificDataSoruce();
        }
        return this.jdbcds;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] doListUsers(String filter, int maxItemLimit) throws UserStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getUserFilterQuery(String caseSensitiveQueryPropertyName, String caseInsensitiveQueryPropertyName) {
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty(caseSensitiveQueryPropertyName) : this.realmConfig.getUserStoreProperty(caseInsensitiveQueryPropertyName);
        return sqlStmt;
    }

    @Override
    public boolean doCheckIsUserInRole(String userName, String roleName) throws UserStoreException {
        String[] roles = this.doGetExternalRoleListOfUser(userName, roleName);
        if (roles != null) {
            for (String role : roles) {
                if (!role.equalsIgnoreCase(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String[] doGetDisplayNamesForInternalRole(String[] userNames) throws UserStoreException {
        return userNames;
    }

    @Override
    public String[] doGetRoleNames(String filter, int maxItemLimit) throws UserStoreException {
        String[] roles = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        if (maxItemLimit == 0) {
            return roles;
        }
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
                filter = filter.replace(QUERY_BINDING_SYMBOL, "_");
            } else {
                filter = SQL_FILTER_STRING_ANY;
            }
            LinkedList<String> lst = new LinkedList<String>();
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            sqlStmt = this.realmConfig.getUserStoreProperty("GetRoleListSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int count = 0;
            count = (byte)(count + 1);
            prepStmt.setString(count, filter);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                count = (byte)(count + 1);
                prepStmt.setInt(count, this.tenantId);
            }
            this.setPSRestrictions(prepStmt, maxItemLimit);
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                if (e instanceof SQLTimeoutException) {
                    log.error((Object)"The cause might be a time out. Hence ignored", (Throwable)e);
                }
                String errorMessage = "Error while fetching roles from JDBC user store according to filter : " + filter + " & max item limit : " + maxItemLimit;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String domain = this.realmConfig.getUserStoreProperty("DomainName");
                    name = UserCoreUtil.addDomainToName(name, domain);
                    lst.add(name);
                }
            }
            if (lst.size() > 0) {
                roles = lst.toArray(new String[lst.size()]);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving role names for filter : " + filter + " & max item limit : " + maxItemLimit;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return roles;
    }

    private void setPSRestrictions(PreparedStatement ps, int maxItemLimit) throws SQLException {
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        ps.setMaxRows(maxItemLimit);
        try {
            ps.setQueryTimeout(searchTime);
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    @Override
    protected String[] doGetSharedRoleNames(String tenantDomain, String filter, int maxItemLimit) throws UserStoreException {
        ResultSet rs;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        String[] roles;
        block17: {
            roles = new String[]{};
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            rs = null;
            if (maxItemLimit == 0) {
                return roles;
            }
            if (this.isSharedGroupEnabled()) break block17;
            String[] stringArray = roles;
            DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
            return stringArray;
        }
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
                filter = filter.replace(QUERY_BINDING_SYMBOL, "_");
            } else {
                filter = SQL_FILTER_STRING_ANY;
            }
            LinkedList<String> lst = new LinkedList<String>();
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            sqlStmt = this.realmConfig.getUserStoreProperty("GetSharedRoleListSQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int count = 0;
            count = (byte)(count + 1);
            prepStmt.setString(count, filter);
            this.setPSRestrictions(prepStmt, maxItemLimit);
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                if (e instanceof SQLTimeoutException) {
                    log.error((Object)"The cause might be a time out. Hence ignored", (Throwable)e);
                }
                String errorMessage = "Error while fetching roles from JDBC user store for tenant domain : " + tenantDomain + " & filter : " + filter + "& max item limit : " + maxItemLimit;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    int roleTenantId = rs.getInt(2);
                    String domain = this.realmConfig.getUserStoreProperty("DomainName");
                    name = UserCoreUtil.addDomainToName(name, domain);
                    name = UserCoreUtil.addTenantDomainToEntry(name, String.valueOf(roleTenantId));
                    lst.add(name);
                }
            }
            if (lst.size() > 0) {
                roles = lst.toArray(new String[lst.size()]);
            }
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error while retrieving roles from JDBC user store for tenant domain : " + tenantDomain + " & filter : " + filter + "& max item limit : " + maxItemLimit;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return roles;
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfJDBCRole(roleContext, filter);
    }

    public String[] getUserListOfJDBCRole(RoleContext ctx, String filter) throws UserStoreException {
        return this.getUserListOfJDBCRole(ctx, filter, -1);
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter, int maxItemLimit) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfJDBCRole(roleContext, filter, maxItemLimit);
    }

    public String[] getUserListOfJDBCRole(RoleContext ctx, String filter, int maxItemLimit) throws UserStoreException {
        String roleName = ctx.getRoleName();
        String[] names = null;
        String sqlStmt = null;
        if (maxItemLimit == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (maxItemLimit < 0 || maxItemLimit > this.maximumUserNameListLength) {
            maxItemLimit = this.maximumUserNameListLength;
        }
        if (StringUtils.isNotEmpty((String)filter)) {
            filter = filter.trim();
            filter = filter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
            filter = filter.replace(QUERY_BINDING_SYMBOL, "_");
        } else {
            filter = SQL_FILTER_STRING_ANY;
        }
        if (!ctx.isShared()) {
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserListOfRoleFilterSQL");
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for retrieving user roles is null");
            }
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabaseWithConstraints(sqlStmt, maxItemLimit, this.queryTimeout, filter, roleName, this.tenantId, this.tenantId, this.tenantId) : this.getStringValuesFromDatabaseWithConstraints(sqlStmt, maxItemLimit, this.queryTimeout, filter, roleName);
        } else if (ctx.isShared()) {
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserListOfSharedRoleFilterSQL");
            names = this.getStringValuesFromDatabaseWithConstraints(sqlStmt, maxItemLimit, this.queryTimeout, filter, roleName);
        }
        ArrayList<String> userList = new ArrayList<String>();
        String domainName = this.realmConfig.getUserStoreProperty("DomainName");
        if (names != null) {
            for (String user : names) {
                user = UserCoreUtil.addDomainToName(user, domainName);
                userList.add(user);
            }
            names = userList.toArray(new String[userList.size()]);
        }
        log.debug((Object)("Roles are not defined for the role name " + roleName));
        return names;
    }

    @Override
    public boolean doCheckExistingRole(String roleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.isExistingJDBCRole(roleContext);
    }

    protected boolean isExistingJDBCRole(RoleContext context) throws UserStoreException {
        String roleName = context.getRoleName();
        String sqlStmt = this.realmConfig.getUserStoreProperty("IsRoleExistingSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for is role existing role null");
        }
        boolean isExisting = sqlStmt.contains("UM_TENANT_ID") ? this.isValueExisting(sqlStmt, null, roleName, ((JDBCRoleContext)context).getTenantId()) : this.isValueExisting(sqlStmt, null, roleName);
        return isExisting;
    }

    @Override
    public String[] getAllProfileNames() throws UserStoreException {
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetProfileNamesSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving profile names is null");
        }
        String[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, new Object[0]);
        return names;
    }

    @Override
    public String[] getProfileNames(String userName) throws UserStoreException {
        userName = UserCoreUtil.removeDomainFromName(userName);
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("GetUserProfileNamesSQL") : this.realmConfig.getUserStoreProperty("GetUserProfileNamesSQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving  is null");
        }
        Object[] names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userName, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userName);
        if (names.length == 0) {
            names = new String[]{"default"};
        } else {
            Arrays.sort(names);
            if (Arrays.binarySearch(names, "default") < 0) {
                String[] newNames = new String[names.length + 1];
                int i = 0;
                for (i = 0; i < names.length; ++i) {
                    newNames[i] = names[i];
                }
                newNames[i] = "default";
                names = newNames;
            }
        }
        return names;
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("GetUserIDFromUserNameSQL") : this.realmConfig.getUserStoreProperty("GetUserIDFromUserNameSQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving ID is null");
        }
        int id = -1;
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            id = sqlStmt.contains("UM_TENANT_ID") ? DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username, this.tenantId) : DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username);
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting user id from username : " + username;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return id;
    }

    public String[] getUserNames(int tenantId) throws UserStoreException {
        String[] userNames;
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetUserNameFromTenantIDSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving user names is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            userNames = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, tenantId);
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting username from tenant ID : " + tenantId;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return userNames;
    }

    public String getAdminUser() throws UserStoreException {
        String[] users = this.getUserListOfRole(this.realmConfig.getAdminRoleName());
        if (users != null && users.length > 0) {
            return users[0];
        }
        return null;
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    public Map<String, String> getProperties(Tenant tenant) throws org.wso2.carbon.user.api.UserStoreException {
        return this.getProperties((org.wso2.carbon.user.core.tenant.Tenant)tenant);
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        if (this.tenantId != -1234) {
            throw new UserStoreException("Not allowed to perform this operation");
        }
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("GetTenantIDFromUserNameSQL") : this.realmConfig.getUserStoreProperty("GetTenantIDFromUserNameSQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving ID is null");
        }
        int id = -1;
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            id = DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, username);
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting tenant ID from username : " + username;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        return id;
    }

    @Override
    public Map<String, String> getUserPropertyValues(String userName, String[] propertyNames, String profileName) throws UserStoreException {
        Object name;
        if (profileName == null) {
            profileName = "default";
        }
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Object[] propertyNamesSorted = (String[])propertyNames.clone();
        Arrays.sort(propertyNamesSorted);
        HashMap<Object, String> map = new HashMap<Object, String>();
        try {
            dbConnection = this.getDBConnection();
            sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("GetUserPropertiesForProfileSQL") : this.realmConfig.getUserStoreProperty("GetUserPropertiesForProfileSQLCaseInsensitive");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userName);
            prepStmt.setString(2, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(3, this.tenantId);
                prepStmt.setInt(4, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                name = rs.getString(1);
                String value = rs.getString(2);
                if (Arrays.binarySearch(propertyNamesSorted, name) < 0) continue;
                map.put(name, value);
            }
            name = map;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error Occurred while getting property values for user : " + userName + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return name;
    }

    private String[] getStringValuesFromDatabase(String sqlStmt, Object ... params) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing Query: " + sqlStmt));
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                log.debug((Object)("Input value: " + param));
            }
        }
        String[] values = new String[]{};
        Connection dbConnection = null;
        Object prepStmt = null;
        ResultSet rs = null;
        try {
            dbConnection = this.getDBConnection();
            values = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, params);
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving string values.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return values;
    }

    private String[] getStringValuesFromDatabaseWithConstraints(String sqlStmt, int maxRows, int queryTimeout, Object ... params) throws UserStoreException {
        String[] values;
        if (log.isDebugEnabled()) {
            String loggableSqlString = DatabaseUtil.getLoggableSqlString(sqlStmt, params);
            String msg = "Using SQL : " + loggableSqlString + ", and maxRows: " + maxRows + ", and queryTimeout: " + queryTimeout;
            log.debug((Object)msg);
        }
        try (Connection dbConnection = this.getDBConnection();){
            values = DatabaseUtil.getStringValuesFromDatabaseWithConstraints(dbConnection, sqlStmt, maxRows, queryTimeout, params);
        }
        catch (SQLException e) {
            String msg = "Error occurred while accessing the database connection.";
            throw new UserStoreException(msg, e);
        }
        return values;
    }

    private String[] getRoleNamesWithDomain(String sqlStmt, String userName, int tenantId, boolean appendDn) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> roles = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int count = 0;
            count = (byte)(count + 1);
            prepStmt.setString(count, userName);
            count = (byte)(count + 1);
            prepStmt.setInt(count, tenantId);
            rs = prepStmt.executeQuery();
            String domain = this.realmConfig.getUserStoreProperty("DomainName");
            while (rs.next()) {
                String name = rs.getString(1);
                int tenant = rs.getInt(2);
                String role = name;
                if (appendDn) {
                    name = UserCoreUtil.addTenantDomainToEntry(name, String.valueOf(tenant));
                }
                roles.add(role);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving role name with tenant id : " + tenantId + " & user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return roles.toArray(new String[roles.size()]);
    }

    protected Connection getDBConnection() throws SQLException, UserStoreException {
        Connection dbConnection = this.getJDBCDataSource().getConnection();
        dbConnection.setAutoCommit(false);
        if (dbConnection.getTransactionIsolation() != 2) {
            dbConnection.setTransactionIsolation(2);
        }
        return dbConnection;
    }

    protected boolean isValueExisting(String sqlStmt, Connection dbConnection, Object ... params) throws UserStoreException {
        boolean bl;
        block8: {
            Object prepStmt = null;
            ResultSet rs = null;
            boolean isExisting = false;
            boolean doClose = false;
            try {
                if (dbConnection == null) {
                    dbConnection = this.getDBConnection();
                    doClose = true;
                }
                if (DatabaseUtil.getIntegerValueFromDatabase(dbConnection, sqlStmt, params) > -1) {
                    isExisting = true;
                }
                bl = isExisting;
                if (!doClose) break block8;
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while checking existence of values.";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    if (doClose) {
                        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    }
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        }
        return bl;
    }

    @Override
    public boolean doCheckExistingUser(String userName) throws UserStoreException {
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("IsUserExistingSQL") : this.realmConfig.getUserStoreProperty("IsUserExistingSQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for is user existing null");
        }
        boolean isExisting = false;
        String isUnique = this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenants");
        if (Boolean.parseBoolean(isUnique) && !"wso2.anonymous.user".equals(userName)) {
            String uniquenesSql = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenantsSQL") : this.realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenantsSQLCaseInsensitive");
            isExisting = this.isValueExisting(uniquenesSql, null, userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)"The username should be unique across tenants.");
            }
        } else {
            isExisting = sqlStmt.contains("UM_TENANT_ID") ? this.isValueExisting(sqlStmt, null, userName, this.tenantId) : this.isValueExisting(sqlStmt, null, userName);
        }
        return isExisting;
    }

    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        boolean isAuthed;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block17: {
            if (!this.isValidUserName(userName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Username validation failed");
                }
                return false;
            }
            if (!this.isValidCredentials(credential)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Password validation failed");
                }
                return false;
            }
            if (UserCoreUtil.isRegistryAnnonymousUser(userName)) {
                log.error((Object)"Anonnymous user trying to login");
                return false;
            }
            dbConnection = null;
            rs = null;
            prepStmt = null;
            String sqlstmt = null;
            String password = null;
            isAuthed = false;
            try {
                dbConnection = this.getDBConnection();
                dbConnection.setAutoCommit(false);
                sqlstmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("SelectUserSQL") : this.realmConfig.getUserStoreProperty("SelectUserSQLCaseInsensitive");
                if (log.isDebugEnabled()) {
                    log.debug((Object)sqlstmt);
                }
                prepStmt = dbConnection.prepareStatement(sqlstmt);
                prepStmt.setString(1, userName);
                if (sqlstmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(2, this.tenantId);
                }
                if (!(rs = prepStmt.executeQuery()).next()) break block17;
                String storedPassword = rs.getString(3);
                String saltValue = null;
                if ("true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("StoreSaltedPassword"))) {
                    saltValue = rs.getString(4);
                }
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                GregorianCalendar gc = new GregorianCalendar();
                gc.add(10, -24);
                Date date = gc.getTime();
                if (requireChange && changedTime.before(date)) {
                    isAuthed = false;
                } else {
                    password = this.preparePassword(credential, saltValue);
                    if (storedPassword != null && storedPassword.equals(password)) {
                        isAuthed = true;
                    }
                }
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while retrieving user authentication info for user : " + userName;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    throw new UserStoreException("Authentication Failure", e);
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User " + userName + " login attempt. Login success :: " + isAuthed));
        }
        return isAuthed;
    }

    @Override
    public boolean isReadOnly() throws UserStoreException {
        return "true".equalsIgnoreCase(this.realmConfig.getUserStoreProperty("ReadOnly"));
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.persistUser(userName, credential, roleList, claims, profileName, requirePasswordChange);
    }

    protected void persistUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        Secret credentialObj;
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        try {
            credentialObj = Secret.getSecret((Object)credential);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        try {
            String sqlStmt1 = this.realmConfig.getUserStoreProperty("AddUserSQL");
            String saltValue = null;
            if ("true".equalsIgnoreCase((String)this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
                saltValue = this.generateSaltValue();
            }
            String password = this.preparePassword(credentialObj, saltValue);
            if (sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, "", requirePasswordChange, new Date(), this.tenantId);
            } else if (sqlStmt1.contains("UM_TENANT_ID") && saltValue != null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, saltValue, requirePasswordChange, new Date(), this.tenantId);
            } else if (!sqlStmt1.contains("UM_TENANT_ID") && saltValue == null) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, "", requirePasswordChange, new Date());
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, password, saltValue, requirePasswordChange, new Date());
            }
            if (roleList != null && roleList.length > 0) {
                RoleBreakdown breakdown = this.getSharedRoleBreakdown(roleList);
                String[] roles = breakdown.getRoles();
                String[] sharedRoles = breakdown.getSharedRoles();
                Integer[] sharedTenantIds = breakdown.getSharedTenantIDs();
                String sqlStmt2 = null;
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if (roles.length > 0) {
                    sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddRoleToUserSQL-" + type) : this.realmConfig.getUserStoreProperty("AddRoleToUserSQLCaseInsensitive-" + type);
                    if (sqlStmt2 == null) {
                        sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddRoleToUserSQL") : this.realmConfig.getUserStoreProperty("AddRoleToUserSQLCaseInsensitive");
                    }
                    if (sqlStmt2.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, roles, this.tenantId, userName, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userName, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roleList, userName);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL") : this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQLCaseInsensitive");
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt2, sharedRoles, userName, sharedTenantIds, this.tenantId);
                }
            }
            if (claims != null) {
                if (profileName == null) {
                    profileName = "default";
                }
                HashMap<String, String> userStoreAttributeValues = new HashMap<String, String>();
                for (Map.Entry<String, String> claimEntry : claims.entrySet()) {
                    userStoreAttributeValues.put(this.getClaimAtrribute(claimEntry.getKey(), userName, null), claimEntry.getValue());
                }
                this.addProperties(dbConnection, userName, userStoreAttributeValues, profileName);
            }
            dbConnection.commit();
        }
        catch (Exception e) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                String errorMessage = "Error rollbacking add user operation for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e1);
                }
                throw new UserStoreException(errorMessage, e1);
            }
            String errorMessage = "Error while persisting user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            if (e instanceof UserStoreException && UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) {
                throw new UserStoreException(errorMessage, UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_A_USER.getCode(), e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            credentialObj.clear();
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doAddRole(String roleName, String[] userList, boolean shared) throws UserStoreException {
        if (shared && this.isSharedGroupEnabled()) {
            this.doAddSharedRole(roleName, userList);
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddRoleSQL");
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, roleName);
            }
            if (userList != null) {
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                String sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddUserToRoleSQL-" + type) : this.realmConfig.getUserStoreProperty("AddUserToRoleSQLCaseInsensitive-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddUserToRoleSQL") : this.realmConfig.getUserStoreProperty("AddUserToRoleSQLCaseInsensitive");
                }
                if (sqlStmt2.contains("UM_TENANT_ID")) {
                    if ("openedge".equals(type)) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, userList, this.tenantId, roleName, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userList, this.tenantId, roleName, this.tenantId, this.tenantId);
                    }
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, userList, roleName);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Error occurred while adding role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            if (e instanceof UserStoreException && UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(((UserStoreException)((Object)e)).getErrorCode())) {
                throw new UserStoreException(errorMessage, UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_ADDING_ROLE.getCode(), e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateRoleName(String roleName, String newRoleName) throws UserStoreException {
        JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(roleName);
        if (this.isExistingRole(newRoleName)) {
            throw new UserStoreException("Role name: " + newRoleName + " in the system. Please pick another role name.");
        }
        String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateRoleNameSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update role name is null");
        }
        Connection dbConnection = null;
        try {
            roleName = ctx.getRoleName();
            dbConnection = this.getDBConnection();
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, newRoleName, roleName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Error occurred while updating role name : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public boolean isSharedRole(String roleName, String roleNameBase) {
        return roleNameBase != null && roleNameBase.indexOf("true") > -1;
    }

    private int getTenantIdFromRole(String roleBase) {
        int tenantId = -1234;
        String[] postfix = roleBase.split("~");
        if (postfix.length > 1) {
            try {
                tenantId = Integer.parseInt(postfix[1]);
            }
            catch (NumberFormatException e) {
                log.error((Object)e);
                tenantId = -1234;
            }
        }
        return tenantId;
    }

    @Override
    public boolean isBulkImportSupported() {
        return new Boolean(this.realmConfig.getUserStoreProperty("IsBulkImportSupported"));
    }

    @Override
    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfig;
    }

    public RoleDTO[] getRoleNamesWithDomain(boolean noHybridRoles) throws UserStoreException {
        RoleDTO[] secondaryRoleDTOs;
        String[] names = null;
        String domain = this.realmConfig.getUserStoreProperty("DomainName");
        String sqlStmt = this.realmConfig.getUserStoreProperty("GetRoleListSQL");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving role name is null");
        }
        names = this.getStringValuesFromDatabase(sqlStmt, this.tenantId);
        if (this.isReadOnly() && !noHybridRoles) {
            String[] hybrids = this.hybridRoleManager.getHybridRoles(QUERY_FILTER_STRING_ANY);
            names = UserCoreUtil.combineArrays(names, hybrids);
        }
        ArrayList<RoleDTO> roleDTOs = new ArrayList<RoleDTO>();
        if (names != null && names.length != 0) {
            roleDTOs.addAll(Arrays.asList(UserCoreUtil.convertRoleNamesToRoleDTO(names, domain)));
        }
        if ((secondaryRoleDTOs = this.getAllSecondaryRoleDTOs()) != null && secondaryRoleDTOs.length != 0) {
            roleDTOs.addAll(Arrays.asList(secondaryRoleDTOs));
        }
        return roleDTOs.toArray(new RoleDTO[roleDTOs.size()]);
    }

    public boolean isMultipleProfilesAllowed() {
        return true;
    }

    @Override
    public void doDeleteRole(String roleName) throws UserStoreException {
        String sqlStmt1 = this.realmConfig.getUserStoreProperty("OnDeleteRoleRemoveUserRoleMappingSQL");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for delete user-role mapping is null");
        }
        String sqlStmt2 = this.realmConfig.getUserStoreProperty("DeleteRoleSQL");
        if (sqlStmt2 == null) {
            throw new UserStoreException("The sql statement for delete role is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt1.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, roleName, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, roleName);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, roleName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Error occurred while deleting role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        String sqlStmt1 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserRoleMappingSQL") : this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserRoleMappingSQLCaseInsensitive");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for delete user-role mapping is null");
        }
        String sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserAttributeSQL") : this.realmConfig.getUserStoreProperty("OnDeleteUserRemoveUserAttributeSQLCaseInsensitive");
        if (sqlStmt2 == null) {
            throw new UserStoreException("The sql statement for delete user attribute is null");
        }
        String sqlStmt3 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("DeleteUserSQL") : this.realmConfig.getUserStoreProperty("DeleteUserSQLCaseInsensitive");
        if (sqlStmt3 == null) {
            throw new UserStoreException("The sql statement for delete user is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt1.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userName, this.tenantId, this.tenantId);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt1, userName);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt2, userName);
                this.updateStringValuesToDatabase(dbConnection, sqlStmt3, userName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Error occurred while deleting user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(roleName);
        roleName = ctx.getRoleName();
        int roleTenantId = ctx.getTenantId();
        boolean isShared = ctx.isShared();
        String sqlStmt1 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty(isShared ? "RemoveUserFromSharedRoleSQL" : "RemoveUserFromRoleSQL") : this.realmConfig.getUserStoreProperty(isShared ? "RemoveUserFromSharedRoleSQLCaseInsensitive" : "RemoveUserFromRoleSQLCaseInsensitive");
        if (sqlStmt1 == null) {
            throw new UserStoreException("The sql statement for remove user from role is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt2 = null;
            if (!isShared) {
                sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddUserToRoleSQL-" + type) : this.realmConfig.getUserStoreProperty("AddUserToRoleSQLCaseInsensitive-" + type);
                if (sqlStmt2 == null) {
                    sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddUserToRoleSQL") : this.realmConfig.getUserStoreProperty("AddUserToRoleSQLCaseInsensitive");
                }
            } else {
                sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL") : this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQLCaseInsensitive");
            }
            if (sqlStmt2 == null) {
                throw new UserStoreException("The sql statement for add user to role is null");
            }
            if (deletedUsers != null) {
                if (isShared) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roleName, this.tenantId, deletedUsers, this.tenantId, this.tenantId, roleTenantId);
                } else if (sqlStmt1.contains("UM_TENANT_ID")) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, this.tenantId, roleName, this.tenantId, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, roleName);
                }
            }
            if (newUsers != null) {
                if (isShared) {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roleName, roleTenantId, newUsers, this.tenantId, this.tenantId, roleTenantId);
                } else if (sqlStmt1.contains("UM_TENANT_ID")) {
                    if ("openedge".equals(type)) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, newUsers, this.tenantId, roleName, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, this.tenantId, roleName, this.tenantId, this.tenantId);
                    }
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, roleName);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Database error occurred while updating user list of role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    private RoleBreakdown getSharedRoleBreakdown(String[] rolesList) {
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<Integer> tenantIds = new ArrayList<Integer>();
        ArrayList<String> sharedRoles = new ArrayList<String>();
        ArrayList<Integer> sharedTenantIds = new ArrayList<Integer>();
        for (String role : rolesList) {
            if (!StringUtils.isNotEmpty((String)role)) continue;
            String[] deletedRoleNames = role.split(CarbonConstants.DOMAIN_SEPARATOR);
            if (deletedRoleNames.length > 1) {
                role = deletedRoleNames[1];
            }
            JDBCRoleContext ctx = (JDBCRoleContext)this.createRoleContext(role);
            role = ctx.getRoleName();
            int roleTenantId = ctx.getTenantId();
            boolean isShared = ctx.isShared();
            if (isShared) {
                sharedRoles.add(role);
                sharedTenantIds.add(roleTenantId);
                continue;
            }
            roles.add(role);
            tenantIds.add(roleTenantId);
        }
        RoleBreakdown breakdown = new RoleBreakdown();
        breakdown.setRoles(roles.toArray(new String[roles.size()]));
        breakdown.setTenantIds(tenantIds.toArray(new Integer[tenantIds.size()]));
        breakdown.setSharedRoles(sharedRoles.toArray(new String[sharedRoles.size()]));
        breakdown.setSharedTenantIDs(sharedTenantIds.toArray(new Integer[sharedTenantIds.size()]));
        return breakdown;
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt2 = null;
            String[] userNames = userName.split(CarbonConstants.DOMAIN_SEPARATOR);
            if (userNames.length > 1) {
                userName = userNames[1];
            }
            if (deletedRoles != null && deletedRoles.length > 0) {
                RoleBreakdown breakdown = this.getSharedRoleBreakdown(deletedRoles);
                String[] roles = breakdown.getRoles();
                String[] sharedRoles = breakdown.getSharedRoles();
                Integer[] sharedTenantIds = breakdown.getSharedTenantIDs();
                String sqlStmt1 = null;
                if (roles.length > 0) {
                    sqlStmt1 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("RemoveRoleFromUserSQL") : this.realmConfig.getUserStoreProperty("RemoveRoleFromUserSQLCaseInsensitive");
                    if (sqlStmt1 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null");
                    }
                    if (sqlStmt1.contains("UM_TENANT_ID")) {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roles, this.tenantId, userName, this.tenantId, this.tenantId);
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, roles, userName);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt1 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("RemoveUserFromSharedRoleSQL") : this.realmConfig.getUserStoreProperty("RemoveUserFromSharedRoleSQLCaseInsensitive");
                    if (sqlStmt1 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null");
                    }
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt1, sharedRoles, userName, sharedTenantIds, this.tenantId);
                }
            }
            if (newRoles != null && newRoles.length > 0) {
                ArrayList<String> newRoleList = new ArrayList<String>();
                for (String role : newRoles) {
                    if (!this.isExistingRole(role)) {
                        String errorMessage = "The role: " + role + " does not exist.";
                        throw new UserStoreException(errorMessage);
                    }
                    if (this.isUserInRole(userName, role)) continue;
                    newRoleList.add(role);
                }
                String[] rolesToAdd = newRoleList.toArray(new String[newRoleList.size()]);
                RoleBreakdown breakdown = this.getSharedRoleBreakdown(rolesToAdd);
                String[] roles = breakdown.getRoles();
                String[] sharedRoles = breakdown.getSharedRoles();
                Integer[] sharedTenantIds = breakdown.getSharedTenantIDs();
                if (roles.length > 0) {
                    if (this.isCaseSensitiveUsername()) {
                        this.realmConfig.getUserStoreProperty("AddRoleToUserSQL-" + type);
                    } else {
                        this.realmConfig.getUserStoreProperty("AddRoleToUserSQLCaseInsensitive-" + type);
                    }
                    if (sqlStmt2 == null) {
                        sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddRoleToUserSQL") : this.realmConfig.getUserStoreProperty("AddRoleToUserSQLCaseInsensitive");
                    }
                    if (sqlStmt2 == null) {
                        throw new UserStoreException("The sql statement for add user to role is null");
                    }
                    if (sqlStmt2.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, this.tenantId, roles, this.tenantId, userName, this.tenantId);
                        } else {
                            DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, roles, this.tenantId, userName, this.tenantId, this.tenantId);
                        }
                    } else {
                        DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newRoles, userName);
                    }
                }
                if (sharedRoles.length > 0) {
                    sqlStmt2 = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL") : this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQLCaseInsensitive");
                    if (sqlStmt2 == null) {
                        throw new UserStoreException("The sql statement for remove user from role is null");
                    }
                    DatabaseUtil.udpateUserRoleMappingWithExactParams(dbConnection, sqlStmt2, sharedRoles, userName, sharedTenantIds, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Database error occurred while updating role list of user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (UserStoreException e) {
            String errorMessage = "Error occurred while updating role list of user:" + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)((Object)e));
            }
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    protected void doSetUserAttribute(String userName, String attributeName, String value, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        if (value == null) {
            throw new UserStoreException("Cannot set null values.");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String propertyValue = this.getProperty(dbConnection, userName, attributeName, profileName);
            if (propertyValue == null) {
                this.addProperty(dbConnection, userName, attributeName, value, profileName);
            } else {
                this.updateProperty(dbConnection, userName, attributeName, value, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Database error occurred while saving user claim value for user : " + userName + " & attribute : " + attributeName + " value : " + value;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (UserStoreException e) {
            String errorMessage = "Error occurred while adding or updating claim value for user : " + userName + " attribute : " + attributeName + " profile : " + profileName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)((Object)e));
            }
            throw new UserStoreException(errorMessage, (Throwable)((Object)e));
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        claims.putIfAbsent("profileConfiguration", "default");
        super.doSetUserClaimValues(userName, claims, profileName);
    }

    @Override
    protected void doSetUserAttributes(String userName, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        try {
            Set<String> receivedProperties = processedClaimAttributes.keySet();
            Map<String, String> alreadyAvailableProperties = this.getUserPropertyValues(userName, receivedProperties.toArray(new String[0]), profileName);
            dbConnection = this.getDBConnection();
            this.addProperties(dbConnection, userName, this.filterNewlyAddedProperties(processedClaimAttributes, alreadyAvailableProperties), profileName);
            this.updateProperties(dbConnection, userName, this.filterUpdatedProperties(processedClaimAttributes, receivedProperties, alreadyAvailableProperties), profileName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while setting user claim values for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    protected Map<String, String> filterNewlyAddedProperties(Map<String, String> processedClaimAttributeValues, Map<String, String> alreadyAvailableProperties) {
        return processedClaimAttributeValues.entrySet().stream().filter(property -> !alreadyAvailableProperties.containsKey(property.getKey())).collect(Collectors.toMap(Map.Entry::getKey, property -> (String)processedClaimAttributeValues.get(property.getKey())));
    }

    protected Map<String, String> filterUpdatedProperties(Map<String, String> processedClaimAttributeValues, Set<String> receivedProperties, Map<String, String> alreadyAvailableProperties) {
        return alreadyAvailableProperties.entrySet().stream().filter(property -> receivedProperties.contains(property.getKey()) && !StringUtils.equals((String)((String)processedClaimAttributeValues.get(property.getKey())), (String)((String)property.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, property -> (String)processedClaimAttributeValues.get(property.getKey())));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            String property = null;
            property = "profileConfiguration".equals(claimURI) ? "profileConfiguration" : this.getClaimAtrribute(claimURI, userName, null);
            dbConnection = this.getDBConnection();
            this.deleteProperty(dbConnection, userName, property, profileName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while deleting user claim value for user : " + userName + " & claim URI : " + claimURI;
                if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                log.debug((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
                catch (org.wso2.carbon.user.api.UserStoreException e2) {
                    String errorMessage = "Error occurred while getting claim attribute for user : " + userName + " & claim URI : " + claimURI;
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e2);
                    log.debug((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(errorMessage, e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        Connection dbConnection = null;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            dbConnection = this.getDBConnection();
            for (String claimURI : claims) {
                String property = this.getClaimAtrribute(claimURI, userName, null);
                this.deleteProperty(dbConnection, userName, property, profileName);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Database error occurred while deleting user claim values for user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String errorMessage = "Error occurred while getting claim attribute for user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        this.doUpdateCredentialByAdmin(userName, newCredential);
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("UpdateUserPasswordSQL") : this.realmConfig.getUserStoreProperty("UpdateUserPasswordSQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for delete user claim value is null");
        }
        String saltValue = null;
        if ("true".equalsIgnoreCase((String)this.realmConfig.getUserStoreProperties().get("StoreSaltedPassword"))) {
            saltValue = this.generateSaltValue();
        }
        String password = this.preparePassword(newCredential, saltValue);
        if (sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, "", false, new Date(), userName, this.tenantId);
        } else if (sqlStmt.contains("UM_TENANT_ID") && saltValue != null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userName, this.tenantId);
        } else if (!sqlStmt.contains("UM_TENANT_ID") && saltValue == null) {
            this.updateStringValuesToDatabase(null, sqlStmt, password, "", false, new Date(), userName);
        } else {
            this.updateStringValuesToDatabase(null, sqlStmt, password, saltValue, false, new Date(), userName);
        }
    }

    @Override
    public Date doGetPasswordExpirationTime(String userName) throws UserStoreException {
        Date date;
        PreparedStatement prepStmt;
        ResultSet rs;
        Connection dbConnection;
        block9: {
            if (userName != null && userName.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                return super.getPasswordExpirationTime(userName);
            }
            dbConnection = null;
            rs = null;
            prepStmt = null;
            String sqlstmt = null;
            date = null;
            try {
                dbConnection = this.getDBConnection();
                dbConnection.setAutoCommit(false);
                sqlstmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("SelectUserSQL") : this.realmConfig.getUserStoreProperty("SelectUserSQLCaseInsensitive");
                if (log.isDebugEnabled()) {
                    log.debug((Object)sqlstmt);
                }
                prepStmt = dbConnection.prepareStatement(sqlstmt);
                prepStmt.setString(1, userName);
                if (sqlstmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(2, this.tenantId);
                }
                if (!(rs = prepStmt.executeQuery()).next()) break block9;
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                if (requireChange) {
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(changedTime);
                    gc.add(10, 24);
                    date = gc.getTime();
                }
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while retrieving password expiration time for user : " + userName;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return date;
    }

    private String generateSaltValue() {
        String saltValue = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(SHA_1_PRNG);
            byte[] bytes = new byte[16];
            secureRandom.nextBytes(bytes);
            saltValue = Base64.encode((byte[])bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1PRNG algorithm could not be found.");
        }
        return saltValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStringValuesToDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block16: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Invalid data provided");
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (param instanceof Integer) {
                            prepStmt.setInt(i + 1, (Integer)param);
                            continue;
                        }
                        if (param instanceof Date) {
                            prepStmt.setTimestamp(i + 1, new Timestamp(System.currentTimeMillis()));
                            continue;
                        }
                        if (!(param instanceof Boolean)) continue;
                        prepStmt.setBoolean(i + 1, (Boolean)param);
                    }
                }
                int count = prepStmt.executeUpdate();
                if (log.isDebugEnabled()) {
                    if (count == 0) {
                        log.debug((Object)"No rows were updated");
                    }
                    log.debug((Object)("Executed query is " + sqlStmt + " and number of updated rows :: " + count));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block16;
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while updating string values to database.";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    if (!(e instanceof SQLIntegrityConstraintViolationException)) throw new UserStoreException(msg, e);
                    throw new UserStoreException(msg, UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode(), e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public void addProperty(Connection dbConnection, String userName, String propertyName, String value, String profileName) throws UserStoreException {
        try {
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for add user property sql is null");
            }
            if (sqlStmt.contains("UM_TENANT_ID")) {
                if ("openedge".equals(type)) {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, propertyName, value, profileName, this.tenantId, userName, this.tenantId);
                } else {
                    this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, this.tenantId, propertyName, value, profileName, this.tenantId);
                }
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, propertyName, value, profileName);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while adding user property for user : " + userName + " & property name : " + propertyName + " & value : " + value;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
    }

    protected void updateProperty(Connection dbConnection, String userName, String propertyName, String value, String profileName) throws UserStoreException {
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("UpdateUserPropertySQL") : this.realmConfig.getUserStoreProperty("UpdateUserPropertySQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        if (sqlStmt.contains("UM_TENANT_ID")) {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, value, userName, this.tenantId, propertyName, profileName, this.tenantId);
        } else {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, value, userName, propertyName, profileName);
        }
    }

    protected void deleteProperty(Connection dbConnection, String userName, String propertyName, String profileName) throws UserStoreException {
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("DeleteUserPropertySQL") : this.realmConfig.getUserStoreProperty("DeleteUserPropertySQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        if (sqlStmt.contains("UM_TENANT_ID")) {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, this.tenantId, propertyName, profileName, this.tenantId);
        } else {
            this.updateStringValuesToDatabase(dbConnection, sqlStmt, userName, propertyName, profileName);
        }
    }

    protected String getProperty(Connection dbConnection, String userName, String propertyName, String profileName) throws UserStoreException {
        String string;
        String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("GetUserPropertyForProfileSQL") : this.realmConfig.getUserStoreProperty("GetUserPropertyForProfileSQLCaseInsensitive");
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for add user property sql is null");
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String value = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, userName);
            prepStmt.setString(2, propertyName);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                value = rs.getString(1);
            }
            string = value;
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving user profile property for user : " + userName + " & property name : " + propertyName + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return string;
    }

    @Deprecated
    protected String preparePassword(String password, String saltValue) throws UserStoreException {
        try {
            String digsestFunction;
            String digestInput = password;
            if (saltValue != null) {
                digestInput = password + saltValue;
            }
            if ((digsestFunction = (String)this.realmConfig.getUserStoreProperties().get("PasswordDigest")) != null) {
                if (digsestFunction.equals("PLAIN_TEXT")) {
                    return password;
                }
                MessageDigest dgst = MessageDigest.getInstance(digsestFunction);
                byte[] byteValue = dgst.digest(digestInput.getBytes());
                password = Base64.encode((byte[])byteValue);
            }
            return password;
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Error occurred while preparing password.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
    }

    protected String preparePassword(Object password, String saltValue) throws UserStoreException {
        Secret credentialObj;
        try {
            credentialObj = Secret.getSecret((Object)password);
        }
        catch (UnsupportedSecretTypeException e) {
            throw new UserStoreException("Unsupported credential type", e);
        }
        try {
            String passwordString;
            String digestFunction;
            if (saltValue != null) {
                credentialObj.addChars(saltValue.toCharArray());
            }
            if ((digestFunction = (String)this.realmConfig.getUserStoreProperties().get("PasswordDigest")) != null) {
                if (digestFunction.equals("PLAIN_TEXT")) {
                    String passwordString2;
                    String string = passwordString2 = new String(credentialObj.getChars());
                    return string;
                }
                MessageDigest digest = MessageDigest.getInstance(digestFunction);
                byte[] byteValue = digest.digest(credentialObj.getBytes());
                passwordString = Base64.encode((byte[])byteValue);
            } else {
                passwordString = new String(credentialObj.getChars());
            }
            String string = passwordString;
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Error occurred while preparing password.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        finally {
            credentialObj.clear();
        }
    }

    private DataSource loadUserStoreSpacificDataSoruce() throws UserStoreException {
        return DatabaseUtil.createUserStoreDataSource(this.realmConfig);
    }

    @Override
    public Map<String, String> getProperties(org.wso2.carbon.user.core.tenant.Tenant tenant) throws UserStoreException {
        return this.realmConfig.getUserStoreProperties();
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String[] values = DatabaseUtil.getStringValuesFromDatabase(dbConnection, "SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", userName, this.tenantId);
            Date createdTime = Calendar.getInstance().getTime();
            if (values != null && values.length > 0 && values[0].length() > 0) {
                DatabaseUtil.updateDatabase(dbConnection, "UPDATE UM_HYBRID_REMEMBER_ME SET UM_COOKIE_VALUE=?, UM_CREATED_TIME=? WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", token, createdTime, userName, this.tenantId);
            } else {
                DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_HYBRID_REMEMBER_ME (UM_USER_NAME, UM_COOKIE_VALUE, UM_CREATED_TIME, UM_TENANT_ID) VALUES (?,?,?,?)", userName, token, createdTime, this.tenantId);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Database error occurred while saving remember me token for tenant : " + this.tenantId;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while saving remember me token";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isExistingRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        boolean isValid = false;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String value = null;
        Timestamp createdTime = null;
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_COOKIE_VALUE, UM_CREATED_TIME FROM UM_HYBRID_REMEMBER_ME WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, userName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                value = rs.getString(1);
                createdTime = rs.getTimestamp(2);
            }
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while checking is existing remember me token for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (value != null && createdTime != null) {
            Calendar calendar = Calendar.getInstance();
            Date nowDate = calendar.getTime();
            calendar.setTime(createdTime);
            calendar.add(13, 604800);
            Date expDate = calendar.getTime();
            if (expDate.before(nowDate)) {
                log.debug((Object)"Remember me token has expired !!");
            } else if (value.equals(token)) {
                isValid = true;
            } else {
                log.debug((Object)"Remember me token in DB and token in request are different !!");
                isValid = false;
            }
        }
        return isValid;
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            if (this.isExistingUser(userName)) {
                return this.isExistingRememberMeToken(userName, token);
            }
        }
        catch (Exception e) {
            log.error((Object)("Validating remember me token failed for" + userName));
        }
        return false;
    }

    @Override
    public String[] getUserListFromProperties(String property, String value, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        if (value == null) {
            throw new IllegalArgumentException("Filter value cannot be null");
        }
        if (value.contains(QUERY_FILTER_STRING_ANY) && !value.matches("(\\*)\\1+")) {
            value = value.replaceAll("(?<!\\\\)\\*", SQL_FILTER_STRING_ANY);
        }
        String[] users = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            int searchTime;
            int givenMax;
            dbConnection = this.getDBConnection();
            sqlStmt = this.realmConfig.getUserStoreProperty("GetUserLisForPropertySQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            int maxItemLimit = -1;
            try {
                givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
            }
            catch (Exception e) {
                givenMax = 100;
            }
            try {
                searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
            }
            catch (Exception e) {
                searchTime = 10000;
            }
            if (maxItemLimit < 0 || maxItemLimit > givenMax) {
                maxItemLimit = givenMax;
            }
            prepStmt.setMaxRows(maxItemLimit);
            try {
                prepStmt.setQueryTimeout(searchTime);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                list.add(name);
            }
            if (list.size() > 0) {
                users = list.toArray(new String[list.size()]);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while listing users for a property : " + property + " & value : " + value + " & profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return users;
    }

    @Override
    public String[] doGetExternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        String[] names;
        String sqlStmt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting roles of user: " + userName + " with filter: " + filter));
        }
        if (filter.equals(QUERY_FILTER_STRING_ANY) || StringUtils.isEmpty((String)filter)) {
            sqlStmt = this.getExternalRoleListSqlStatement(this.realmConfig.getUserStoreProperty("UserRoleSQL"), this.realmConfig.getUserStoreProperty("UserRoleSQLCaseInsensitive"));
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userName, this.tenantId, this.tenantId, this.tenantId) : this.getStringValuesFromDatabase(sqlStmt, userName);
        } else {
            filter = filter.trim();
            filter = filter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
            filter = filter.replace(QUERY_BINDING_SYMBOL, "_");
            sqlStmt = this.getExternalRoleListSqlStatement(this.realmConfig.getUserStoreProperty("UserRoleExistSQL"), this.realmConfig.getUserStoreProperty("IsUserRoleExistSQLCaseInsensitive"));
            names = sqlStmt.contains("UM_TENANT_ID") ? this.getStringValuesFromDatabase(sqlStmt, userName, this.tenantId, this.tenantId, this.tenantId, filter) : this.getStringValuesFromDatabase(sqlStmt, userName, filter);
        }
        ArrayList roles = new ArrayList();
        if (log.isDebugEnabled()) {
            if (names != null) {
                for (String name : names) {
                    log.debug((Object)("Found role: " + name));
                }
            } else {
                log.debug((Object)("No external role found for the user: " + userName));
            }
        }
        Collections.addAll(roles, names);
        return roles.toArray(new String[roles.size()]);
    }

    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties(JDBCUserStoreConstants.JDBC_UM_MANDATORY_PROPERTIES.toArray(new Property[JDBCUserStoreConstants.JDBC_UM_MANDATORY_PROPERTIES.size()]));
        properties.setOptionalProperties(JDBCUserStoreConstants.JDBC_UM_OPTIONAL_PROPERTIES.toArray(new Property[JDBCUserStoreConstants.JDBC_UM_OPTIONAL_PROPERTIES.size()]));
        properties.setAdvancedProperties(JDBCUserStoreConstants.JDBC_UM_ADVANCED_PROPERTIES.toArray(new Property[JDBCUserStoreConstants.JDBC_UM_ADVANCED_PROPERTIES.size()]));
        return properties;
    }

    @Override
    protected Map<String, Map<String, String>> getUsersPropertyValues(List<String> users, String[] propertyNames, String profileName) throws UserStoreException {
        HashMap<String, Map<String, String>> name2;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        Object[] propertyNamesSorted = (String[])propertyNames.clone();
        Arrays.sort(propertyNamesSorted);
        HashMap<String, Map<String, String>> usersPropertyValuesMap = new HashMap<String, Map<String, String>>();
        try {
            int i;
            String sqlStmt;
            dbConnection = this.getDBConnection();
            StringBuilder usernameParameter = new StringBuilder();
            if (this.isCaseSensitiveUsername()) {
                sqlStmt = this.realmConfig.getUserStoreProperty("GetUsersPropertiesForProfileSQL");
                for (i = 0; i < users.size(); ++i) {
                    users.set(i, users.get(i).replaceAll("'", "''"));
                    usernameParameter.append("'").append(users.get(i)).append("'");
                    if (i == users.size() - 1) continue;
                    usernameParameter.append(",");
                }
            } else {
                sqlStmt = this.realmConfig.getUserStoreProperty("GetUsersPropertiesForProfileSQLCaseInsensitive");
                for (i = 0; i < users.size(); ++i) {
                    users.set(i, users.get(i).replaceAll("'", "''"));
                    usernameParameter.append("LOWER('").append(users.get(i)).append("')");
                    if (i == users.size() - 1) continue;
                    usernameParameter.append(",");
                }
            }
            sqlStmt = sqlStmt.replaceFirst("\\?", Matcher.quoteReplacement(usernameParameter.toString()));
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
                prepStmt.setInt(3, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String name2 = rs.getString(2);
                if (Arrays.binarySearch(propertyNamesSorted, name2) < 0) continue;
                String username = rs.getString(1);
                String value = rs.getString(3);
                if (usersPropertyValuesMap.get(username) != null) {
                    ((Map)usersPropertyValuesMap.get(username)).put(name2, value);
                    continue;
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(name2, value);
                usersPropertyValuesMap.put(username, attributes);
            }
            name2 = usersPropertyValuesMap;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error Occurred while getting property values";
                if (log.isDebugEnabled()) {
                    errorMessage = errorMessage + ": " + users;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return name2;
    }

    @Override
    protected Map<String, List<String>> doGetExternalRoleListOfUsers(List<String> userNames) throws UserStoreException {
        HashMap<String, List<String>> hashMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting roles of users: " + userNames));
        }
        HashMap<String, List<String>> rolesListOfUsersMap = new HashMap<String, List<String>>();
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            int i;
            String sqlStmt;
            dbConnection = this.getDBConnection();
            StringBuilder usernameParameter = new StringBuilder();
            if (this.isCaseSensitiveUsername()) {
                sqlStmt = this.realmConfig.getUserStoreProperty("UsersRoleSQL");
                if (sqlStmt == null) {
                    throw new UserStoreException("The sql statement for retrieving users roles is null");
                }
                for (i = 0; i < userNames.size(); ++i) {
                    userNames.set(i, userNames.get(i).replaceAll("'", "''"));
                    usernameParameter.append("'").append(userNames.get(i)).append("'");
                    if (i == userNames.size() - 1) continue;
                    usernameParameter.append(",");
                }
            } else {
                sqlStmt = this.realmConfig.getUserStoreProperty("UsersRoleSQLCaseInsensitive");
                if (sqlStmt == null) {
                    throw new UserStoreException("The sql statement for retrieving users roles is null");
                }
                for (i = 0; i < userNames.size(); ++i) {
                    userNames.set(i, userNames.get(i).replaceAll("'", "''"));
                    usernameParameter.append("LOWER('").append(userNames.get(i)).append("')");
                    if (i == userNames.size() - 1) continue;
                    usernameParameter.append(",");
                }
            }
            sqlStmt = sqlStmt.replaceFirst("\\?", Matcher.quoteReplacement(usernameParameter.toString()));
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(1, this.tenantId);
                prepStmt.setInt(2, this.tenantId);
                prepStmt.setInt(3, this.tenantId);
            }
            rs = prepStmt.executeQuery();
            String domainName = this.getMyDomainName();
            while (rs.next()) {
                String username = UserCoreUtil.addDomainToName(rs.getString(1), domainName);
                String roleName = UserCoreUtil.addDomainToName(rs.getString(2), domainName);
                if (rolesListOfUsersMap.get(username) != null) {
                    ((List)rolesListOfUsersMap.get(username)).add(roleName);
                    continue;
                }
                ArrayList<String> roleNames = new ArrayList<String>();
                roleNames.add(roleName);
                rolesListOfUsersMap.put(username, roleNames);
            }
            hashMap = rolesListOfUsersMap;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error Occurred while getting role lists of users";
                if (log.isDebugEnabled()) {
                    errorMessage = errorMessage + ": " + userNames;
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return hashMap;
    }

    protected void doAddSharedRole(String roleName, String[] userList) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddSharedRoleSQL");
            if (sqlStmt.contains("UM_TENANT_ID")) {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, true, roleName, this.tenantId);
            } else {
                this.updateStringValuesToDatabase(dbConnection, sqlStmt, true, roleName);
            }
            if (userList != null) {
                int roleTenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQL") : this.realmConfig.getUserStoreProperty("AddSharedRoleToUserSQLCaseInsensitive");
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt, roleName, roleTenantId, userList, this.tenantId, this.tenantId, roleTenantId);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String msg = "Database error occurred while adding shared role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        catch (Exception e) {
            String msg = "Error occurred while adding shared role.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    protected String[] doGetSharedRoleListOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for shared roles for user: " + userName + " for tenant: " + tenantDomain));
        }
        if (this.isSharedGroupEnabled()) {
            String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("UserSharedRoleSQL") : this.realmConfig.getUserStoreProperty("UserSharedRoleSQLCaseInsensitive");
            String[] sharedNames = this.getRoleNamesWithDomain(sqlStmt, userName, this.tenantId, true);
            return sharedNames;
        }
        return new String[0];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addProperties(Connection dbConnection, String userName, Map<String, String> properties, String profileName) throws UserStoreException {
        PreparedStatement prepStmt;
        block19: {
            String type;
            try {
                type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            }
            catch (Exception e) {
                String msg = "Error occurred while adding user properties for user : " + userName;
                if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                log.debug((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
            }
            String sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("AddUserPropertySQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for add user property sql is null");
            }
            prepStmt = null;
            boolean localConnection = false;
            try {
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String attributeName = entry.getKey();
                    String attributeValue = entry.getValue();
                    userAttributes.put(attributeName, attributeValue);
                }
                for (Map.Entry<String, String> entry : userAttributes.entrySet()) {
                    String propertyName = entry.getKey();
                    String propertyValue = entry.getValue();
                    if (sqlStmt.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            this.batchUpdateStringValuesToDatabase(prepStmt, propertyName, propertyValue, profileName, this.tenantId, userName, this.tenantId);
                            continue;
                        }
                        this.batchUpdateStringValuesToDatabase(prepStmt, userName, this.tenantId, propertyName, propertyValue, profileName, this.tenantId);
                        continue;
                    }
                    this.batchUpdateStringValuesToDatabase(prepStmt, userName, propertyName, propertyValue, profileName);
                }
                int[] counts = prepStmt.executeBatch();
                if (log.isDebugEnabled()) {
                    void var11_19;
                    boolean bl = false;
                    if (counts != null) {
                        int i;
                        int[] nArray = counts;
                        int n = nArray.length;
                        for (int j = 0; j < n; var11_19 += i, ++j) {
                            i = nArray[j];
                        }
                    }
                    if (var11_19 == false) {
                        log.debug((Object)"No rows were updated");
                    }
                    log.debug((Object)("Executed query is " + sqlStmt + " and number of updated rows :: " + (int)var11_19));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block19;
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while updating string values to database.";
                    if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                    log.debug((Object)msg, (Throwable)e);
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateProperties(Connection dbConnection, String userName, Map<String, String> properties, String profileName) throws UserStoreException {
        PreparedStatement prepStmt;
        block18: {
            String type;
            try {
                type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            }
            catch (Exception e) {
                String msg = "Error occurred while updating user properties for user : " + userName;
                if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                log.debug((Object)msg, (Throwable)e);
                throw new UserStoreException(msg, e);
            }
            String sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPropertySQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("UpdateUserPropertySQL");
            }
            if (sqlStmt == null) {
                throw new UserStoreException("The sql statement for update user property sql is null");
            }
            prepStmt = null;
            boolean localConnection = false;
            try {
                if (dbConnection == null) {
                    localConnection = true;
                    dbConnection = this.getDBConnection();
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String propertyName = entry.getKey();
                    String propertyValue = entry.getValue();
                    if (sqlStmt.contains("UM_TENANT_ID")) {
                        if ("openedge".equals(type)) {
                            this.batchUpdateStringValuesToDatabase(prepStmt, propertyName, propertyValue, profileName, this.tenantId, userName, this.tenantId);
                            continue;
                        }
                        this.batchUpdateStringValuesToDatabase(prepStmt, propertyValue, userName, this.tenantId, propertyName, profileName, this.tenantId);
                        continue;
                    }
                    this.batchUpdateStringValuesToDatabase(prepStmt, propertyValue, userName, propertyName, profileName);
                }
                int[] counts = prepStmt.executeBatch();
                if (log.isDebugEnabled()) {
                    int totalUpdated = 0;
                    if (counts != null) {
                        int i;
                        int[] nArray = counts;
                        int n = nArray.length;
                        for (int j = 0; j < n; totalUpdated += i, ++j) {
                            i = nArray[j];
                        }
                    }
                    if (totalUpdated == 0) {
                        log.debug((Object)"No rows were updated");
                    }
                    log.debug((Object)("Executed query is " + sqlStmt + " and number of updated rows :: " + totalUpdated));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block18;
            }
            catch (SQLException e) {
                try {
                    String msg = "Error occurred while updating string values to database.";
                    if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
                    log.debug((Object)msg, (Throwable)e);
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    private void batchUpdateStringValuesToDatabase(PreparedStatement prepStmt, Object ... params) throws UserStoreException {
        try {
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        throw new UserStoreException("Invalid data provided");
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        prepStmt.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Date) {
                        prepStmt.setTimestamp(i + 1, new Timestamp(System.currentTimeMillis()));
                        continue;
                    }
                    if (!(param instanceof Boolean)) continue;
                    prepStmt.setBoolean(i + 1, (Boolean)param);
                }
            }
            prepStmt.addBatch();
        }
        catch (SQLException e) {
            String msg = "Error occurred while updating property values to database.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
    }

    @Override
    protected RoleContext createRoleContext(String roleName) {
        String[] roleNameParts;
        JDBCRoleContext searchCtx = new JDBCRoleContext();
        if (this.isSharedGroupEnabled()) {
            roleNameParts = roleName.split("@");
            if (roleNameParts.length > 1 && (roleNameParts[1] == null || roleNameParts[1].equals("null"))) {
                roleNameParts = new String[]{roleNameParts[0]};
            }
        } else {
            roleNameParts = new String[]{roleName};
        }
        int tenantId = -1;
        if (roleNameParts.length > 1) {
            tenantId = Integer.parseInt(roleNameParts[1]);
            searchCtx.setTenantId(tenantId);
        } else {
            tenantId = this.tenantId;
            searchCtx.setTenantId(tenantId);
        }
        if (tenantId != this.tenantId) {
            searchCtx.setShared(true);
        }
        searchCtx.setRoleName(roleNameParts[0]);
        return searchCtx;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected PaginatedSearchResult doListUsers(String filter, int limit, int offset) throws UserStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long doCountUsersWithClaims(String claimUri, String value) throws UserStoreException {
        if (claimUri == null) {
            throw new IllegalArgumentException("Error while getting the claim uri");
        }
        String valueFilter = value;
        if (valueFilter == null) {
            throw new IllegalArgumentException("Error while getting the claim filter");
        }
        String sqlStmt = this.isUserNameClaim(claimUri) ? this.realmConfig.getUserStoreProperty("CountUsersSQL") : "SELECT COUNT(UM_USER_ID) AS RESULT FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME = ? AND UM_TENANT_ID = ? AND UM_ATTR_VALUE LIKE ? AND UM_PROFILE_ID = ?";
        if (valueFilter.equals(QUERY_FILTER_STRING_ANY)) {
            valueFilter = SQL_FILTER_STRING_ANY;
        } else {
            valueFilter = valueFilter.trim();
            valueFilter = valueFilter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
            valueFilter = valueFilter.replace(QUERY_BINDING_SYMBOL, "_");
        }
        try (Connection dbConnection = this.getDBConnection();){
            long l;
            block28: {
                PreparedStatement prepStmt;
                block26: {
                    long l2;
                    block27: {
                        prepStmt = dbConnection.prepareStatement(sqlStmt);
                        try {
                            String domainName = this.getMyDomainName();
                            if (StringUtils.isEmpty((String)domainName)) {
                                domainName = "PRIMARY";
                            }
                            if (this.isUserNameClaim(claimUri)) {
                                prepStmt.setString(1, valueFilter);
                                prepStmt.setInt(2, this.tenantId);
                            } else {
                                prepStmt.setString(1, this.userRealm.getClaimManager().getAttributeName(domainName, claimUri));
                                prepStmt.setInt(2, this.tenantId);
                                prepStmt.setString(3, valueFilter);
                                prepStmt.setString(4, "default");
                            }
                            ResultSet resultSet = prepStmt.executeQuery();
                            if (!resultSet.next()) break block26;
                            l2 = resultSet.getLong("RESULT");
                            if (prepStmt == null) break block27;
                        }
                        catch (Throwable throwable) {
                            if (prepStmt != null) {
                                try {
                                    prepStmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        prepStmt.close();
                    }
                    return l2;
                }
                log.warn((Object)("No result for the filter" + value));
                l = 0L;
                if (prepStmt == null) break block28;
                prepStmt.close();
            }
            return l;
        }
        catch (SQLException e) {
            String msg = "Error while executing the SQL " + sqlStmt;
            if (log.isDebugEnabled()) {
                log.debug((Object)(msg + sqlStmt));
            }
            throw new UserStoreException(msg, e);
        }
        catch (UserStoreException ex) {
            this.handleGetUserCountFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_COUNT_USERS.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_COUNT_USERS.getMessage(), ex.getMessage()), claimUri, value);
            throw ex;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String ErrorMsg = "Error while getting attribute name from " + claimUri;
            throw new UserStoreException(ErrorMsg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long doCountRoles(String filter) throws UserStoreException {
        String sqlStmt;
        long usersCount = 0L;
        if (filter.startsWith("Internal")) {
            sqlStmt = this.realmConfig.getUserStoreProperty("CountInternalRolesSQL");
            String[] names = filter.split(UserCoreConstants.DOMAIN_SEPARATOR);
            filter = names[1].trim();
        } else {
            sqlStmt = filter.startsWith("Application") ? this.realmConfig.getUserStoreProperty("CountApplicationRolesSQL") : this.realmConfig.getUserStoreProperty("CountRolesSQL");
        }
        if (StringUtils.isNotEmpty((String)filter)) {
            filter = filter.trim();
            filter = filter.replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
            filter = filter.replace(QUERY_BINDING_SYMBOL, "_");
        } else {
            filter = SQL_FILTER_STRING_ANY;
        }
        try (Connection dbConnection = this.getDBConnection();
             PreparedStatement prepStmt = dbConnection.prepareStatement(sqlStmt);){
            ResultSet resultSets;
            prepStmt.setString(1, filter);
            if (sqlStmt.toUpperCase().contains("ESCAPE")) {
                prepStmt.setString(2, SQL_FILTER_CHAR_ESCAPE);
                if (sqlStmt.contains("UM_TENANT_ID")) {
                    prepStmt.setInt(3, this.tenantId);
                }
            } else if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            if (!(resultSets = prepStmt.executeQuery()).next()) return usersCount;
            long l = resultSets.getLong(1);
            return l;
        }
        catch (SQLException e) {
            String msg = "Error occurred while retrieving users for filter : " + filter;
            if (!log.isDebugEnabled()) throw new UserStoreException(msg, e);
            log.debug((Object)msg, (Throwable)e);
            throw new UserStoreException(msg, e);
        }
        catch (UserStoreException ex) {
            this.handleGetUserCountFailure(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_ROLES_COUNT.getCode(), String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ERROR_WHILE_GETTING_ROLES_COUNT.getMessage(), ex.getMessage()), null, null);
            throw ex;
        }
    }

    protected int doGetListUsersCount(String filter) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int count = 0;
        try {
            if (filter != null && StringUtils.isNotEmpty((String)filter.trim())) {
                filter = filter.trim().replace(QUERY_FILTER_STRING_ANY, SQL_FILTER_STRING_ANY);
                filter = filter.replace(QUERY_BINDING_SYMBOL, "_");
            } else {
                filter = SQL_FILTER_STRING_ANY;
            }
            dbConnection = this.getDBConnection();
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            String sqlStmt = this.isCaseSensitiveUsername() ? this.realmConfig.getUserStoreProperty("UserFilterPaginatedCountSQL") : this.realmConfig.getUserStoreProperty("UserFilterPaginatedSQLCaseInsensitiveCount");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            if ((rs = prepStmt.executeQuery()).next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Error occurred while retrieving users count for filter : " + filter;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return count;
    }

    @Override
    public PaginatedSearchResult getUserListFromProperties(String property, String value, String profileName, int limit, int offset) throws UserStoreException {
        PaginatedSearchResult result = new PaginatedSearchResult();
        if (profileName == null) {
            profileName = "default";
        }
        if (limit == 0) {
            return result;
        }
        if (value == null) {
            throw new IllegalArgumentException("Filter value cannot be null");
        }
        if (value.contains(QUERY_FILTER_STRING_ANY) && !value.matches("(\\*)\\1+")) {
            value = value.replaceAll("(?<!\\\\)\\*", SQL_FILTER_STRING_ANY);
        }
        String[] users = new String[]{};
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            int initialOffset;
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            offset = offset <= 0 ? 0 : --offset;
            if (ORACLE.equalsIgnoreCase(type)) {
                limit = offset + limit;
            } else if (MSSQL.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
            } else if (DB2.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset += limit;
                limit = initialOffset + 1;
            }
            sqlStmt = this.realmConfig.getUserStoreProperty("GetPaginatedUserLisForPropertySQL-" + type);
            if (sqlStmt == null) {
                sqlStmt = this.realmConfig.getUserStoreProperty("GetPaginatedUserLisForPropertySQL");
            }
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
                prepStmt.setInt(6, limit);
                prepStmt.setInt(7, offset);
            } else {
                prepStmt.setInt(4, limit);
                prepStmt.setInt(5, offset);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                list.add(name);
            }
            if (list.size() > 0) {
                users = list.toArray(new String[list.size()]);
            }
            result.setUsers(users);
        }
        catch (Exception e) {
            try {
                String msg = "Database error occurred while paginating users for a property : " + property + " & value : " + value + "& profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        if (users.length == 0) {
            result.setSkippedUserCount(this.getUserListFromPropertiesCount(property, value, profileName));
        }
        return result;
    }

    @Override
    protected PaginatedSearchResult doGetUserList(Condition condition, String profileName, int limit, int offset, String sortBy, String sortOrder) throws UserStoreException {
        boolean isGroupFiltering = false;
        boolean isUsernameFiltering = false;
        boolean isClaimFiltering = false;
        int totalMultiGroupFilters = 0;
        int totalMulitClaimFitlers = 0;
        PaginatedSearchResult result = new PaginatedSearchResult();
        if (limit == 0) {
            return result;
        }
        ArrayList<ExpressionCondition> expressionConditions = new ArrayList<ExpressionCondition>();
        this.getExpressionConditions(condition, expressionConditions);
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName())) {
                isGroupFiltering = true;
                ++totalMultiGroupFilters;
                continue;
            }
            if (ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                isUsernameFiltering = true;
                continue;
            }
            isClaimFiltering = true;
            ++totalMulitClaimFitlers;
        }
        String[] users = new String[]{};
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            int initialOffset;
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            offset = offset <= 0 ? 0 : --offset;
            if (DB2.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset += limit;
                limit = initialOffset + 1;
            } else if (ORACLE.equalsIgnoreCase(type)) {
                limit = offset + limit;
            } else if (MSSQL.equalsIgnoreCase(type)) {
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
            }
            SqlBuilder sqlBuilder = this.getQueryString(isGroupFiltering, isUsernameFiltering, isClaimFiltering, expressionConditions, limit, offset, sortBy, sortOrder, profileName, type, totalMultiGroupFilters, totalMulitClaimFitlers);
            if (MYSQL.equals(type) && totalMultiGroupFilters > 1 && totalMulitClaimFitlers > 1) {
                String fullQuery = sqlBuilder.getQuery();
                String[] splits = fullQuery.split("INTERSECT ");
                int startIndex = 0;
                int endIndex = 0;
                for (String query : splits) {
                    ArrayList<String> tempUserList = new ArrayList<String>();
                    int occurance = StringUtils.countMatches((String)query, (String)QUERY_BINDING_SYMBOL);
                    prepStmt = dbConnection.prepareStatement(query);
                    this.populatePrepareStatement(sqlBuilder, prepStmt, startIndex, endIndex += occurance);
                    rs = prepStmt.executeQuery();
                    while (rs.next()) {
                        String name = rs.getString(1);
                        tempUserList.add(UserCoreUtil.addDomainToName(name, this.getMyDomainName()));
                    }
                    if (startIndex == 0) {
                        list = tempUserList;
                    } else {
                        list.retainAll(tempUserList);
                    }
                    startIndex += occurance;
                }
            } else {
                prepStmt = dbConnection.prepareStatement(sqlBuilder.getQuery());
                int occurance = StringUtils.countMatches((String)sqlBuilder.getQuery(), (String)QUERY_BINDING_SYMBOL);
                this.populatePrepareStatement(sqlBuilder, prepStmt, 0, occurance);
                rs = prepStmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    list.add(UserCoreUtil.addDomainToName(name, this.getMyDomainName()));
                }
            }
            if (list.size() > 0) {
                users = list.toArray(new String[list.size()]);
            }
            result.setUsers(users);
        }
        catch (Exception e) {
            try {
                String msg = "Error occur while doGetUserList for multi attribute searching";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return result;
    }

    private void populatePrepareStatement(SqlBuilder sqlBuilder, PreparedStatement prepStmt, int startIndex, int endIndex) throws SQLException {
        Map<Integer, Integer> integerParameters = sqlBuilder.getIntegerParameters();
        Map<Integer, String> stringParameters = sqlBuilder.getStringParameters();
        Map<Integer, Long> longParameters = sqlBuilder.getLongParameters();
        for (Map.Entry<Integer, Integer> entry : integerParameters.entrySet()) {
            if (entry.getKey() <= startIndex || entry.getKey() > endIndex) continue;
            prepStmt.setInt(entry.getKey() - startIndex, entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : stringParameters.entrySet()) {
            if (entry.getKey() <= startIndex || entry.getKey() > endIndex) continue;
            prepStmt.setString(entry.getKey() - startIndex, (String)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : longParameters.entrySet()) {
            if (entry.getKey() <= startIndex || entry.getKey() > endIndex) continue;
            prepStmt.setLong(entry.getKey() - startIndex, (Long)entry.getValue());
        }
    }

    protected SqlBuilder getQueryString(boolean isGroupFiltering, boolean isUsernameFiltering, boolean isClaimFiltering, List<ExpressionCondition> expressionConditions, int limit, int offset, String sortBy, String sortOrder, String profileName, String dbType, int totalMultiGroupFilters, int totalMulitClaimFitlers) throws UserStoreException {
        SqlBuilder sqlBuilder;
        StringBuilder sqlStatement;
        boolean hitGroupFilter = false;
        boolean hitClaimFilter = false;
        int groupFilterCount = 0;
        int claimFilterCount = 0;
        if (isGroupFiltering && isUsernameFiltering && isClaimFiltering || isGroupFiltering && isClaimFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_NAME  FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT  UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (POSTGRESQL.equals(dbType) ? new StringBuilder("SELECT DISTINCT UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID = U.UM_ID INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : new StringBuilder("SELECT DISTINCT UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR INNER JOIN UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON R.UM_ID = UR.UM_ROLE_ID AND UR.UM_USER_ID = U.UM_ID AND U.UM_ID = UA.UM_USER_ID"))));
            sqlBuilder = new SqlBuilder(sqlStatement).where("R.UM_TENANT_ID = ?", this.tenantId).where("U.UM_TENANT_ID = ?", this.tenantId).where("UR.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_PROFILE_ID = ?", profileName);
        } else if (isGroupFiltering && isUsernameFiltering || isGroupFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_NAME  FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID ") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT  UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID") : (POSTGRESQL.equals(dbType) ? new StringBuilder("SELECT DISTINCT UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR ON R.UM_ID = UR.UM_ROLE_ID INNER JOIN UM_USER U ON UR.UM_USER_ID =U.UM_ID") : new StringBuilder("SELECT DISTINCT UM_USER_NAME FROM UM_ROLE R INNER JOIN UM_USER_ROLE UR INNER JOIN UM_USER U ON R.UM_ID = UR.UM_ROLE_ID AND UR.UM_USER_ID =U.UM_ID"))));
            sqlBuilder = new SqlBuilder(sqlStatement).where("R.UM_TENANT_ID = ?", this.tenantId).where("U.UM_TENANT_ID = ?", this.tenantId).where("UR.UM_TENANT_ID = ?", this.tenantId);
        } else if (isUsernameFiltering && isClaimFiltering || isClaimFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_NAME  FROM  UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT UM_USER_NAME FROM UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT UM_USER_NAME FROM UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID") : new StringBuilder("SELECT DISTINCT UM_USER_NAME FROM UM_USER U INNER JOIN UM_USER_ATTRIBUTE UA ON U.UM_ID = UA.UM_USER_ID")));
            sqlBuilder = new SqlBuilder(sqlStatement).where("U.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_TENANT_ID = ?", this.tenantId).where("UA.UM_PROFILE_ID = ?", profileName);
        } else if (isUsernameFiltering) {
            sqlStatement = DB2.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, p.*  FROM (SELECT DISTINCT UM_USER_NAME  FROM UM_USER U") : (MSSQL.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM (SELECT DISTINCT UM_USER_NAME FROM UM_USER U") : (ORACLE.equals(dbType) ? new StringBuilder("SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT UM_USER_NAME FROM UM_USER U") : new StringBuilder("SELECT UM_USER_NAME FROM UM_USER U")));
            sqlBuilder = new SqlBuilder(sqlStatement).where("U.UM_TENANT_ID = ?", this.tenantId);
        } else {
            throw new UserStoreException("Condition is not valid.");
        }
        SqlBuilder header = new SqlBuilder(new StringBuilder(sqlBuilder.getSql()));
        this.addingWheres(sqlBuilder, header);
        for (ExpressionCondition expressionCondition : expressionConditions) {
            if (ExpressionAttribute.ROLE.toString().equals(expressionCondition.getAttributeName())) {
                if (!MYSQL.equals(dbType) || MYSQL.equals(dbType) && totalMultiGroupFilters > 1 && totalMulitClaimFitlers > 1) {
                    this.multiGroupQueryBuilder(sqlBuilder, header, hitGroupFilter, expressionCondition);
                    hitGroupFilter = true;
                    continue;
                }
                this.multiGroupMySqlQueryBuilder(sqlBuilder, groupFilterCount, expressionCondition);
                ++groupFilterCount;
                continue;
            }
            if (ExpressionOperation.EQ.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME = ?", expressionCondition.getAttributeValue());
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME = LOWER(?)", expressionCondition.getAttributeValue());
                continue;
            }
            if (ExpressionOperation.CO.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME LIKE ?", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME LIKE LOWER(?)", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                continue;
            }
            if (ExpressionOperation.EW.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME LIKE ?", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue());
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME LIKE LOWER(?)", SQL_FILTER_STRING_ANY + expressionCondition.getAttributeValue());
                continue;
            }
            if (ExpressionOperation.SW.toString().equals(expressionCondition.getOperation()) && ExpressionAttribute.USERNAME.toString().equals(expressionCondition.getAttributeName())) {
                if (this.isCaseSensitiveUsername()) {
                    sqlBuilder.where("U.UM_USER_NAME LIKE ?", expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                    continue;
                }
                sqlBuilder.where("U.UM_USER_NAME LIKE LOWER(?)", expressionCondition.getAttributeValue() + SQL_FILTER_STRING_ANY);
                continue;
            }
            if (!MYSQL.equals(dbType) || MYSQL.equals(dbType) && totalMultiGroupFilters > 1 && totalMulitClaimFitlers > 1) {
                this.multiClaimQueryBuilder(sqlBuilder, header, hitClaimFilter, expressionCondition);
                hitClaimFilter = true;
                continue;
            }
            this.multiClaimMySqlQueryBuilder(sqlBuilder, claimFilterCount, expressionCondition);
            ++claimFilterCount;
        }
        if (MYSQL.equals(dbType)) {
            sqlBuilder.updateSql(" GROUP BY U.UM_USER_NAME ");
            if (groupFilterCount > 0 && claimFilterCount > 0) {
                sqlBuilder.updateSql(" HAVING (COUNT(DISTINCT R.UM_ROLE_NAME) = " + groupFilterCount + " AND COUNT(DISTINCT UA.UM_ATTR_VALUE) = " + claimFilterCount + ")");
            } else if (groupFilterCount > 0) {
                sqlBuilder.updateSql(" HAVING COUNT(DISTINCT R.UM_ROLE_NAME) = " + groupFilterCount);
            } else if (claimFilterCount > 0) {
                sqlBuilder.updateSql(" HAVING COUNT(DISTINCT UA.UM_ATTR_VALUE) = " + claimFilterCount);
            }
        }
        if (!MYSQL.equals(dbType) || totalMultiGroupFilters <= 1 || totalMulitClaimFitlers <= 1) {
            if (DB2.equals(dbType)) {
                sqlBuilder.setTail(") AS p) WHERE rn BETWEEN ? AND ?", limit, offset);
            } else if (MSSQL.equals(dbType)) {
                sqlBuilder.setTail(") AS R) AS P WHERE P.RowNum BETWEEN ? AND ?", limit, offset);
            } else if (ORACLE.equals(dbType)) {
                sqlBuilder.setTail(" ORDER BY UM_USER_NAME) where rownum <= ?) WHERE  rnum > ?", limit, offset);
            } else {
                sqlBuilder.setTail(" ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?", limit, offset);
            }
        }
        return sqlBuilder;
    }

    private void multiGroupQueryBuilder(SqlBuilder sqlBuilder, SqlBuilder header, boolean hitFirstRound, ExpressionCondition expressionCondition) {
        if (hitFirstRound) {
            sqlBuilder.updateSql(" INTERSECT " + header.getSql());
            this.addingWheres(header, sqlBuilder);
            this.buildGroupWhereConditions(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildGroupWhereConditions(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildGroupWhereConditions(SqlBuilder sqlBuilder, String operation, String value) {
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME = ?", value);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.where("R.UM_ROLE_NAME LIKE ?", value + SQL_FILTER_STRING_ANY);
        }
    }

    private void multiGroupMySqlQueryBuilder(SqlBuilder sqlBuilder, int groupFilterCount, ExpressionCondition expressionCondition) {
        if (groupFilterCount == 0) {
            this.buildGroupWhereConditions(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildGroupConditionWithOROperator(sqlBuilder, expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildGroupConditionWithOROperator(SqlBuilder sqlBuilder, String operation, String value) {
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME = ?", value);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME LIKE ?", SQL_FILTER_STRING_ANY + value + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("R.UM_ROLE_NAME LIKE ?", value + SQL_FILTER_STRING_ANY);
        }
    }

    private void multiClaimQueryBuilder(SqlBuilder sqlBuilder, SqlBuilder header, boolean hitFirstRound, ExpressionCondition expressionCondition) {
        if (hitFirstRound) {
            sqlBuilder.updateSql(" INTERSECT " + header.getSql());
            this.addingWheres(header, sqlBuilder);
            this.buildClaimWhereConditions(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildClaimWhereConditions(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildClaimWhereConditions(SqlBuilder sqlBuilder, String attributeName, String operation, String attributeValue) {
        sqlBuilder.where("UA.UM_ATTR_NAME = ?", attributeName);
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE = ?", attributeValue);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.where("UA.UM_ATTR_VALUE LIKE ?", attributeValue + SQL_FILTER_STRING_ANY);
        }
    }

    private void multiClaimMySqlQueryBuilder(SqlBuilder sqlBuilder, int claimFilterCount, ExpressionCondition expressionCondition) {
        if (claimFilterCount == 0) {
            this.buildClaimWhereConditions(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        } else {
            this.buildClaimConditionWithOROperator(sqlBuilder, expressionCondition.getAttributeName(), expressionCondition.getOperation(), expressionCondition.getAttributeValue());
        }
    }

    private void buildClaimConditionWithOROperator(SqlBuilder sqlBuilder, String attributeName, String operation, String attributeValue) {
        sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_NAME = ?", attributeName);
        if (ExpressionOperation.EQ.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE = ?", attributeValue);
        } else if (ExpressionOperation.EW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue);
        } else if (ExpressionOperation.CO.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE LIKE ?", SQL_FILTER_STRING_ANY + attributeValue + SQL_FILTER_STRING_ANY);
        } else if (ExpressionOperation.SW.toString().equals(operation)) {
            sqlBuilder.updateSqlWithOROperation("UA.UM_ATTR_VALUE LIKE ?", attributeValue + SQL_FILTER_STRING_ANY);
        }
    }

    private void addingWheres(SqlBuilder baseSqlBuilder, SqlBuilder newSqlBuilder) {
        for (int i = 0; i < baseSqlBuilder.getWheres().size(); ++i) {
            if (baseSqlBuilder.getIntegerParameters().containsKey(i + 1)) {
                newSqlBuilder.where(baseSqlBuilder.getWheres().get(i), baseSqlBuilder.getIntegerParameters().get(i + 1));
                continue;
            }
            if (baseSqlBuilder.getStringParameters().containsKey(i + 1)) {
                newSqlBuilder.where(baseSqlBuilder.getWheres().get(i), baseSqlBuilder.getStringParameters().get(i + 1));
                continue;
            }
            if (!baseSqlBuilder.getIntegerParameters().containsKey(i + 1)) continue;
            newSqlBuilder.where(baseSqlBuilder.getWheres().get(i), baseSqlBuilder.getLongParameters().get(i + 1));
        }
    }

    private void getExpressionConditions(Condition condition, List<ExpressionCondition> expressionConditions) {
        if (condition instanceof ExpressionCondition) {
            expressionConditions.add((ExpressionCondition)condition);
        } else if (condition instanceof OperationalCondition) {
            Condition leftCondition = ((OperationalCondition)condition).getLeftCondition();
            this.getExpressionConditions(leftCondition, expressionConditions);
            Condition rightCondition = ((OperationalCondition)condition).getRightCondition();
            this.getExpressionConditions(rightCondition, expressionConditions);
        }
    }

    protected int getUserListFromPropertiesCount(String property, String value, String profileName) throws UserStoreException {
        if (profileName == null) {
            profileName = "default";
        }
        if (value == null) {
            throw new IllegalArgumentException("Filter value cannot be null");
        }
        if (value.contains(QUERY_FILTER_STRING_ANY) && !value.matches("(\\*)\\1+")) {
            value = value.replaceAll("(?<!\\\\)\\*", SQL_FILTER_STRING_ANY);
        }
        int count = 0;
        Connection dbConnection = null;
        String sqlStmt = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            dbConnection = this.getDBConnection();
            sqlStmt = this.realmConfig.getUserStoreProperty("GetPaginatedUserCountForPropertySQL");
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, property);
            prepStmt.setString(2, value);
            prepStmt.setString(3, profileName);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
            }
            if ((rs = prepStmt.executeQuery()).next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Database error occurred while paginating users count for a property : " + property + " & value : " + value + "& profile name : " + profileName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return count;
    }

    private boolean isCaseSensitiveUsername() {
        String isUsernameCaseInsensitiveString = this.realmConfig.getUserStoreProperty(CASE_INSENSITIVE_USERNAME);
        return !Boolean.parseBoolean(isUsernameCaseInsensitiveString);
    }

    private String getExternalRoleListSqlStatement(String caseSensitiveUsernameQuery, String nonCaseSensitiveUsernameQuery) throws UserStoreException {
        String sqlStmt = this.isCaseSensitiveUsername() ? caseSensitiveUsernameQuery : nonCaseSensitiveUsernameQuery;
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for retrieving user roles is null");
        }
        return sqlStmt;
    }

    private int getMaxUserNameListLength() {
        int maxUserList;
        try {
            maxUserList = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to get the MaxUserNameListLength from the realm configuration. The default value: 100 is used instead.", (Throwable)e);
            }
            maxUserList = 100;
        }
        return maxUserList;
    }

    private int getSQLQueryTimeoutLimit() {
        int searchTime;
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to get the MaxSearchQueryTime from the realm configuration. The default value: 10000 is used instead.", (Throwable)e);
            }
            searchTime = 10000;
        }
        return searchTime;
    }

    private boolean isUserNameClaim(String claim) {
        return "http://wso2.org/claims/username".equals(claim);
    }

    @Override
    public boolean isUniqueUserIdEnabled() {
        return false;
    }
}

