/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.jdbc;

import java.util.ArrayList;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.core.constants.UserStoreUIConstants;

public class JDBCUserStoreConstants {
    public static final ArrayList<Property> JDBC_UM_MANDATORY_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> JDBC_UM_OPTIONAL_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> JDBC_UM_ADVANCED_PROPERTIES = new ArrayList();
    private static final String usernameJavaRegExViolationErrorMsg = "UsernameJavaRegExViolationErrorMsg";
    private static final String usernameJavaRegExViolationErrorMsgDescription = "Error message when the Username is not matched with UsernameJavaRegEx";
    private static final String passwordJavaRegExViolationErrorMsg = "PasswordJavaRegExViolationErrorMsg";
    private static final String passwordJavaRegExViolationErrorMsgDescription = "Error message when the Password is not matched with passwordJavaRegEx";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final String MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION = "This is the separator for multiple claim values";
    private static final String VALIDATION_INTERVAL = "validationInterval";

    private static void setProperty(String name, String displayName, String value, String description, Property[] childProperties) {
        Property property = new Property(name, value, displayName + "#" + description, childProperties);
        JDBC_UM_OPTIONAL_PROPERTIES.add(property);
    }

    private static void setMandatoryProperty(String name, String displayName, String value, String description, boolean encrypt, Property[] childProperties) {
        String propertyDescription = displayName + "#" + description;
        if (encrypt) {
            propertyDescription = propertyDescription + "#encrypt";
        }
        Property property = new Property(name, value, propertyDescription, childProperties);
        JDBC_UM_MANDATORY_PROPERTIES.add(property);
    }

    private static void setAdvancedProperty(String name, String displayName, String value, String description, Property[] childProperties) {
        Property property = new Property(name, value, displayName + "#" + description, childProperties);
        JDBC_UM_ADVANCED_PROPERTIES.add(property);
    }

    static {
        JDBCUserStoreConstants.setMandatoryProperty("url", "Connection URL", "", "URL of the user store database", false, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setMandatoryProperty("userName", "Connection Name", "", "Username for the database", false, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setMandatoryProperty("password", "Connection Password", "", "Password for the database", true, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.PASSWORD.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setMandatoryProperty("driverName", "Driver Name", "", "Full qualified driver name", false, new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("Disabled", "Disabled", "false", "Whether user store is disabled", new Property[]{UserStoreUIConstants.DataCategory.BASIC.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("ReadOnly", "Read-only", "false", "Indicates whether the user store of this realm operates in the user read only mode or not", new Property[]{UserStoreUIConstants.DataCategory.BASIC.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("ReadGroups", "Read Groups", "true", "Specifies whether groups should be read from LDAP", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("WriteGroups", "Write Groups", "true", "Indicate whether write groups enabled", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("UsernameJavaRegEx", "Username RegEx (Java)", "[a-zA-Z0-9._\\-|//]{3,30}$", "A regular expression to validate user names", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("UsernameJavaScriptRegEx", "Username RegEx (Javascript)", "^[\\S]{5,30}$", "The regular expression used by the font-end components for username validation", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty(usernameJavaRegExViolationErrorMsg, "Username RegEx Violation Error Message", "Username pattern policy violated.", usernameJavaRegExViolationErrorMsgDescription, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setProperty("PasswordJavaRegEx", "Password RegEx (Java)", "^[\\S]{5,30}$", "A regular expression to validate passwords", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("PasswordJavaScriptRegEx", "Password RegEx (Javascript)", "^[\\S]{5,30}$", "The regular expression used by the font-end components for password validation", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty(passwordJavaRegExViolationErrorMsg, "Password RegEx Violation Error Message", "Password pattern policy violated", passwordJavaRegExViolationErrorMsgDescription, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setProperty("RolenameJavaRegEx", "Group Name RegEx (Java)", "[a-zA-Z0-9._\\-|//]{3,30}$", "A regular expression to validate group names", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("RolenameJavaScriptRegEx", "Group Name RegEx (Javascript)", "^[\\S]{5,30}$", "The regular expression used by the font-end components for group name validation", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.TRUE.getProperty()});
        JDBCUserStoreConstants.setProperty("CaseInsensitiveUsername", "Case Insensitive Username", "false", "Whether the username is case sensitive or not", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsBulkImportSupported", "Is Bulk Import Supported", "false", "Support Bulk User Import Operation for this user store", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("PasswordDigest", "Password Hashing Algorithm", "SHA-256", "Password Hash method to use when storing user entries", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty(MULTI_ATTRIBUTE_SEPARATOR, "Multiple Attribute Separator", ",", MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION, new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("StoreSaltedPassword", "Enable Salted Passwords", "true", "Indicates whether to salt the password", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("MaxUserNameListLength", "Maximum User List Length", "100", "Maximum number of users retrieved at once", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("MaxRoleNameListLength", "Maximum Group List Length", "100", "Maximum number of groups retrieved at once", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserRolesCacheEnabled", "Enable User Group Cache", "true", "This is to indicate whether to cache the group list of a user", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserNameUniqueAcrossTenants", "Make Username Unique Across Tenants", "false", "An attribute used for multi-tenancy", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("validationQuery", "Validation Query for the Database", "", "validationQuery is the SQL query that will be used to validate connections. This query MUST be an SQL SELECT statement that returns at least one row", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty(VALIDATION_INTERVAL, "Validation Interval(milliseconds)", "", "Used to avoid excess validation, only run validation at most at this frequency", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("defaultAutoCommit", "Default Auto-Commit", "", "The default auto-commit state of connections created by this pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("defaultReadOnly", "Default Read Only", "", "The default read-only state of connections created by this pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("defaultTransactionIsolation", "Default Transaction Isolation", "", "The default TransactionIsolation state of connections created by this pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("defaultCatalog", "Default Catalog", "", "The default catalog of connections created by this pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("initialSize", "Initial Size", "", "The initial number of connections that are created when the pool is started", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("testOnReturn", "Test On Return", "false", "The indication of whether objects will be validated before being returned to the pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("testOnBorrow", "Test On Borrow", "false", "The indication of whether objects will be validated before being borrowed from the pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("validatorClassName", "Validator Class Name", "", "The name of a class which implements the org.apache.tomcat.jdbc.pool.Validator interface and provides a no-arg constructor (may be implicit)", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("numTestsPerEvictionRun", "Num Tests Per Eviction Run", "", " Property not used in tomcat-jdbc-pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("accessToUnderlyingConnectionAllowed", "Access To Underlying Connection Allowed", "", "Property not used. Access can be achieved by calling unwrap on the pooled connection", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("removeAbandoned", "Remove Abandoned", "false", "Flag to remove abandoned connections if they exceed the removeAbandonedTimeout", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("removeAbandonedTimeout", "Remove Abandoned Timeout", "", "Timeout in seconds before an abandoned(in use) connection can be removed", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("logAbandoned", "Log Abandoned", "false", "Flag to log stack traces for application code which abandoned a Connection", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("connectionProperties", "Connection Properties", "", "The connection properties that will be sent to our JDBC driver when establishing new connections", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("initSQL", "Init SQL", "", "A custom query to be run when a connection is first created", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("jdbcInterceptors", "JDBC Interceptors", "", "JDBC Interceptors", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("jmxEnabled", "JMX Enabled", "true", "Register the pool with JMX or not", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("fairQueue", "Fair Queue", "true", "Set to true if you wish that calls to getConnection should be treated fairly in a true FIFO fashion", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("abandonWhenPercentageFull", "Abandon When Percentage Full", "", "Connections that have been abandoned (timed out) wont get closed and reported up unless the number of connections in use are above the percentage defined by abandonWhenPercentageFull", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("maxAge", "Max Age", "", "Time in milliseconds to keep the connection", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("useEquals", "Use Equals", "true", "Set to true if you wish the ProxyConnection class to use String.equals and set to false when you wish to use == when comparing method names", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("suspectTimeout", "Suspect Timeout", "", "Similar to to the removeAbandonedTimeout value but instead of treating the connection as abandoned, and potentially closing the connection, this simply logs the warning if logAbandoned is set to true", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("validationQueryTimeout", "Validation Query Timeout", "", "The timeout in seconds before a connection validation queries fail", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.NUMBER.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("alternateUsernameAllowed", "Alternate Username Allowed", "false", "If enabled, the pool size is still managed on a global level, and not on a per schema level", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("commitOnReturn", "Commit On Return", "false", "If autoCommit==false then the pool can complete the transaction by calling commit on the connection as it is returned to the pool If rollbackOnReturn==true then this attribute is ignored", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("rollbackOnReturn", "Rollback On Return", "false", "If autoCommit==false then the pool can terminate the transaction by calling rollback on the connection as it is returned to the pool", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.BOOLEAN.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("CountRetrieverClass", "Count Implementation", "org.wso2.carbon.identity.user.store.count.jdbc.JDBCUserStoreCountRetriever", "Name of the class that implements the count functionality", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserSQL", "Select User SQL", "SELECT * FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserNameSQL", "Select Username SQL", "SELECT UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserIDSQL", "Select User ID SQL", "SELECT UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserWithIDSQL", "Select User ID SQL", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME, UM_USER.UM_USER_PASSWORD, UM_USER.UM_SALT_VALUE, UM_USER.UM_REQUIRE_CHANGE, UM_USER.UM_CHANGED_TIME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE =? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserSQLCaseInsensitive", "Select User SQL With Case Insensitive Username", "SELECT * FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserNameSQLCaseInsensitive", "Select User Name SQL With Case Insensitive Username", "SELECT UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserWithIDSQLCaseInsensitive", "Select User With ID SQL With Case Insensitive Username", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME, UM_USER.UM_USER_PASSWORD, UM_USER.UM_SALT_VALUE, UM_USER.UM_REQUIRE_CHANGE, UM_USER.UM_CHANGED_TIME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND LOWER(UM_USER_ATTRIBUTE.UM_ATTR_VALUE) =LOWER(?) AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserIDFromUserNameSQL", "Select User ID From Username SQL", "SELECT UM_USER_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserNameFromUserIDSQL", "Select Username From User ID SQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserIDFromUserNameSQLCaseInsensitive", "Select User ID From Username SQL With Case Insensitive Username", "SELECT UM_USER_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetRoleListSQL", "Get Group List SQL", "SELECT UM_ROLE_NAME, UM_TENANT_ID, UM_SHARED_ROLE FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID=? AND UM_SHARED_ROLE ='0' ORDER BY UM_ROLE_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetSharedRoleListSQL", "Get Shared Group List SQP", "SELECT UM_ROLE_NAME, UM_TENANT_ID, UM_SHARED_ROLE FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_SHARED_ROLE ='1' ORDER BY UM_ROLE_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserFilterSQL", "User Filter SQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserFilterWithIDSQL", "User ID Filter SQL", "SELECT UM_USER_ID, UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserFilterSQLWithEscape", "User Filter SQL With Escape", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? ESCAPE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserFilterSQLCaseInsensitive", "User Filter SQL With Case Insensitive Username", "SELECT UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=? ORDER BY UM_USER_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserFilterWithIDSQLCaseInsensitive", "User Filter With ID SQL With Case Insensitive Username", "SELECT UM_USER_ID, UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=? ORDER BY UM_USER_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserFilterSQLCaseInsensitiveWithEscape", "User Filter SQL With Case Insensitive Username With Escape", "SELECT UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) ESCAPE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserRoleSQL", "User Group SQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserRoleWithIDSQL", "User Group With ID SQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_ID=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserRoleExistSQL", "User Group Exist SQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? AND UM_ROLE_NAME LIKE ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserRoleExistWithIDSQL", "User Group Exist With ID SQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_ID=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? AND UM_ROLE_NAME LIKE ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserRoleSQLCaseInsensitive", "User Group SQL With Case Insensitive Username", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsUserRoleExistSQLCaseInsensitive", "User Group Exist SQL With Case Insensitive Username", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? AND UM_ROLE_NAME LIKE ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserSharedRoleSQL", "User Shared Role SQL", "SELECT UM_ROLE_NAME, UM_ROLE.UM_TENANT_ID, UM_SHARED_ROLE FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_NAME = ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = ? ", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserSharedRoleWithIDSQL", "User Shared Role With ID SQL", "SELECT UM_ROLE_NAME, UM_ROLE.UM_TENANT_ID, UM_SHARED_ROLE FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_ID = ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = ? ", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserSharedRoleSQLCaseInsensitive", "User Shared Role SQL With Case Insensitive Username", "SELECT UM_ROLE_NAME, UM_ROLE.UM_TENANT_ID, UM_SHARED_ROLE FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE LOWER(UM_USER.UM_USER_NAME) = LOWER(?) AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = ? ", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsRoleExistingSQL", "Is Group Existing SQL", "SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfRoleSQL", "Get User List Of Group SQL", "SELECT UM_USER_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_ROLE.UM_ROLE_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfRoleFilterSQL", "Get User List Of Group Filter SQL", "SELECT UM_USER_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfRoleFilterWithIDSQL", "Get User List Of Group Filter SQL With ID", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfSharedRoleSQL", "Get User List Of Shared Role SQL", "SELECT UM_USER_NAME FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_ROLE.UM_ROLE_NAME= ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfSharedRoleFilterSQL", "Get User List Of Shared Role Filter SQL", "SELECT UM_USER_NAME FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME= ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfSharedRoleFilterWithIDSQL", "Get User List Of Shared Role Filter With ID SQL", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME= ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsUserExistingSQL", "Is User Existing SQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsUserExistingWithIDSQL", "Is User Existing SQL With ID", "SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsUserNameExistingSQL", "Is Username Existing SQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsUserExistingSQLCaseInsensitive", "Is User Existing SQL With Case Insensitive Username", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsUserExistingSQLCaseInsensitive", "Is Username Existing SQL With Case Insensitive Username", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertiesForProfileSQL", "Get User Properties for Profile SQL", "SELECT UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertiesForProfileWithIDSQL", "Get User Properties for Profile SQL With ID", "SELECT UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_ID=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertiesForProfileSQLCaseInsensitive", "Get User Properties for Profile SQL With Case Insensitive Username", "SELECT UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertyForProfileSQL", "Get User Property for Profile SQL", "SELECT UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME=? AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertyForProfileWithIDSQL", "Get User Property for Profile With ID SQL", "SELECT UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_ID=? AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertyForProfileSQLCaseInsensitive", "Get User Property for Profile SQL With Case Insensitive Username", "SELECT UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserLisForPropertySQL", "Get User List for Property SQL", "SELECT DISTINCT UM_USER_NAME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserLisForPropertyWithIDSQL", "Get User List for Property With ID SQL", "SELECT DISTINCT UM_USER.UM_USER_ID FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetProfileNamesSQL", "Get Profile Names SQL", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserProfileNamesSQL", "Get User Profile Names SQL", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserProfileNamesWithIDSQL", "Get User Profile Names SQL With ID", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserProfileNamesSQLCaseInsensitive", "Get User Profile Names SQL With Case Insensitive Username", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserIDFromUserNameSQL", "Get User ID From Username SQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserIDFromUserNameWithIDSQL", "Get User ID From Username SQL With ID", "SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserIDFromUserNameSQLCaseInsensitive", "Get User ID From Username SQL With Case Insensitive Username", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetUserNameFromTenantIDSQL", "Get Username From Tenant ID SQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetTenantIDFromUserNameSQL", "Get Tenant ID From Username SQL", "SELECT UM_TENANT_ID FROM UM_USER WHERE UM_USER_NAME=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("GetTenantIDFromUserNameSQLCaseInsensitive", "Get Tenant ID From Username SQL With Case Insensitive Username", "SELECT UM_TENANT_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserSQL", "Add User SQL", "INSERT INTO UM_USER (UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME, UM_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserWithIDSQL", "Add User With ID SQL", "INSERT INTO UM_USER (UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME, UM_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQL", "Add User To Group SQL", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleWithIDSQL", "Add User To Group With ID SQL", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQLCaseInsensitive", "Add User To Group SQL With Case Insensitive Username", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleSQL", "Add Group SQL", "INSERT INTO UM_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddSharedRoleSQL", "Add Shared Role SQL", "UPDATE UM_ROLE SET UM_SHARED_ROLE = ? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQL", "Add Group To User SQL", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserWithIDSQL", "Add Group To User With ID SQL", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?), ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddSharedRoleToUserSQL", "Add Shared Role To User SQL", "INSERT INTO UM_SHARED_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_USER_TENANT_ID, UM_ROLE_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddSharedRoleToUserWithIDSQL", "Add Shared Role To User With ID SQL", "INSERT INTO UM_SHARED_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_USER_TENANT_ID, UM_ROLE_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?), ?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddSharedRoleToUserSQLCaseInsensitive", "Add Shared Role To User SQL With Case Insensitive Username", "INSERT INTO UM_SHARED_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_USER_TENANT_ID, UM_ROLE_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?), ?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromSharedRoleSQL", "Remove User From Shared Roles SQL", "DELETE FROM UM_SHARED_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_USER_TENANT_ID=? AND UM_ROLE_TENANT_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromSharedRoleWithIDSQL", "Remove User From Shared Roles With ID SQL", "DELETE FROM UM_SHARED_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_USER_TENANT_ID=? AND UM_ROLE_TENANT_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromRoleSQLCaseInsensitive", "Remove User From Role SQL With Case Insensitive Username", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromRoleSQL", "Remove User From Group SQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromRoleWithIDSQL", "Remove User From Group With ID SQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromRoleSQLCaseInsensitive", "Remove Use From Group SQL With Case Insensitive Username", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveRoleFromUserSQL", "Remove Group From User SQL", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveRoleFromUserWithIDSQL", "Remove Group From User With ID SQL", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("RemoveRoleFromUserSQLCaseInsensitive", "Remove Group From User SQL With Case Insensitive Username", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("DeleteRoleSQL", "Delete Group SQL", "DELETE FROM UM_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteRoleRemoveUserRoleMappingSQL", "On Delete Group, Remove User Group Mapping SQL", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserSQL", "Delete User SQL", "DELETE FROM UM_USER WHERE UM_USER_NAME = ? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserSQLCaseInsensitive", "Delete User SQL With Case Insensitive Username", "DELETE FROM UM_USER WHERE LOWER(UM_USER_NAME) = LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteUserRemoveUserRoleMappingSQL", "On Delete User, Remove User Group Mapping SQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteUserRemoveUserRoleMappingWithIDSQL", "On Delete User, Remove User Group Mapping SQL With ID", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("CountUsersWithClaimSQL", "Count Users With Claim SQL", "SELECT COUNT(UM_USER_ID) AS RESULT FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME = ? AND UM_TENANT_ID = ? AND UM_ATTR_VALUE LIKE ? AND UM_PROFILE_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("CountInternalRolesSQL", "Count Internal Roles SQL", "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME NOT LIKE 'Application%' AND UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("CountApplicationRolesSQL", "Count Application Roles SQL", "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("CountRolesSQL", "Count Groups SQL", "SELECT COUNT(UM_ROLE_NAME) AS RESULT FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("CountUsersSQL", "Count Users SQL", "SELECT COUNT(UM_USER_NAME) AS RESULT FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID = ?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteUserRemoveUserAttributeSQL", "On Delete User, Remove User Attribute SQL", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteUserRemoveUserAttributeWithIDSQL", "On Delete User, Remove User Attribute SQL With ID", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserWithIDSQL", "Delete User With ID", "DELETE FROM UM_USER WHERE UM_USER_ID = ? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteUserRemoveUserAttributeSQLCaseInsensitive", "On Delete User, Remove User Attribute SQL With Case Insensitive Username", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPasswordSQL", "Update User Password SQL", "UPDATE UM_USER SET UM_USER_PASSWORD= ?, UM_SALT_VALUE=?, UM_REQUIRE_CHANGE=?, UM_CHANGED_TIME=? WHERE UM_USER_NAME= ? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPasswordWithIDSQL", "Update User Password With ID SQL", "UPDATE UM_USER SET UM_USER_PASSWORD= ?, UM_SALT_VALUE=?, UM_REQUIRE_CHANGE=?, UM_CHANGED_TIME=? WHERE UM_USER_ID= ? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPasswordSQLCaseInsensitive", "Update User Password SQL With Case Insensitive Username", "UPDATE UM_USER SET UM_USER_PASSWORD= ?, UM_SALT_VALUE=?, UM_REQUIRE_CHANGE=?, UM_CHANGED_TIME=? WHERE LOWER(UM_USER_NAME)= LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UpdateRoleNameSQL", "Update Group Name SQL", "UPDATE UM_ROLE set UM_ROLE_NAME=? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQL", "Add User Property SQL", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?, ?, ?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertyWithIDSQL", "Add User Property With ID SQL", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?), ?, ?, ?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPropertySQL", "Update User Property SQL", "UPDATE UM_USER_ATTRIBUTE SET UM_ATTR_VALUE=? WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPropertyWithIDSQL", "Update User Property With ID SQL", "UPDATE UM_USER_ATTRIBUTE SET UM_ATTR_VALUE=? WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPropertySQLCaseInsensitive", "Update User Property SQL With Case Insensitive Username", "UPDATE UM_USER_ATTRIBUTE SET UM_ATTR_VALUE=? WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserPropertySQL", "Delete User Property SQL", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserPropertyWWithIDSQL", "Delete User Property With ID SQL", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserPropertySQLCaseInsensitive", "Delete User Property SQL With Case Insensitive Username", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserNameUniqueAcrossTenantsSQL", "User Name Unique Across Tenant SQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserIDUniqueAcrossTenantsSQLWithID", "User ID Unique Across Tenant SQL With ID", "SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserNameUniqueAcrossTenantsSQLWithID", "User Name Unique Across Tenant SQL With ID", "SELECT UM_ID FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME=? AND UM_ATTR_VALUE=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserNameUniqueAcrossTenantsSQLCaseInsensitive", "User Name Unique Across Tenant SQL With Case Insensitive Username", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("UserNameUniqueAcrossTenantsSQLCaseInsensitiveWithID", "User Name Unique Across Tenant SQL With Case Insensitive Username With ID", "SELECT UM_ID FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME=? AND LOWER(UM_ATTR_VALUE)=LOWER(?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("IsDomainExistingSQL", "Is Domain Existing SQL", "SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddDomainSQL", "Add Domain SQL", "INSERT INTO UM_DOMAIN (UM_DOMAIN_NAME, UM_TENANT_ID) VALUES (?, ?)", "", new Property[]{UserStoreUIConstants.DataCategory.CONNECTION.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQL-mssql", "Add User To Group SQL (MSSQL)", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQL-mssql", "Add Group To User SQL (MSSQL)", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), (?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQL-mssql", "Add User Property (MSSQL)", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), (?), (?), (?), (?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQLCaseInsensitive-mssql", "Add User To Group SQL With Case Insensitive Username (MSSQL)", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQLCaseInsensitive-mssql", "Add Group To User SQL With Case Insensitive Username (MSSQL)", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?), (?)", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQLCaseInsensitive-mssql", "Add User Property With Case Insensitive Username (MSSQL)", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?), (?), (?), (?), (?)", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQL-openedge", "Add User To Group SQL (OpenEdge)", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT UU.UM_ID, UR.UM_ID, ? FROM UM_USER UU, UM_ROLE UR WHERE UU.UM_USER_NAME=? AND UU.UM_TENANT_ID=? AND UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQL-openedge", "Add Group To User SQL (OpenEdge)", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT UR.UM_ID, UU.UM_ID, ? FROM UM_ROLE UR, UM_USER UU WHERE UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=? AND UU.UM_USER_NAME=? AND UU.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQL-openedge", "Add User Property (OpenEdge)", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT UM_ID, ?, ?, ?, ? FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQLCaseInsensitive-openedge", "Add User To Group SQL With Case Insensitive Username (OpenEdge)", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT UU.UM_ID, UR.UM_ID, ? FROM UM_USER UU, UM_ROLE UR WHERE LOWER(UU.UM_USER_NAME)=LOWER(?) AND UU.UM_TENANT_ID=? AND UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQLCaseInsensitive-openedge", "Add Group To User SQL With Case Insensitive Username (OpenEdge)", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT UR.UM_ID, UU.UM_ID, ? FROM UM_ROLE UR, UM_USER UU WHERE UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=? AND LOWER(UU.UM_USER_NAME)=LOWER(?) AND UU.UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.GROUP.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQLCaseInsensitive-openedge", "Add User Property With Case Insensitive Username (OpenEdge)", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT UM_ID, ?, ?, ?, ? FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setAdvancedProperty("ClaimOperationsSupported", "Claim Operations Supported", "true", "Whether the userstore supports claim read and write", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.SQL.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
        JDBCUserStoreConstants.setProperty("UniqueID", "", "", "", new Property[]{UserStoreUIConstants.DataCategory.USER.getProperty(), UserStoreUIConstants.DataTypes.STRING.getProperty(), UserStoreUIConstants.DataImportance.FALSE.getProperty()});
    }
}

