/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.hybrid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.authorization.AuthorizationCache;
import org.wso2.carbon.user.core.common.UserRolesCache;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;
import org.wso2.carbon.utils.xml.StringUtils;

public class HybridRoleManager {
    private static Log log = LogFactory.getLog(JDBCUserStoreManager.class);
    private final int DEFAULT_MAX_ROLE_LIST_SIZE = 1000;
    private final int DEFAULT_MAX_SEARCH_TIME = 1000;
    protected UserRealm userRealm = null;
    protected UserRolesCache userRolesCache = null;
    int tenantId;
    private DataSource dataSource;
    private RealmConfiguration realmConfig;
    private String isCascadeDeleteEnabled;
    private boolean userRolesCacheEnabled = true;
    private static final String APPLICATION_DOMAIN = "Application";
    private static final String WORKFLOW_DOMAIN = "Workflow";
    private static final String CASE_INSENSITIVE_USERNAME = "CaseInsensitiveUsername";
    private static final String DB2 = "db2";

    public HybridRoleManager(DataSource dataSource, int tenantId, RealmConfiguration realmConfig, UserRealm realm) throws UserStoreException {
        this.dataSource = dataSource;
        this.tenantId = tenantId;
        this.realmConfig = realmConfig;
        this.isCascadeDeleteEnabled = realmConfig.getRealmProperty("isCascadeDeleteEnabled");
        this.userRealm = realm;
        UserCoreUtil.persistDomain("Internal", tenantId, dataSource);
        UserCoreUtil.persistDomain(APPLICATION_DOMAIN, tenantId, dataSource);
        UserCoreUtil.persistDomain(WORKFLOW_DOMAIN, tenantId, dataSource);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addHybridRole(String roleName, String[] userList) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String primaryDomainName = this.getMyDomainName();
            if (primaryDomainName != null) {
                primaryDomainName = primaryDomainName.toUpperCase();
            }
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (!this.isExistingRole(roleName)) {
                DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_HYBRID_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (?, ?)", roleName, this.tenantId);
                dbConnection.commit();
            } else {
                this.throwRoleAlreadyExistsError(roleName);
            }
            if (userList != null) {
                String sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))";
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if ("mssql".equals(type)) {
                    sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (?),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
                }
                if ("openedge".equals(type)) {
                    sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sql, primaryDomainName, userList, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sql, primaryDomainName, userList, roleName, this.tenantId, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (UserStoreException e) {
            try {
                String errorMessage = "Error occurred while adding hybrid role : " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)((Object)e));
                }
                if (!UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(e.getErrorCode())) throw e;
                this.throwRoleAlreadyExistsError(roleName);
                throw e;
                catch (SQLException e2) {
                    errorMessage = "Error occurred while adding hybrid role : " + roleName;
                    if (!log.isDebugEnabled()) throw new UserStoreException(e2.getMessage(), e2);
                    log.debug((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(e2.getMessage(), e2);
                }
                catch (Exception e3) {
                    errorMessage = "Error occurred while getting database type from DB connection";
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e3);
                    log.debug((Object)errorMessage, (Throwable)e3);
                    throw new UserStoreException(errorMessage, e3);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    protected void clearUserRolesCacheByTenant(int tenantID) {
        if (this.userRolesCache != null) {
            this.userRolesCache.clearCacheByTenant(tenantID);
            AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
            authorizationCache.clearCacheByTenant(tenantID);
        }
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        boolean value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME =? AND UM_TENANT_ID=?");
            prepStmt.setString(1, roleName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) > -1 != 0) {
                isExisting = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Is roleName: " + roleName + " Exist: " + isExisting + " TenantId: " + this.tenantId));
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while checking is existing role for role name : " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getHybridRoles(String filter) throws UserStoreException {
        String[] stringArray;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlStmt = "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID=?";
        int maxItemLimit = 100;
        int searchTime = 10000;
        try {
            maxItemLimit = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            maxItemLimit = 1000;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 1000;
        }
        try {
            if (filter != null && filter.trim().length() != 0) {
                filter = filter.trim();
                filter = filter.replace("*", "%");
                filter = filter.replace("?", "_");
            } else {
                filter = "%";
            }
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (dbConnection == null) {
                throw new UserStoreException("null connection");
            }
            dbConnection.setAutoCommit(false);
            if (dbConnection.getTransactionIsolation() != 2) {
                dbConnection.setTransactionIsolation(2);
            }
            String dbType = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if (filter.startsWith("Internal")) {
                sqlStmt = DB2.equalsIgnoreCase(dbType) ? "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND NOT(UM_ROLE_NAME LIKE ?) AND UM_TENANT_ID=?" : "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND NOT UM_ROLE_NAME LIKE ? AND UM_TENANT_ID=?";
            }
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int increment = 0;
            if (filter.startsWith("Internal")) {
                increment = (byte)(increment + 1);
                prepStmt.setString(increment, UserCoreUtil.removeDomainFromName(filter));
            } else {
                increment = (byte)(increment + 1);
                prepStmt.setString(increment, filter);
            }
            if (filter.startsWith("Internal")) {
                increment = (byte)(increment + 1);
                prepStmt.setString(increment, "%/%");
            }
            if (sqlStmt.contains("UM_TENANT_ID")) {
                increment = (byte)(increment + 1);
                prepStmt.setInt(increment, this.tenantId);
            }
            prepStmt.setMaxRows(maxItemLimit);
            try {
                prepStmt.setQueryTimeout(searchTime);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            ArrayList<String> filteredRoles = new ArrayList<String>();
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                log.error((Object)"Error while retrieving roles from Internal JDBC role store", (Throwable)e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (!name.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                        name = "Internal" + CarbonConstants.DOMAIN_SEPARATOR + name;
                    }
                    filteredRoles.add(name);
                }
            }
            stringArray = filteredRoles.toArray(new String[filteredRoles.size()]);
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while getting hybrid roles from filter : " + filter;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
                catch (Exception e2) {
                    String msg = "Error occur while getting database type";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e2);
                    }
                    throw new UserStoreException(msg, e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return stringArray;
    }

    public String[] getUserListOfHybridRole(String roleName) throws UserStoreException {
        if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
            return this.userRealm.getUserStoreManager().listUsers("*", -1);
        }
        String sqlStmt = "SELECT UM_USER_NAME, UM_DOMAIN_NAME FROM UM_HYBRID_USER_ROLE, UM_DOMAIN WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID";
        Connection dbConnection = null;
        try {
            String[] names;
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String[] stringArray = names = DatabaseUtil.getStringValuesFromDatabaseForInternalRoles(dbConnection, sqlStmt, roleName, this.tenantId, this.tenantId);
            return stringArray;
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting user list from hybrid role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateUserListOfHybridRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        String sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=? AND UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        String sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))";
        if (!this.isCaseSensitiveUsername()) {
            sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        }
        Connection dbConnection = null;
        try {
            String type;
            String primaryDomainName = this.getMyDomainName();
            if (primaryDomainName != null) {
                primaryDomainName = primaryDomainName.toUpperCase();
            }
            if ("mssql".equals(type = DatabaseCreator.getDatabaseType((Connection)(dbConnection = DatabaseUtil.getDBConnection(this.dataSource))))) {
                sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (?),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            }
            if (deletedUsers != null && deletedUsers.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt1, primaryDomainName, deletedUsers, roleName, this.tenantId, this.tenantId, this.tenantId);
                for (String deletedUser : deletedUsers) {
                    this.userRealm.getAuthorizationManager().clearUserAuthorization(deletedUser);
                }
            }
            if (newUsers != null && newUsers.length > 0) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt2, primaryDomainName, newUsers, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt2, primaryDomainName, newUsers, roleName, this.tenantId, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException | UserStoreException e) {
            try {
                String errorMessage = "Error occurred while updating user list of hybrid role : " + roleName;
                if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, (Throwable)e);
                log.debug((Object)errorMessage, (Throwable)e);
                throw new UserStoreException(errorMessage, (Throwable)e);
                catch (Exception e2) {
                    errorMessage = "Error occurred while getting database type from DB connection";
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e2);
                    log.debug((Object)errorMessage, (Throwable)e2);
                    throw new UserStoreException(errorMessage, e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    public void updateGroupListOfHybridRole(String roleName, String[] deletedGroups, String[] newGroups) throws UserStoreException {
        String sqlStmt1 = "DELETE FROM UM_HYBRID_GROUP_ROLE WHERE UM_GROUP_NAME=? ANDUM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        String sqlStmt2 = "INSERT INTO UM_HYBRID_GROUP_ROLE (UM_GROUP_NAME, UM_ROLE_ID, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))";
        try (Connection dbConnection = DatabaseUtil.getDBConnection(this.dataSource);){
            String type;
            String domainName = this.getMyDomainName();
            if (domainName != null) {
                domainName = domainName.toUpperCase();
            }
            if ("mssql".equals(type = DatabaseCreator.getDatabaseType((Connection)dbConnection))) {
                sqlStmt2 = "INSERT INTO UM_HYBRID_GROUP_ROLE (UM_GROUP_NAME, UM_ROLE_ID, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (?),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            }
            if (ArrayUtils.isNotEmpty((Object[])deletedGroups)) {
                DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt1, domainName, deletedGroups, roleName, this.tenantId, this.tenantId, this.tenantId);
            }
            if (ArrayUtils.isNotEmpty((Object[])newGroups)) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_HYBRID_GROUP_ROLE (UM_GROUP_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt2, domainName, newGroups, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchModeForInternalRoles(dbConnection, sqlStmt2, domainName, newGroups, roleName, this.tenantId, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException | UserStoreException e) {
            String errorMessage = "Error occurred while updating user list of hybrid role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while getting database type from DB connection";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
    }

    public String[] getGroupListOfHybridRole(String roleName) throws UserStoreException {
        String[] stringArray;
        block9: {
            String sqlStmt = "SELECT UM_GROUP_NAME, UM_DOMAIN_NAME FROM UM_HYBRID_GROUP_ROLE, UM_DOMAIN WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_HYBRID_GROUP_ROLE.UM_TENANT_ID=? AND UM_HYBRID_GROUP_ROLE.UM_DOMAIN_ID=UM_DOMAIN.UM_DOMAIN_ID";
            Connection dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            try {
                stringArray = DatabaseUtil.getStringValuesFromDatabaseForInternalRoles(dbConnection, sqlStmt, roleName, this.tenantId, this.tenantId);
                if (dbConnection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dbConnection != null) {
                        try {
                            dbConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    String errorMessage = "Error occurred while getting user list from hybrid role : " + roleName;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e);
                    }
                    throw new UserStoreException(errorMessage, e);
                }
            }
            dbConnection.close();
        }
        return stringArray;
    }

    public String[] getHybridRoleListOfUser(String userName, String filter) throws UserStoreException {
        Connection dbConnection = null;
        userName = UserCoreUtil.addDomainToName(userName, this.getMyDomainName());
        String domain = UserCoreUtil.extractDomainFromName(userName);
        try {
            String[] roles;
            String sqlStmt;
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            if (filter.equals("*") || StringUtils.isEmpty((String)filter)) {
                sqlStmt = this.getHybridRoleListSqlStatement(this.realmConfig.getRealmProperty("GetRoleListOfInternalUserSQL"), "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE UM_USER_NAME=? AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)");
                roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, UserCoreUtil.removeDomainFromName(userName), this.tenantId, this.tenantId, this.tenantId, domain);
            } else if (filter.contains("*") || filter.contains("?")) {
                filter = filter.trim();
                filter = filter.replace("*", "%");
                filter = filter.replace("?", "_");
                sqlStmt = this.getHybridRoleListSqlStatement(this.realmConfig.getRealmProperty("GetIsRoleExistFromRoleListOfInternalUserSQL"), "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE UM_USER_NAME=? AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?) AND UM_ROLE_NAME LIKE ?", "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?) AND UM_ROLE_NAME LIKE ?");
                filter = this.truncateInternalDomainFromFilter(filter);
                roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, UserCoreUtil.removeDomainFromName(userName), this.tenantId, this.tenantId, this.tenantId, domain, filter);
            } else {
                sqlStmt = this.getHybridRoleListSqlStatement(this.realmConfig.getRealmProperty("GetIsRoleExistFromRoleListOfInternalUserSQL"), "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE UM_USER_NAME=? AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?) AND UM_ROLE_NAME=?", "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?) AND UM_ROLE_NAME LIKE ?");
                filter = this.truncateInternalDomainFromFilter(filter);
                roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, UserCoreUtil.removeDomainFromName(userName), this.tenantId, this.tenantId, this.tenantId, domain, filter);
            }
            if (!"wso2.anonymous.user".equals(userName)) {
                if (roles == null || roles.length == 0) {
                    String[] stringArray = new String[]{this.realmConfig.getEveryOneRoleName()};
                    return stringArray;
                }
                ArrayList<String> allRoles = new ArrayList<String>();
                boolean isEveryone = false;
                for (String role : roles) {
                    if (!role.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                        role = "Internal" + CarbonConstants.DOMAIN_SEPARATOR + role;
                    }
                    if (role.equals(this.realmConfig.getEveryOneRoleName())) {
                        isEveryone = true;
                    }
                    allRoles.add(role);
                }
                if (!isEveryone) {
                    allRoles.add(this.realmConfig.getEveryOneRoleName());
                }
                String[] stringArray = allRoles.toArray(new String[allRoles.size()]);
                return stringArray;
            }
            String[] allRoles = roles;
            return allRoles;
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting hybrid role list of user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    private String truncateInternalDomainFromFilter(String filter) {
        int index;
        String filterLowerCased = filter.toLowerCase();
        if (filterLowerCased.contains("internal") && filterLowerCased.indexOf("internal") == 0 && (index = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR)) >= 0) {
            filter = filter.substring(index + 1);
        }
        return filter;
    }

    public Map<String, List<String>> getHybridRoleListOfUsers(List<String> userNames, String domainName) throws UserStoreException {
        int i;
        HashMap<String, List<String>> hybridRoleListOfUsers = new HashMap<String, List<String>>();
        String sqlStmt = this.realmConfig.getRealmProperty("GetRoleListOfInternalUsersSQL");
        StringBuilder usernameParameter = new StringBuilder();
        if (this.isCaseSensitiveUsername()) {
            if (StringUtils.isEmpty((String)sqlStmt)) {
                sqlStmt = "SELECT UM_USER_NAME, UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE UM_USER_NAME IN (?) AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            }
            for (i = 0; i < userNames.size(); ++i) {
                userNames.set(i, userNames.get(i).replaceAll("'", "''"));
                usernameParameter.append("'").append(userNames.get(i)).append("'");
                if (i == userNames.size() - 1) continue;
                usernameParameter.append(",");
            }
        } else {
            if (sqlStmt == null) {
                sqlStmt = "SELECT UM_USER_NAME, UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE LOWER(UM_USER_NAME) IN (?) AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_USER_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            }
            for (i = 0; i < userNames.size(); ++i) {
                userNames.set(i, userNames.get(i).replaceAll("'", "''"));
                usernameParameter.append("LOWER('").append(userNames.get(i)).append("')");
                if (i == userNames.size() - 1) continue;
                usernameParameter.append(",");
            }
        }
        sqlStmt = sqlStmt.replaceFirst("\\?", Matcher.quoteReplacement(usernameParameter.toString()));
        try (Connection connection = DatabaseUtil.getDBConnection(this.dataSource);
             PreparedStatement prepStmt = connection.prepareStatement(sqlStmt);){
            prepStmt.setInt(1, this.tenantId);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.setString(4, domainName);
            try (ResultSet resultSet = prepStmt.executeQuery();){
                while (resultSet.next()) {
                    String userName = resultSet.getString(1);
                    if (!userNames.contains(userName)) continue;
                    String roleName = resultSet.getString(2);
                    ArrayList<String> userRoles = (ArrayList<String>)hybridRoleListOfUsers.get(userName);
                    if (userRoles == null) {
                        userRoles = new ArrayList<String>();
                        hybridRoleListOfUsers.put(userName, userRoles);
                    }
                    if (!roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                        roleName = "Internal" + CarbonConstants.DOMAIN_SEPARATOR + roleName;
                    }
                    userRoles.add(roleName);
                }
            }
            for (String userName : userNames) {
                ArrayList<String> hybridRoles = (ArrayList<String>)hybridRoleListOfUsers.get(userName);
                if (hybridRoles == null) {
                    hybridRoles = new ArrayList<String>();
                    hybridRoleListOfUsers.put(userName, hybridRoles);
                }
                if (hybridRoles.contains(this.realmConfig.getEveryOneRoleName()) || "wso2.anonymous.user".equals(userName)) continue;
                hybridRoles.add(this.realmConfig.getEveryOneRoleName());
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting hybrid role list of users : " + Arrays.toString(userNames.toArray()) + " in domain: " + domainName;
            throw new UserStoreException(errorMessage, e);
        }
        return hybridRoleListOfUsers;
    }

    public Map<String, List<String>> getHybridRoleListOfGroups(List<String> groupNames, String domainName) throws UserStoreException {
        HashMap<String, List<String>> hybridRoleListOfGroups = new HashMap<String, List<String>>();
        String sqlStmt = this.realmConfig.getRealmProperty("GetInternalRoleListOfGroupsSQL");
        StringBuilder groupNameParameter = new StringBuilder();
        if (StringUtils.isEmpty((String)sqlStmt)) {
            sqlStmt = "SELECT UM_GROUP_NAME, UM_ROLE_NAME FROM UM_HYBRID_GROUP_ROLE, UM_HYBRID_ROLE WHERE UM_GROUP_NAME IN (?) AND UM_HYBRID_GROUP_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_GROUP_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=? AND UM_HYBRID_GROUP_ROLE.UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        }
        for (int i = 0; i < groupNames.size(); ++i) {
            groupNames.set(i, groupNames.get(i).replaceAll("'", "''"));
            groupNameParameter.append("'").append(groupNames.get(i)).append("'");
            if (i == groupNames.size() - 1) continue;
            groupNameParameter.append(",");
        }
        sqlStmt = sqlStmt.replaceFirst("\\?", Matcher.quoteReplacement(groupNameParameter.toString()));
        try (Connection connection = DatabaseUtil.getDBConnection(this.dataSource);
             PreparedStatement prepStmt = connection.prepareStatement(sqlStmt);){
            prepStmt.setInt(1, this.tenantId);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.setString(4, domainName);
            try (ResultSet resultSet = prepStmt.executeQuery();){
                while (resultSet.next()) {
                    String groupName = resultSet.getString(1);
                    if (!groupNames.contains(groupName)) continue;
                    String roleName = resultSet.getString(2);
                    List groupRoles = hybridRoleListOfGroups.computeIfAbsent(groupName, k -> new ArrayList());
                    if (!roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
                        roleName = "Internal" + CarbonConstants.DOMAIN_SEPARATOR + roleName;
                    }
                    groupRoles.add(roleName);
                }
            }
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while getting hybrid role list of groups : " + Arrays.toString(groupNames.toArray()) + " in domain: " + domainName;
            throw new UserStoreException(errorMessage, e);
        }
        return hybridRoleListOfGroups;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateHybridRoleListOfUser(String user, String[] deletedRoles, String[] addRoles) throws UserStoreException {
        String sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        String sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID, UM_DOMAIN_ID) VALUES ((SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, ?,(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))";
        if (!this.isCaseSensitiveUsername()) {
            sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        }
        Connection dbConnection = null;
        try {
            user = UserCoreUtil.addDomainToName(user, this.getMyDomainName());
            String domain = UserCoreUtil.extractDomainFromName(user);
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if ("mssql".equals(type)) {
                sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID,  UM_DOMAIN_ID) SELECT (SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (?),(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
            }
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            if (deletedRoles != null && deletedRoles.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedRoles, this.tenantId, UserCoreUtil.removeDomainFromName(user), this.tenantId, this.tenantId, domain);
            }
            if (addRoles != null && addRoles.length > 0) {
                ArrayList<String> newRoleList = new ArrayList<String>();
                for (String role : addRoles) {
                    if (!this.isExistingRole(role)) {
                        String errorMessage = "The role: " + role + " does not exist.";
                        throw new UserStoreException(errorMessage);
                    }
                    if (this.isUserInRole(user, role)) continue;
                    newRoleList.add(role);
                }
                String[] rolesToAdd = newRoleList.toArray(new String[newRoleList.size()]);
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) SELECT UM_ID, ?, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, user, this.tenantId, rolesToAdd, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, rolesToAdd, this.tenantId, UserCoreUtil.removeDomainFromName(user), this.tenantId, this.tenantId, domain);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException | UserStoreException e) {
            try {
                String errorMessage = "Error occurred while updating hybrid role list of user : " + user;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, (Throwable)e);
                catch (Exception e2) {
                    errorMessage = "Error occurred while getting database type from DB connection";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)errorMessage, (Throwable)e2);
                    }
                    throw new UserStoreException(errorMessage, e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        if (deletedRoles != null && deletedRoles.length > 0) {
            this.userRealm.getAuthorizationManager().clearUserAuthorization(user);
        }
    }

    public void deleteHybridRole(String roleName) throws UserStoreException {
        if (UserCoreUtil.isEveryoneRole(roleName, this.realmConfig)) {
            throw new UserStoreException("Invalid operation");
        }
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (this.isCascadeDeleteEnabled == null || !Boolean.parseBoolean(this.isCascadeDeleteEnabled)) {
                DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", roleName, this.tenantId, this.tenantId);
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?", roleName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while deleting hybrid role : " + roleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        if (!roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            roleName = UserCoreUtil.addDomainToName(roleName, "Internal");
        }
        this.userRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
    }

    public void updateHybridRoleName(String roleName, String newRoleName) throws UserStoreException {
        if (this.isExistingRole(newRoleName)) {
            throw new UserStoreException("Role name: " + newRoleName + " in the system. Please pick another role name.");
        }
        String sqlStmt = "UPDATE UM_HYBRID_ROLE set UM_ROLE_NAME=? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?";
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update hybrid role name is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (sqlStmt.contains("UM_TENANT_ID")) {
                DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId);
            } else {
                DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName);
            }
            dbConnection.commit();
            this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while updating hybrid role : " + roleName + " to new role : " + newRoleName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public Long countHybridRoles(String filter) throws UserStoreException {
        Long l;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        block8: {
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            resultSet = null;
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            if (filter.startsWith("Internal")) {
                sqlStmt = "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME NOT LIKE 'Application%' AND UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?";
                filter = filter.replace("Internal", "");
            } else {
                sqlStmt = "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?";
            }
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setQueryTimeout(10000);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block8;
            Long l2 = resultSet.getLong("RESULT");
            DatabaseUtil.closeAllConnections(dbConnection, resultSet, prepStmt);
            return l2;
        }
        try {
            log.error((Object)("No role count is retrieved for Internal domain filter: " + filter));
            l = -1L;
        }
        catch (SQLException e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("An error occurred while getting hybrid roles count Using sql : " + sqlStmt + ", with the filter: " + filter));
                }
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, resultSet, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, resultSet, prepStmt);
        return l;
    }

    public boolean isUserInRole(String userName, String roleName) throws UserStoreException {
        String[] roles = this.getHybridRoleListOfUser(userName, "*");
        if (roles != null && roleName != null) {
            for (String role : roles) {
                if (roleName.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                    if (!role.equalsIgnoreCase(roleName)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Role: " + roleName + " is already assigned to the user: " + userName));
                    }
                    return true;
                }
                if (!UserCoreUtil.removeDomainFromName(role).equalsIgnoreCase(roleName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Role: " + roleName + " is already assigned to the user: " + userName));
                }
                return true;
            }
        }
        return false;
    }

    public void deleteUser(String userName) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement preparedStatement = null;
        String domain = UserCoreUtil.extractDomainFromName(userName = UserCoreUtil.addDomainToName(userName, this.getMyDomainName()));
        if (domain != null) {
            domain = domain.toUpperCase();
        }
        String sqlStmt = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        if (!this.isCaseSensitiveUsername()) {
            sqlStmt = "DELETE FROM UM_HYBRID_USER_ROLE WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        }
        try {
            dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
            preparedStatement = dbConnection.prepareStatement(sqlStmt);
            preparedStatement.setString(1, UserCoreUtil.removeDomainFromName(userName));
            preparedStatement.setInt(2, this.tenantId);
            preparedStatement.setInt(3, this.tenantId);
            preparedStatement.setString(4, domain);
            preparedStatement.execute();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while deleting user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, preparedStatement);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, preparedStatement);
    }

    protected void initUserRolesCache() {
        String userRolesCacheEnabledString = this.realmConfig.getUserStoreProperty("UserRolesCacheEnabled");
        if (userRolesCacheEnabledString != null && !userRolesCacheEnabledString.equals("")) {
            this.userRolesCacheEnabled = Boolean.parseBoolean(userRolesCacheEnabledString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User Roles Cache is configured to:" + userRolesCacheEnabledString));
            }
        } else if (log.isDebugEnabled()) {
            log.info((Object)("User Roles Cache is not configured. Default value: " + this.userRolesCacheEnabled + " is taken."));
        }
        if (this.userRolesCacheEnabled) {
            int timeOut = 5;
            String timeOutString = this.realmConfig.getUserStoreProperty("UserCoreCacheTimeOut");
            if (timeOutString != null) {
                timeOut = Integer.parseInt(timeOutString);
            }
            this.userRolesCache = UserRolesCache.getInstance();
            this.userRolesCache.setTimeOut(timeOut);
        }
    }

    protected String getMyDomainName() {
        return UserCoreUtil.getDomainName(this.realmConfig);
    }

    private boolean isCaseSensitiveUsername() throws UserStoreException {
        String isUsernameCaseInsensitiveString = this.realmConfig.getUserStoreProperty(CASE_INSENSITIVE_USERNAME);
        return !Boolean.parseBoolean(isUsernameCaseInsensitiveString);
    }

    private String getHybridRoleListSqlStatement(String getRoleListOfUserSQLConfig, String caseSensitiveUsernameQuery, String nonCaseSensitiveUsernameQuery) throws UserStoreException {
        String sqlStmt = this.isCaseSensitiveUsername() ? caseSensitiveUsernameQuery : nonCaseSensitiveUsernameQuery;
        if (!StringUtils.isEmpty((String)getRoleListOfUserSQLConfig)) {
            sqlStmt = getRoleListOfUserSQLConfig;
        }
        return sqlStmt;
    }

    private void throwRoleAlreadyExistsError(String roleName) throws UserStoreException {
        String errorCode = UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getCode();
        String errorMessage = String.format(UserCoreErrorConstants.ErrorMessages.ERROR_CODE_ROLE_ALREADY_EXISTS.getMessage(), roleName);
        throw new UserStoreException(errorCode + " - " + errorMessage, errorCode, null);
    }
}

