/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config.multitenancy;

import java.util.Map;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;

public class LDAPRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static Log log = LogFactory.getLog(LDAPRealmConfigBuilder.class);

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfiguration, Tenant tenantInfo, int tenantId) throws UserStoreException {
        RealmConfiguration ldapRealmConfig = null;
        try {
            ldapRealmConfig = bootStrapConfig.cloneRealmConfiguration();
            ldapRealmConfig.setAdminPassword(UIDGenerator.generateUID());
            ldapRealmConfig.setAdminUserName(tenantInfo.getAdminName());
            ldapRealmConfig.setTenantId(tenantId);
            Map authz = ldapRealmConfig.getAuthzProperties();
            authz.put("AdminRoleManagementPermissions", "/permission/admin");
            Map userStoreProperties = ldapRealmConfig.getUserStoreProperties();
            String partitionDN = "dc=" + tenantInfo.getDomain().split("\\.")[0] + ",dc=" + tenantInfo.getDomain().split("\\.")[1];
            String userSearchBase = "ou=Users," + partitionDN;
            userStoreProperties.put("UserSearchBase", userSearchBase);
            return ldapRealmConfig;
        }
        catch (Exception e) {
            String errorMessage = "Tenant specific realm config could not be created.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }
}

