/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config.multitenancy;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class FileSystemRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static Log logger = LogFactory.getLog(FileSystemRealmConfigBuilder.class);

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        RealmConfiguration realmConfig;
        try {
            realmConfig = bootStrapConfig.cloneRealmConfiguration();
            realmConfig.setAdminPassword(persistedConfig.getAdminPassword());
            realmConfig.setAdminUserName(persistedConfig.getAdminUserName());
            realmConfig.setAdminRoleName(persistedConfig.getAdminRoleName());
            realmConfig.setEveryOneRoleName(persistedConfig.getEveryOneRoleName());
            realmConfig.setTenantId(persistedConfig.getTenantId());
            Map authz = realmConfig.getAuthzProperties();
            authz.put("AdminRoleManagementPermissions", "/permission/admin");
            if (persistedConfig.getUserStoreProperties().get("UserSearchBase") != null) {
                realmConfig.getUserStoreProperties().put("UserSearchBase", (String)persistedConfig.getUserStoreProperties().get("UserSearchBase"));
            }
            if (persistedConfig.getUserStoreProperties().get("GroupSearchBase") != null) {
                realmConfig.getUserStoreProperties().put("GroupSearchBase", (String)persistedConfig.getUserStoreProperties().get("GroupSearchBase"));
            }
            if (persistedConfig.getUserStoreProperties().get("UserDNPattern") != null) {
                realmConfig.getUserStoreProperties().put("UserDNPattern", (String)persistedConfig.getUserStoreProperties().get("UserDNPattern"));
            }
            realmConfig.setSecondaryRealmConfig(null);
            if (persistedConfig.getSecondaryRealmConfig() != null) {
                realmConfig.setSecondaryRealmConfig(persistedConfig.getSecondaryRealmConfig());
            }
        }
        catch (Exception e) {
            String errorMessage = "Error while building tenant specific realm configurationwhen creating tenant's realm.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return realmConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfig, Tenant tenantInfo, int tenantId) throws UserStoreException {
        try {
            RealmConfiguration ldapRealmConfig = bootStrapConfig.cloneRealmConfiguration();
            ldapRealmConfig.setAdminPassword(UserCoreUtil.getDummyPassword());
            ldapRealmConfig.setAdminUserName(tenantInfo.getAdminName());
            ldapRealmConfig.setTenantId(tenantId);
            this.removePropertiesFromTenantRealmConfig(ldapRealmConfig);
            String adminRoleName = ldapRealmConfig.getAdminRoleName();
            ldapRealmConfig.setAdminRoleName(UserCoreUtil.removeDomainFromName(adminRoleName));
            Map userStoreProperties = ldapRealmConfig.getUserStoreProperties();
            String partitionDN = (String)tenantMgtConfig.getTenantStoreProperties().get("RootPartition");
            String organizationName = tenantInfo.getDomain();
            String organizationRDN = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalAttribute") + "=" + organizationName;
            String orgSubContextAttribute = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
            String userContextRDNValue = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextUserContextName");
            if (userContextRDNValue == null) {
                userContextRDNValue = "users";
            }
            String userContextRDN = orgSubContextAttribute + "=" + userContextRDNValue;
            String userSearchBase = userContextRDN + "," + organizationRDN + "," + partitionDN;
            userStoreProperties.put("UserSearchBase", userSearchBase);
            if ("true".equals(bootStrapConfig.getUserStoreProperty("ReadLDAPGroups"))) {
                String groupContextRDNValue = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextGroupContextName");
                if (groupContextRDNValue == null) {
                    groupContextRDNValue = "groups";
                }
                String groupContextRDN = orgSubContextAttribute + "=" + groupContextRDNValue;
                String groupSearchBase = groupContextRDN + "," + organizationRDN + "," + partitionDN;
                userStoreProperties.put("GroupSearchBase", groupSearchBase);
            }
            if (bootStrapConfig.getUserStoreProperties().containsKey("UserDNPattern")) {
                String userDNPattern = (String)bootStrapConfig.getUserStoreProperties().get("UserDNPattern");
                String userIdentifier = userDNPattern.split(",")[0];
                String tenantUserDNPattern = userIdentifier + "," + userSearchBase;
                userStoreProperties.put("UserDNPattern", tenantUserDNPattern);
            }
            return ldapRealmConfig;
        }
        catch (Exception e) {
            String errorMessage = "Error while building tenant specific realm configuration to be persisted.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    private void removePropertiesFromTenantRealmConfig(RealmConfiguration tenantRealmConfiguration) {
        tenantRealmConfiguration.getRealmProperties().clear();
        String tenantManagerKey = "TenantManager";
        String tenantManagerValue = tenantRealmConfiguration.getUserStoreProperty(tenantManagerKey);
        tenantRealmConfiguration.getUserStoreProperties().clear();
        tenantRealmConfiguration.getUserStoreProperties().put(tenantManagerKey, tenantManagerValue);
    }
}

