/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.crypto.api.CipherMetaDataHolder;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.CryptoService;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.XMLProcessorUtils;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.internal.UserStoreMgtDataHolder;
import org.wso2.carbon.user.core.tracker.UserStoreManagerRegistry;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class UserStoreConfigXMLProcessor {
    private static final Log log = LogFactory.getLog(UserStoreConfigXMLProcessor.class);
    private static BundleContext bundleContext;
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";
    private static PrivateKey privateKey;
    private SecretResolver secretResolver;
    private String filePath = null;
    private Gson gson = new Gson();
    private static final String CRYPTO_API_PROVIDER_BC = "BC";
    private static final String ENCRYPTION_KEYSTORE = "Security.UserStorePasswordEncryption";
    private static final String INTERNAL_KEYSTORE = "InternalKeystore";
    private static final String CRYPTO_PROVIDER = "CryptoService.InternalCryptoProviderClassName";
    private static final String SYMMETRIC_KEY_CRYPTO_PROVIDER = "org.wso2.carbon.crypto.provider.SymmetricKeyInternalCryptoProvider";

    public UserStoreConfigXMLProcessor(String path) {
        this.filePath = path;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        UserStoreConfigXMLProcessor.bundleContext = bundleContext;
    }

    public static OMElement serialize(RealmConfiguration realmConfig) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement userStoreManagerElement = factory.createOMElement(new QName("UserStoreManager"));
        UserStoreConfigXMLProcessor.addPropertyElements(factory, userStoreManagerElement, realmConfig.getUserStoreClass(), realmConfig.getUserStoreProperties());
        return userStoreManagerElement;
    }

    private static void addPropertyElements(OMFactory factory, OMElement parent, String className, Map<String, String> properties) {
        if (className != null) {
            parent.addAttribute("class", className, null);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            OMElement propElem = factory.createOMElement(new QName("Property"));
            OMAttribute propAttr = factory.createOMAttribute("name", null, name);
            propElem.addAttribute(propAttr);
            propElem.setText(value);
            parent.addChild((OMNode)propElem);
        }
    }

    public RealmConfiguration buildUserStoreConfigurationFromFile() throws UserStoreException {
        try {
            OMElement realmElement = this.getRealmElement();
            return this.buildUserStoreConfiguration(realmElement);
        }
        catch (Exception e) {
            String message = "Error while building user store manager from file";
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            throw new UserStoreException(message, e);
        }
    }

    public RealmConfiguration buildUserStoreConfiguration(OMElement userStoreElement) throws org.wso2.carbon.user.api.UserStoreException {
        RealmConfiguration realmConfig = null;
        String userStoreClass = null;
        Map<String, String> userStoreProperties = null;
        boolean passwordsExternallyManaged = false;
        XMLProcessorUtils xmlProcessorUtils = new XMLProcessorUtils();
        realmConfig = new RealmConfiguration();
        String pattern = Pattern.quote(System.getProperty("file.separator"));
        String[] fileNames = this.filePath.split(pattern);
        String fileName = fileNames[fileNames.length - 1].replace(".xml", "").replace("_", ".");
        RealmConfiguration primaryRealm = UserStoreMgtDSComponent.getRealmService().getBootstrapRealmConfiguration();
        userStoreClass = userStoreElement.getAttributeValue(new QName("class"));
        userStoreProperties = this.getChildPropertyElements(userStoreElement, this.secretResolver);
        if (!userStoreProperties.get("DomainName").equalsIgnoreCase(fileName)) {
            throw new UserStoreException("File name is required to be the user store domain name(eg.: wso2.com-->wso2_com.xml).");
        }
        if (!xmlProcessorUtils.isMandatoryFieldsProvided(userStoreProperties, UserStoreManagerRegistry.getUserStoreProperties(userStoreClass).getMandatoryProperties())) {
            throw new UserStoreException("A required mandatory field is missing.");
        }
        String sIsPasswordExternallyManaged = userStoreProperties.get("PasswordsExternallyManaged");
        if (null != sIsPasswordExternallyManaged && !sIsPasswordExternallyManaged.trim().equals("")) {
            passwordsExternallyManaged = Boolean.parseBoolean(sIsPasswordExternallyManaged);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"External password management is disabled.");
        }
        Map<String, String> multipleCredentialsProperties = this.getMultipleCredentialsProperties(userStoreElement);
        realmConfig.setUserStoreClass(userStoreClass);
        realmConfig.setAuthorizationManagerClass(primaryRealm.getAuthorizationManagerClass());
        realmConfig.setEveryOneRoleName(UserCoreUtil.addDomainToName(primaryRealm.getEveryOneRoleName(), "Internal"));
        realmConfig.setUserStoreProperties(userStoreProperties);
        realmConfig.setPasswordsExternallyManaged(passwordsExternallyManaged);
        realmConfig.setAuthzProperties(primaryRealm.getAuthzProperties());
        realmConfig.setRealmProperties(primaryRealm.getRealmProperties());
        realmConfig.setPasswordsExternallyManaged(primaryRealm.isPasswordsExternallyManaged());
        realmConfig.addMultipleCredentialProperties(userStoreClass, multipleCredentialsProperties);
        if (realmConfig.getUserStoreProperty("MaxUserNameListLength") == null) {
            realmConfig.getUserStoreProperties().put("MaxUserNameListLength", "100");
        }
        if (realmConfig.getUserStoreProperty("ReadOnly") == null) {
            realmConfig.getUserStoreProperties().put("ReadOnly", "false");
        }
        return realmConfig;
    }

    private Map<String, String> getChildPropertyElements(OMElement omElement, SecretResolver secretResolver) throws org.wso2.carbon.user.api.UserStoreException {
        String domainName = "";
        try {
            AXIOMXPath xPath = new AXIOMXPath("//UserStoreManager/Property[@name='DomainName']");
            OMElement val = (OMElement)xPath.selectSingleNode((Object)omElement);
            if (val != null) {
                domainName = "." + val.getText();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error While getting DomainName from Configurations ");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator ite = omElement.getChildrenWithName(new QName("Property"));
        boolean tokenProtected = false;
        while (ite.hasNext()) {
            OMElement propElem = (OMElement)ite.next();
            String propName = propElem.getAttributeValue(new QName("name"));
            String propValue = propElem.getText();
            if (secretResolver != null && secretResolver.isInitialized()) {
                String alias = MiscellaneousUtil.getProtectedToken((String)propValue);
                if (StringUtils.isNotEmpty((String)alias) && secretResolver.isTokenProtected(alias)) {
                    propValue = secretResolver.resolve(alias);
                    tokenProtected = true;
                } else {
                    if (secretResolver.isTokenProtected("UserManager.Configuration.Property." + propName + domainName)) {
                        propValue = secretResolver.resolve("UserManager.Configuration.Property." + propName + domainName);
                        tokenProtected = true;
                    }
                    if (secretResolver.isTokenProtected("UserStoreManager.Property." + propName + domainName)) {
                        propValue = secretResolver.resolve("UserStoreManager.Property." + propName + domainName);
                        tokenProtected = true;
                    }
                }
            }
            if (!tokenProtected && propValue != null) {
                propValue = this.resolveEncryption(propElem);
            }
            tokenProtected = false;
            if (propName == null || propValue == null) continue;
            map.put(propName.trim(), propValue.trim());
        }
        return map;
    }

    private Map<String, String> getMultipleCredentialsProperties(OMElement omElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        OMElement multipleCredentialsEl = omElement.getFirstChildWithName(new QName("MultipleCredentials"));
        if (multipleCredentialsEl != null) {
            Iterator ite = multipleCredentialsEl.getChildrenWithLocalName("Credential");
            while (ite.hasNext()) {
                Object OMObj = ite.next();
                if (!(OMObj instanceof OMElement)) continue;
                OMElement credsElem = (OMElement)OMObj;
                String credsType = credsElem.getAttributeValue(new QName("type"));
                String credsClassName = credsElem.getText();
                map.put(credsType.trim(), credsClassName.trim());
            }
        }
        return map;
    }

    private OMElement getRealmElement() throws XMLStreamException, IOException, UserStoreException {
        StAXOMBuilder builder = null;
        InputStream inStream = null;
        inStream = new FileInputStream(this.filePath);
        try {
            inStream = CarbonUtils.replaceSystemVariablesInXml((InputStream)inStream);
            builder = new StAXOMBuilder(inStream);
            OMElement documentElement = builder.getDocumentElement();
            this.setSecretResolver(documentElement);
            OMElement oMElement = documentElement;
            return oMElement;
        }
        catch (CarbonException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            inStream.close();
        }
    }

    public void setSecretResolver(OMElement rootElement) {
        this.secretResolver = SecretResolverFactory.create((OMElement)rootElement, (boolean)true);
    }

    private String resolveEncryption(OMElement propElem) throws org.wso2.carbon.user.api.UserStoreException {
        String secretPropName;
        String propValue = propElem.getText();
        if (propValue != null && (secretPropName = propElem.getAttributeValue(new QName("encrypted"))) != null && secretPropName.equalsIgnoreCase("true")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Eligible to be decrypted=" + propElem.getAttributeValue(new QName("name"))));
            }
            try {
                propValue = this.decryptProperty(propValue);
            }
            catch (CryptoException e) {
                String errMsg = "decryption of Property=" + propElem.getAttributeValue(new QName("name")) + " failed";
                log.error((Object)errMsg, (Throwable)e);
            }
        }
        return propValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey getPrivateKey() {
        ServerConfigurationService serverConfigurationService = UserStoreMgtDSComponent.getServerConfigurationService();
        if (serverConfigurationService == null) {
            String message = "Key store initialization for decrypting secondary store failed due to serverConfigurationService is null while attempting to decrypt secondary store";
            log.error((Object)message);
            return null;
        }
        InputStream in = null;
        String passwordXPath = "Security.KeyStore.Password";
        String keypassXPath = "Security.KeyStore.KeyPassword";
        String keyAliasXPath = "Security.KeyStore.KeyAlias";
        String locationXPath = "Security.KeyStore.Location";
        String typeXPath = "Security.KeyStore.Type";
        String password = serverConfigurationService.getFirstProperty(passwordXPath);
        String keyPass = serverConfigurationService.getFirstProperty(keypassXPath);
        String keyAlias = serverConfigurationService.getFirstProperty(keyAliasXPath);
        try {
            KeyStore store = KeyStore.getInstance(serverConfigurationService.getFirstProperty(typeXPath));
            String file = new File(serverConfigurationService.getFirstProperty(locationXPath)).getAbsolutePath();
            in = new FileInputStream(file);
            store.load(in, password.toCharArray());
            PrivateKey privateKey = (PrivateKey)store.getKey(keyAlias, keyPass.toCharArray());
            return privateKey;
        }
        catch (FileNotFoundException e) {
            String errorMsg = "Keystore File Not Found in configured location";
            log.error((Object)errorMsg, (Throwable)e);
        }
        catch (IOException e) {
            String errorMsg = "Keystore File IO operation failed";
            log.error((Object)errorMsg, (Throwable)e);
        }
        catch (KeyStoreException e) {
            String errorMsg = "Faulty keystore";
            log.error((Object)errorMsg, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            String errorMsg = "Some parameters assigned to access the keystore is invalid";
            log.error((Object)errorMsg, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error occurred while closing Registry key store file", (Throwable)e);
                }
            }
        }
        return null;
    }

    private String decryptProperty(String propValue) throws CryptoException {
        CryptoService cryptoService = UserStoreMgtDataHolder.getInstance().getCryptoService();
        String cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
        byte[] cipherTextBytes = Base64.decode((String)propValue.trim());
        String algorithm = null;
        boolean isInternalKeyStoreEncryptionEnabled = false;
        boolean isSymmetricKeyEncryptionEnabled = false;
        ServerConfigurationService config = UserStoreMgtDSComponent.getServerConfigurationService();
        if (config != null) {
            String cryptoProvider;
            String encryptionKeyStore = config.getFirstProperty(ENCRYPTION_KEYSTORE);
            if (INTERNAL_KEYSTORE.equalsIgnoreCase(encryptionKeyStore)) {
                isInternalKeyStoreEncryptionEnabled = true;
            }
            if (SYMMETRIC_KEY_CRYPTO_PROVIDER.equalsIgnoreCase(cryptoProvider = config.getFirstProperty(CRYPTO_PROVIDER))) {
                isSymmetricKeyEncryptionEnabled = true;
            }
        }
        if (isInternalKeyStoreEncryptionEnabled && isSymmetricKeyEncryptionEnabled) {
            throw new CryptoException(String.format("Userstore encryption can not be supported due to conflicting configurations: '%s' and '%s'. When using internal keystore, assymetric crypto provider should be used.", INTERNAL_KEYSTORE, SYMMETRIC_KEY_CRYPTO_PROVIDER));
        }
        if (isInternalKeyStoreEncryptionEnabled || isSymmetricKeyEncryptionEnabled) {
            byte[] decryptedValue;
            if (cipherTransformation != null) {
                CipherMetaDataHolder cipherHolder = this.cipherTextToCipherHolder(cipherTextBytes);
                if (cipherHolder != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cipher transformation for decryption : " + cipherHolder.getTransformation()));
                    }
                    algorithm = cipherHolder.getTransformation();
                    cipherTextBytes = cipherHolder.getCipherBase64Decoded();
                } else {
                    algorithm = cipherTransformation;
                }
            }
            if (cipherTextBytes.length == 0) {
                decryptedValue = "".getBytes();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ciphertext is empty. An empty array will be used as the plaintext bytes.");
                }
            } else {
                decryptedValue = cryptoService.decrypt(cipherTextBytes, algorithm, CRYPTO_API_PROVIDER_BC);
            }
            return new String(decryptedValue);
        }
        return this.decryptWithPrimaryKeyStore(propValue);
    }

    private String decryptWithPrimaryKeyStore(String propValue) throws CryptoException {
        Cipher keyStoreCipher = null;
        String cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
        byte[] cipherTextBytes = Base64.decode((String)propValue.trim());
        byte[] plainTextBytes = new byte[]{};
        PrivateKey privateKey = UserStoreConfigXMLProcessor.privateKey = UserStoreConfigXMLProcessor.privateKey == null ? UserStoreConfigXMLProcessor.getPrivateKey() : UserStoreConfigXMLProcessor.privateKey;
        if (UserStoreConfigXMLProcessor.privateKey == null) {
            throw new CryptoException("Private key initialization failed. Cannot decrypt the userstore password.");
        }
        try {
            if (cipherTransformation != null) {
                CipherMetaDataHolder cipherHolder = this.cipherTextToCipherHolder(cipherTextBytes);
                if (cipherHolder != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cipher transformation for decryption : " + cipherHolder.getTransformation()));
                    }
                    keyStoreCipher = Cipher.getInstance(cipherHolder.getTransformation(), CRYPTO_API_PROVIDER_BC);
                    cipherTextBytes = cipherHolder.getCipherBase64Decoded();
                } else {
                    keyStoreCipher = Cipher.getInstance(cipherTransformation, CRYPTO_API_PROVIDER_BC);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cipher transformation property is not available.Hence RSA is considered as default cipher transformation.");
                }
                keyStoreCipher = Cipher.getInstance("RSA", CRYPTO_API_PROVIDER_BC);
            }
            keyStoreCipher.init(2, UserStoreConfigXMLProcessor.privateKey);
            plainTextBytes = keyStoreCipher.doFinal(cipherTextBytes);
        }
        catch (GeneralSecurityException e) {
            String errMsg = "decryption of secondary userstore property failed.";
            throw new CryptoException(errMsg);
        }
        return new String(plainTextBytes, Charset.defaultCharset());
    }

    private CipherMetaDataHolder cipherTextToCipherHolder(byte[] cipherText) {
        String cipherStr = new String(cipherText, Charset.defaultCharset());
        try {
            return (CipherMetaDataHolder)this.gson.fromJson(cipherStr, CipherMetaDataHolder.class);
        }
        catch (JsonSyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Deserialization failed since cipher string is not representing cipher with metadata");
            }
            return null;
        }
    }

    static {
        privateKey = UserStoreConfigXMLProcessor.getPrivateKey();
    }
}

