/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class TenantMgtXMLProcessor {
    private static final String TENANT_MGT_XML = "tenant-mgt.xml";
    private static Log log = LogFactory.getLog(TenantMgtXMLProcessor.class);
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public TenantMgtConfiguration buildTenantMgtConfigFromFile(String tenantManagerClass) throws UserStoreException {
        try {
            OMElement tenantMgtConfigElement = this.getTenantMgtConfigElement();
            return this.buildTenantMgtConfiguration(tenantMgtConfigElement, tenantManagerClass);
        }
        catch (XMLStreamException e) {
            String error_Message = "Error in reading tenant-mgt.xml";
            if (log.isDebugEnabled()) {
                log.debug((Object)error_Message, (Throwable)e);
            }
            throw new UserStoreException(error_Message);
        }
        catch (IOException e) {
            String error_Message = "Error in reading tenant-mgt.xml file.";
            if (log.isDebugEnabled()) {
                log.debug((Object)error_Message, (Throwable)e);
            }
            throw new UserStoreException(error_Message);
        }
    }

    public TenantMgtConfiguration buildTenantMgtConfiguration(OMElement tenantMgtConfigElement, String tenantManagerClass) throws UserStoreException {
        Map<String, String> tenantMgtProperties = null;
        TenantMgtConfiguration tenantMgtConfiguration = new TenantMgtConfiguration();
        Iterator iterator = tenantMgtConfigElement.getChildrenWithName(new QName("TenantManager"));
        while (iterator.hasNext()) {
            OMElement tenantManager = (OMElement)iterator.next();
            if (tenantManagerClass == null || !tenantManagerClass.equals(tenantManager.getAttributeValue(new QName("class")))) continue;
            tenantMgtProperties = this.readChildPropertyElements(tenantManager);
            tenantMgtConfiguration.setTenantManagerClass(tenantManagerClass);
            tenantMgtConfiguration.setTenantStoreProperties(tenantMgtProperties);
            return tenantMgtConfiguration;
        }
        String errorMessage = "Error in locating TenantManager compatible with PrimaryUserStore. Required a TenantManager using " + tenantManagerClass + " in tenant-mgt.xml.";
        if (log.isDebugEnabled()) {
            log.debug((Object)errorMessage);
        }
        throw new UserStoreException(errorMessage);
    }

    private Map<String, String> readChildPropertyElements(OMElement parentElement) {
        HashMap<String, String> tenantMgtConfigProperties = new HashMap<String, String>();
        Iterator ite = parentElement.getChildrenWithName(new QName("Property"));
        while (ite.hasNext()) {
            OMElement propertyElement = (OMElement)ite.next();
            String propertyName = propertyElement.getAttributeValue(new QName("name"));
            String propertyValue = propertyElement.getText();
            tenantMgtConfigProperties.put(propertyName, propertyValue);
        }
        return tenantMgtConfigProperties;
    }

    private OMElement getTenantMgtConfigElement() throws IOException, XMLStreamException {
        InputStream inStream = null;
        File tenantConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), TENANT_MGT_XML);
        if (tenantConfigXml.exists()) {
            inStream = new FileInputStream(tenantConfigXml);
        }
        String warningMessage = "";
        if (inStream == null) {
            URL url;
            if (this.bundleContext != null) {
                url = this.bundleContext.getBundle().getResource(TENANT_MGT_XML);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource tenant-mgt.xml or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = this.getClass().getClassLoader().getResource(TENANT_MGT_XML);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Could not find resource tenant-mgt.xml or user does not have sufficient permission to access the resource.";
                }
            }
        }
        if (inStream == null) {
            String message = "Tenant configuration not found. Cause - " + warningMessage;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new FileNotFoundException(message);
        }
        StAXOMBuilder builder = new StAXOMBuilder(inStream);
        OMElement documentElement = builder.getDocumentElement();
        if (inStream != null) {
            ((InputStream)inStream).close();
        }
        return documentElement;
    }
}

