/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.xml.StringUtils;

public class UserUniqueIDDomainResolver {
    private static final Log log = LogFactory.getLog(UserUniqueIDDomainResolver.class);
    private static final String UNIQUE_ID_DOMAIN_RESOLVER_CACHE_MANGER_NAME = "unique_id_domain_cache_manager";
    private static final String UNIQUE_ID_DOMAIN_RESOLVER_CACHE_NAME = "unique_id_domain_cache";
    private static final String DOMAIN_COLUMN_NAME = "UM_DOMAIN_NAME";
    private DataSource dataSource;
    private static final String IS_DOMAIN_EXISTS_SQL = "SELECT UM_DOMAIN_ID FROM UM_UUID_DOMAIN_MAPPER WHERE UM_USER_ID = ?";
    private static final String UPDATE_DOMAIN_NAME = "UPDATE UM_UUID_DOMAIN_MAPPER SET UM_DOMAIN_ID = (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_NAME = ? AND UM_TENANT_ID = ?), UM_TENANT_ID = ? WHERE UM_USER_ID = ?";
    private static final String ADD_DOMAIN_NAME = "INSERT INTO UM_UUID_DOMAIN_MAPPER (UM_USER_ID, UM_DOMAIN_ID, UM_TENANT_ID) VALUES (?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_NAME = ? AND UM_TENANT_ID = ?), ?)";
    private static final String GET_DOMAIN = "SELECT UM_DOMAIN_NAME FROM UM_DOMAIN WHERE UM_DOMAIN_ID = (SELECT UM_DOMAIN_ID FROM UM_UUID_DOMAIN_MAPPER WHERE UM_USER_ID = ? AND UM_TENANT_ID = ?)";

    public UserUniqueIDDomainResolver(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDomainForUserId(String userId, int tenantId) throws UserStoreException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(tenantId, true);
            CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(UNIQUE_ID_DOMAIN_RESOLVER_CACHE_MANGER_NAME);
            Cache uniqueIdDomainCache = cacheManager.getCache(UNIQUE_ID_DOMAIN_RESOLVER_CACHE_NAME);
            if (StringUtils.isEmpty((String)userId)) {
                throw new UserStoreException("User Id cannot be empty or null.");
            }
            String domainName = (String)uniqueIdDomainCache.get((Object)userId);
            if (domainName != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache hit for user id: " + userId));
                }
                String string = domainName;
                return string;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache miss for user id: " + userId + " searching from the database."));
            }
            if ((domainName = this.getDomainFromDB(userId, tenantId)) != null) {
                uniqueIdDomainCache.put((Object)userId, (Object)domainName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Domain with name: " + domainName + " retrieved from the database."));
                }
            }
            String string = domainName;
            return string;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDomainForUserId(String userId, String userDomain, int tenantId) throws UserStoreException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(tenantId, true);
            CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(UNIQUE_ID_DOMAIN_RESOLVER_CACHE_MANGER_NAME);
            Cache uniqueIdDomainCache = cacheManager.getCache(UNIQUE_ID_DOMAIN_RESOLVER_CACHE_NAME);
            if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)userDomain)) {
                throw new UserStoreException("User id or user domain cannot be empty or null.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persisting user id: " + userId + " against domain: " + userDomain));
            }
            this.persistDomainAgainstUserId(userId, userDomain, tenantId);
            uniqueIdDomainCache.put((Object)userId, (Object)userDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully persisted user id: " + userId + " against domain: " + userDomain + " and added to the cache."));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private String getDomainFromDB(String userId, int tenantId) throws UserStoreException {
        String domainName = null;
        try (Connection dbConnection = this.getDBConnection();
             PreparedStatement preparedStatement = dbConnection.prepareStatement(GET_DOMAIN);){
            preparedStatement.setString(1, userId);
            preparedStatement.setInt(2, tenantId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    domainName = resultSet.getString(DOMAIN_COLUMN_NAME);
                }
            }
        }
        catch (SQLException ex) {
            throw new UserStoreException("Error occurred while reading the domain name for user id from database.", ex);
        }
        return domainName;
    }

    private void persistDomainAgainstUserId(String userId, String userDomain, int tenantId) throws UserStoreException {
        block25: {
            try (Connection dbConnection = this.getDBConnection();){
                try {
                    if (this.isDomainExistsForUserId(userId, dbConnection)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Domain name available for the provided user id: " + userId + " Hence updating it."));
                        }
                        try (PreparedStatement preparedStatement = dbConnection.prepareStatement(UPDATE_DOMAIN_NAME);){
                            preparedStatement.setString(1, userDomain);
                            preparedStatement.setInt(2, tenantId);
                            preparedStatement.setInt(3, tenantId);
                            preparedStatement.setString(4, userId);
                            preparedStatement.execute();
                            this.commitTransaction(dbConnection);
                            break block25;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No domain name found for the give user id: " + userId + " Hence adding it as a new value."));
                    }
                    try (PreparedStatement preparedStatement = dbConnection.prepareStatement(ADD_DOMAIN_NAME);){
                        preparedStatement.setString(1, userId);
                        preparedStatement.setString(2, userDomain);
                        preparedStatement.setInt(3, tenantId);
                        preparedStatement.setInt(4, tenantId);
                        preparedStatement.execute();
                        this.commitTransaction(dbConnection);
                    }
                }
                catch (SQLException e) {
                    this.rollbackTransaction(dbConnection);
                    throw new UserStoreException("Error occurred while persisting domain against the user id.", e);
                }
            }
            catch (SQLException ex) {
                throw new UserStoreException("Error occurred while persisting domain against the user id.", ex);
            }
        }
    }

    private boolean isDomainExistsForUserId(String userId, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(IS_DOMAIN_EXISTS_SQL);){
            boolean bl;
            block12: {
                preparedStatement.setString(1, userId);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    private Connection getDBConnection() throws SQLException, UserStoreException {
        if (this.dataSource == null) {
            throw new UserStoreException("Datasource is null. Cannot create connection.");
        }
        return this.dataSource.getConnection();
    }

    private void commitTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null && !dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            log.error((Object)"An error occurred while transaction commit. ", (Throwable)e);
            this.rollbackTransaction(dbConnection);
        }
    }

    private void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null && !dbConnection.getAutoCommit()) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e) {
            log.error((Object)"An error occurred while transaction rollback.", (Throwable)e);
        }
    }
}

