/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilder;
import org.wso2.carbon.user.core.common.RealmCache;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.config.TenantMgtXMLProcessor;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.profile.builder.ProfileConfigurationBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class DefaultRealmService
implements RealmService {
    private static final Log log = LogFactory.getLog(DefaultRealmService.class);
    private static final String PRIMARY_TENANT_REALM = "primary";
    private static final String DB_CHECK_SQL = "select * from UM_SYSTEM_USER";
    private static boolean isFirstInitialization = true;
    private RealmCache realmCache = RealmCache.getInstance();
    private BundleContext bc;
    private RealmConfiguration bootstrapRealmConfig;
    private TenantMgtConfiguration tenantMgtConfiguration;
    private DataSource dataSource;
    private OMElement parentElement;
    private TenantManager tenantManager;
    private UserRealm bootstrapRealm;
    private MultiTenantRealmConfigBuilder multiTenantBuilder = null;
    private Map<String, Object> properties = new Hashtable<String, Object>();

    public DefaultRealmService(BundleContext bc, RealmConfiguration realmConfig) throws Exception {
        this.bootstrapRealmConfig = realmConfig != null ? realmConfig : this.buildBootStrapRealmConfig();
        this.tenantMgtConfiguration = this.buildTenantMgtConfig(bc, this.bootstrapRealmConfig.getUserStoreProperty("TenantManager"));
        this.dataSource = DatabaseUtil.getRealmDataSource(this.bootstrapRealmConfig);
        this.initializeDatabase(this.dataSource);
        this.properties.put("um.datasource", this.dataSource);
        this.properties.put("FistStartupCheck", isFirstInitialization);
        this.tenantManager = this.initializeTenantManger(this.tenantMgtConfiguration);
        this.tenantManager.setBundleContext(bc);
        this.tenantManager.initializeExistingPartitions();
        this.bc = bc;
        this.bootstrapRealm = this.initializeRealm(this.bootstrapRealmConfig, -1234);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("RealmGenre", "Delegating");
        if (bc != null) {
            bc.registerService(UserRealm.class.getName(), (Object)this.bootstrapRealm, dictionary);
        }
    }

    public DefaultRealmService(BundleContext bc) throws Exception {
        this(bc, null);
    }

    public DefaultRealmService(RealmConfiguration realmConfig, TenantManager tenantManager) throws Exception {
        this.bootstrapRealmConfig = realmConfig;
        this.dataSource = DatabaseUtil.getRealmDataSource(this.bootstrapRealmConfig);
        this.properties.put("um.datasource", this.dataSource);
        this.tenantMgtConfiguration = this.buildTenantMgtConfig(this.bc, this.bootstrapRealmConfig.getUserStoreProperty("TenantManager"));
        this.tenantManager = tenantManager;
        this.bootstrapRealm = this.initializeRealm(this.bootstrapRealmConfig, -1234);
    }

    private RealmConfiguration buildBootStrapRealmConfig() throws UserStoreException {
        this.parentElement = this.getConfigurationElement();
        OMElement realmElement = this.parentElement.getFirstChildWithName(new QName("Realm"));
        RealmConfigXMLProcessor rmProcessor = new RealmConfigXMLProcessor();
        rmProcessor.setSecretResolver(this.parentElement);
        return rmProcessor.buildRealmConfiguration(realmElement);
    }

    private TenantMgtConfiguration buildTenantMgtConfig(BundleContext bc, String tenantManagerClass) throws UserStoreException {
        TenantMgtXMLProcessor tenantMgtXMLProcessor = new TenantMgtXMLProcessor();
        tenantMgtXMLProcessor.setBundleContext(bc);
        return tenantMgtXMLProcessor.buildTenantMgtConfigFromFile(tenantManagerClass);
    }

    public org.wso2.carbon.user.api.UserRealm getTenantUserRealm(final int tenantId) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<org.wso2.carbon.user.api.UserRealm>(){

                @Override
                public org.wso2.carbon.user.api.UserRealm run() throws Exception {
                    return DefaultRealmService.this.getTenantUserRealmInternal(tenantId);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (org.wso2.carbon.user.api.UserStoreException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.wso2.carbon.user.api.UserRealm getTenantUserRealmInternal(int tenantId) throws org.wso2.carbon.user.api.UserStoreException {
        UserRealm userRealm;
        block10: {
            if (tenantId == -1234) {
                return this.bootstrapRealm;
            }
            userRealm = this.getCachedUserRealm(tenantId);
            if (userRealm != null) {
                return userRealm;
            }
            try {
                Tenant tenant = this.tenantManager.getTenant(tenantId);
                if (tenant == null) break block10;
                RealmConfiguration tenantRealmConfig = tenant.getRealmConfig();
                MultiTenantRealmConfigBuilder realmConfigBuilder = this.getMultiTenantRealmConfigBuilder();
                if (realmConfigBuilder != null) {
                    tenantRealmConfig = realmConfigBuilder.getRealmConfigForTenantToCreateRealm(this.bootstrapRealmConfig, tenantRealmConfig, tenantId);
                }
                String lockedString = tenant.getDomain() + "@DefaultRealmService_getTenantUserRealmInternal";
                userRealm = this.getCachedUserRealm(tenantId);
                if (userRealm != null) break block10;
                String string = lockedString.intern();
                synchronized (string) {
                    userRealm = this.getCachedUserRealm(tenantId);
                    if (userRealm == null) {
                        userRealm = this.initializeRealm(tenantRealmConfig, tenantId);
                        this.realmCache.addToCache(tenantId, PRIMARY_TENANT_REALM, userRealm);
                    }
                }
            }
            catch (Exception e) {
                String errorMessage = "Error occurred while getting tenant user realm for tenant id : " + tenantId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
        }
        return userRealm;
    }

    @Override
    public UserRealm getCachedUserRealm(int tenantId) throws UserStoreException {
        return (UserRealm)this.realmCache.getUserRealm(tenantId, PRIMARY_TENANT_REALM);
    }

    @Override
    public void clearCachedUserRealm(int tenantId) throws UserStoreException {
        this.realmCache.clearFromCache(tenantId, PRIMARY_TENANT_REALM);
    }

    @Override
    public UserRealm getUserRealm(final RealmConfiguration tenantRealmConfig) throws UserStoreException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<UserRealm>(){

                @Override
                public UserRealm run() throws Exception {
                    return DefaultRealmService.this.getUserRealmInternal(tenantRealmConfig);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UserStoreException)((Object)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserRealm getUserRealmInternal(RealmConfiguration tenantRealmConfig) throws UserStoreException {
        UserRealm userRealm = null;
        int tenantId = tenantRealmConfig.getTenantId();
        if (tenantId == -1234) {
            return this.bootstrapRealm;
        }
        userRealm = (UserRealm)this.realmCache.getUserRealm(tenantId, PRIMARY_TENANT_REALM);
        if (userRealm == null) {
            MultiTenantRealmConfigBuilder realmConfigBuilder = this.getMultiTenantRealmConfigBuilder();
            if (realmConfigBuilder != null) {
                tenantRealmConfig = realmConfigBuilder.getRealmConfigForTenantToCreateRealm(this.bootstrapRealmConfig, tenantRealmConfig, tenantId);
            }
            String tenantDomain = null;
            try {
                tenantDomain = this.tenantManager.getDomain(tenantId);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException("Error occurred while retrieving tenant domain from tenant Id " + tenantId);
            }
            userRealm = (UserRealm)this.realmCache.getUserRealm(tenantId, PRIMARY_TENANT_REALM);
            if (userRealm == null) {
                String string = tenantDomain.intern();
                synchronized (string) {
                    userRealm = (UserRealm)this.realmCache.getUserRealm(tenantId, PRIMARY_TENANT_REALM);
                    if (userRealm == null) {
                        userRealm = this.initializeRealm(tenantRealmConfig, tenantId);
                        this.realmCache.addToCache(tenantId, PRIMARY_TENANT_REALM, userRealm);
                    }
                }
            }
        }
        return userRealm;
    }

    public UserRealm initializeRealm(RealmConfiguration realmConfig, int tenantId) throws UserStoreException {
        ClaimBuilder.setBundleContext(this.bc);
        ProfileConfigurationBuilder.setBundleContext(this.bc);
        UserRealm userRealm = null;
        try {
            Class<?> clazz = Class.forName(realmConfig.getRealmClassName());
            userRealm = (UserRealm)clazz.newInstance();
            userRealm.init(realmConfig, this.properties, tenantId);
        }
        catch (Exception e) {
            if (!realmConfig.isPrimary()) {
                String msg = "Cannot initialize the realm.";
                log.warn((Object)msg, (Throwable)e);
            }
            String msg = "Cannot initialize the realm.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)e);
            }
            throw new UserStoreException(msg, e);
        }
        return userRealm;
    }

    private OMElement getConfigurationElement() throws UserStoreException {
        InputStream inStream = null;
        try {
            String userMgt = CarbonUtils.getUserMgtXMLPath();
            if (userMgt != null) {
                File userMgtXml = new File(userMgt);
                if (!userMgtXml.exists()) {
                    String msg = "Instance of a WSO2 User Manager has not been created. user-mgt.xml is not found.";
                    throw new FileNotFoundException(msg);
                }
                inStream = new FileInputStream(userMgtXml);
            } else {
                String confPath = System.getProperty("carbon.config.dir.path");
                if (confPath == null) {
                    inStream = this.getClass().getClassLoader().getResourceAsStream(Paths.get("repository", "conf", "user-mgt.xml").toString());
                } else {
                    String relativeConfDirPath = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(confPath, new String[0])).toString();
                    inStream = this.getClass().getClassLoader().getResourceAsStream(Paths.get(relativeConfDirPath, "user-mgt.xml").toString());
                }
                if (inStream == null) {
                    String msg = "Instance of a WSO2 User Manager has not been created. user-mgt.xml is not found. Please set the carbon.home";
                    throw new FileNotFoundException(msg);
                }
            }
            StAXOMBuilder builder = new StAXOMBuilder(CarbonUtils.replaceSystemVariablesInXml((InputStream)inStream));
            OMElement oMElement = builder.getDocumentElement();
            return oMElement;
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (CarbonException e) {
            String errorMessage = "Error occurred while replacing System variables in XML";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Object)("Couldn't close the InputStream" + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void initializeDatabase(DataSource ds) throws Exception {
        String value = System.getProperty("setup");
        if (value != null) {
            DatabaseCreator databaseCreator = new DatabaseCreator(ds);
            try {
                if (!databaseCreator.isDatabaseStructureCreated(DB_CHECK_SQL)) {
                    databaseCreator.createRegistryDatabase();
                } else {
                    isFirstInitialization = false;
                    log.info((Object)"Database already exists. Not creating a new database.");
                }
            }
            catch (Exception e) {
                String msg = "Error in creating the database";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new Exception(msg, e);
            }
        }
    }

    private TenantManager initializeTenantManger(TenantMgtConfiguration tenantMgtConfiguration) throws Exception {
        TenantManager tenantManager = null;
        String className = tenantMgtConfiguration.getTenantManagerClass();
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(OMElement.class, Map.class);
        this.properties.put("tenantMgtConfiguration", tenantMgtConfiguration);
        this.properties.put("userMgtConfiguration", this.bootstrapRealmConfig);
        Object newObject = constructor.newInstance(null, this.properties);
        tenantManager = (TenantManager)newObject;
        return tenantManager;
    }

    @Override
    public RealmConfiguration getBootstrapRealmConfiguration() {
        return this.bootstrapRealmConfig;
    }

    public void setBootstrapRealmConfiguration(RealmConfiguration realmConfiguration) {
        this.bootstrapRealmConfig = realmConfiguration;
    }

    @Override
    public UserRealm getBootstrapRealm() throws UserStoreException {
        return this.bootstrapRealm;
    }

    public void setTenantManager(org.wso2.carbon.user.api.TenantManager tenantManager) throws org.wso2.carbon.user.api.UserStoreException {
        this.setTenantManager((TenantManager)tenantManager);
    }

    @Override
    public TenantManager getTenantManager() {
        return this.tenantManager;
    }

    @Override
    public void setTenantManager(TenantManager tenantManager) {
        this.tenantManager = tenantManager;
    }

    public TenantMgtConfiguration getTenantMgtConfiguration() {
        return this.tenantMgtConfiguration;
    }

    @Override
    public MultiTenantRealmConfigBuilder getMultiTenantRealmConfigBuilder() throws UserStoreException {
        try {
            if (this.multiTenantBuilder == null) {
                String clazzName = this.tenantMgtConfiguration.getTenantStoreProperty("MultiTenantRealmConfigBuilder");
                if (clazzName != null) {
                    Class<?> clazz = Class.forName(clazzName);
                    MultiTenantRealmConfigBuilder multiConfigBuilder = (MultiTenantRealmConfigBuilder)clazz.newInstance();
                    return multiConfigBuilder;
                }
                return null;
            }
            return this.multiTenantBuilder;
        }
        catch (ClassNotFoundException e) {
            this.errorEncountered(e);
        }
        catch (InstantiationException e) {
            this.errorEncountered(e);
        }
        catch (IllegalAccessException e) {
            this.errorEncountered(e);
        }
        return null;
    }

    private void errorEncountered(Exception e) throws UserStoreException {
        String msg = "Exception while creating multi tenant builder " + e.getMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)msg, (Throwable)e);
        }
        throw new UserStoreException(msg, e);
    }
}

