/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim.inmemory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimKey;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.DefaultClaimManager;
import org.wso2.carbon.user.core.claim.inmemory.ClaimConfig;
import org.wso2.carbon.user.core.claim.inmemory.FileBasedClaimBuilder;

public class InMemoryClaimManager
implements ClaimManager {
    private static final Log log = LogFactory.getLog(DefaultClaimManager.class);
    protected static ClaimConfig claimConfig;
    protected Map<String, ClaimMapping> claimMapping = new HashMap<String, ClaimMapping>();

    public ClaimConfig getClaimConfig() {
        return claimConfig;
    }

    public void setClaimConfig(ClaimConfig claimConfig) {
        InMemoryClaimManager.claimConfig = claimConfig;
    }

    public InMemoryClaimManager() throws UserStoreException {
        Map<ClaimKey, ClaimMapping> tmpClaimMap = claimConfig.getClaimMap();
        for (Map.Entry<ClaimKey, ClaimMapping> entry : tmpClaimMap.entrySet()) {
            this.claimMapping.put(entry.getKey().getClaimUri(), entry.getValue());
        }
    }

    public String getAttributeName(String domainName, String claimURI) throws UserStoreException {
        ClaimMapping mapping = this.claimMapping.get(claimURI);
        if (mapping != null) {
            if (domainName != null) {
                String mappedAttrib = mapping.getMappedAttribute(domainName.toUpperCase());
                if (mappedAttrib != null) {
                    return mappedAttrib;
                }
                return mapping.getMappedAttribute();
            }
            return mapping.getMappedAttribute();
        }
        return null;
    }

    public String getAttributeName(String claimURI) throws UserStoreException {
        ClaimMapping mapping = this.claimMapping.get(claimURI);
        if (mapping != null) {
            return mapping.getMappedAttribute();
        }
        return null;
    }

    public String[] getAllClaimUris() throws UserStoreException {
        return this.claimMapping.keySet().toArray(new String[this.claimMapping.size()]);
    }

    public org.wso2.carbon.user.api.Claim getClaim(String claimURI) throws UserStoreException {
        ClaimMapping mapping = this.claimMapping.get(claimURI);
        if (mapping != null) {
            return mapping.getClaim();
        }
        return null;
    }

    public ClaimMapping getClaimMapping(String claimURI) throws UserStoreException {
        return this.claimMapping.get(claimURI);
    }

    public ClaimMapping[] getAllSupportClaimMappingsByDefault() throws org.wso2.carbon.user.api.UserStoreException {
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> entry : this.claimMapping.entrySet()) {
            ClaimMapping claimMapping = entry.getValue();
            Claim claim = claimMapping.getClaim();
            if (!claim.isSupportedByDefault()) continue;
            claimList.add(claimMapping);
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public ClaimMapping[] getAllClaimMappings() throws UserStoreException {
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> entry : this.claimMapping.entrySet()) {
            ClaimMapping claimMapping = entry.getValue();
            claimList.add(claimMapping);
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public ClaimMapping[] getAllClaimMappings(String dialectUri) throws org.wso2.carbon.user.api.UserStoreException {
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> entry : this.claimMapping.entrySet()) {
            ClaimMapping claimMapping = entry.getValue();
            if (!claimMapping.getClaim().getDialectURI().equals(dialectUri)) continue;
            claimList.add(claimMapping);
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public ClaimMapping[] getAllRequiredClaimMappings() throws UserStoreException {
        ArrayList<ClaimMapping> claimList = new ArrayList<ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> entry : this.claimMapping.entrySet()) {
            ClaimMapping claimMapping = entry.getValue();
            if (!claimMapping.getClaim().isRequired()) continue;
            claimList.add(claimMapping);
        }
        return claimList.toArray(new ClaimMapping[claimList.size()]);
    }

    public void addNewClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        this.claimMapping.put(mapping.getClaim().getClaimUri(), (ClaimMapping)mapping);
    }

    public void updateClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        this.claimMapping.remove(mapping.getClaim().getClaimUri());
        this.claimMapping.put(mapping.getClaim().getClaimUri(), (ClaimMapping)mapping);
    }

    public void deleteClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        this.claimMapping.remove(mapping.getClaim().getClaimUri());
    }

    static {
        try {
            claimConfig = FileBasedClaimBuilder.buildClaimMappingsFromConfigFile();
        }
        catch (IOException e) {
            log.error((Object)"Could not find claim configuration file", (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error while parsing claim configuration file", (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while initializing claim manager");
        }
    }
}

