/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim.inmemory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimKey;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.inmemory.ClaimConfig;
import org.wso2.carbon.utils.CarbonUtils;

public class FileBasedClaimBuilder {
    public static final String LOCAL_NAME_DIALECTS = "Dialects";
    public static final String LOCAL_NAME_DIALECT = "Dialect";
    public static final String LOCAL_NAME_CLAIM = "Claim";
    public static final String LOCAL_NAME_CLAIM_URI = "ClaimURI";
    public static final String LOCAL_NAME_DESCRIPTION = "Description";
    public static final String LOCAL_NAME_ATTR_ID = "AttributeID";
    public static final String ATTR_DIALECT_URI = "dialectURI";
    private static final String CLAIM_CONFIG = "claim-config.xml";
    private static Log log = LogFactory.getLog(FileBasedClaimBuilder.class);
    private static BundleContext bundleContext;
    private static InputStream inStream;
    private int tenantId;

    public FileBasedClaimBuilder(int tenantId) {
        this.tenantId = tenantId;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        FileBasedClaimBuilder.bundleContext = bundleContext;
    }

    public static ClaimConfig buildClaimMappingsFromConfigFile() throws IOException, XMLStreamException, UserStoreException {
        HashMap<ClaimKey, ClaimMapping> claims = new HashMap<ClaimKey, ClaimMapping>();
        HashMap<ClaimKey, Map<String, String>> propertyHolder = new HashMap<ClaimKey, Map<String, String>>();
        OMElement dom = FileBasedClaimBuilder.getRootElement();
        Iterator dialectsIterator = dom.getChildrenWithName(new QName(LOCAL_NAME_DIALECTS));
        while (dialectsIterator.hasNext()) {
            OMElement dialects = (OMElement)dialectsIterator.next();
            Iterator dialectIterator = dialects.getChildrenWithName(new QName(LOCAL_NAME_DIALECT));
            while (dialectIterator.hasNext()) {
                OMElement dialect = (OMElement)dialectIterator.next();
                String dialectUri = dialect.getAttributeValue(new QName(ATTR_DIALECT_URI));
                Iterator claimsIterator = dialect.getChildrenWithName(new QName(LOCAL_NAME_CLAIM));
                while (claimsIterator.hasNext()) {
                    String claimUri = null;
                    String attributeId = null;
                    OMElement claimElement = (OMElement)claimsIterator.next();
                    FileBasedClaimBuilder.validateSchema(claimElement);
                    Claim claim = new Claim();
                    claim.setDialectURI(dialectUri);
                    Iterator metadataIterator = claimElement.getChildElements();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    while (metadataIterator.hasNext()) {
                        OMElement metadata = (OMElement)metadataIterator.next();
                        String key = metadata.getQName().toString();
                        String value = metadata.getText();
                        if (key.equals(LOCAL_NAME_CLAIM_URI)) {
                            claim.setClaimUri(value);
                            claimUri = value;
                        }
                        if (key.equals(LOCAL_NAME_ATTR_ID)) {
                            attributeId = value;
                        }
                        properties.put(key, value);
                        properties.put(LOCAL_NAME_DIALECT, dialectUri);
                    }
                    ClaimKey claimKey = new ClaimKey();
                    claimKey.setClaimUri(claimUri);
                    claimKey.setDialectUri(dialectUri);
                    propertyHolder.put(claimKey, properties);
                    ClaimMapping claimMapping = new ClaimMapping();
                    claimMapping.setClaim(claim);
                    FileBasedClaimBuilder.setMappedAttributes(claimMapping, attributeId);
                    claims.put(claimKey, claimMapping);
                }
            }
        }
        ClaimConfig claimConfig = new ClaimConfig();
        claimConfig.setClaimMap(claims);
        claimConfig.setPropertyHolderMap(propertyHolder);
        return claimConfig;
    }

    private static void validateSchema(OMElement claimElement) throws UserStoreException {
        if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_CLAIM_URI)) == null) {
            String message = "In valid schema <ClaimUri> element not present";
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new UserStoreException(message);
        }
        if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_ATTR_ID)) == null) {
            String message = "In valid schema <AttributeId> element not present";
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new UserStoreException(message);
        }
    }

    private static OMElement getRootElement() throws XMLStreamException, IOException, UserStoreException {
        StAXOMBuilder builder = null;
        File claimConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), CLAIM_CONFIG);
        if (claimConfigXml.exists()) {
            inStream = new FileInputStream(claimConfigXml);
        }
        String warningMessage = "";
        if (inStream == null) {
            URL url;
            if (bundleContext != null) {
                url = bundleContext.getBundle().getResource(CLAIM_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource claim-config.xml or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = FileBasedClaimBuilder.class.getClassLoader().getResource(CLAIM_CONFIG);
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "ClaimBuilder could not find resource claim-config.xml or user does not have sufficient permission to access the resource.";
                }
            }
        }
        if (inStream == null) {
            String message = "Claim configuration not found. Cause - " + warningMessage;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new FileNotFoundException(message);
        }
        builder = new StAXOMBuilder(inStream);
        OMElement documentElement = builder.getDocumentElement();
        return documentElement;
    }

    private static void setMappedAttributes(ClaimMapping claimMapping, String mappedAttribute) {
        if (mappedAttribute != null) {
            String[] attributes = mappedAttribute.split(";");
            HashMap<String, String> attrMap = new HashMap<String, String>();
            for (int i = 0; i < attributes.length; ++i) {
                int index = attributes[i].indexOf("/");
                if (index > 1 && attributes[i].indexOf("/") == attributes[i].lastIndexOf("/")) {
                    String domain = attributes[i].substring(0, index);
                    String attrName = attributes[i].substring(index + 1);
                    if (domain != null) {
                        attrMap.put(domain.toUpperCase(), attrName);
                        continue;
                    }
                    claimMapping.setMappedAttribute(attributes[i]);
                    continue;
                }
                claimMapping.setMappedAttribute(attributes[i]);
            }
            if (attrMap.size() > 0) {
                claimMapping.setMappedAttributes(attrMap);
            }
        }
    }

    static {
        inStream = null;
    }
}

