/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim.inmemory;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.user.core.claim.ClaimKey;
import org.wso2.carbon.user.core.claim.ClaimMapping;

public class ClaimConfig {
    private Map<ClaimKey, ClaimMapping> claims;
    private Map<ClaimKey, Map<String, String>> propertyHolder;

    public ClaimConfig() {
    }

    public ClaimConfig(Map<String, ClaimMapping> claims, Map<String, Map<String, String>> propertyHolder) {
        this.setClaims(claims);
        this.setPropertyHolder(propertyHolder);
    }

    public Map<String, ClaimMapping> getClaims() {
        HashMap<String, ClaimMapping> convertedClaimMap = new HashMap<String, ClaimMapping>();
        for (Map.Entry<ClaimKey, ClaimMapping> entry : this.claims.entrySet()) {
            convertedClaimMap.put(entry.getKey().getClaimUri(), entry.getValue());
        }
        return convertedClaimMap;
    }

    public void setClaims(Map<String, ClaimMapping> claims) {
        this.claims = new HashMap<ClaimKey, ClaimMapping>();
        for (Map.Entry<String, ClaimMapping> entry : claims.entrySet()) {
            ClaimKey claimKey = new ClaimKey(entry.getKey(), entry.getValue().getClaim().getDialectURI());
            this.claims.put(claimKey, entry.getValue());
        }
    }

    public Map<String, Map<String, String>> getPropertyHolder() {
        HashMap<String, Map<String, String>> convertedPropertyHolder = new HashMap<String, Map<String, String>>();
        for (Map.Entry<ClaimKey, Map<String, String>> entry : this.propertyHolder.entrySet()) {
            convertedPropertyHolder.put(entry.getKey().getClaimUri(), entry.getValue());
        }
        return convertedPropertyHolder;
    }

    @Deprecated
    public void setPropertyHolder(Map<String, Map<String, String>> propertyHolder) {
        this.propertyHolder = new HashMap<ClaimKey, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : propertyHolder.entrySet()) {
            ClaimKey claimKey = new ClaimKey();
            claimKey.setClaimUri(entry.getKey());
            claimKey.setDialectUri(this.claims.get(entry.getKey()).getClaim().getDialectURI());
            this.propertyHolder.put(claimKey, entry.getValue());
        }
    }

    public Map<ClaimKey, ClaimMapping> getClaimMap() {
        return this.claims;
    }

    public void setClaimMap(Map<ClaimKey, ClaimMapping> claims) {
        this.claims = claims;
    }

    public Map<ClaimKey, Map<String, String>> getPropertyHolderMap() {
        return this.propertyHolder;
    }

    public void setPropertyHolderMap(Map<ClaimKey, Map<String, String>> propertyHolder) {
        this.propertyHolder = propertyHolder;
    }
}

