/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;

public class ClaimInvalidationCache {
    private static final String CLAIM_CACHE_MANAGER = "Claim.Cache.Manager";
    private static final Object lock = new Object();
    private static Log log = LogFactory.getLog(ClaimInvalidationCache.class);
    private static ClaimInvalidationCache claimCache;
    private String CLAIM_CACHE_NAME = "Claim.Cache";
    private String INVALIDATE_CACHE_KEY = "Invalidate.Cache.Key";
    private int myHashCode;
    private boolean isAlreadyInitialize;

    private ClaimInvalidationCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClaimInvalidationCache getInstance() {
        if (claimCache == null) {
            Object object = lock;
            synchronized (object) {
                if (claimCache == null) {
                    claimCache = new ClaimInvalidationCache();
                }
            }
        }
        return claimCache;
    }

    private Cache<String, Integer> getClaimCache() {
        CacheManager manager = Caching.getCacheManagerFactory().getCacheManager(CLAIM_CACHE_MANAGER);
        Cache cache = manager.getCache(this.CLAIM_CACHE_NAME);
        return cache;
    }

    public boolean isInvalid() {
        Integer hashCode = this.getValueFromCache(this.INVALIDATE_CACHE_KEY);
        if (hashCode != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("My Hash code of Claim cache is : " + this.myHashCode));
                log.debug((Object)("Shared Hash code of Claim cache is : " + hashCode));
            }
            if (hashCode > this.myHashCode) {
                this.myHashCode = hashCode;
                return true;
            }
        }
        if (ServerConfiguration.getInstance().getFirstProperty("Cache.ForceLocalCache") != null && ServerConfiguration.getInstance().getFirstProperty("Cache.ForceLocalCache").equals("true") && hashCode == null && this.isAlreadyInitialize) {
            this.updateCache(this.INVALIDATE_CACHE_KEY, this.myHashCode);
            return true;
        }
        return false;
    }

    public void invalidateCache() {
        ++this.myHashCode;
        this.addToCache(this.INVALIDATE_CACHE_KEY, this.myHashCode);
        if (log.isDebugEnabled()) {
            log.debug((Object)("My Hash code of Claim cache is : " + this.myHashCode));
        }
    }

    private void addToCache(String key, Integer entry) {
        this.clearCacheEntry(key);
        Cache<String, Integer> cache = this.getClaimCache();
        if (cache != null) {
            cache.put((Object)key, (Object)entry);
        }
    }

    private Integer getValueFromCache(String key) {
        Cache<String, Integer> cache = this.getClaimCache();
        if (cache != null) {
            return (Integer)cache.get((Object)key);
        }
        return null;
    }

    private void clearCacheEntry(String key) {
        Cache<String, Integer> cache = this.getClaimCache();
        if (cache != null) {
            cache.remove((Object)key);
        }
    }

    public void setIsAlreadyInitialize(Boolean bool) {
        this.isAlreadyInitialize = bool;
    }

    private void updateCache(String key, Integer entry) {
        Cache<String, Integer> cache = this.getClaimCache();
        if (cache != null) {
            cache.put((Object)key, (Object)entry);
        } else {
            log.debug((Object)"Error while updating the claim cache. ClaimCache is null");
        }
    }
}

