/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class TreeNode {
    private String name;
    private Map<String, TreeNode> children = new HashMap<String, TreeNode>();
    private Map<String, BitSet> userAllowPermissions = new HashMap<String, BitSet>();
    private Map<String, BitSet> userDenyPermissions = new HashMap<String, BitSet>();
    private Map<String, BitSet> roleAllowPermissions = new HashMap<String, BitSet>();
    private Map<String, BitSet> roleDenyPermissions = new HashMap<String, BitSet>();

    TreeNode(String name) {
        this.name = name;
    }

    TreeNode getChild(String name) {
        return this.children.get(name);
    }

    public Boolean isUserAuthorized(String user, Permission permission) {
        BitSet bsAlow = this.userAllowPermissions.get(user);
        BitSet bsDeny = this.userDenyPermissions.get(user);
        if (bsAlow == null && bsDeny == null) {
            return null;
        }
        if (bsDeny != null && bsDeny.get(permission.ordinal())) {
            return Boolean.FALSE;
        }
        if (bsAlow != null && bsAlow.get(permission.ordinal())) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Boolean isRoleAuthorized(String role, Permission permission) {
        BitSet bsAlow = this.roleAllowPermissions.get(this.modify(role));
        BitSet bsDeny = this.roleDenyPermissions.get(role);
        if (bsAlow == null && bsDeny == null) {
            return null;
        }
        if (bsDeny != null && bsDeny.get(permission.ordinal())) {
            return Boolean.FALSE;
        }
        if (bsAlow != null && bsAlow.get(permission.ordinal())) {
            return Boolean.TRUE;
        }
        return null;
    }

    public void authorizeUser(String user, Permission permission) {
        BitSet bsAllow = this.userAllowPermissions.get(user);
        if (bsAllow == null) {
            bsAllow = new BitSet();
            bsAllow.set(permission.ordinal());
            this.userAllowPermissions.put(user, bsAllow);
        } else {
            bsAllow.set(permission.ordinal());
        }
        BitSet bsDeny = this.userDenyPermissions.get(user);
        if (bsDeny != null) {
            bsDeny.clear(permission.ordinal());
        }
    }

    public void authorizeRole(String role, Permission permission) {
        BitSet bsAllow = this.roleAllowPermissions.get(this.modify(role));
        if (bsAllow == null) {
            bsAllow = new BitSet();
            bsAllow.set(permission.ordinal());
            this.roleAllowPermissions.put(this.modify(role), bsAllow);
        } else {
            bsAllow.set(permission.ordinal());
        }
        BitSet bsDeny = this.roleDenyPermissions.get(role);
        if (bsDeny != null) {
            bsDeny.clear(permission.ordinal());
        }
    }

    public void denyUser(String user, Permission permission) {
        BitSet bsDeny = this.userDenyPermissions.get(user);
        if (bsDeny == null) {
            bsDeny = new BitSet();
            bsDeny.set(permission.ordinal());
            this.userDenyPermissions.put(user, bsDeny);
        } else {
            bsDeny.set(permission.ordinal());
        }
        BitSet bsAllow = this.userAllowPermissions.get(user);
        if (bsAllow != null) {
            bsAllow.clear(permission.ordinal());
        }
    }

    public void denyRole(String role, Permission permission) {
        BitSet bsDeny = this.roleDenyPermissions.get(role);
        if (bsDeny == null) {
            bsDeny = new BitSet();
            bsDeny.set(permission.ordinal());
            this.roleDenyPermissions.put(role, bsDeny);
        } else {
            bsDeny.set(permission.ordinal());
        }
        BitSet bsAllow = this.roleAllowPermissions.get(this.modify(role));
        if (bsAllow != null) {
            bsAllow.clear(permission.ordinal());
        }
    }

    public TreeNode create(List<String> paths) {
        if (paths != null && !paths.isEmpty()) {
            String childName = paths.get(0);
            TreeNode tn = new TreeNode(childName);
            this.children.put(childName, tn);
            paths.remove(0);
            if (!paths.isEmpty()) {
                return tn.create(paths);
            }
            return tn;
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, TreeNode> getChildren() {
        return this.children;
    }

    public Map<String, BitSet> getUserAllowPermissions() {
        return this.userAllowPermissions;
    }

    public Map<String, BitSet> getUserDenyPermissions() {
        return this.userDenyPermissions;
    }

    public Map<String, BitSet> getRoleAllowPermissions() {
        return this.roleAllowPermissions;
    }

    public Map<String, BitSet> getRoleDenyPermissions() {
        return this.roleDenyPermissions;
    }

    public void clearNodes() {
        this.roleAllowPermissions.clear();
        this.roleDenyPermissions.clear();
        this.userAllowPermissions.clear();
        this.userDenyPermissions.clear();
        Map<String, TreeNode> children = this.getChildren();
        if (null != children) {
            for (Map.Entry<String, TreeNode> entry : children.entrySet()) {
                TreeNode node = entry.getValue();
                if (null == node) continue;
                node.clearNodes();
            }
            children.clear();
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.name ? 0 : this.name.hashCode());
        hash = 31 * hash + (null == this.children ? 0 : this.children.hashCode());
        hash = 31 * hash + (null == this.userAllowPermissions ? 0 : this.userAllowPermissions.hashCode());
        hash = 31 * hash + (null == this.userDenyPermissions ? 0 : this.userDenyPermissions.hashCode());
        hash = 31 * hash + (null == this.roleAllowPermissions ? 0 : this.roleAllowPermissions.hashCode());
        hash = 31 * hash + (null == this.roleDenyPermissions ? 0 : this.roleDenyPermissions.hashCode());
        hash = 31 * hash + (null == this.roleDenyPermissions ? 0 : this.roleDenyPermissions.hashCode());
        return hash;
    }

    private String modify(String name) {
        if (!name.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            return name;
        }
        String domain = UserCoreUtil.extractDomainFromName(name);
        String nameWithoutDomain = UserCoreUtil.removeDomainFromName(name);
        String modifiedName = UserCoreUtil.addDomainToName(nameWithoutDomain, domain.toUpperCase());
        return modifiedName;
    }

    public static enum Permission {
        GET,
        ADD,
        DELETE,
        EDIT,
        LOGIN,
        MAN_CONFIG,
        MAN_LC_CONFIG,
        MAN_SEC,
        UP_SERV,
        MAN_SERV,
        MAN_MEDIA,
        MON_SYS,
        DEL_ID,
        AUTHORIZE,
        INV_SER,
        UI_EXECUTE,
        SUBSCRIBE,
        PUBLISH,
        CONSUME,
        CHANGE_PERMISSION,
        BROWSE,
        SQS_SEND_MESSAGE,
        SQS_RECEIVE_MESSAGE,
        SQS_DELETE_MESSAGE,
        SQS_CHANGE_MESSAGE_VISIBILITY,
        SQS_GET_QUEUE_ATTRIBUTES;

    }
}

