/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.authorization.AuthorizationCache;
import org.wso2.carbon.user.core.authorization.AuthorizationCacheException;
import org.wso2.carbon.user.core.authorization.PermissionTree;
import org.wso2.carbon.user.core.authorization.PermissionTreeUtil;
import org.wso2.carbon.user.core.authorization.SearchResult;
import org.wso2.carbon.user.core.authorization.TreeNode;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class JDBCAuthorizationManager
implements AuthorizationManager {
    private static Log log = LogFactory.getLog(JDBCAuthorizationManager.class);
    private static boolean debug = log.isDebugEnabled();
    private final String GET_ALL_ROLES_OF_USER_ENABLED = "GetAllRolesOfUserEnabled";
    private DataSource dataSource = null;
    private PermissionTree permissionTree = null;
    private AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
    private UserRealm userRealm = null;
    private RealmConfiguration realmConfig = null;
    private boolean caseInSensitiveAuthorizationRules;
    private boolean preserveCaseForResources = true;
    private boolean verifyByRetrievingAllUserRoles;
    private boolean isRoleAndGroupSeparationEnabled;
    private String cacheIdentifier;
    private int tenantId;
    private String isCascadeDeleteEnabled;
    private static final String DELETE_ROLE_PERMISSIONS = "DeleteRolePermissions";
    private static final String DELETE_USER_PERMISSIONS = "DeleteUserPermissions";
    private static final String DELETE_ROLE_PERMISSIONS_MYSQL = "DeleteRolePermissions-mysql";
    private static final String DELETE_USER_PERMISSIONS_MYSQL = "DeleteUserPermissions-mysql";
    private static final ThreadLocal<Boolean> isSecureCall = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public JDBCAuthorizationManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        String userCoreCacheIdentifier;
        if (!"true".equals(realmConfig.getAuthorizationManagerProperty("AuthorizationCacheEnabled"))) {
            this.authorizationCache.disableCache();
        }
        if (!"true".equals(realmConfig.getAuthorizationManagerProperty("CaseSensitiveAuthorizationRules"))) {
            this.caseInSensitiveAuthorizationRules = true;
        }
        if ("true".equals(realmConfig.getAuthorizationManagerProperty("GetAllRolesOfUserEnabled"))) {
            this.verifyByRetrievingAllUserRoles = true;
        }
        if (Boolean.parseBoolean(realmConfig.getAuthorizationManagerProperty("GroupAndRoleSeparationEnabled"))) {
            this.isRoleAndGroupSeparationEnabled = true;
        }
        if (!realmConfig.getAuthzProperties().containsKey(DELETE_ROLE_PERMISSIONS)) {
            realmConfig.getAuthzProperties().put(DELETE_ROLE_PERMISSIONS, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=?) AND UM_TENANT_ID=?");
        }
        if (!realmConfig.getAuthzProperties().containsKey(DELETE_USER_PERMISSIONS)) {
            realmConfig.getAuthzProperties().put(DELETE_USER_PERMISSIONS, "DELETE FROM UM_USER_PERMISSION WHERE UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=?) AND UM_TENANT_ID=?");
        }
        if ("false".equals(realmConfig.getAuthorizationManagerProperty("PreserveCaseForResources"))) {
            this.preserveCaseForResources = false;
        }
        if (!realmConfig.getAuthzProperties().containsKey(DELETE_ROLE_PERMISSIONS_MYSQL)) {
            realmConfig.getAuthzProperties().put(DELETE_ROLE_PERMISSIONS_MYSQL, "DELETE UM_ROLE_PERMISSION FROM UM_ROLE_PERMISSION INNER JOIN UM_PERMISSION ON UM_ROLE_PERMISSION.UM_PERMISSION_ID = UM_PERMISSION.UM_ID WHERE UM_PERMISSION.UM_RESOURCE_ID=? AND UM_ROLE_PERMISSION.UM_TENANT_ID=?");
        }
        if (!realmConfig.getAuthzProperties().containsKey(DELETE_USER_PERMISSIONS_MYSQL)) {
            realmConfig.getAuthzProperties().put(DELETE_USER_PERMISSIONS_MYSQL, "DELETE UM_USER_PERMISSION FROM UM_USER_PERMISSION INNER JOIN UM_PERMISSION ON UM_USER_PERMISSION.UM_PERMISSION_ID = UM_PERMISSION.UM_ID WHERE UM_PERMISSION.UM_RESOURCE_ID=? AND UM_USER_PERMISSION.UM_TENANT_ID=?");
        }
        this.cacheIdentifier = (userCoreCacheIdentifier = realmConfig.getUserStoreProperty("UserCoreCacheIdentifier")) != null && userCoreCacheIdentifier.trim().length() > 0 ? userCoreCacheIdentifier : "defaultCacheDomain";
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
            properties.put("um.datasource", this.dataSource);
        }
        this.isCascadeDeleteEnabled = realmConfig.getRealmProperty("isCascadeDeleteEnabled");
        this.permissionTree = new PermissionTree(this.cacheIdentifier, tenantId, this.dataSource, this.preserveCaseForResources);
        this.realmConfig = realmConfig;
        this.userRealm = realm;
        this.tenantId = tenantId;
        if (log.isDebugEnabled()) {
            log.debug((Object)("The jdbcDataSource being used by JDBCAuthorizationManager :: " + this.dataSource.hashCode()));
        }
        this.populatePermissionTreeFromDB();
        this.addInitialData();
    }

    @Override
    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            Object object = this.callSecure("isRoleAuthorized", new Object[]{roleName, resourceId, action}, argTypes);
            return (Boolean)object;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.isRoleAuthorized(roleName, resourceId, action, this)) continue;
            return false;
        }
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getRolePermission(roleName, PermissionTreeUtil.actionToPermission(action), null, null, PermissionTreeUtil.toComponenets(resourceId));
        if (log.isDebugEnabled() && !sr.getLastNodeAllowedAccess().booleanValue()) {
            log.debug((Object)(roleName + " role is not Authorized to perform " + action + " on " + resourceId));
        }
        return sr.getLastNodeAllowedAccess();
    }

    @Override
    public boolean isUserAuthorized(String userName, String resourceId, String action) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            Object object = this.callSecure("isUserAuthorized", new Object[]{userName, resourceId, action}, argTypes);
            return (Boolean)object;
        }
        if ("wso2.system.user".equals(userName)) {
            return true;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.isUserAuthorized(userName, resourceId, action, this)) continue;
            return false;
        }
        try {
            Boolean userAllowed = this.authorizationCache.isUserAuthorized(this.cacheIdentifier, this.tenantId, userName, resourceId, action);
            if (log.isDebugEnabled() && userAllowed != null && !userAllowed.booleanValue()) {
                log.debug((Object)("Authorization cache hit. " + userName + " user is not Authorized to perform " + action + " on " + resourceId));
            }
            if (userAllowed != null) {
                return userAllowed;
            }
        }
        catch (AuthorizationCacheException userAllowed) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authorization cache miss for username : " + userName + " resource " + resourceId + " action : " + action));
        }
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getUserPermission(userName, PermissionTreeUtil.actionToPermission(action), null, null, PermissionTreeUtil.toComponenets(resourceId));
        if (sr.getLastNodeAllowedAccess().booleanValue()) {
            this.authorizationCache.addToCache(this.cacheIdentifier, this.tenantId, userName, resourceId, action, true);
            return true;
        }
        boolean userAllowed = false;
        String[] allowedRoles = this.getAllowedRolesForResource(resourceId, action);
        if (allowedRoles != null && allowedRoles.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Roles which have permission for resource : " + resourceId + " action : " + action));
                for (String allowedRole : allowedRoles) {
                    log.debug((Object)("Role :  " + allowedRole));
                }
            }
            if (this.isRoleAndGroupSeparationEnabled || this.verifyByRetrievingAllUserRoles) {
                String[] roles;
                block30: {
                    roles = null;
                    try {
                        roles = this.userRealm.getUserStoreManager().getRoleListOfUser(userName);
                    }
                    catch (UserStoreException e) {
                        if (!log.isDebugEnabled()) break block30;
                        log.debug((Object)("Error getting role list of user : " + userName), (Throwable)((Object)e));
                    }
                }
                if (roles == null || roles.length == 0) {
                    AbstractUserStoreManager manager = (AbstractUserStoreManager)this.userRealm.getUserStoreManager();
                    roles = manager.doGetRoleListOfUser(userName, "*");
                }
                block8: for (String allowRole : allowedRoles) {
                    for (String userRole : roles) {
                        if (!allowRole.equalsIgnoreCase(userRole)) continue;
                        userAllowed = true;
                        break block8;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(userName + " user has permitted resource :  " + resourceId + ", action :" + action));
                }
            } else {
                AbstractUserStoreManager manager = (AbstractUserStoreManager)this.userRealm.getUserStoreManager();
                for (String role : allowedRoles) {
                    try {
                        if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
                            if (!"system/wso2.anonymous.role".equalsIgnoreCase(role)) continue;
                            userAllowed = true;
                            break;
                        }
                        if (manager.isUserInRole(userName, role)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(userName + " user is in role :  " + role));
                            }
                            userAllowed = true;
                            break;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(userName + " user is not in role :  " + role));
                    }
                    catch (UserStoreException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(userName + " user is not in role :  " + role), (Throwable)((Object)e));
                    }
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No roles have permission for resource : " + resourceId + " action : " + action));
        }
        this.authorizationCache.addToCache(this.cacheIdentifier, this.tenantId, userName, resourceId, action, userAllowed);
        if (log.isDebugEnabled() && !userAllowed) {
            log.debug((Object)(userName + " user is not Authorized to perform " + action + " on " + resourceId));
        }
        return userAllowed;
    }

    @Override
    public String[] getAllowedRolesForResource(String resourceId, String action) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getAllowedRolesForResource", new Object[]{resourceId, action}, argTypes);
            return (String[])object;
        }
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getAllowedRolesForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        if (debug) {
            String[] roles;
            log.debug((Object)("Allowed roles for the ResourceID: " + resourceId + " Action: " + action));
            for (String role : roles = sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()])) {
                log.debug((Object)("role: " + role));
            }
        }
        return sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    public void refreshAllowedRolesForResource(String resourceId) throws UserStoreException {
        this.permissionTree.updatePermissionTree(resourceId);
    }

    @Override
    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws UserStoreException {
        if (resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getExplicitlyAllowedUsersForResource", new Object[]{resourceId, action}, argTypes);
            return (String[])object;
        }
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getAllowedUsersForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        if (debug) {
            String[] roles;
            log.debug((Object)("Explicitly allowed roles for the ResourceID: " + resourceId + " Action: " + action));
            for (String role : roles = sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()])) {
                log.debug((Object)("role: " + role));
            }
        }
        return sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getDeniedRolesForResource(String resourceId, String action) throws UserStoreException {
        if (resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getDeniedRolesForResource", new Object[]{resourceId, action}, argTypes);
            return (String[])object;
        }
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getDeniedRolesForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getDeniedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws UserStoreException {
        if (resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getExplicitlyDeniedUsersForResource", new Object[]{resourceId, action}, argTypes);
            return (String[])object;
        }
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getDeniedUsersForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getDeniedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getAllowedUIResourcesForUser", new Object[]{userName, permissionRootPath}, argTypes);
            return (String[])object;
        }
        ArrayList<String> lstPermissions = new ArrayList<String>();
        if (this.isRoleAndGroupSeparationEnabled || this.verifyByRetrievingAllUserRoles) {
            String[] roles = this.userRealm.getUserStoreManager().getRoleListOfUser(userName);
            this.permissionTree.updatePermissionTree();
            this.permissionTree.getUIResourcesForRoles(roles, lstPermissions, permissionRootPath);
            String[] permissions = lstPermissions.toArray(new String[0]);
            return UserCoreUtil.optimizePermissions(permissions);
        }
        List<String> resourceIds = this.getUIPermissionId();
        if (resourceIds != null) {
            for (String resourceId : resourceIds) {
                if (!this.isUserAuthorized(userName, resourceId, "ui.execute")) continue;
                if (permissionRootPath == null) {
                    lstPermissions.add(resourceId);
                    continue;
                }
                if (!resourceId.contains(permissionRootPath)) continue;
                lstPermissions.add(resourceId);
            }
        }
        String[] permissions = lstPermissions.toArray(new String[0]);
        String[] optimizedList = UserCoreUtil.optimizePermissions(permissions);
        if (debug) {
            log.debug((Object)("Allowed UI Resources for User: " + userName + " in permissionRootPath: " + permissionRootPath));
            for (String resource : optimizedList) {
                log.debug((Object)("Resource: " + resource));
            }
        }
        return optimizedList;
    }

    @Override
    public String[] getAllowedUIResourcesForRole(String roleName, String permissionRootPath) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            Object object = this.callSecure("getAllowedUIResourcesForRole", new Object[]{roleName, permissionRootPath}, argTypes);
            return (String[])object;
        }
        ArrayList<String> lstPermissions = new ArrayList<String>();
        List<String> resourceIds = this.getUIPermissionId();
        if (resourceIds != null) {
            for (String resourceId : resourceIds) {
                if (!this.isRoleAuthorized(roleName, resourceId, "ui.execute")) continue;
                if (permissionRootPath == null) {
                    permissionRootPath = "/";
                }
                if (!resourceId.contains(permissionRootPath)) continue;
                lstPermissions.add(resourceId);
            }
        }
        String[] permissions = lstPermissions.toArray(new String[lstPermissions.size()]);
        String[] optimizedList = UserCoreUtil.optimizePermissions(permissions);
        if (debug) {
            log.debug((Object)("Allowed UI Resources for Role: " + roleName + " in permissionRootPath: " + permissionRootPath));
            for (String resource : optimizedList) {
                log.debug((Object)("Resource: " + resource));
            }
        }
        return optimizedList;
    }

    @Override
    public void authorizeRole(String roleName, String resourceId, String action) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("authorizeRole", new Object[]{roleName, resourceId, action}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.authorizeRole(roleName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        this.addAuthorizationForRole(roleName, resourceId, action, (short)1, true);
    }

    @Override
    public void denyRole(String roleName, String resourceId, String action) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("denyRole", new Object[]{roleName, resourceId, action}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.denyRole(roleName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        this.addAuthorizationForRole(roleName, resourceId, action, (short)0, true);
    }

    @Override
    public void authorizeUser(String userName, String resourceId, String action) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("authorizeUser", new Object[]{userName, resourceId, action}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.authorizeUser(userName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        if (!this.preserveCaseForResources) {
            resourceId = resourceId.toLowerCase();
        }
        this.addAuthorizationForUser(userName, resourceId, action, (short)1, true);
    }

    @Override
    public void denyUser(String userName, String resourceId, String action) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("denyUser", new Object[]{userName, resourceId, action}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.denyUser(userName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        if (!this.preserveCaseForResources) {
            resourceId = resourceId.toLowerCase();
        }
        this.addAuthorizationForUser(userName, resourceId, action, (short)0, true);
    }

    @Override
    public void clearResourceAuthorizations(String resourceId) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            this.callSecure("clearResourceAuthorizations", new Object[]{resourceId}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearResourceAuthorizations(resourceId, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (this.isCascadeDeleteEnabled == null || !Boolean.parseBoolean(this.isCascadeDeleteEnabled)) {
                DatabaseUtil.updateDatabase(dbConnection, (String)this.realmConfig.getAuthzProperties().get(DELETE_ROLE_PERMISSIONS), resourceId, this.tenantId);
                DatabaseUtil.updateDatabase(dbConnection, (String)this.realmConfig.getAuthzProperties().get(DELETE_USER_PERMISSIONS), resourceId, this.tenantId);
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if ("mysql".equals(type) || "mssql".equals(type)) {
                    DatabaseUtil.updateDatabase(dbConnection, (String)this.realmConfig.getAuthzProperties().get(DELETE_ROLE_PERMISSIONS_MYSQL), resourceId, this.tenantId);
                    DatabaseUtil.updateDatabase(dbConnection, (String)this.realmConfig.getAuthzProperties().get(DELETE_USER_PERMISSIONS_MYSQL), resourceId, this.tenantId);
                } else {
                    DatabaseUtil.updateDatabase(dbConnection, (String)this.realmConfig.getAuthzProperties().get(DELETE_ROLE_PERMISSIONS), resourceId, this.tenantId);
                    DatabaseUtil.updateDatabase(dbConnection, (String)this.realmConfig.getAuthzProperties().get(DELETE_USER_PERMISSIONS), resourceId, this.tenantId);
                }
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_TENANT_ID=?", resourceId, this.tenantId);
            this.permissionTree.clearResourceAuthorizations(resourceId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while clearing resource authorizations for resource id : " + resourceId;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while clearing resource authorization for resource id : " + resourceId;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("clearRoleAuthorization", new Object[]{roleName, resourceId, action}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleAuthorization(roleName, resourceId, action, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String domain = UserCoreUtil.extractDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), resourceId, action, this.tenantId, this.tenantId, this.tenantId, domain);
            this.permissionTree.clearRoleAuthorization(roleName, resourceId, action);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Error occurred while clearing role authorizations for role : " + roleName + " & resource id : " + resourceId + " & action : " + action;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void clearUserAuthorization(String userName, String resourceId, String action) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class};
            this.callSecure("clearUserAuthorization", new Object[]{userName, resourceId, action}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearUserAuthorization(userName, resourceId, action, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheEntry(this.cacheIdentifier, this.tenantId, userName, resourceId, action);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            int permissionId = this.getPermissionId(dbConnection, resourceId, action);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", userName, resourceId, action, this.tenantId, this.tenantId);
            this.permissionTree.clearUserAuthorization(userName, resourceId, action);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while clearing role authorizations for user : " + userName + " & resource id : " + resourceId + " & action : " + action;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearRoleActionOnAllResources(String roleName, String action) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            this.callSecure("clearRoleActionOnAllResources", new Object[]{roleName, action}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleActionOnAllResources(roleName, action, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearRoleAuthorization(roleName, action);
            String domain = UserCoreUtil.extractDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), action, this.tenantId, this.tenantId, this.tenantId, domain);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while clearing role action on all resources for role : " + roleName + " & action : " + action;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearRoleAuthorization(String roleName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            this.callSecure("clearRoleAuthorization", new Object[]{roleName}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleAuthorization(roleName, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearRoleAuthorization(roleName);
            String domain = UserCoreUtil.extractDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), this.tenantId, this.tenantId, domain);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while clearing role authorizations for role : " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearUserAuthorization(String userName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class};
            this.callSecure("clearUserAuthorization", new Object[]{userName}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearUserAuthorization(userName, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearUserAuthorization(userName);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", userName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while clearing user authorizations for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class};
            this.callSecure("resetPermissionOnUpdateRole", new Object[]{roleName, newRoleName}, argTypes);
            return;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.resetPermissionOnUpdateRole(roleName, newRoleName, this)) continue;
            return;
        }
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        String sqlStmt = "UPDATE UM_ROLE_PERMISSION set UM_ROLE_NAME=? WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update role name is null");
        }
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.updateRoleNameInCache(roleName, newRoleName);
            String domain = UserCoreUtil.extractDomainFromName(newRoleName);
            newRoleName = UserCoreUtil.removeDomainFromName(newRoleName);
            roleName = UserCoreUtil.removeDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId, this.tenantId, domain);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while resetting permission on update role : " + roleName + " & to new role : " + newRoleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public void addAuthorization(String subject, String resourceId, String action, boolean authorized, boolean isRole) throws UserStoreException {
        if (!this.preserveCaseForResources && resourceId != null) {
            resourceId = resourceId.toLowerCase();
        }
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE};
            this.callSecure("addAuthorization", new Object[]{subject, resourceId, action, authorized, isRole}, argTypes);
            return;
        }
        short allow = 0;
        if (authorized) {
            allow = 1;
        }
        if (isRole) {
            this.addAuthorizationForRole(subject, resourceId, action, allow, false);
        } else {
            this.addAuthorizationForUser(subject, resourceId, action, allow, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAuthorizationForRole(String roleName, String resourceId, String action, short allow, boolean updateCache) throws UserStoreException {
        PreparedStatement prepStmt;
        Connection dbConnection;
        block26: {
            this.authorizationCache.clearCacheByTenant(this.tenantId);
            dbConnection = null;
            prepStmt = null;
            ResultSet rs = null;
            short isAllowed = -1;
            boolean isRolePermissionExisting = false;
            try {
                boolean isSystemRole;
                dbConnection = this.getDBConnection();
                int permissionId = this.getPermissionId(dbConnection, resourceId, action);
                String domain = UserCoreUtil.extractDomainFromName(roleName);
                if (domain != null) {
                    domain = domain.toUpperCase();
                }
                if (isSystemRole = UserCoreUtil.isSystemRole(roleName, this.tenantId, this.dataSource)) {
                    domain = "SYSTEM";
                } else if (domain == null) {
                    domain = "PRIMARY";
                }
                prepStmt = dbConnection.prepareStatement("SELECT UM_ID, UM_IS_ALLOWED FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)");
                prepStmt.setString(1, UserCoreUtil.removeDomainFromName(roleName));
                prepStmt.setString(2, resourceId);
                prepStmt.setString(3, action);
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
                prepStmt.setInt(6, this.tenantId);
                prepStmt.setString(7, domain);
                rs = prepStmt.executeQuery();
                if (rs != null && rs.next()) {
                    isAllowed = rs.getShort(2);
                    isRolePermissionExisting = true;
                } else {
                    isRolePermissionExisting = false;
                }
                if (isRolePermissionExisting && isAllowed != allow) {
                    DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), resourceId, action, this.tenantId, this.tenantId, this.tenantId, domain);
                    isRolePermissionExisting = false;
                }
                if (!isRolePermissionExisting) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding permission Id: " + permissionId + " to the role: " + UserCoreUtil.removeDomainFromName(roleName) + " of tenant: " + this.tenantId + " of domain: " + domain + " to resource: " + resourceId));
                    }
                    try {
                        DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_ROLE_PERMISSION (UM_PERMISSION_ID, UM_ROLE_NAME, UM_IS_ALLOWED, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?, ?, ?, ?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))", permissionId, UserCoreUtil.removeDomainFromName(roleName), allow, this.tenantId, this.tenantId, domain);
                    }
                    catch (UserStoreException e) {
                        if (!UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode().equals(e.getErrorCode())) throw e;
                        log.warn((Object)("Permission Id: " + permissionId + " is already added to the role: " + roleName));
                    }
                }
                if (updateCache) {
                    if (allow == 1) {
                        this.permissionTree.authorizeRoleInTree(roleName, resourceId, action, true);
                    } else {
                        this.permissionTree.denyRoleInTree(roleName, resourceId, action, true);
                    }
                }
                dbConnection.commit();
                if (rs == null) break block26;
            }
            catch (Exception e) {
                try {
                    try {
                        if (dbConnection != null) {
                            dbConnection.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        throw new UserStoreException("Error in connection rollback ", e1);
                    }
                    if (!log.isDebugEnabled()) throw new UserStoreException("Error! " + e.getMessage(), e);
                    log.debug((Object)("Error! " + e.getMessage()), (Throwable)e);
                    throw new UserStoreException("Error! " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            log.error((Object)"Closing result set failed when adding role permission", (Throwable)e2);
                        }
                    }
                    DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)"Closing result set failed when adding role permission", (Throwable)e);
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAuthorizationForUser(String userName, String resourceId, String action, short allow, boolean updateCache) throws UserStoreException {
        PreparedStatement prepStmt;
        Connection dbConnection;
        block20: {
            this.authorizationCache.clearCacheByTenant(this.tenantId);
            dbConnection = null;
            prepStmt = null;
            ResultSet rs = null;
            short isAllowed = -1;
            boolean isUserPermissionExisting = false;
            try {
                dbConnection = this.getDBConnection();
                int permissionId = this.getPermissionId(dbConnection, resourceId, action);
                prepStmt = dbConnection.prepareStatement("SELECT UM_ID, UM_IS_ALLOWED FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
                prepStmt.setString(1, userName);
                prepStmt.setString(2, resourceId);
                prepStmt.setString(3, action);
                prepStmt.setInt(4, this.tenantId);
                prepStmt.setInt(5, this.tenantId);
                rs = prepStmt.executeQuery();
                if (rs != null && rs.next()) {
                    isAllowed = rs.getShort(2);
                    isUserPermissionExisting = true;
                } else {
                    isUserPermissionExisting = false;
                }
                if (isUserPermissionExisting && isAllowed != allow) {
                    DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", userName, resourceId, action, this.tenantId, this.tenantId);
                    isUserPermissionExisting = false;
                }
                if (!isUserPermissionExisting) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding permission Id: " + permissionId + " to the user: " + userName + " of tenant: " + this.tenantId + " to resource: " + resourceId));
                    }
                    DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_USER_PERMISSION (UM_PERMISSION_ID, UM_USER_NAME, UM_IS_ALLOWED, UM_TENANT_ID) VALUES (?, ?, ?, ?)", permissionId, userName, allow, this.tenantId);
                }
                if (updateCache) {
                    if (allow == 1) {
                        this.permissionTree.authorizeUserInTree(userName, resourceId, action, true);
                    } else {
                        this.permissionTree.denyUserInTree(userName, resourceId, action, true);
                        this.authorizationCache.clearCacheEntry(this.cacheIdentifier, this.tenantId, userName, resourceId, action);
                    }
                }
                dbConnection.commit();
                if (rs == null) break block20;
            }
            catch (Exception e) {
                try {
                    try {
                        if (dbConnection != null) {
                            dbConnection.rollback();
                        }
                    }
                    catch (SQLException e1) {
                        throw new UserStoreException("Error in connection rollback ", e1);
                    }
                    if (!log.isDebugEnabled()) throw new UserStoreException("Error! " + e.getMessage(), e);
                    log.debug((Object)("Error! " + e.getMessage()), (Throwable)e);
                    throw new UserStoreException("Error! " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            log.error((Object)"Closing result set failed when adding user permission", (Throwable)e2);
                        }
                    }
                    DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)"Closing result set failed when adding user permission", (Throwable)e);
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    private List<String> getUIPermissionId() throws UserStoreException {
        ArrayList<String> arrayList;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> resourceIds = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_RESOURCE_ID FROM UM_PERMISSION WHERE UM_ACTION=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, "ui.execute");
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    resourceIds.add(rs.getString(1));
                }
            }
            arrayList = resourceIds;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while getting UI permission ID";
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return arrayList;
    }

    private int getPermissionId(Connection dbConnection, String resourceId, String action) throws UserStoreException {
        int permissionId = this.getPermissionIdFromStore(dbConnection, resourceId, action);
        if (permissionId == -1) {
            this.addPermissionId(dbConnection, resourceId, action);
            permissionId = this.getPermissionIdFromStore(dbConnection, resourceId, action);
            if (permissionId == -1) {
                String errorMessage = "Error occurred while getting UI permission ID for resource id : " + resourceId + " & action : " + action;
                throw new UserStoreException(errorMessage);
            }
        }
        return permissionId;
    }

    private int getPermissionIdFromStore(Connection dbConnection, String resourceId, String action) throws UserStoreException {
        int n;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int value = -1;
        try {
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=? AND UM_ACTION=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, resourceId);
            prepStmt.setString(2, action);
            prepStmt.setInt(3, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                value = rs.getInt(1);
            }
            n = value;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error occurred while getting UI permission ID for resource id : " + resourceId + " & action : " + action;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return n;
    }

    /*
     * Loose catch block
     */
    private void addPermissionId(Connection dbConnection, String resourceId, String action) throws UserStoreException {
        PreparedStatement prepStmt;
        block7: {
            prepStmt = null;
            try {
                prepStmt = dbConnection.prepareStatement("INSERT INTO UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID) VALUES (?, ?, ?)");
                prepStmt.setString(1, resourceId);
                prepStmt.setString(2, action);
                prepStmt.setInt(3, this.tenantId);
                int count = prepStmt.executeUpdate();
                dbConnection.commit();
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("Executed query is INSERT INTO UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID) VALUES (?, ?, ?) and number of updated rows :: " + count));
            }
            catch (SQLIntegrityConstraintViolationException e) {
                block8: {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                DatabaseUtil.closeAllConnections(null, prepStmt);
            }
            catch (SQLException e2) {
                String errorMessage = "Error occurred while adding UI permission ID for resource id : " + resourceId + " & action : " + action;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e2);
                }
                throw new UserStoreException(errorMessage, e2);
                {
                    catch (Throwable throwable) {
                        DatabaseUtil.closeAllConnections(null, prepStmt);
                        throw throwable;
                    }
                }
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = this.dataSource.getConnection();
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }

    public void populatePermissionTreeFromDB() throws UserStoreException {
        if (!isSecureCall.get().booleanValue()) {
            Class[] argTypes = new Class[]{};
            this.callSecure("populatePermissionTreeFromDB", new Object[0], argTypes);
            return;
        }
        this.permissionTree.updatePermissionTreeFromDB();
    }

    public void clearPermissionTree() {
        if (!isSecureCall.get().booleanValue()) {
            block3: {
                Class[] argTypes = new Class[]{};
                try {
                    this.callSecure("clearPermissionTree", new Object[0], argTypes);
                }
                catch (UserStoreException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Error while clearing Permission Tree : " + (Object)((Object)e)));
                }
            }
            return;
        }
        this.permissionTree.clear();
        this.authorizationCache.clearCache();
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    private void addInitialData() throws UserStoreException {
        String mgtPermissions = this.realmConfig.getAuthorizationManagerProperty("EveryoneRoleManagementPermissions");
        if (mgtPermissions != null) {
            String[] resourceIds;
            String everyoneRole = this.realmConfig.getEveryOneRoleName();
            for (String resourceId : resourceIds = mgtPermissions.split(",")) {
                if (this.isRoleAuthorized(everyoneRole, resourceId, "ui.execute")) continue;
                this.authorizeRole(everyoneRole, resourceId, "ui.execute");
            }
        }
        if ((mgtPermissions = this.realmConfig.getAuthorizationManagerProperty("AdminRoleManagementPermissions")) != null) {
            String[] resourceIds = mgtPermissions.split(",");
            String adminRole = this.realmConfig.getAdminRoleName();
            for (String resourceId : resourceIds) {
                if (this.isRoleAuthorized(adminRole, resourceId, "ui.execute")) continue;
                if (this.userRealm.getUserStoreManager().isReadOnly()) {
                    String readLDAPGroups = (String)this.realmConfig.getUserStoreProperties().get("ReadLDAPGroups");
                    if (readLDAPGroups != null) {
                        if (!Boolean.parseBoolean(readLDAPGroups)) {
                            this.authorizeRole("Internal" + CarbonConstants.DOMAIN_SEPARATOR + UserCoreUtil.removeDomainFromName(adminRole), resourceId, "ui.execute");
                            return;
                        }
                    } else {
                        this.authorizeRole("Internal" + CarbonConstants.DOMAIN_SEPARATOR + UserCoreUtil.removeDomainFromName(adminRole), resourceId, "ui.execute");
                        return;
                    }
                }
                adminRole = UserCoreUtil.addDomainToName(adminRole, this.realmConfig.getUserStoreProperty("DomainName"));
                this.authorizeRole(adminRole, resourceId, "ui.execute");
            }
        }
    }

    @Override
    public String[] normalizeRoles(String[] roles) {
        if (roles != null && roles.length > 0) {
            int index = 0;
            ArrayList<String> normalizedRoles = new ArrayList<String>();
            for (String role : roles) {
                index = role.indexOf("@".toLowerCase());
                if (index >= 0) {
                    normalizedRoles.add(role.substring(0, index));
                    continue;
                }
                normalizedRoles.add(role);
            }
            return normalizedRoles.toArray(new String[normalizedRoles.size()]);
        }
        return roles;
    }

    private Object callSecure(String methodName, final Object[] objects, Class[] argTypes) throws UserStoreException {
        Method method;
        final JDBCAuthorizationManager instance = this;
        isSecureCall.set(Boolean.TRUE);
        try {
            Class<?> clazz = Class.forName("org.wso2.carbon.user.core.authorization.JDBCAuthorizationManager");
            method = clazz.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Error occurred when calling method " + methodName), (Throwable)e);
            throw new UserStoreException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Error occurred when calling class " + methodName), (Throwable)e);
            throw new UserStoreException(e);
        }
        try {
            Object e = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke((Object)instance, objects);
                }
            });
            return e;
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof UserStoreException) {
                throw new UserStoreException(e.getCause().getCause().getMessage(), e);
            }
            String msg = "Error occurred while accessing Java Security Manager Privilege Block";
            log.error((Object)msg);
            throw new UserStoreException(msg, e);
        }
        finally {
            isSecureCall.set(Boolean.FALSE);
        }
    }
}

