/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder;

import com.google.code.geocoder.Geocoder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.InvalidKeyException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public class AdvancedGeoCoder
extends Geocoder {
    private final HttpClient httpClient;

    public AdvancedGeoCoder(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public AdvancedGeoCoder() {
        this(new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager()));
    }

    public AdvancedGeoCoder(String clientId, String clientKey) throws InvalidKeyException {
        super(clientId, clientKey);
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    }

    public AdvancedGeoCoder(HttpClient httpClient, String clientId, String clientKey) throws InvalidKeyException {
        super(clientId, clientKey);
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GeocodeResponse request(Gson gson, String urlString) throws IOException {
        GetMethod getMethod = new GetMethod(urlString);
        try {
            this.httpClient.executeMethod((HttpMethod)getMethod);
            InputStreamReader reader = new InputStreamReader(getMethod.getResponseBodyAsStream(), getMethod.getResponseCharSet());
            GeocodeResponse geocodeResponse = (GeocodeResponse)gson.fromJson((Reader)reader, GeocodeResponse.class);
            return geocodeResponse;
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

