/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.user.store.configuration.stub.UserStoreConfigAdminServiceIdentityUserStoreMgtException;
import org.wso2.carbon.identity.user.store.configuration.stub.UserStoreConfigAdminServiceStub;
import org.wso2.carbon.identity.user.store.configuration.stub.api.Properties;
import org.wso2.carbon.identity.user.store.configuration.stub.dto.UserStoreDTO;

public class UserStoreConfigAdminServiceClient {
    private UserStoreConfigAdminServiceStub stub;
    protected static final Log log = LogFactory.getLog(UserStoreConfigAdminServiceClient.class);

    public UserStoreConfigAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws AxisFault {
        String serviceURL = backendServerURL + "UserStoreConfigAdminService";
        this.stub = new UserStoreConfigAdminServiceStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getRepositoryClasses() throws Exception {
        return this.stub.getRepositoryClasses();
    }

    public UserStoreDTO[] getActiveDomains() throws Exception {
        return this.stub.getSecondaryRealmConfigurations();
    }

    public String[] getAvailableUserStoreClasses() throws Exception {
        return this.stub.getAvailableUserStoreClasses();
    }

    public Properties getUserStoreProperties(String className) throws Exception {
        return this.stub.getUserStoreManagerProperties(className);
    }

    public void addUserStore(UserStoreDTO userStoreDTO) throws Exception {
        try {
            this.stub.addUserStore(userStoreDTO);
        }
        catch (UserStoreConfigAdminServiceIdentityUserStoreMgtException e) {
            this.handleException(e);
        }
    }

    public void deleteUserStoresSet(String[] userStores) throws Exception {
        this.stub.deleteUserStoresSet(userStores);
    }

    public void deleteUserStoresSet(UserStoreDTO[] userStores) throws Exception {
        this.stub.deleteUserStoresSetFromRepository(userStores);
    }

    @Deprecated
    public void deleteUserStore(String userStore) throws Exception {
        this.stub.deleteUserStore(userStore);
    }

    public void deleteUserStoreFromRepository(UserStoreDTO userStoreDTO) throws Exception {
        this.stub.deleteUserStoreFromRepository(userStoreDTO);
    }

    @Deprecated
    public void changeUserStoreState(String domain, String isDisabled) throws Exception {
        this.stub.changeUserStoreState(domain, Boolean.parseBoolean(isDisabled));
    }

    public void changeUserStoreState(String domain, String isDisabled, String repositoryClasses) throws Exception {
        this.stub.modifyUserStoreState(domain, Boolean.parseBoolean(isDisabled), repositoryClasses);
    }

    public void updateUserStoreWithDomainName(String previousDomain, UserStoreDTO userStoreDTO) throws Exception {
        if (previousDomain != null && !"".equals(previousDomain) && !previousDomain.equalsIgnoreCase(userStoreDTO.getDomainId())) {
            try {
                this.stub.editUserStoreWithDomainName(previousDomain, userStoreDTO);
            }
            catch (UserStoreConfigAdminServiceIdentityUserStoreMgtException e) {
                this.handleException(e);
            }
        } else {
            this.updateUserStore(userStoreDTO);
        }
    }

    public void updateUserStore(UserStoreDTO userStoreDTO) throws Exception {
        try {
            this.stub.editUserStore(userStoreDTO);
        }
        catch (UserStoreConfigAdminServiceIdentityUserStoreMgtException e) {
            this.handleException(e);
        }
    }

    public boolean testRDBMSConnection(String domainName, String driverName, String connectionURL, String username, String connectionPassword, String messageID) throws Exception {
        boolean result = false;
        try {
            result = this.stub.testRDBMSConnection(domainName, driverName, connectionURL, username, connectionPassword, messageID);
        }
        catch (UserStoreConfigAdminServiceIdentityUserStoreMgtException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getFaultMessage().getIdentityUserStoreMgtException().getMessage(), (Throwable)e);
            }
            throw new AxisFault(e.getFaultMessage().getIdentityUserStoreMgtException().getMessage());
        }
        return result;
    }

    protected void handleException(UserStoreConfigAdminServiceIdentityUserStoreMgtException e) throws AxisFault {
        String errorMessage = e.getFaultMessage().getIdentityUserStoreMgtException() != null ? e.getFaultMessage().getIdentityUserStoreMgtException().getMessage() : e.getMessage();
        log.error((Object)errorMessage, (Throwable)e);
        throw new AxisFault(errorMessage);
    }
}

