/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.bootup.validator.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.core.bootup.validator.ConfigurationValidator;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

@Deprecated
public class ConfigValidationXMLProcessor {
    public static final String CONFIG_VALIDATION_XML = "config-validation.xml";
    public static final String CONFIG_ROOT_TAG = "Configuration";
    public static final String PARAMETER_TAG = "Parameter";
    public static final String VALIDATOR_TAG = "Validator";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String VALIDATOR_ENABLED_ATTRIBUTE = "enabled";
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static boolean activate = false;
    private static final Log log = LogFactory.getLog(ConfigValidationXMLProcessor.class);
    private Document dom;
    private List<ConfigurationValidator> validators = new ArrayList<ConfigurationValidator>();

    public void parseConfigValidationXml() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = ConfigValidationXMLProcessor.getSecuredDocumentBuilder();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.dom = db.parse(ConfigValidationXMLProcessor.getConfigRecommendationsXML());
        this.parseDocument();
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    private static String getConfigRecommendationsXML() {
        String confDir = CarbonUtils.getEtcCarbonConfigDirPath();
        String xmlPath = confDir + File.separator + CONFIG_VALIDATION_XML;
        return xmlPath;
    }

    private void parseDocument() {
        Element configRootElement = this.dom.getDocumentElement();
        String enabled = configRootElement.getAttribute(VALIDATOR_ENABLED_ATTRIBUTE);
        if (Boolean.valueOf(enabled).booleanValue()) {
            activate = true;
            NodeList validatorNodeList = configRootElement.getElementsByTagName(VALIDATOR_TAG);
            if (validatorNodeList != null && validatorNodeList.getLength() > 0) {
                for (int i = 0; i < validatorNodeList.getLength(); ++i) {
                    Element el = (Element)validatorNodeList.item(i);
                    try {
                        ConfigurationValidator validator = this.initConfigValidator(el);
                        this.validators.add(validator);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error occured while loading ConfigurationValidator class : " + el.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
                    }
                }
            }
        }
    }

    private ConfigurationValidator initConfigValidator(Element elem) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        HashMap<String, String> validationParams = new HashMap<String, String>();
        String className = elem.getAttribute(CLASS_ATTRIBUTE);
        ConfigurationValidator validator = (ConfigurationValidator)Class.forName(className).newInstance();
        NodeList nl = elem.getElementsByTagName(PARAMETER_TAG);
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                String paramName = el.getAttribute(ID_ATTRIBUTE);
                if (!el.hasChildNodes()) continue;
                String val = el.getFirstChild().getNodeValue();
                if (paramName == null || val == null) continue;
                validationParams.put(paramName, val);
            }
        }
        validator.setRecommendedConfigurations(validationParams);
        return validator;
    }

    public List<ConfigurationValidator> getValidators() {
        return this.validators;
    }

    public void setConfigValidators(ArrayList<ConfigurationValidator> configValidators) {
        this.validators = configValidators;
    }

    public static boolean isActivated() {
        return activate;
    }
}

