/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.soap.SOAPEventAdapter;
import org.wso2.carbon.utils.CarbonUtils;

public class SOAPEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.soap.i18n.Resources", Locale.getDefault());
    private int httpPort;
    private int httpsPort;
    private int portOffset = this.getPortOffset();

    public SOAPEventAdapterFactory() {
        this.httpPort = 9763 + this.portOffset;
        this.httpsPort = 9443 + this.portOffset;
    }

    public String getType() {
        return "soap";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("xml");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property exposedTransportsProperty = new Property("transports");
        exposedTransportsProperty.setRequired(true);
        exposedTransportsProperty.setDisplayName(this.resourceBundle.getString("transports"));
        exposedTransportsProperty.setOptions(new String[]{"https", "http", "local", "all"});
        exposedTransportsProperty.setDefaultValue("all");
        propertyList.add(exposedTransportsProperty);
        return propertyList;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("soap.usage.tips_prefix") + this.httpPort + this.resourceBundle.getString("soap.usage.tips_mid1") + this.httpsPort + this.resourceBundle.getString("soap.usage.tips_mid2") + this.httpPort + this.resourceBundle.getString("soap.usage.tips_mid3") + this.httpsPort + this.resourceBundle.getString("soap.usage.tips_postfix");
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new SOAPEventAdapter(eventAdapterConfiguration, globalProperties);
    }

    private int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }
}

