/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.soap;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.soap.internal.SubscriptionMessageReceiver;

public final class SOAPEventAdapter
implements InputEventAdapter {
    private static final Log log = LogFactory.getLog(SOAPEventAdapter.class);
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdaptorListener;
    private final String id = UUID.randomUUID().toString();
    private boolean isConnected = false;

    public SOAPEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init(InputEventAdapterListener eventAdaptorListener) throws InputEventAdapterException {
        this.eventAdaptorListener = eventAdaptorListener;
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            this.registerService(this.eventAdaptorListener, this.eventAdapterConfiguration.getName(), EventAdapterUtil.getAxisConfiguration());
            this.isConnected = true;
        }
        catch (AxisFault axisFault) {
            throw new InputEventAdapterRuntimeException("Cannot register Input Adapter " + this.eventAdapterConfiguration.getName() + " on tenant " + tenantId, (Throwable)axisFault);
        }
    }

    public void disconnect() {
        if (this.isConnected) {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            try {
                this.unregisterService(this.eventAdapterConfiguration.getName(), EventAdapterUtil.getAxisConfiguration());
                this.isConnected = false;
            }
            catch (AxisFault axisFault) {
                throw new InputEventAdapterRuntimeException("Cannot un-register Input Adapter " + this.eventAdapterConfiguration.getName() + " on tenant " + tenantId, (Throwable)axisFault);
            }
        }
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SOAPEventAdapter)) {
            return false;
        }
        SOAPEventAdapter that = (SOAPEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isEventDuplicatedInCluster() {
        return false;
    }

    public boolean isPolling() {
        return false;
    }

    private void registerService(InputEventAdapterListener eventAdaptorListener, String serviceName, AxisConfiguration axisConfiguration) throws AxisFault {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        AxisService axisService = axisConfiguration.getService(serviceName);
        if (axisService != null) {
            axisConfiguration.removeService(serviceName);
        }
        axisService = new AxisService(serviceName);
        InOnlyAxisOperation axisOperation = new InOnlyAxisOperation(new QName("receive"));
        axisOperation.setMessageReceiver((MessageReceiver)new SubscriptionMessageReceiver(eventAdaptorListener, serviceName, "receive", tenantId));
        axisService.addOperation((AxisOperation)axisOperation);
        List transports = axisService.getExposedTransports();
        transports.clear();
        String exposedTransports = (String)this.eventAdapterConfiguration.getProperties().get("transports");
        if (exposedTransports.equalsIgnoreCase("all")) {
            transports.add("http");
            transports.add("https");
            transports.add("local");
        } else {
            transports.add(exposedTransports);
        }
        axisService.setExposedTransports(transports);
        axisConfiguration.addService(axisService);
        axisOperation.setSoapAction("urn:receive");
        axisConfiguration.getPhasesInfo().setOperationPhases((AxisOperation)axisOperation);
        axisOperation.getMessage("In").setName("in");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterService(String serviceName, AxisConfiguration axisConfiguration) throws AxisFault {
        AxisService axisService = axisConfiguration.getService(serviceName);
        try {
            if (axisService == null) {
                throw new AxisFault("There is no service with the name " + serviceName);
            }
            AxisOperation axisOperation = axisService.getOperation(new QName("receive"));
            if (axisOperation == null) {
                throw new AxisFault("There is no operation with the name receive");
            }
            SubscriptionMessageReceiver messageReceiver = (SubscriptionMessageReceiver)axisOperation.getMessageReceiver();
            if (messageReceiver == null) {
                throw new AxisFault("There is no message receiver for operation with name receive");
            }
        }
        finally {
            if (axisService != null) {
                axisConfiguration.removeService(serviceName);
            }
        }
    }
}

