/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.ws.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLTTransformer {
    public static final String WSDL2SIG_XSL_LOCATION = "xslt/wsdl2sig.xslt";
    public static final String JSSTUB_XSL_LOCATION = "xslt/jsstub.xslt";
    public static final String WSDL10TO20_XSL_LOCATION = "xslt/wsdl11to20.xslt";
    private static Log log = LogFactory.getLog(XSLTTransformer.class);

    public static DOMSource getSigStream(InputStream wsdlInStream, Map paramMap) throws TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        StreamSource wsdlSource = new StreamSource(wsdlInStream);
        InputStream sigStream = XSLTTransformer.class.getClassLoader().getResourceAsStream(WSDL2SIG_XSL_LOCATION);
        StreamSource wsdl2sigXSLTSource = new StreamSource(sigStream);
        DocumentBuilder docB = XSLTTransformer.getSecuredDocumentBuilder(false);
        Document docSig = docB.newDocument();
        DOMResult resultSig = new DOMResult(docSig);
        XSLTTransformer.transform(wsdlSource, wsdl2sigXSLTSource, resultSig, paramMap, new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                String xsd = href.substring(href.toLowerCase().indexOf("?xsd=") + 5);
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    return new StreamSource(new ByteArrayInputStream(outputStream.toByteArray()));
                }
                catch (Exception e) {
                    log.error((Object)("Error while printing xsd : " + xsd), (Throwable)e);
                    throw new TransformerException(e);
                }
            }
        });
        return new DOMSource(docSig);
    }

    public static void generateStub(Source xmlIn, Result result, Map paramMap) throws TransformerException {
        try (InputStream stubXSLTStream = XSLTTransformer.class.getClassLoader().getResourceAsStream(JSSTUB_XSL_LOCATION);){
            StreamSource stubXSLSource = new StreamSource(stubXSLTStream);
            XSLTTransformer.transform(xmlIn, stubXSLSource, result, paramMap, new URIResolver(){

                @Override
                public Source resolve(String href, String base) {
                    InputStream is = XSLTTransformer.class.getResourceAsStream(href);
                    return new StreamSource(is);
                }
            });
        }
        catch (IOException e) {
            log.error((Object)"Error while handling inputstream: ", (Throwable)e);
            throw new TransformerException(e);
        }
    }

    public static InputStream getWSDL2(InputStream wsdl1InStream, Map paramMap) throws TransformerException, ParserConfigurationException {
        ByteArrayInputStream wsdlIS;
        InputStream wsdl10to20xslt = XSLTTransformer.class.getClassLoader().getResourceAsStream(WSDL10TO20_XSL_LOCATION);
        StreamSource wsdl10Source = new StreamSource(wsdl1InStream);
        DocumentBuilder docB = XSLTTransformer.getSecuredDocumentBuilder(false);
        Document docWSDL = docB.newDocument();
        DOMResult resultWSDL20 = new DOMResult(docWSDL);
        StreamSource wsdlXSLSource = new StreamSource(wsdl10to20xslt);
        try {
            XSLTTransformer.transform(wsdl10Source, wsdlXSLSource, resultWSDL20, paramMap, new URIResolver(){

                @Override
                public Source resolve(String href, String base) {
                    InputStream is = XSLTTransformer.class.getResourceAsStream(href);
                    StreamSource isSource = new StreamSource(is);
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return isSource;
                }
            });
            ByteArrayOutputStream wsdl20OutputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(docWSDL);
            StreamResult outputTarget = new StreamResult(wsdl20OutputStream);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlSource, outputTarget);
            wsdlIS = new ByteArrayInputStream(wsdl20OutputStream.toByteArray());
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                wsdl10to20xslt.close();
            }
            catch (IOException ignore) {
                log.error((Object)"Unable to close the XSLT used to transform WSDL 1.1 to 2.0", (Throwable)ignore);
            }
        }
        return wsdlIS;
    }

    public static void transform(Source xmlIn, Source xslIn, Result result, Map paramMap, URIResolver uriResolver) throws TransformerException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setURIResolver(uriResolver);
            Transformer transformer = transformerFactory.newTransformer(xslIn);
            if (paramMap != null) {
                Set set = paramMap.keySet();
                for (Object aSet : set) {
                    String key = (String)aSet;
                    String value = (String)paramMap.get(key);
                    transformer.setParameter(key, value);
                }
            }
            transformer.transform(xmlIn, result);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static DocumentBuilder getSecuredDocumentBuilder(boolean setIgnoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(setIgnoreComments);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                throw new SAXException("Possible XML External Entity (XXE) attack. Skip resolving entity");
            }
        });
        return documentBuilder;
    }

    static {
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
    }
}

