/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.modules.ws;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.modules.ws.WSRequestHostObject;
import org.jaggeryjs.modules.ws.WebServiceErrorHostObject;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;

public class WSRequestCallback
implements AxisCallback {
    private WSRequestHostObject wsrequest;
    private static final Log log = LogFactory.getLog(WSRequestCallback.class);

    public WSRequestCallback(WSRequestHostObject wsrequest) {
        this.wsrequest = wsrequest;
    }

    public void onComplete() {
    }

    public void onError(Exception ex) {
        this.wsrequest.error = new WebServiceErrorHostObject();
        this.processError(ex);
    }

    public void onFault(MessageContext messageContext) {
        AxisFault fault = Utils.getInboundFaultFromMessageContext((MessageContext)messageContext);
        this.processError((Exception)fault);
    }

    private void processError(Exception ex) {
        if (ex instanceof AxisFault) {
            QName faultCode;
            AxisFault e = (AxisFault)ex;
            OMElement detail = e.getDetail();
            if (detail != null) {
                this.wsrequest.error.jsSet_detail(detail.toString());
            }
            if ((faultCode = e.getFaultCode()) != null) {
                this.wsrequest.error.jsSet_code(faultCode.toString());
            }
            this.wsrequest.error.jsSet_reason(e.getReason());
        } else {
            Throwable cause = ex.getCause();
            if (cause != null) {
                this.wsrequest.error.jsSet_detail(cause.toString());
            }
            this.wsrequest.error.jsSet_code("No SOAP Body.");
            this.wsrequest.error.jsSet_reason(ex.getMessage());
        }
        this.wsrequest.readyState = 4;
        if (this.wsrequest.onReadyStateChangeFunction != null) {
            Context cx = RhinoEngine.enterContext((ContextFactory)this.wsrequest.context.getFactory());
            this.wsrequest.onReadyStateChangeFunction.call(cx, (Scriptable)this.wsrequest, (Scriptable)this.wsrequest, new Object[0]);
            RhinoEngine.exitContext();
        }
    }

    public void onMessage(MessageContext messageContext) {
        try {
            this.wsrequest.updateResponse(messageContext.getEnvelope().getBody().getFirstElement());
            this.wsrequest.readyState = 4;
            if (this.wsrequest.onReadyStateChangeFunction != null) {
                Context cx = RhinoEngine.enterContext((ContextFactory)this.wsrequest.context.getFactory());
                this.wsrequest.onReadyStateChangeFunction.call(cx, (Scriptable)this.wsrequest, (Scriptable)this.wsrequest, new Object[0]);
                RhinoEngine.exitContext();
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

