/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.fastXSLT;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.io.IOUtils;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.jaxp.DOOMResultBuilderFactory;
import org.apache.synapse.util.jaxp.DOOMSourceBuilderFactory;
import org.apache.synapse.util.jaxp.ResultBuilderFactory;
import org.apache.synapse.util.jaxp.SourceBuilderFactory;
import org.apache.synapse.util.jaxp.StreamResultBuilderFactory;
import org.apache.synapse.util.jaxp.StreamSourceBuilderFactory;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.xpath.SourceXPathSupport;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.wso2.carbon.mediator.fastXSLT.MessageDataSource;
import org.wso2.carbon.relay.StreamingOnRequestDataSource;

public class FastXSLTMediator
extends AbstractMediator
implements ManagedLifecycle {
    public static final String USE_DOM_SOURCE_AND_RESULTS = "http://ws.apache.org/ns/synapse/transform/feature/dom";
    public static final String SOURCE_BUILDER_FACTORY = "http://ws.apache.org/ns/synapse/transform/attribute/sbf";
    public static final String RESULT_BUILDER_FACTORY = "http://ws.apache.org/ns/synapse/transform/attribute/rbf";
    private Value xsltKey = null;
    private final Object transformerLock = new Object();
    private Map<String, Templates> cachedTemplatesMap = new Hashtable<String, Templates>();
    private TransformerFactory transFact = TransformerFactory.newInstance();
    private final SourceXPathSupport source = new SourceXPathSupport();
    private String targetPropertyName = null;
    private ResourceMap resourceMap;
    private final List<MediatorProperty> properties = new ArrayList<MediatorProperty>();
    private SourceBuilderFactory sourceBuilderFactory = new StreamSourceBuilderFactory();
    private ResultBuilderFactory resultBuilderFactory = new StreamResultBuilderFactory();
    private final List<MediatorProperty> transformerFactoryFeatures = new ArrayList<MediatorProperty>();
    private final List<MediatorProperty> transformerFactoryAttributes = new ArrayList<MediatorProperty>();
    private int bufferSizeSupport = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(org.apache.synapse.MessageContext context) {
        Object object;
        if (context.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(context)) {
            return true;
        }
        InputStream inMessage = null;
        Templates cTemplate = null;
        MessageContext axis2MC = null;
        SynapseLog synLog = this.getLog(context);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"XMLConverter mediator : start");
        }
        try {
            axis2MC = ((Axis2MessageContext)context).getAxis2MessageContext();
            Pipe pipe = (Pipe)axis2MC.getProperty("pass-through.pipe");
            if (pipe != null) {
                inMessage = this.getMessageInputStreamFromSoapEnvelop(context);
                if (inMessage == null) {
                    inMessage = this.getMessageInputStreamPT(axis2MC, pipe);
                }
            } else {
                inMessage = this.getMessageInputStreamBinaryRelay(context);
            }
            if (inMessage == null) {
                inMessage = this.getMessageInputStreamFromSoapEnvelop(context);
            }
        }
        catch (IOException e) {
            this.handleException("Error while reading the input stream ", e, context);
        }
        String generatedXsltKey = this.xsltKey.evaluateValue(context);
        if (this.isCreationOrRecreationRequired(context)) {
            object = this.transformerLock;
            synchronized (object) {
                cTemplate = this.isCreationOrRecreationRequired(context) ? this.createTemplate(context, generatedXsltKey) : this.cachedTemplatesMap.get(generatedXsltKey);
            }
        }
        object = this.transformerLock;
        synchronized (object) {
            cTemplate = this.cachedTemplatesMap.get(generatedXsltKey);
        }
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        try {
            ByteArrayOutputStream _transformedOutMessage = new ByteArrayOutputStream();
            this.transform(inMessage, _transformedOutMessage, cTemplate);
            ByteArrayOutputStream _transformedOutMessageNew = new ByteArrayOutputStream();
            IOUtils.write((byte[])_transformedOutMessage.toByteArray(), (OutputStream)_transformedOutMessageNew);
            BufferedInputStream bufferedStream = new BufferedInputStream(new ByteArrayInputStream(_transformedOutMessageNew.toByteArray()));
            Pipe pipe = (Pipe)axis2MC.getProperty("pass-through.pipe");
            if (pipe != null) {
                OutputStream msgContextOutStream = pipe.resetOutputStream();
                axis2MC.setProperty("bufferedInputStream", (Object)bufferedStream);
                boolean fullLenthDone = false;
                if (_transformedOutMessage.toByteArray().length > this.bufferSizeSupport) {
                    RelayUtils.buildMessage((MessageContext)axis2MC, (boolean)false, (InputStream)bufferedStream);
                    fullLenthDone = true;
                }
                if (!fullLenthDone && Boolean.TRUE.equals(axis2MC.getProperty("message.builder.invoked"))) {
                    RelayUtils.buildMessage((MessageContext)axis2MC, (boolean)false, (InputStream)bufferedStream);
                } else if (!fullLenthDone) {
                    IOUtils.write((byte[])_transformedOutMessage.toByteArray(), (OutputStream)msgContextOutStream);
                }
            } else {
                OMElement omElement = context.getEnvelope().getBody().getFirstElement();
                if (omElement != null) {
                    omElement.detach();
                }
                String omString = _transformedOutMessage.toString();
                OMElement responseOM = AXIOMUtil.stringToOM((String)omString);
                context.getEnvelope().getBody().addChild((OMNode)responseOM);
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)"XMLConverter mediator : Done");
            }
            return true;
        }
        catch (Exception e) {
            this.handleException("Error while transforming the Stream ", e, context);
            this.handleException("Unexpected SOAP message content found. " + ((Object)((Object)this)).getClass().getName() + " mediator can only be used with messages built with BinaryRelayBuilder", context);
            return false;
        }
    }

    private void transform(InputStream xmlIn, OutputStream out, Templates templates) throws Exception {
        Transformer trans = templates.newTransformer();
        StreamSource source = new StreamSource(xmlIn);
        StreamResult resultXML = new StreamResult(out);
        trans.transform(source, resultXML);
    }

    private Templates createTemplate(org.apache.synapse.MessageContext synCtx, String xsltKey) {
        Templates cachedTemplates = null;
        try {
            cachedTemplates = this.transFact.newTemplates(SynapseConfigUtils.getStreamSource((Object)synCtx.getEntry(xsltKey)));
            if (cachedTemplates == null) {
                this.handleException("Error compiling the XSLT with key : " + xsltKey, synCtx);
            } else {
                this.cachedTemplatesMap.put(xsltKey, cachedTemplates);
            }
        }
        catch (Exception e) {
            this.handleException("Error creating XSLT transformer using : " + xsltKey, e, synCtx);
        }
        return cachedTemplates;
    }

    private InputStream getMessageInputStreamBinaryRelay(org.apache.synapse.MessageContext context) throws IOException {
        OMText binaryDataNode;
        DataHandler dh;
        DataSource dataSource;
        OMNode node;
        SOAPEnvelope envelope = context.getEnvelope();
        OMElement contentEle = envelope.getBody().getFirstElement();
        if (contentEle != null && (node = contentEle.getFirstOMChild()) != null && node instanceof OMText && (dataSource = (dh = (DataHandler)(binaryDataNode = (OMText)node).getDataHandler()).getDataSource()) instanceof StreamingOnRequestDataSource) {
            ((StreamingOnRequestDataSource)dataSource).setLastUse(false);
            InputStream temp = dataSource.getInputStream();
            return temp;
        }
        return null;
    }

    private InputStream getMessageInputStreamFromSoapEnvelop(org.apache.synapse.MessageContext messageContext) {
        InputStream temp = null;
        SOAPEnvelope envelope = messageContext.getEnvelope();
        OMElement contentEle = envelope.getBody().getFirstElement();
        if (contentEle != null) {
            String omElement = contentEle.toString();
            temp = IOUtils.toInputStream((String)omElement);
        }
        return temp;
    }

    private InputStream getMessageInputStreamPT(MessageContext context, Pipe pipe) throws IOException {
        if (pipe != null && Boolean.TRUE.equals(context.getProperty("message.builder.invoked")) && context.getProperty("bufferedInputStream") != null) {
            BufferedInputStream bufferedInputStream = (BufferedInputStream)context.getProperty("bufferedInputStream");
            bufferedInputStream.reset();
            bufferedInputStream.mark(0);
            return bufferedInputStream;
        }
        if (pipe != null) {
            return pipe.getInputStream();
        }
        return null;
    }

    private MessageDataSource getResultBlob(org.apache.synapse.MessageContext synCtx) throws IOException {
        SynapseEnvironment synEnv = synCtx.getEnvironment();
        return new MessageDataSource(synEnv.createOverflowBlob());
    }

    private boolean writeResult(org.apache.synapse.MessageContext synCtx, MessageDataSource resulMessage) throws IOException, XMLStreamException {
        if (resulMessage != null) {
            SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
            QName BINARY_CONTENT_QNAME = new QName("http://ws.apache.org/commons/ns/payload", "binary");
            OMNamespace ns = factory.createOMNamespace(BINARY_CONTENT_QNAME.getNamespaceURI(), "ns");
            OMElement omEle = factory.createOMElement(BINARY_CONTENT_QNAME.getLocalPart(), ns);
            DataHandler dataHandler = new DataHandler((DataSource)resulMessage);
            OMText textData = factory.createOMText((Object)dataHandler, true);
            omEle.addChild((OMNode)textData);
            SOAPBody body = synCtx.getEnvelope().getBody();
            if (body.getFirstElement() != null) {
                body.getFirstElement().detach();
            }
            body.addChild((OMNode)omEle);
            return true;
        }
        return false;
    }

    private boolean isCreationOrRecreationRequired(org.apache.synapse.MessageContext synCtx) {
        String generatedXsltKey = this.xsltKey.evaluateValue(synCtx);
        if (this.cachedTemplatesMap.isEmpty() || !this.cachedTemplatesMap.containsKey(generatedXsltKey)) {
            return true;
        }
        Entry dp = synCtx.getConfiguration().getEntryDefinition(generatedXsltKey);
        return dp != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired());
    }

    public Value getXsltKey() {
        return this.xsltKey;
    }

    public void setXsltKey(Value xsltKey) {
        this.xsltKey = xsltKey;
    }

    public void setSourceXPathString(String sourceXPathString) {
        this.source.setXPathString(sourceXPathString);
    }

    public SynapseXPath getSource() {
        return this.source.getXPath();
    }

    public void setSource(SynapseXPath source) {
        this.source.setXPath(source);
    }

    public String getTargetPropertyName() {
        return this.targetPropertyName;
    }

    public void setTargetPropertyName(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
    }

    public void addProperty(MediatorProperty p) {
        this.properties.add(p);
    }

    private void applyProperties(Transformer transformer, org.apache.synapse.MessageContext synCtx, SynapseLog synLog) {
        for (MediatorProperty prop : this.properties) {
            if (prop == null) continue;
            String value = prop.getValue() != null ? prop.getValue() : prop.getExpression().stringValueOf(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                if (value == null) {
                    synLog.traceOrDebug((Object)("Not setting parameter '" + prop.getName() + "'"));
                } else {
                    synLog.traceOrDebug((Object)("Setting parameter '" + prop.getName() + "' to '" + value + "'"));
                }
            }
            if (value == null) continue;
            transformer.setParameter(prop.getName(), value);
        }
    }

    public void addFeature(String featureName, boolean isFeatureEnable) {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(featureName);
        if (isFeatureEnable) {
            mp.setValue("true");
        } else {
            mp.setValue("false");
        }
        this.transformerFactoryFeatures.add(mp);
        if (USE_DOM_SOURCE_AND_RESULTS.equals(featureName)) {
            if (isFeatureEnable) {
                this.sourceBuilderFactory = new DOOMSourceBuilderFactory();
                this.resultBuilderFactory = new DOOMResultBuilderFactory();
            }
        } else {
            try {
                this.transFact.setFeature(featureName, isFeatureEnable);
            }
            catch (TransformerConfigurationException e) {
                String msg = "Error occurred when setting features to the TransformerFactory";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, (Throwable)e);
            }
        }
    }

    public void addAttribute(String name, String value) {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(name);
        mp.setValue(value);
        this.transformerFactoryAttributes.add(mp);
        if (SOURCE_BUILDER_FACTORY.equals(name) || RESULT_BUILDER_FACTORY.equals(name)) {
            Object instance;
            try {
                instance = Class.forName(value).newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "The class specified by the " + name + " attribute was not found";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, (Throwable)e);
            }
            catch (Exception e) {
                String msg = "The class " + value + " could not be instantiated";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, (Throwable)e);
            }
            if (SOURCE_BUILDER_FACTORY.equals(name)) {
                this.sourceBuilderFactory = (SourceBuilderFactory)instance;
            } else {
                this.resultBuilderFactory = (ResultBuilderFactory)instance;
            }
        } else {
            try {
                this.transFact.setAttribute(name, value);
            }
            catch (IllegalArgumentException e) {
                String msg = "Error occurred when setting attribute to the TransformerFactory";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, (Throwable)e);
            }
        }
    }

    public List<MediatorProperty> getFeatures() {
        return this.transformerFactoryFeatures;
    }

    public List<MediatorProperty> getAttributes() {
        return this.transformerFactoryAttributes;
    }

    public void addAllProperties(List<MediatorProperty> list) {
        this.properties.addAll(list);
    }

    public List<MediatorProperty> getProperties() {
        return this.properties;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    public boolean isContentAware() {
        return false;
    }

    public void destroy() {
    }

    public void init(SynapseEnvironment arg0) {
        PassThroughConfiguration conf = PassThroughConfiguration.getInstance();
        this.bufferSizeSupport = conf.getIOBufferSize();
    }
}

