/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.base;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class IdentityValidatorConfig {
    private Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public void addPattern(String key, String regex) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Pattern identification key cannot be empty.");
        }
        if (StringUtils.isBlank((String)regex)) {
            throw new IllegalArgumentException("Pattern cannot be empty.");
        }
        try {
            if (this.patterns.containsKey(key)) {
                throw new IllegalArgumentException("A pattern already exists for key " + key);
            }
            this.patterns.put(key, Pattern.compile(regex));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Failed to parse given pattern " + regex, e);
        }
    }

    public Pattern getPattern(String key) {
        return this.patterns.get(key);
    }

    public void removePattern(String key) {
        this.patterns.remove(key);
    }

    public boolean patternExists(String key) {
        return this.patterns.containsKey(key);
    }
}

