/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.base;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.base.IdentityValidationException;
import org.wso2.carbon.identity.base.IdentityValidatorConfig;

public class IdentityValidationUtil {
    private static final IdentityValidatorConfig validatorConfig = new IdentityValidatorConfig();
    private static final String msgSection1 = "The provided input ";
    private static final String msgSection2 = "does not match any of the white list patterns [ %s ]";
    private static final String msgSection3 = "contains illegal characters matching one of the black list patterns [ %s ]";
    private static final String msgSection4 = " or ";
    private static final String PATTERN_NOT_REGISTERED = "No regex pattern registered for the provided key : %s";

    private IdentityValidationUtil() {
    }

    public static boolean isValidOverWhiteListPatterns(String input, String ... whiteListPatterns) {
        String key;
        if (ArrayUtils.isEmpty((Object[])whiteListPatterns)) {
            throw new IllegalArgumentException("Should provide at least one white list pattern");
        }
        if (StringUtils.isEmpty((String)input)) {
            return true;
        }
        IdentityValidationUtil.validatePatternKeys(whiteListPatterns);
        boolean isValid = false;
        String[] stringArray = whiteListPatterns;
        int n = stringArray.length;
        for (int i = 0; i < n && !(isValid = validatorConfig.getPattern(key = stringArray[i]).matcher(input).matches()); ++i) {
        }
        return isValid;
    }

    public static boolean isValidOverBlackListPatterns(String input, String ... blackListPatterns) {
        if (ArrayUtils.isEmpty((Object[])blackListPatterns)) {
            throw new IllegalArgumentException("Should provide at least one black list pattern");
        }
        if (StringUtils.isEmpty((String)input)) {
            return true;
        }
        IdentityValidationUtil.validatePatternKeys(blackListPatterns);
        boolean isValid = false;
        for (String key : blackListPatterns) {
            boolean bl = isValid = !validatorConfig.getPattern(key).matcher(input).matches();
            if (!isValid) break;
        }
        return isValid;
    }

    public static boolean isValid(String input, String[] whiteListPatterns, String[] blackListPatterns) {
        if (ArrayUtils.isEmpty((Object[])whiteListPatterns) || ArrayUtils.isEmpty((Object[])blackListPatterns)) {
            throw new IllegalArgumentException("Should provide at least one white list pattern and black list pattern");
        }
        return IdentityValidationUtil.isValidOverWhiteListPatterns(input, whiteListPatterns) || IdentityValidationUtil.isValidOverBlackListPatterns(input, blackListPatterns);
    }

    public static String getValidInputOverWhiteListPatterns(String input, String ... whiteListPatterns) throws IdentityValidationException {
        if (StringUtils.isEmpty((String)input) || IdentityValidationUtil.isValidOverWhiteListPatterns(input, whiteListPatterns)) {
            return input;
        }
        throw new IdentityValidationException(msgSection1 + String.format(msgSection2, IdentityValidationUtil.getPatternString(whiteListPatterns)));
    }

    public static String getValidInputOverBlackListPatterns(String input, String ... blackListPatterns) throws IdentityValidationException {
        if (StringUtils.isEmpty((String)input) || IdentityValidationUtil.isValidOverBlackListPatterns(input, blackListPatterns)) {
            return input;
        }
        throw new IdentityValidationException(msgSection1 + String.format(msgSection3, IdentityValidationUtil.getPatternString(blackListPatterns)));
    }

    public static String getValidInput(String input, String[] whiteListPatterns, String[] blackListPatterns) throws IdentityValidationException {
        if (StringUtils.isEmpty((String)input) || IdentityValidationUtil.isValid(input, whiteListPatterns, blackListPatterns)) {
            return input;
        }
        StringBuilder message = new StringBuilder();
        message.append(msgSection1);
        message.append(String.format(msgSection2, IdentityValidationUtil.getPatternString(whiteListPatterns)));
        message.append(msgSection4);
        message.append(String.format(msgSection3, IdentityValidationUtil.getPatternString(blackListPatterns)));
        throw new IdentityValidationException(message.toString());
    }

    public static void addPattern(String key, String regex) {
        validatorConfig.addPattern(key, regex);
    }

    public static void removePattern(String key) {
        validatorConfig.removePattern(key);
    }

    public static boolean patternExists(String key) {
        return validatorConfig.patternExists(key);
    }

    private static String getPatternString(String[] patterns) {
        StringBuilder patternString = new StringBuilder();
        for (int i = 0; i < patterns.length; ++i) {
            patternString.append(validatorConfig.getPattern(patterns[i]).pattern());
            if (patterns.length - 1 == i) continue;
            patternString.append(", ");
        }
        return patternString.toString();
    }

    private static void validatePatternKeys(String[] patterns) {
        for (String key : patterns) {
            if (IdentityValidationUtil.patternExists(key)) continue;
            throw new IllegalArgumentException(String.format(PATTERN_NOT_REGISTERED, key));
        }
    }

    static {
        for (ValidatorPattern pattern : ValidatorPattern.values()) {
            validatorConfig.addPattern(pattern.name(), pattern.getRegex());
        }
    }

    public static enum ValidatorPattern {
        DIGITS_ONLY("^[0-9]+$"),
        ALPHABETIC_ONLY("^[a-zA-Z]+$"),
        ALPHANUMERICS_ONLY("^[a-zA-Z0-9]+$"),
        URL("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),
        URL_WITHOUT_FRAGMENT("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?$"),
        EMAIL("^\\s*?(.+)@(.+?)\\s*$"),
        WHITESPACE_EXISTS(".*\\s+.*"),
        URI_RESERVED_EXISTS(".*[:/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=]+.*"),
        URI_UNSAFE_EXISTS(".*[<>%\\{\\}\\|\\^~\\[\\]`]+.*"),
        HTML_META_EXISTS(".*[&<>\"'/]+.*"),
        XML_META_EXISTS(".*[&<>\"']+.*"),
        REGEX_META_EXISTS(".*[\\\\\\^\\$\\.\\|\\?\\*\\+\\(\\)\\[\\{]+.*"),
        HTTP_URL("^(http:)([^/?#])?(:)?(([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),
        HTTPS_URL("^(https:)([^/?#])?(:)?(([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),
        FTP_URL("^(ftp:)([^/?#])?(:)?(([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),
        REGISTRY_INVALID_CHARS_EXISTS("[~!@#;%^*()+={}|<>\\\\\"'/,]+");

        private String regex;

        private ValidatorPattern(String regex) {
            this.regex = regex;
        }

        public String getRegex() {
            return this.regex;
        }
    }
}

