/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.base;

public class IdentityRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -5872545821846152596L;
    private String errorCode = null;

    public IdentityRuntimeException(String message) {
        super(message);
    }

    public IdentityRuntimeException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public IdentityRuntimeException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public IdentityRuntimeException(String errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public IdentityRuntimeException(String errorCode, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
    }

    public static IdentityRuntimeException error(String message) {
        return new IdentityRuntimeException(message);
    }

    public static IdentityRuntimeException error(String errorCode, String message) {
        return new IdentityRuntimeException(errorCode, message);
    }

    public static IdentityRuntimeException error(String message, Throwable cause) {
        return new IdentityRuntimeException(message, cause);
    }

    public static IdentityRuntimeException error(String errorCode, String message, Throwable cause) {
        return new IdentityRuntimeException(errorCode, message, cause);
    }

    public static <T extends IdentityRuntimeException> T error(Class<T> exceptionClass, String message) {
        IdentityRuntimeException exception = null;
        try {
            exception = (IdentityRuntimeException)exceptionClass.getConstructor(String.class).newInstance(message);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage(), e);
        }
        return (T)exception;
    }

    public static <T extends IdentityRuntimeException> T error(Class<T> exceptionClass, String errorCode, String message) {
        IdentityRuntimeException exception = null;
        try {
            exception = (IdentityRuntimeException)exceptionClass.getConstructor(String.class, String.class).newInstance(errorCode, message);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage(), e);
        }
        return (T)exception;
    }

    public static <T extends IdentityRuntimeException> T error(Class<T> exceptionClass, String message, Throwable cause) {
        IdentityRuntimeException exception = null;
        try {
            exception = (IdentityRuntimeException)exceptionClass.getConstructor(String.class, Throwable.class).newInstance(message, cause);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage(), e);
        }
        return (T)exception;
    }

    public static <T extends IdentityRuntimeException> T error(Class<T> exceptionClass, String errorCode, String message, Throwable cause) {
        IdentityRuntimeException exception = null;
        try {
            exception = (IdentityRuntimeException)exceptionClass.getConstructor(String.class, String.class, Throwable.class).newInstance(errorCode, message, cause);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage(), e);
        }
        return (T)exception;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

