/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.base;

import org.wso2.carbon.identity.base.IdentityRuntimeException;

public class IdentityException
extends Exception {
    private static final long serialVersionUID = 725992116511551241L;
    private String errorCode = null;

    public IdentityException(String message) {
        super(message);
    }

    public IdentityException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public IdentityException(String message, Throwable cause) {
        super(message, cause);
    }

    public IdentityException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    @Deprecated
    public static IdentityException error(String message) {
        return new IdentityException(message);
    }

    @Deprecated
    public static IdentityException error(String errorCode, String message) {
        return new IdentityException(errorCode, message);
    }

    @Deprecated
    public static IdentityException error(String message, Throwable cause) {
        return new IdentityException(message, cause);
    }

    @Deprecated
    public static IdentityException error(String errorCode, String message, Throwable cause) {
        return new IdentityException(errorCode, message, cause);
    }

    public static <T extends IdentityException> T error(Class<T> exceptionClass, String message) {
        IdentityException exception = null;
        try {
            exception = (IdentityException)exceptionClass.getConstructor(String.class).newInstance(message);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage());
        }
        return (T)exception;
    }

    public static <T extends IdentityException> T error(Class<T> exceptionClass, String errorCode, String message) {
        IdentityException exception = null;
        try {
            exception = (IdentityException)exceptionClass.getConstructor(String.class, String.class).newInstance(errorCode, message);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage(), e);
        }
        return (T)exception;
    }

    public static <T extends IdentityException> T error(Class<T> exceptionClass, String message, Throwable cause) {
        IdentityException exception = null;
        try {
            exception = (IdentityException)exceptionClass.getConstructor(String.class, Throwable.class).newInstance(message, cause);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage(), e);
        }
        return (T)exception;
    }

    public static <T extends IdentityException> T error(Class<T> exceptionClass, String errorCode, String message, Throwable cause) {
        IdentityException exception = null;
        try {
            exception = (IdentityException)exceptionClass.getConstructor(String.class, String.class, Throwable.class).newInstance(errorCode, message, cause);
        }
        catch (Exception e) {
            throw new IdentityRuntimeException("Invalid Exception Type, " + e.getMessage(), e);
        }
        return (T)exception;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

