/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.directory.server.manager.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.directory.server.manager.DirectoryServerApplicationMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;

@Component(name="identity.ldap.directory.component", immediate=true)
public class LDAPServiceComponent {
    private static Log log = LogFactory.getLog(LDAPServiceComponent.class);
    private static ServiceRegistration<?> serviceRegistration;

    @Activate
    protected void activate(ComponentContext ctxt) {
        serviceRegistration = ctxt.getBundleContext().registerService(ApplicationMgtListener.class.getName(), (Object)new DirectoryServerApplicationMgtListener(), null);
        if (serviceRegistration != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" LDAP directory  - ApplicationMgtListener registered.");
            }
        } else {
            log.error((Object)" LDAP directory  - ApplicationMgtListener could not be registered.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity LDAP directory mgt bundle is activated");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        ctxt.getBundleContext().ungetService(serviceRegistration.getReference());
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity  LDAP directory mgt bundle is deactivated");
        }
    }
}

