/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.directory.server.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.directory.server.manager.DirectoryServerManagerException;
import org.wso2.carbon.directory.server.manager.common.ServerPrinciple;
import org.wso2.carbon.directory.server.manager.internal.LDAPServerStoreManager;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class DirectoryServerManager
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DirectoryServerManager.class);

    private LDAPServerStoreManager getServerStoreManager() throws DirectoryServerManagerException {
        RealmConfiguration configuration;
        UserRealm realm = this.getUserRealm();
        try {
            configuration = realm.getRealmConfiguration();
        }
        catch (UserStoreException e) {
            throw new DirectoryServerManagerException("Unable to retrieve realm configuration.", e);
        }
        return new LDAPServerStoreManager(configuration);
    }

    public void addServer(String serverName, String serverDescription, String serverPassword) throws DirectoryServerManagerException {
        LDAPServerStoreManager ldapServerStoreManager = this.getServerStoreManager();
        ldapServerStoreManager.addServicePrinciple(serverName, serverDescription, serverPassword);
    }

    public void removeServer(String serverName) throws DirectoryServerManagerException {
        LDAPServerStoreManager ldapServerStoreManager = this.getServerStoreManager();
        ldapServerStoreManager.deleteServicePrinciple(serverName);
    }

    public void changePassword(String serverPrinciple, String existingPassword, String newPassword) throws DirectoryServerManagerException {
        LDAPServerStoreManager ldapServerStoreManager = this.getServerStoreManager();
        ldapServerStoreManager.updateServicePrinciplePassword(serverPrinciple, existingPassword, newPassword);
    }

    public ServerPrinciple[] listServicePrinciples(String filter) throws DirectoryServerManagerException {
        LDAPServerStoreManager ldapServerStoreManager = this.getServerStoreManager();
        return ldapServerStoreManager.listServicePrinciples(filter);
    }

    public ServerPrinciple getServicePrinciple(String serverName) throws DirectoryServerManagerException {
        LDAPServerStoreManager ldapServerStoreManager = this.getServerStoreManager();
        return ldapServerStoreManager.getServicePrinciple(serverName);
    }

    public boolean isExistingServicePrinciple(String servicePrinciple) throws DirectoryServerManagerException {
        LDAPServerStoreManager ldapServerStoreManager = this.getServerStoreManager();
        return ldapServerStoreManager.isExistingServicePrinciple(servicePrinciple);
    }

    public String getPasswordConformanceRegularExpression() throws DirectoryServerManagerException {
        try {
            RealmConfiguration userStoreConfigurations = this.getUserRealm().getRealmConfiguration();
            if (userStoreConfigurations != null) {
                String passwordRegEx = userStoreConfigurations.getUserStoreProperty("ServicePasswordJavaRegEx");
                if (passwordRegEx == null) {
                    return "[\\S]{5,30}";
                }
                log.info((Object)("Service password format is " + passwordRegEx));
                return passwordRegEx;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Unable to retrieve service password format.", (Throwable)e);
            throw new DirectoryServerManagerException("Unable to retrieve service password format.", e);
        }
        return "[\\S]{5,30}";
    }

    public String getServiceNameConformanceRegularExpression() throws DirectoryServerManagerException {
        try {
            RealmConfiguration userStoreConfigurations = this.getUserRealm().getRealmConfiguration();
            if (userStoreConfigurations != null) {
                String serviceNameRegEx = userStoreConfigurations.getUserStoreProperty("ServiceNameJavaRegEx");
                if (serviceNameRegEx == null) {
                    return "[a-zA-Z\\d]{2,10}/[a-zA-Z]{2,30}";
                }
                log.info((Object)("Service name format is " + serviceNameRegEx));
                return serviceNameRegEx;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Unable to retrieve service name format.", (Throwable)e);
            throw new DirectoryServerManagerException("Unable to retrieve service name format.", e);
        }
        return "[a-zA-Z\\d]{2,10}/[a-zA-Z]{2,30}";
    }

    public boolean isKDCEnabled() throws DirectoryServerManagerException {
        try {
            RealmConfiguration userStoreConfigurations = this.getUserRealm().getRealmConfiguration();
            if (userStoreConfigurations != null) {
                String isKDCEnabled = userStoreConfigurations.getUserStoreProperty("kdcEnabled");
                return isKDCEnabled != null && Boolean.parseBoolean(isKDCEnabled);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Could not retrieve KDC Enabled parameter.", (Throwable)e);
            throw new DirectoryServerManagerException("Could not retrieve KDC Enabled parameter.", e);
        }
        return false;
    }
}

