/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.directory.server.manager;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.directory.server.manager.DirectoryServerManager;
import org.wso2.carbon.directory.server.manager.DirectoryServerManagerException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtSystemConfig;
import org.wso2.carbon.identity.application.mgt.dao.ApplicationDAO;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;

public class DirectoryServerApplicationMgtListener
extends AbstractApplicationMgtListener {
    private static Log log = LogFactory.getLog(DirectoryServerApplicationMgtListener.class);
    private static final String KERBEROS = "kerberos";

    public int getDefaultOrderId() {
        return 999;
    }

    public boolean doPreDeleteApplication(String applicationName, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        ApplicationDAO appDAO = ApplicationMgtSystemConfig.getInstance().getApplicationDAO();
        ServiceProvider serviceProvider = appDAO.getApplication(applicationName, tenantDomain);
        if (serviceProvider != null && serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null) {
            InboundAuthenticationRequestConfig[] configs;
            for (InboundAuthenticationRequestConfig config : configs = serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                if (!KERBEROS.equalsIgnoreCase(config.getInboundAuthType()) || config.getInboundAuthKey() == null) continue;
                DirectoryServerManager directoryServerManager = new DirectoryServerManager();
                try {
                    directoryServerManager.removeServer(config.getInboundAuthKey());
                    break;
                }
                catch (DirectoryServerManagerException e) {
                    String error = "Error while removing a kerberos: " + config.getInboundAuthKey();
                    throw new IdentityApplicationManagementException(error, (Throwable)((Object)e));
                }
            }
        }
        return true;
    }

    public void doExportServiceProvider(ServiceProvider serviceProvider, Boolean exportSecrets) throws IdentityApplicationManagementException {
        InboundAuthenticationConfig inboundAuthenticationConfig = serviceProvider.getInboundAuthenticationConfig();
        if (inboundAuthenticationConfig != null && inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs() != null) {
            for (InboundAuthenticationRequestConfig authConfig : inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs()) {
                if (!KERBEROS.equals(authConfig.getInboundAuthType())) continue;
                inboundAuthenticationConfig.setInboundAuthenticationRequestConfigs((InboundAuthenticationRequestConfig[])ArrayUtils.removeElement((Object[])inboundAuthenticationConfig.getInboundAuthenticationRequestConfigs(), (Object)authConfig));
                return;
            }
        }
    }
}

