/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.examples;

import io.swagger.codegen.examples.XmlExampleGenerator;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.Json;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ExampleGenerator.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String MIME_TYPE_XML = "application/xml";
    private static final String EXAMPLE = "example";
    private static final String CONTENT_TYPE = "contentType";
    private static final String OUTPUT = "output";
    private static final String NONE = "none";
    protected Map<String, Model> examples;
    private Random random;

    public ExampleGenerator(Map<String, Model> examples) {
        this.examples = examples;
        this.random = new Random("ExampleGenerator".hashCode());
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, Property property) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (property != null && string.startsWith(MIME_TYPE_JSON)) {
                    example = Json.pretty(this.resolvePropertyToExample("", string, property, processedModels));
                    if (example == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (property == null || !string.startsWith(MIME_TYPE_XML) || (example = new XmlExampleGenerator(this.examples).toXml(property)) == null) continue;
                kv.put(EXAMPLE, example);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap kv = new HashMap();
                kv.put(CONTENT_TYPE, entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, String modelName) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                Model model;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (modelName != null && string.startsWith(MIME_TYPE_JSON)) {
                    model = this.examples.get(modelName);
                    if (model == null || (example = Json.pretty(this.resolveModelToExample(modelName, string, model, processedModels))) == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (modelName == null || !string.startsWith(MIME_TYPE_XML) || (example = new XmlExampleGenerator(this.examples).toXml(model = this.examples.get(modelName), 0, Collections.emptySet())) == null) continue;
                kv.put(EXAMPLE, example);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap kv = new HashMap();
                kv.put(CONTENT_TYPE, entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    private Object resolvePropertyToExample(String propertyName, String mediaType, Property property, Set<String> processedModels) {
        logger.debug("Resolving example for property {}...", (Object)property);
        if (property.getExample() != null) {
            logger.debug("Example set in swagger spec, returning example: '{}'", (Object)property.getExample().toString());
            return property.getExample();
        }
        if (property instanceof StringProperty) {
            logger.debug("String property");
            String defaultValue = ((StringProperty)property).getDefault();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                logger.debug("Default value found: '{}'", (Object)defaultValue);
                return defaultValue;
            }
            List enumValues = ((StringProperty)property).getEnum();
            if (enumValues != null && !enumValues.isEmpty()) {
                logger.debug("Enum value found: '{}'", enumValues.get(0));
                return enumValues.get(0);
            }
            String format = property.getFormat();
            if (format != null && (StringProperty.Format.URI.getName().equals(format) || StringProperty.Format.URL.getName().equals(format))) {
                logger.debug("URI or URL format, without default or enum, generating random one.");
                return "http://example.com/aeiou";
            }
            logger.debug("No values found, using property name " + propertyName + " as example");
            return propertyName;
        }
        if (property instanceof BooleanProperty) {
            Boolean defaultValue = ((BooleanProperty)property).getDefault();
            if (defaultValue != null) {
                return defaultValue;
            }
            return Boolean.TRUE;
        }
        if (property instanceof ArrayProperty) {
            Property innerType = ((ArrayProperty)property).getItems();
            if (innerType != null) {
                int arrayLength = null == ((ArrayProperty)property).getMaxItems() ? 2 : ((ArrayProperty)property).getMaxItems();
                Object[] objectProperties = new Object[arrayLength];
                Object objProperty = this.resolvePropertyToExample(propertyName, mediaType, innerType, processedModels);
                for (int i = 0; i < arrayLength; ++i) {
                    objectProperties[i] = objProperty;
                }
                return objectProperties;
            }
        } else {
            if (property instanceof DateProperty) {
                return "2000-01-23";
            }
            if (property instanceof DateTimeProperty) {
                return "2000-01-23T04:56:07.000+00:00";
            }
            if (property instanceof DoubleProperty) {
                Double min = ((DecimalProperty)property).getMinimum() == null ? null : Double.valueOf(((DecimalProperty)property).getMinimum().doubleValue());
                Double max = ((DecimalProperty)property).getMaximum() == null ? null : Double.valueOf(((DecimalProperty)property).getMaximum().doubleValue());
                return this.randomNumber(min, max);
            }
            if (property instanceof FloatProperty) {
                Double min = ((DecimalProperty)property).getMinimum() == null ? null : Double.valueOf(((DecimalProperty)property).getMinimum().doubleValue());
                Double max = ((DecimalProperty)property).getMaximum() == null ? null : Double.valueOf(((DecimalProperty)property).getMaximum().doubleValue());
                return Float.valueOf((float)this.randomNumber(min, max));
            }
            if (property instanceof DecimalProperty) {
                Double min = ((DecimalProperty)property).getMinimum() == null ? null : Double.valueOf(((DecimalProperty)property).getMinimum().doubleValue());
                Double max = ((DecimalProperty)property).getMaximum() == null ? null : Double.valueOf(((DecimalProperty)property).getMaximum().doubleValue());
                return new BigDecimal(this.randomNumber(min, max));
            }
            if (property instanceof FileProperty) {
                return "";
            }
            if (property instanceof LongProperty) {
                Double min = ((BaseIntegerProperty)property).getMinimum() == null ? null : Double.valueOf(((BaseIntegerProperty)property).getMinimum().doubleValue());
                Double max = ((BaseIntegerProperty)property).getMaximum() == null ? null : Double.valueOf(((BaseIntegerProperty)property).getMaximum().doubleValue());
                return (long)this.randomNumber(min, max);
            }
            if (property instanceof BaseIntegerProperty) {
                Double min = ((BaseIntegerProperty)property).getMinimum() == null ? null : Double.valueOf(((BaseIntegerProperty)property).getMinimum().doubleValue());
                Double max = ((BaseIntegerProperty)property).getMaximum() == null ? null : Double.valueOf(((BaseIntegerProperty)property).getMaximum().doubleValue());
                return (int)this.randomNumber(min, max);
            }
            if (property instanceof MapProperty) {
                HashMap<String, Object> mp = new HashMap<String, Object>();
                if (property.getName() != null) {
                    mp.put(property.getName(), this.resolvePropertyToExample(propertyName, mediaType, ((MapProperty)property).getAdditionalProperties(), processedModels));
                } else {
                    mp.put("key", this.resolvePropertyToExample(propertyName, mediaType, ((MapProperty)property).getAdditionalProperties(), processedModels));
                }
                return mp;
            }
            if (property instanceof ObjectProperty) {
                return "{}";
            }
            if (property instanceof RefProperty) {
                String simpleName = ((RefProperty)property).getSimpleRef();
                logger.debug("Ref property, simple name: {}", (Object)simpleName);
                Model model = this.examples.get(simpleName);
                if (model != null) {
                    return this.resolveModelToExample(simpleName, mediaType, model, processedModels);
                }
                logger.warn("Ref property with empty model.");
            } else if (property instanceof UUIDProperty) {
                return "046b6c7f-0b8a-43b9-b35d-6489e6daee91";
            }
        }
        return "";
    }

    private double randomNumber(Double min, Double max) {
        if (min != null && max != null) {
            double range = max - min;
            return this.random.nextDouble() * range + min;
        }
        if (min != null) {
            return this.random.nextDouble() + min;
        }
        if (max != null) {
            return this.random.nextDouble() * max;
        }
        return this.random.nextDouble() * 10.0;
    }

    private Object resolveModelToExample(String name, String mediaType, Model model, Set<String> processedModels) {
        if (processedModels.contains(name)) {
            return model.getExample();
        }
        if (model instanceof ModelImpl) {
            processedModels.add(name);
            ModelImpl impl = (ModelImpl)model;
            HashMap<String, Object> values = new HashMap<String, Object>();
            logger.debug("Resolving model '{}' to example", (Object)name);
            if (impl.getExample() != null) {
                logger.debug("Using example from spec: {}", impl.getExample());
                return impl.getExample();
            }
            if (impl.getProperties() != null) {
                logger.debug("Creating example from model values");
                for (String propertyName : impl.getProperties().keySet()) {
                    Property property = (Property)impl.getProperties().get(propertyName);
                    values.put(propertyName, this.resolvePropertyToExample(propertyName, mediaType, property, processedModels));
                }
                impl.setExample(values);
            }
            return values;
        }
        return "";
    }
}

