/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.wso2.carbon.kernel.internal.startupresolver.StartOrderResolverException;
import org.wso2.carbon.kernel.internal.startupresolver.beans.StartupComponent;
import org.wso2.carbon.kernel.utils.manifest.ManifestElement;
import org.wso2.carbon.kernel.utils.manifest.ManifestElementParserException;

class StartupOrderResolverUtils {
    private StartupOrderResolverUtils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    static boolean isSupportedManifestHeaderExists(Bundle bundle, List<String> supportedManifestHeaders) {
        Dictionary headerDictionary = bundle.getHeaders();
        for (String manifestHeader : supportedManifestHeaders) {
            if (headerDictionary.get(manifestHeader) == null) continue;
            return true;
        }
        return false;
    }

    static StartupComponent getStartupComponentBean(ManifestElement manifestElement) {
        String componentName = StartupOrderResolverUtils.getManifestElementAttribute("componentName", manifestElement, true);
        String requiredServices = StartupOrderResolverUtils.getManifestElementAttribute("requiredService", manifestElement, true);
        String[] requiredServiceArray = requiredServices != null ? requiredServices.split(",") : new String[]{};
        List<String> requiredServicesList = Arrays.asList(requiredServiceArray).stream().map(String::trim).collect(Collectors.toList());
        StartupComponent startupComponent = new StartupComponent(componentName, manifestElement.getBundle());
        startupComponent.setRequiredServiceList(requiredServicesList);
        return startupComponent;
    }

    static List<ManifestElement> extractManifestElements(Bundle bundle, List<String> supportedManifestHeaders) {
        Dictionary headerDictionary = bundle.getHeaders();
        ArrayList<ManifestElement> manifestElementList = new ArrayList<ManifestElement>();
        supportedManifestHeaders.stream().forEach(manifestHeader -> {
            if (headerDictionary.get(manifestHeader) != null) {
                StartupOrderResolverUtils.processManifestHeader(manifestHeader, (String)headerDictionary.get(manifestHeader), bundle).stream().forEach(manifestElementList::add);
            }
        });
        return manifestElementList;
    }

    public static String getManifestElementAttribute(String attributeKey, ManifestElement manifestElement, boolean mandatory) {
        String value = manifestElement.getAttribute(attributeKey);
        if ((value == null || value.equals("")) && mandatory) {
            throw new StartOrderResolverException(attributeKey + " attribute value is missing in " + manifestElement.getManifestHeaderName() + " header of bundle(" + manifestElement.getBundle().getSymbolicName() + ":" + manifestElement.getBundle().getVersion() + ")");
        }
        return value != null ? value.trim() : null;
    }

    public static String getObjectClassName(ManifestElement manifestElement) {
        String className = manifestElement.getAttribute("objectClass");
        if (className == null || className.equals("")) {
            throw new StartOrderResolverException("objectClass cannot be empty. Bundle-SymbolicName: " + manifestElement.getBundle().getSymbolicName());
        }
        return className;
    }

    private static List<ManifestElement> processManifestHeader(String headerName, String headerValue, Bundle bundle) {
        try {
            return ManifestElement.parseHeader(headerName, headerValue, bundle);
        }
        catch (ManifestElementParserException e) {
            String message = "Error occurred while parsing the " + headerName + " header in bundle(" + bundle.getSymbolicName() + ":" + bundle.getVersion() + "). " + "Header value: " + headerValue;
            throw new StartOrderResolverException(message, e);
        }
    }
}

