/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.carbon.kernel.internal.CarbonStartupHandler;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.startupresolver.OSGiServiceCapabilityTracker;
import org.wso2.carbon.kernel.internal.startupresolver.StartOrderResolverException;
import org.wso2.carbon.kernel.internal.startupresolver.StartupComponentManager;
import org.wso2.carbon.kernel.internal.startupresolver.StartupOrderResolverUtils;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.CapabilityProviderCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.OSGiServiceCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.StartupComponent;
import org.wso2.carbon.kernel.startupresolver.CapabilityProvider;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.utils.manifest.ManifestElement;

@Component(name="org.wso2.carbon.kernel.internal.startupresolver.RequireCapabilityCoordinator", immediate=true)
public class StartupOrderResolver {
    private static final Logger logger = LoggerFactory.getLogger(StartupOrderResolver.class);
    private static final List<String> supportedManifestHeaders = new ArrayList<String>();
    private StartupComponentManager startupComponentManager = new StartupComponentManager();
    private OSGiServiceCapabilityTracker osgiServiceTracker = new OSGiServiceCapabilityTracker(this.startupComponentManager);
    private Timer capabilityListenerTimer = new Timer();
    private Timer pendingCapabilityTimer = new Timer();

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        try {
            logger.debug("Initialize - Startup Order Resolver.");
            this.processManifestHeaders(Arrays.asList(bundleContext.getBundles()), supportedManifestHeaders);
            if (this.startupComponentManager.getPendingComponents().size() == 0) {
                this.startupComponentManager = null;
                this.osgiServiceTracker = null;
                return;
            }
            this.startCapabilityTrackers();
            this.scheduleCapabilityListenerTimer();
            this.schedulePendingCapabilityTimerTask();
        }
        catch (Throwable e) {
            logger.error("Error occurred in Startup Order Resolver.", e);
        }
    }

    @Deactivate
    public void stop(BundleContext bundleContext) throws Exception {
        logger.debug("Deactivating startup resolver component available in bundle {}", (Object)bundleContext.getBundle().getSymbolicName());
    }

    private void processManifestHeaders(List<Bundle> bundleList, List<String> supportedManifestHeaders) {
        Map<String, List<ManifestElement>> groupedManifestElements = bundleList.stream().filter(bundle -> AccessController.doPrivileged(() -> StartupOrderResolverUtils.isSupportedManifestHeaderExists(bundle, supportedManifestHeaders))).flatMap(bundle -> StartupOrderResolverUtils.extractManifestElements(bundle, supportedManifestHeaders).stream()).collect(Collectors.groupingBy(ManifestElement::getValue));
        if (groupedManifestElements.get("startup.listener") != null) {
            this.processStartupComponents(groupedManifestElements.get("startup.listener"));
        }
        if (groupedManifestElements.get("osgi.service") != null) {
            this.processOSGiServiceCapabilities(groupedManifestElements.get("osgi.service"));
        }
    }

    private void startCapabilityTrackers() {
        this.osgiServiceTracker.startTracker();
    }

    private void scheduleCapabilityListenerTimer() {
        CarbonConfiguration carbonConfiguration = DataHolder.getInstance().getCarbonRuntime().getConfiguration();
        long capabilityListenerTimerDelay = carbonConfiguration.getStartupResolverConfig().getCapabilityListenerTimer().getDelay();
        long capabilityListenerTimerPeriod = carbonConfiguration.getStartupResolverConfig().getCapabilityListenerTimer().getPeriod();
        this.capabilityListenerTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (StartupOrderResolver.this.startupComponentManager.getPendingComponents().size() == 0) {
                    StartupOrderResolver.this.notifySatisfiableComponents();
                    logger.debug("All the StartupComponents are satisfied. Cancelling the capabilityListenerTimer");
                    CarbonStartupHandler.logServerStartupTime();
                    CarbonStartupHandler.registerCarbonServerInfoService();
                    StartupOrderResolver.this.capabilityListenerTimer.cancel();
                    StartupOrderResolver.this.osgiServiceTracker.closeTracker();
                    logger.debug("Complete - Startup Order Resolver.");
                    return;
                }
                StartupOrderResolver.this.notifySatisfiableComponents();
            }
        }, capabilityListenerTimerDelay, capabilityListenerTimerPeriod);
    }

    private void schedulePendingCapabilityTimerTask() {
        CarbonConfiguration carbonConfiguration = DataHolder.getInstance().getCarbonRuntime().getConfiguration();
        long pendingCapabilityTimerDelay = carbonConfiguration.getStartupResolverConfig().getPendingCapabilityTimer().getDelay();
        long pendingCapabilityTimerPeriod = carbonConfiguration.getStartupResolverConfig().getPendingCapabilityTimer().getPeriod();
        this.pendingCapabilityTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                List<StartupComponent> pendingComponents = StartupOrderResolver.this.startupComponentManager.getPendingComponents();
                if (pendingComponents.size() == 0) {
                    logger.debug("All the RequiredCapabilityListeners are notified, therefore cancelling the pendingCapabilityTimer");
                    StartupOrderResolver.this.pendingCapabilityTimer.cancel();
                    return;
                }
                pendingComponents.forEach(startupComponent -> {
                    List<Capability> pendingCapabilityList = StartupOrderResolver.this.startupComponentManager.getPendingProvideCapabilityList(startupComponent.getName());
                    pendingCapabilityList.forEach(provideCapability -> logger.warn("Startup component {} from bundle({}:{}) will be in the pending state until Capability {} from bundle({}:{}) is available", new Object[]{startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion(), provideCapability.getName(), provideCapability.getBundle().getSymbolicName(), provideCapability.getBundle().getVersion()}));
                });
                List<StartupComponent> pendingComponentList = StartupOrderResolver.this.startupComponentManager.getPendingRequiredCapabilityListeners();
                pendingComponentList.forEach(startupComponent -> logger.warn("Waiting for RequiredCapabilityListener OSGi Service from bundle({}:{}). component-key: {}", new Object[]{startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion(), startupComponent.getName()}));
                List<CapabilityProviderCapability> pendingCapabilityProviderList = StartupOrderResolver.this.startupComponentManager.getPendingCapabilityProviderList();
                pendingCapabilityProviderList.forEach(capabilityProvider -> logger.warn("Waiting for CapabilityProvider OSGi service from bundle({}:{}). Provided capability name: {} ", new Object[]{capabilityProvider.getBundle().getSymbolicName(), capabilityProvider.getBundle().getVersion(), capabilityProvider.getProvidedCapabilityName()}));
            }
        }, pendingCapabilityTimerDelay, pendingCapabilityTimerPeriod);
    }

    private void processStartupComponents(List<ManifestElement> manifestElementList) {
        List<StartupComponent> startupComponentList = manifestElementList.stream().map(StartupOrderResolverUtils::getStartupComponentBean).collect(Collectors.toList());
        this.startupComponentManager.addComponents(startupComponentList);
    }

    private void processOSGiServiceCapabilities(List<ManifestElement> manifestElementList) {
        this.processCapabilityProviders(manifestElementList);
        manifestElementList.stream().filter(manifestElement -> !CapabilityProvider.class.getName().equals(StartupOrderResolverUtils.getObjectClassName(manifestElement)) && !RequiredCapabilityListener.class.getName().equals(StartupOrderResolverUtils.getObjectClassName(manifestElement))).flatMap(manifestElement -> {
            String capabilityName = StartupOrderResolverUtils.getObjectClassName(manifestElement);
            String serviceCountStr = StartupOrderResolverUtils.getManifestElementAttribute("serviceCount", manifestElement, false);
            int serviceCount = 1;
            if (serviceCountStr != null) {
                try {
                    serviceCount = Integer.parseInt(serviceCountStr.trim());
                }
                catch (NumberFormatException e) {
                    throw new StartOrderResolverException("Invalid value for serviceCount manifest attribute in bundle(" + manifestElement.getBundle().getSymbolicName() + ":" + manifestElement.getBundle().getVersion() + ")", e);
                }
            }
            ArrayList osgiServiceCapabilityList = new ArrayList(serviceCount);
            IntStream.range(0, serviceCount).forEach(count -> {
                OSGiServiceCapability osgiServiceCapability = new OSGiServiceCapability(capabilityName, Capability.CapabilityType.OSGi_SERVICE, manifestElement.getBundle());
                String dependentComponentName = StartupOrderResolverUtils.getManifestElementAttribute("dependentComponentName", manifestElement, false);
                if (dependentComponentName != null && !dependentComponentName.equals("")) {
                    osgiServiceCapability.setDependentComponentName(dependentComponentName.trim());
                }
                osgiServiceCapabilityList.add(osgiServiceCapability);
            });
            return osgiServiceCapabilityList.stream();
        }).forEach(capability -> {
            if (capability.getDependentComponentName() != null) {
                this.startupComponentManager.addRequiredOSGiServiceCapabilityToComponent(capability.getDependentComponentName(), capability.getName());
            }
            this.startupComponentManager.addExpectedRequiredCapability((Capability)capability);
        });
    }

    private void processCapabilityProviders(List<ManifestElement> manifestElementList) {
        manifestElementList.stream().filter(manifestElement -> CapabilityProvider.class.getName().equals(StartupOrderResolverUtils.getObjectClassName(manifestElement))).map(manifestElement -> {
            String providedCapabilityName = StartupOrderResolverUtils.getManifestElementAttribute("capabilityName", manifestElement, false);
            if (logger.isDebugEnabled()) {
                logger.debug("Creating a CapabilityProviderCapability from manifest element in bundle({}:{}), with CapabilityName - {}. ", new Object[]{manifestElement.getBundle().getSymbolicName(), manifestElement.getBundle().getVersion(), providedCapabilityName});
            }
            return new CapabilityProviderCapability(StartupOrderResolverUtils.getObjectClassName(manifestElement), Capability.CapabilityType.OSGi_SERVICE, providedCapabilityName, manifestElement.getBundle());
        }).forEach(capability -> this.startupComponentManager.addExpectedCapabilityProvider((CapabilityProviderCapability)capability));
    }

    private void notifySatisfiableComponents() {
        this.startupComponentManager.getSatisfiableComponents().forEach(startupComponent -> {
            String componentName = startupComponent.getName();
            String string = componentName.intern();
            synchronized (string) {
                this.startupComponentManager.removeSatisfiedComponent((StartupComponent)startupComponent);
                RequiredCapabilityListener capabilityListener = startupComponent.getListener();
                if (logger.isDebugEnabled()) {
                    logger.debug("Notifying RequiredCapabilityListener of component {} from bundle({}:{}) since all the required capabilities are available", new Object[]{componentName, startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
                }
                capabilityListener.onAllRequiredCapabilitiesAvailable();
            }
        });
    }

    static {
        supportedManifestHeaders.add("Carbon-Component");
    }
}

