/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.CapabilityProviderCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.StartupComponent;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

class StartupComponentManager {
    private static final Logger logger = LoggerFactory.getLogger(StartupComponentManager.class);
    private Map<String, StartupComponent> startupComponentMap = new ConcurrentHashMap<String, StartupComponent>();
    private Map<String, List<Capability>> pendingCapabilityMap = new ConcurrentHashMap<String, List<Capability>>();
    private Map<String, List<StartupComponent>> capabilityToComponentMap = new HashMap<String, List<StartupComponent>>();
    private Map<String, List<CapabilityProviderCapability>> pendingCapabilityProviderMap = new HashMap<String, List<CapabilityProviderCapability>>();

    StartupComponentManager() {
    }

    void addComponents(List<StartupComponent> startupComponentList) {
        startupComponentList.stream().forEach(this::addComponentInternal);
    }

    void addRequiredOSGiServiceCapabilityToComponent(String componentName, String capabilityName) {
        StartupComponent startupComponent = this.startupComponentMap.get(componentName);
        if (startupComponent == null) {
            logger.warn("Adding a required OSGi service capability to component, but specified startup component is not available, component-name: {} and capability-name: {}.", (Object)componentName, (Object)capabilityName);
            return;
        }
        logger.debug("Updating the required OSGi Service list of startup component {}. capabilityName: {} ", (Object)componentName, (Object)capabilityName);
        startupComponent.getRequiredServiceList().add(capabilityName);
        this.updateCapabilityToComponentMap(startupComponent, capabilityName);
    }

    void addRequiredCapabilityListener(RequiredCapabilityListener listener, String componentName, Bundle bundle) {
        StartupComponent startupComponent = this.startupComponentMap.get(componentName);
        if (startupComponent == null) {
            logger.warn("Adding a RequiredCapabilityListener from bundle({}:{}), but specified startup component is not available, component-name: {}", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), componentName});
            return;
        }
        if (startupComponent.getListener() != null) {
            logger.warn("Duplicate RequiredCapabilityListener detected. Existing RequiredCapabilityListener for startup component {}. New RequiredCapabilityListener from bundle({}:{}).", new Object[]{componentName, bundle.getSymbolicName(), bundle.getVersion()});
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding available RequiredCapabilityListener with the componentName {} from bundle({}:{})", new Object[]{componentName, bundle.getSymbolicName(), bundle.getVersion()});
        }
        startupComponent.setListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExpectedCapabilityProvider(CapabilityProviderCapability capabilityProvider) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding expected CapabilityProvider with the CapabilityName {} from bundle({}:{})", new Object[]{capabilityProvider.getProvidedCapabilityName(), capabilityProvider.getBundle().getSymbolicName(), capabilityProvider.getBundle().getVersion()});
        }
        String providedCapabilityName = capabilityProvider.getProvidedCapabilityName();
        String string = providedCapabilityName.intern();
        synchronized (string) {
            if (this.pendingCapabilityProviderMap.containsKey(providedCapabilityName)) {
                this.pendingCapabilityProviderMap.get(providedCapabilityName).add(capabilityProvider);
            } else {
                ArrayList<CapabilityProviderCapability> providerCapabilityList = new ArrayList<CapabilityProviderCapability>();
                providerCapabilityList.add(capabilityProvider);
                this.pendingCapabilityProviderMap.put(providedCapabilityName, providerCapabilityList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAvailableCapabilityProvider(CapabilityProviderCapability capabilityProvider) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding available CapabilityProvider with the CapabilityName {} from bundle({}:{})", new Object[]{capabilityProvider.getProvidedCapabilityName(), capabilityProvider.getBundle().getSymbolicName(), capabilityProvider.getBundle().getVersion()});
        }
        String providedCapabilityName = capabilityProvider.getProvidedCapabilityName();
        String string = providedCapabilityName.intern();
        synchronized (string) {
            List<CapabilityProviderCapability> capabilityProviderList = this.pendingCapabilityProviderMap.get(providedCapabilityName);
            if (capabilityProviderList != null) {
                capabilityProviderList.remove(capabilityProvider);
                if (capabilityProviderList.size() == 0) {
                    this.pendingCapabilityProviderMap.remove(providedCapabilityName);
                }
            } else {
                logger.debug("Unknown CapabilityProvider from bundle({}:{})", (Object)capabilityProvider.getBundle().getSymbolicName(), (Object)capabilityProvider.getBundle().getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExpectedRequiredCapability(Capability capability) {
        String capabilityName = capability.getName();
        String string = capabilityName.intern();
        synchronized (string) {
            this.startupComponentMap.values().stream().filter(startupComponent -> startupComponent.getRequiredServiceList().contains(capabilityName)).forEach(startupComponent -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding expected required capability {} from bundle({}:{}) to startup component {}.", new Object[]{capability.getName(), capability.getBundle().getSymbolicName(), capability.getBundle().getVersion(), startupComponent.getName()});
                }
                String componentName = startupComponent.getName();
                this.addCapabilityToComponent(componentName, capability);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAvailableRequiredCapability(Capability capability) {
        String capabilityName = capability.getName();
        String string = capabilityName.intern();
        synchronized (string) {
            this.capabilityToComponentMap.get(capabilityName).stream().forEach(startupComponent -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding available required capability {} from bundle({}:{}) to startup component {}.", new Object[]{capability.getName(), capability.getBundle().getSymbolicName(), capability.getBundle().getVersion(), startupComponent.getName()});
                }
                String componentName = startupComponent.getName();
                this.addCapabilityToComponent(componentName, capability);
            });
        }
    }

    List<StartupComponent> getPendingComponents() {
        return this.pendingCapabilityMap.keySet().stream().filter(componentName -> this.getPendingProvideCapabilityList((String)componentName).size() != 0 || this.startupComponentMap.get(componentName).getListener() == null || this.getPendingCapabilityProviderList((String)componentName).size() != 0).map(componentName -> this.startupComponentMap.get(componentName)).collect(Collectors.toList());
    }

    List<StartupComponent> getSatisfiableComponents() {
        return this.pendingCapabilityMap.keySet().stream().filter(componentName -> this.getPendingProvideCapabilityList((String)componentName).size() == 0).filter(componentName -> this.startupComponentMap.get(componentName).getListener() != null).filter(componentName -> this.getPendingCapabilityProviderList((String)componentName).size() == 0).map(componentName -> this.startupComponentMap.get(componentName)).collect(Collectors.toList());
    }

    void removeSatisfiedComponent(StartupComponent startupComponent) {
        this.startupComponentMap.remove(startupComponent.getName());
        this.pendingCapabilityMap.remove(startupComponent.getName());
    }

    List<StartupComponent> getPendingRequiredCapabilityListeners() {
        return this.startupComponentMap.values().stream().filter(startupComponent -> startupComponent.getListener() == null).collect(Collectors.toList());
    }

    List<CapabilityProviderCapability> getPendingCapabilityProviderList() {
        return this.pendingCapabilityProviderMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    List<Capability> getPendingProvideCapabilityList(String componentName) {
        return this.pendingCapabilityMap.get(componentName);
    }

    private void addComponentInternal(StartupComponent startupComponent) {
        String componentName = startupComponent.getName();
        if (this.startupComponentMap.get(componentName) != null) {
            StartupComponent existingComponent = this.startupComponentMap.get(componentName);
            logger.warn("Duplicate Startup-Component detected. Existing Startup-Component {} from bundle({}:{}). New Startup-Component {} from bundle({}:{}).", new Object[]{existingComponent.getName(), existingComponent.getBundle().getSymbolicName(), existingComponent.getBundle().getVersion(), startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding startup component {} from bundle({}:{})", new Object[]{componentName, startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
        }
        this.startupComponentMap.put(componentName, startupComponent);
        this.pendingCapabilityMap.put(componentName, new ArrayList());
        startupComponent.getRequiredServiceList().forEach(requiredCapabilityName -> {
            logger.debug("Startup component {} depends on OSGi Service capability {}", (Object)startupComponent.getName(), requiredCapabilityName);
            this.updateCapabilityToComponentMap(startupComponent, (String)requiredCapabilityName);
        });
    }

    private List<CapabilityProviderCapability> getPendingCapabilityProviderList(String componentName) {
        return this.startupComponentMap.get(componentName).getRequiredServiceList().stream().filter(requiredCapability -> this.pendingCapabilityProviderMap.get(requiredCapability) != null).flatMap(requiredCapability -> this.pendingCapabilityProviderMap.get(requiredCapability).stream()).collect(Collectors.toList());
    }

    private void addCapabilityToComponent(String componentName, Capability capability) {
        List<Capability> pendingCapabilityList = this.pendingCapabilityMap.get(componentName);
        if (pendingCapabilityList != null) {
            if (pendingCapabilityList.contains(capability)) {
                pendingCapabilityList.remove(capability);
            } else {
                pendingCapabilityList.add(capability);
            }
        } else {
            pendingCapabilityList = new ArrayList<Capability>();
            pendingCapabilityList.add(capability);
            this.pendingCapabilityMap.put(componentName, pendingCapabilityList);
        }
        logger.debug("Required Capability count of component {}: {}", (Object)componentName, (Object)pendingCapabilityList.size());
    }

    private void updateCapabilityToComponentMap(StartupComponent startupComponent, String requiredCapabilityName) {
        if (this.capabilityToComponentMap.containsKey(requiredCapabilityName)) {
            this.capabilityToComponentMap.get(requiredCapabilityName).add(startupComponent);
        } else {
            ArrayList<StartupComponent> componentList = new ArrayList<StartupComponent>();
            componentList.add(startupComponent);
            this.capabilityToComponentMap.put(requiredCapabilityName, componentList);
        }
    }
}

