/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.kafka.KafkaEventAdapter;

public class KafkaEventAdapterFactory
extends OutputEventAdapterFactory {
    private static final Log log = LogFactory.getLog(KafkaEventAdapterFactory.class);
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.kafka.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "kafka";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("text");
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property webKafkaConnect = new Property("meta.broker.list");
        webKafkaConnect.setDisplayName(this.resourceBundle.getString("meta.broker.list"));
        webKafkaConnect.setHint(this.resourceBundle.getString("meta.broker.list.hint"));
        webKafkaConnect.setRequired(true);
        propertyList.add(webKafkaConnect);
        Property optionConfigProperties = new Property("optional.configuration");
        optionConfigProperties.setDisplayName(this.resourceBundle.getString("optional.configuration"));
        optionConfigProperties.setHint(this.resourceBundle.getString("optional.configuration.hint"));
        propertyList.add(optionConfigProperties);
        return propertyList;
    }

    public List<Property> getDynamicPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property webTopic = new Property("topic");
        webTopic.setDisplayName(this.resourceBundle.getString("topic"));
        webTopic.setRequired(true);
        propertyList.add(webTopic);
        return propertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new KafkaEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

