/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.kafka;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public class KafkaEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(KafkaEventAdapter.class);
    private static ThreadPoolExecutor threadPoolExecutor;
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private ProducerConfig config;
    private Producer<String, Object> producer;
    private int tenantId;

    public KafkaEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (threadPoolExecutor == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            threadPoolExecutor = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize), new ThreadFactoryBuilder().setNameFormat("KafkaOutput-" + this.eventAdapterConfiguration.getName() + "-executor-thread-%d").build());
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
        String[] optionalProperties;
        Map staticProperties = this.eventAdapterConfiguration.getStaticProperties();
        String kafkaConnect = (String)staticProperties.get("meta.broker.list");
        String optionalConfigs = (String)staticProperties.get("optional.configuration");
        Properties props = new Properties();
        props.put("metadata.broker.list", kafkaConnect);
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        if (optionalConfigs != null && (optionalProperties = optionalConfigs.split(",")) != null && optionalProperties.length > 0) {
            for (String header : optionalProperties) {
                try {
                    String[] configPropertyWithValue = header.split(":", 2);
                    props.put(configPropertyWithValue[0], configPropertyWithValue[1]);
                }
                catch (Exception e) {
                    log.warn((Object)("Optional property '" + header + "' is not defined in the correct format."), (Throwable)e);
                }
            }
        }
        this.config = new ProducerConfig(props);
        this.producer = new Producer(this.config);
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        String topic = dynamicProperties.get("topic");
        try {
            threadPoolExecutor.submit(new KafkaSender(topic, message));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    class KafkaSender
    implements Runnable {
        String topic;
        Object message;

        KafkaSender(String topic, Object message) {
            this.topic = topic;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                KeyedMessage data = new KeyedMessage(this.topic, (Object)this.message.toString());
                KafkaEventAdapter.this.producer.send(data);
            }
            catch (Throwable e) {
                log.error((Object)("Unexpected error when sending event via Kafka Output Adatper:" + e.getMessage()), e);
            }
        }
    }
}

