/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;

public class StringStartsWith<O, A extends CharSequence>
extends SimpleQuery<O, A> {
    private final Attribute<O, A> attribute;
    private final A value;

    public StringStartsWith(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.attribute = attribute;
        this.value = value;
    }

    public A getValue() {
        return this.value;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        CharSequence attributeValue = (CharSequence)attribute.getValue(object, queryOptions);
        return this.matchesValue(attributeValue, queryOptions);
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (CharSequence attributeValue : attribute.getValues(object, queryOptions)) {
            if (!this.matchesValue(attributeValue, queryOptions)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesValue(A aValue, QueryOptions queryOptions) {
        int charsMatched = 0;
        int length = Math.min(aValue.length(), this.value.length());
        for (int i = 0; i < length && aValue.charAt(i) == this.value.charAt(i); ++i) {
            ++charsMatched;
        }
        return charsMatched == this.value.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringStartsWith)) {
            return false;
        }
        StringStartsWith that = (StringStartsWith)o;
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "startsWith(" + StringStartsWith.asLiteral(super.getAttributeName()) + ", " + StringStartsWith.asLiteral(this.value) + ")";
    }
}

