/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;

public class Equal<O, A>
extends SimpleQuery<O, A> {
    private final A value;

    public Equal(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.value = value;
    }

    public A getValue() {
        return this.value;
    }

    public String toString() {
        return "equal(" + Equal.asLiteral(super.getAttributeName()) + ", " + Equal.asLiteral(this.value) + ")";
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        return this.value.equals(attribute.getValue(object, queryOptions));
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (A attributeValue : attribute.getValues(object, queryOptions)) {
            if (!this.value.equals(attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Equal)) {
            return false;
        }
        Equal equal = (Equal)o;
        if (!this.attribute.equals(equal.attribute)) {
            return false;
        }
        return this.value.equals(equal.value);
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

