/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.logical;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.logical.LogicalQuery;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collection;
import java.util.Iterator;

public class And<O>
extends LogicalQuery<O> {
    private final Collection<Query<O>> childQueries;

    public And(Collection<Query<O>> childQueries) {
        super(childQueries);
        if (this.size() < 2) {
            throw new IllegalStateException("An 'And' query cannot have fewer than 2 child queries, " + childQueries.size() + " were supplied");
        }
        this.childQueries = childQueries;
    }

    @Override
    public boolean matches(O object, QueryOptions queryOptions) {
        for (Query query : super.getSimpleQueries()) {
            if (query.matches(object, queryOptions)) continue;
            return false;
        }
        for (Query<O> query : super.getLogicalQueries()) {
            if (query.matches(object, queryOptions)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof And)) {
            return false;
        }
        And and = (And)o;
        return this.childQueries.equals(and.childQueries);
    }

    @Override
    protected int calcHashCode() {
        return this.childQueries.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("and(");
        Iterator<Query<O>> iterator = this.childQueries.iterator();
        while (iterator.hasNext()) {
            Query<O> childQuery = iterator.next();
            sb.append(childQuery);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

