/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.quantizer;

import com.googlecode.cqengine.quantizer.Quantizer;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalQuantizer {
    BigDecimalQuantizer() {
    }

    public static Quantizer<BigDecimal> withCompressionFactor(int compressionFactor) {
        return compressionFactor < 2 ? new TruncatingQuantizer() : new TruncatingAndCompressingQuantizer(compressionFactor);
    }

    static class TruncatingQuantizer
    implements Quantizer<BigDecimal> {
        TruncatingQuantizer() {
        }

        @Override
        public BigDecimal getQuantizedValue(BigDecimal attributeValue) {
            return attributeValue.setScale(0, RoundingMode.DOWN);
        }
    }

    static class TruncatingAndCompressingQuantizer
    implements Quantizer<BigDecimal> {
        private final BigDecimal compressionFactor;

        public TruncatingAndCompressingQuantizer(int compressionFactor) {
            if (compressionFactor < 2) {
                throw new IllegalArgumentException("Invalid compression factor, must be >= 2: " + compressionFactor);
            }
            this.compressionFactor = BigDecimal.valueOf(compressionFactor);
        }

        @Override
        public BigDecimal getQuantizedValue(BigDecimal attributeValue) {
            return attributeValue.divideToIntegralValue(this.compressionFactor).multiply(this.compressionFactor).setScale(0, RoundingMode.DOWN);
        }
    }
}

