/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.sqlite;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.engine.QueryEngine;
import com.googlecode.cqengine.index.AttributeIndex;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.sqlite.SQLiteIndex;
import com.googlecode.cqengine.index.sqlite.SQLitePersistence;
import com.googlecode.cqengine.index.support.CloseableIterable;
import com.googlecode.cqengine.index.support.KeyStatistics;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.NonHeapTypeIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;

public abstract class SimplifiedSQLiteIndex<A extends Comparable<A>, O, K extends Comparable<K>>
implements SortedKeyStatisticsAttributeIndex<A, O>,
NonHeapTypeIndex {
    final Class<? extends SQLitePersistence> persistenceType;
    final Attribute<O, A> attribute;
    final String tableNameSuffix;
    volatile SQLiteIndex<A, O, K> backingIndex;

    protected SimplifiedSQLiteIndex(Class<? extends SQLitePersistence<O, A>> persistenceType, Attribute<O, A> attribute, String tableNameSuffix) {
        this.persistenceType = persistenceType;
        this.attribute = attribute;
        this.tableNameSuffix = tableNameSuffix;
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        Persistence<O, K> persistence = SimplifiedSQLiteIndex.getPersistenceFromQueryOptions(queryOptions);
        QueryEngine<O> queryEngine = SimplifiedSQLiteIndex.getQueryEngineFromQueryOptions(queryOptions);
        final SimpleAttribute<O, K> primaryKeyAttribute = this.getPrimaryKeyFromPersistence(persistence);
        final AttributeIndex<K, O> primaryKeyIndex = this.getPrimaryKeyIndexFromQueryEngine(primaryKeyAttribute, queryEngine, queryOptions);
        SimpleAttribute foreignKeyAttribute = new SimpleAttribute<K, O>(primaryKeyAttribute.getAttributeType(), primaryKeyAttribute.getObjectType()){

            @Override
            public O getValue(K primaryKeyValue, QueryOptions queryOptions) {
                return primaryKeyIndex.retrieve(QueryFactory.equal(primaryKeyAttribute, primaryKeyValue), queryOptions).uniqueResult();
            }
        };
        this.backingIndex = new SQLiteIndex<A, O, K>(this.attribute, primaryKeyAttribute, foreignKeyAttribute, this.tableNameSuffix){

            @Override
            public Index<O> getEffectiveIndex() {
                return SimplifiedSQLiteIndex.this.getEffectiveIndex();
            }
        };
        this.backingIndex.init(objectStore, queryOptions);
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    static <O, K extends Comparable<K>> Persistence<O, K> getPersistenceFromQueryOptions(QueryOptions queryOptions) {
        Persistence persistence = queryOptions.get(Persistence.class);
        if (persistence == null) {
            throw new IllegalStateException("A required Persistence object was not supplied in query options");
        }
        return persistence;
    }

    static <O> QueryEngine<O> getQueryEngineFromQueryOptions(QueryOptions queryOptions) {
        QueryEngine queryEngine = queryOptions.get(QueryEngine.class);
        if (queryEngine == null) {
            throw new IllegalStateException("The QueryEngine was not supplied in query options");
        }
        return queryEngine;
    }

    SimpleAttribute<O, K> getPrimaryKeyFromPersistence(Persistence<O, K> persistence) {
        SimpleAttribute<O, K> primaryKey = persistence.getPrimaryKeyAttribute();
        if (primaryKey == null) {
            throw new IllegalStateException("This index " + this.getClass().getSimpleName() + " on attribute '" + this.attribute.getAttributeName() + "' cannot be added to the IndexedCollection, because the configured persistence was not configured with a primary key attribute.");
        }
        return primaryKey;
    }

    AttributeIndex<K, O> getPrimaryKeyIndexFromQueryEngine(SimpleAttribute<O, K> primaryKeyAttribute, QueryEngine<O> queryEngine, QueryOptions queryOptions) {
        for (Index<O> index : queryEngine.getIndexes()) {
            AttributeIndex attributeIndex;
            if (!(index instanceof AttributeIndex) || !primaryKeyAttribute.equals((attributeIndex = (AttributeIndex)index).getAttribute()) || !attributeIndex.supportsQuery(QueryFactory.equal(primaryKeyAttribute, null), queryOptions)) continue;
            return attributeIndex;
        }
        throw new IllegalStateException("This index " + this.getClass().getSimpleName() + " on attribute '" + this.attribute.getAttributeName() + "' cannot be added to the IndexedCollection yet, because it requires that an index on the primary key to be added first.");
    }

    SQLiteIndex<A, O, K> backingIndex() {
        SQLiteIndex<A, O, K> backingIndex = this.backingIndex;
        if (backingIndex == null) {
            throw new IllegalStateException("This index can only be used after it has been added to an IndexedCollection");
        }
        return backingIndex;
    }

    @Override
    public Attribute<O, A> getAttribute() {
        return this.attribute;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        return this.backingIndex().supportsQuery(query, queryOptions);
    }

    @Override
    public boolean isQuantized() {
        return this.backingIndex().isQuantized();
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        return this.backingIndex().retrieve(query, queryOptions);
    }

    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        return this.backingIndex().addAll(objectSet, queryOptions);
    }

    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        return this.backingIndex().removeAll(objectSet, queryOptions);
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.backingIndex().clear(queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(QueryOptions queryOptions) {
        return this.backingIndex().getDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.backingIndex().getDistinctKeys(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(QueryOptions queryOptions) {
        return this.backingIndex().getDistinctKeysDescending(queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.backingIndex().getDistinctKeysDescending(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    @Override
    public Integer getCountForKey(A key, QueryOptions queryOptions) {
        return this.backingIndex().getCountForKey(key, queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeysDescending(QueryOptions queryOptions) {
        return this.backingIndex().getStatisticsForDistinctKeysDescending(queryOptions);
    }

    @Override
    public Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        return this.backingIndex().getCountOfDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        return this.backingIndex().getStatisticsForDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(QueryOptions queryOptions) {
        return this.backingIndex().getKeysAndValues(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.backingIndex().getKeysAndValues(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(QueryOptions queryOptions) {
        return this.backingIndex().getKeysAndValuesDescending(queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.backingIndex().getKeysAndValuesDescending(lowerBound, lowerInclusive, upperBound, upperInclusive, queryOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplifiedSQLiteIndex that = (SimplifiedSQLiteIndex)o;
        return this.attribute.equals(that.attribute);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 31 * result + this.attribute.hashCode();
        return result;
    }
}

