/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine;

import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.engine.CollectionQueryEngine;
import com.googlecode.cqengine.engine.QueryEngineInternal;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.CloseableRequestResources;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.onheap.OnHeapPersistence;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.persistence.support.ObjectStoreAsSet;
import com.googlecode.cqengine.persistence.support.PersistenceFlags;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.FlagsEnabled;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.closeable.CloseableResultSet;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class ConcurrentIndexedCollection<O>
implements IndexedCollection<O> {
    protected final Persistence<O, ?> persistence;
    protected final ObjectStore<O> objectStore;
    protected final QueryEngineInternal<O> indexEngine;

    public ConcurrentIndexedCollection() {
        this(OnHeapPersistence.withoutPrimaryKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentIndexedCollection(Persistence<O, ? extends Comparable> persistence) {
        this.persistence = persistence;
        this.objectStore = persistence.createObjectStore();
        CollectionQueryEngine<O> queryEngine = new CollectionQueryEngine<O>();
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            queryEngine.init(this.objectStore, queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
        this.indexEngine = queryEngine;
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query) {
        final QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        ConcurrentIndexedCollection.flagAsReadRequest(queryOptions);
        ResultSet<O> results = this.indexEngine.retrieve(query, queryOptions);
        return new CloseableResultSet<O>(results, query, queryOptions){

            @Override
            public void close() {
                super.close();
                ConcurrentIndexedCollection.this.closeRequestScopeResourcesIfNecessary(queryOptions);
            }
        };
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        final QueryOptions queryOptionsOpened = this.openRequestScopeResourcesIfNecessary(queryOptions);
        ConcurrentIndexedCollection.flagAsReadRequest(queryOptionsOpened);
        ResultSet<O> results = this.indexEngine.retrieve(query, queryOptions);
        return new CloseableResultSet<O>(results, query, queryOptions){

            @Override
            public void close() {
                super.close();
                ConcurrentIndexedCollection.this.closeRequestScopeResourcesIfNecessary(queryOptionsOpened);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Iterable<O> objectsToRemove, Iterable<O> objectsToAdd) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean bl = this.update(objectsToRemove, objectsToAdd, queryOptions);
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Iterable<O> objectsToRemove, Iterable<O> objectsToAdd, QueryOptions queryOptions) {
        queryOptions = this.openRequestScopeResourcesIfNecessary(queryOptions);
        try {
            boolean modified = this.doRemoveAll(objectsToRemove, queryOptions);
            boolean bl = this.doAddAll(objectsToAdd, queryOptions) || modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public void addIndex(Index<O> index) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            this.indexEngine.addIndex(index, queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public void addIndex(Index<O> index, QueryOptions queryOptions) {
        queryOptions = this.openRequestScopeResourcesIfNecessary(queryOptions);
        try {
            this.indexEngine.addIndex(index, queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public Iterable<Index<O>> getIndexes() {
        return this.indexEngine.getIndexes();
    }

    @Override
    public int size() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            int n = this.objectStore.size(queryOptions);
            return n;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public boolean isEmpty() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean bl = this.objectStore.isEmpty(queryOptions);
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean bl = this.objectStore.contains(o, queryOptions);
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public Object[] toArray() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Object[] objectArray = this.getObjectStoreAsSet(queryOptions).toArray();
            return objectArray;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            T[] TArray = this.getObjectStoreAsSet(queryOptions).toArray(a);
            return TArray;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean bl = this.objectStore.containsAll(c, queryOptions);
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public CloseableIterator<O> iterator() {
        return new CloseableIterator<O>(){
            final QueryOptions queryOptions;
            private final CloseableIterator<O> collectionIterator;
            private O currentObject;
            {
                this.queryOptions = ConcurrentIndexedCollection.this.openRequestScopeResourcesIfNecessary(null);
                this.collectionIterator = ConcurrentIndexedCollection.this.objectStore.iterator(this.queryOptions);
                this.currentObject = null;
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.collectionIterator.hasNext();
                if (!hasNext) {
                    this.close();
                }
                return hasNext;
            }

            @Override
            public O next() {
                Object next = this.collectionIterator.next();
                this.currentObject = next;
                return next;
            }

            @Override
            public void remove() {
                this.collectionIterator.remove();
                ConcurrentIndexedCollection.this.indexEngine.removeAll(ObjectSet.fromCollection(Collections.singleton(this.currentObject)), this.queryOptions);
            }

            @Override
            public void close() {
                CloseableRequestResources.closeQuietly(this.collectionIterator);
                ConcurrentIndexedCollection.this.closeRequestScopeResourcesIfNecessary(this.queryOptions);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(O o) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean modified = this.objectStore.add(o, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(Collections.singleton(o)), queryOptions);
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Object o = object;
            boolean modified = this.objectStore.remove(o, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(Collections.singleton(o)), queryOptions);
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends O> c) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Collection<? extends O> objects = c;
            boolean modified = this.objectStore.addAll(objects, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(objects), queryOptions);
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Collection<?> objects = c;
            boolean modified = this.objectStore.removeAll(objects, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(objects), queryOptions);
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        boolean bl;
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        Iterator iterator = null;
        try {
            boolean modified = false;
            iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (c.contains(next)) continue;
                iterator.remove();
                modified = true;
            }
            bl = modified;
        }
        catch (Throwable throwable) {
            CloseableRequestResources.closeQuietly(iterator);
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
            throw throwable;
        }
        CloseableRequestResources.closeQuietly((Closeable)((Object)iterator));
        this.closeRequestScopeResourcesIfNecessary(queryOptions);
        return bl;
    }

    @Override
    public void clear() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            this.objectStore.clear(queryOptions);
            this.indexEngine.clear(queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    boolean doAddAll(Iterable<O> objects, QueryOptions queryOptions) {
        if (objects instanceof Collection) {
            Collection c = (Collection)objects;
            boolean modified = this.objectStore.addAll(c, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(c), queryOptions);
            return modified;
        }
        boolean modified = false;
        for (O object : objects) {
            boolean added = this.objectStore.add(object, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(Collections.singleton(object)), queryOptions);
            modified = added || modified;
        }
        return modified;
    }

    boolean doRemoveAll(Iterable<O> objects, QueryOptions queryOptions) {
        if (objects instanceof Collection) {
            Collection c = (Collection)objects;
            boolean modified = this.objectStore.removeAll(c, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(c), queryOptions);
            return modified;
        }
        boolean modified = false;
        for (O object : objects) {
            boolean removed = this.objectStore.remove(object, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(Collections.singleton(object)), queryOptions);
            modified = removed || modified;
        }
        return modified;
    }

    protected QueryOptions openRequestScopeResourcesIfNecessary(QueryOptions queryOptions) {
        if (queryOptions == null) {
            queryOptions = new QueryOptions();
        }
        if (!(this.persistence instanceof OnHeapPersistence)) {
            this.persistence.openRequestScopeResources(queryOptions);
        }
        queryOptions.put(Persistence.class, this.persistence);
        return queryOptions;
    }

    protected void closeRequestScopeResourcesIfNecessary(QueryOptions queryOptions) {
        if (!(this.persistence instanceof OnHeapPersistence)) {
            this.persistence.closeRequestScopeResources(queryOptions);
        }
    }

    protected ObjectStoreAsSet<O> getObjectStoreAsSet(QueryOptions queryOptions) {
        return new ObjectStoreAsSet<O>(this.objectStore, queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            if (this == o) {
                boolean bl = true;
                return bl;
            }
            if (!(o instanceof Set)) {
                boolean bl = false;
                return bl;
            }
            Set that = (Set)o;
            if (!this.getObjectStoreAsSet(queryOptions).equals(that)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public int hashCode() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            int n = this.getObjectStoreAsSet(queryOptions).hashCode();
            return n;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    public String toString() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            String string = this.getObjectStoreAsSet(queryOptions).toString();
            return string;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    protected static void flagAsReadRequest(QueryOptions queryOptions) {
        FlagsEnabled.forQueryOptions(queryOptions).add(PersistenceFlags.READ_REQUEST);
    }
}

