/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.auth.service.internal.AuthenticationServiceHolder;
import org.wso2.carbon.identity.auth.service.module.ResourceConfig;
import org.wso2.carbon.identity.auth.service.module.ResourceConfigKey;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class AuthConfigurationUtil {
    private static AuthConfigurationUtil authConfigurationUtil = new AuthConfigurationUtil();
    private Map<ResourceConfigKey, ResourceConfig> resourceConfigMap = new LinkedHashMap<ResourceConfigKey, ResourceConfig>();
    private Map<String, String> applicationConfigMap = new HashMap<String, String>();
    private List<String> intermediateCertCNList = new ArrayList<String>();
    private List<String> exemptedContextList = new ArrayList<String>();
    private boolean isIntermediateCertValidationEnabled = false;
    private static final String SECRET_ALIAS = "secretAlias";
    private static final String SECRET_ALIAS_NAMESPACE_URI = "http://org.wso2.securevault/configuration";
    private static final String SECRET_ALIAS_PREFIX = "svns";
    private String defaultAccess;
    private boolean isScopeValidationEnabled = true;
    private static final Log log = LogFactory.getLog(AuthConfigurationUtil.class);

    private AuthConfigurationUtil() {
    }

    public static AuthConfigurationUtil getInstance() {
        return authConfigurationUtil;
    }

    public ResourceConfig getSecuredConfig(ResourceConfigKey resourceConfigKey) {
        ResourceConfig resourceConfig = null;
        for (Map.Entry<ResourceConfigKey, ResourceConfig> entry : this.resourceConfigMap.entrySet()) {
            if (!entry.getKey().equals(resourceConfigKey)) continue;
            resourceConfig = entry.getValue();
            break;
        }
        return resourceConfig;
    }

    public void buildResourceAccessControlData() {
        OMElement resourceAccessControl = IdentityConfigParser.getInstance().getConfigElement("ResourceAccessControl");
        if (resourceAccessControl != null) {
            this.defaultAccess = resourceAccessControl.getAttributeValue(new QName("default-access"));
            this.isScopeValidationEnabled = !Boolean.parseBoolean(resourceAccessControl.getAttributeValue(new QName("disable-scope-validation")));
            Iterator resources = resourceAccessControl.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Resource"));
            if (resources != null) {
                while (resources.hasNext()) {
                    OMElement resource = (OMElement)resources.next();
                    ResourceConfig resourceConfig = new ResourceConfig();
                    String httpMethod = resource.getAttributeValue(new QName("http-method"));
                    String context = resource.getAttributeValue(new QName("context"));
                    String isSecured = resource.getAttributeValue(new QName("secured"));
                    String isCrossTenantAllowed = resource.getAttributeValue(new QName("cross-tenant"));
                    String allowedAuthHandlers = resource.getAttributeValue(new QName("allowed-auth-handlers"));
                    StringBuilder permissionBuilder = new StringBuilder();
                    Iterator permissionsIterator = resource.getChildrenWithName(new QName("Permissions"));
                    if (permissionsIterator != null) {
                        while (permissionsIterator.hasNext()) {
                            OMElement permissionElement = (OMElement)permissionsIterator.next();
                            String permission = permissionElement.getText();
                            if (StringUtils.isNotEmpty((String)permissionBuilder.toString()) && StringUtils.isNotEmpty((String)permission)) {
                                permissionBuilder.append(",");
                            }
                            if (!StringUtils.isNotEmpty((String)permission)) continue;
                            permissionBuilder.append(permission);
                        }
                    }
                    ArrayList<String> scopes = new ArrayList<String>();
                    Iterator scopesIterator = resource.getChildrenWithName(new QName("Scopes"));
                    if (scopesIterator != null) {
                        while (scopesIterator.hasNext()) {
                            OMElement scopeElement = (OMElement)scopesIterator.next();
                            scopes.add(scopeElement.getText());
                        }
                    }
                    resourceConfig.setContext(context);
                    resourceConfig.setHttpMethod(httpMethod);
                    if (StringUtils.isNotEmpty((String)isSecured) && (Boolean.TRUE.toString().equals(isSecured) || Boolean.FALSE.toString().equals(isSecured))) {
                        resourceConfig.setIsSecured(Boolean.parseBoolean(isSecured));
                    }
                    if (StringUtils.isNotEmpty((String)isCrossTenantAllowed) && (Boolean.TRUE.toString().equals(isCrossTenantAllowed) || Boolean.FALSE.toString().equals(isCrossTenantAllowed))) {
                        resourceConfig.setIsCrossTenantAllowed(Boolean.parseBoolean(isCrossTenantAllowed));
                    }
                    if (StringUtils.isBlank((String)allowedAuthHandlers)) {
                        allowedAuthHandlers = "all";
                    }
                    resourceConfig.setAllowedAuthHandlers(allowedAuthHandlers);
                    resourceConfig.setPermissions(permissionBuilder.toString());
                    resourceConfig.setScopes(scopes);
                    this.resourceConfigMap.put(new ResourceConfigKey(context, httpMethod), resourceConfig);
                }
            }
        }
    }

    public List<String> buildAllowedAuthenticationHandlers(String allowedAuthenticationHandlers) {
        ArrayList<String> allowedAuthHandlersList = new ArrayList<String>();
        if (StringUtils.equals((String)allowedAuthenticationHandlers, (String)"all")) {
            List<AuthenticationHandler> allAvailableAuthHandlers = AuthenticationServiceHolder.getInstance().getAuthenticationHandlers();
            for (AuthenticationHandler handler : allAvailableAuthHandlers) {
                allowedAuthHandlersList.add(handler.getName());
            }
        } else {
            String regex = "\\s*,\\s*";
            String[] allowedAuthHandlerNames = allowedAuthenticationHandlers.split(regex);
            allowedAuthHandlersList.addAll(Arrays.asList(allowedAuthHandlerNames));
        }
        return allowedAuthHandlersList;
    }

    public void buildClientAuthenticationHandlerControlData() {
        Iterator applications;
        OMElement resourceAccessControl = IdentityConfigParser.getInstance().getConfigElement("ClientAppAuthentication");
        if (resourceAccessControl != null && (applications = resourceAccessControl.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Application"))) != null) {
            while (applications.hasNext()) {
                OMElement resource = (OMElement)applications.next();
                SecretResolver secretResolver = SecretResolverFactory.create((OMElement)resource, (boolean)true);
                String appName = resource.getAttributeValue(new QName("name"));
                String hash = resource.getAttributeValue(new QName("hash"));
                String secretAlias = resource.getAttributeValue(new QName(SECRET_ALIAS_NAMESPACE_URI, SECRET_ALIAS, SECRET_ALIAS_PREFIX));
                hash = StringUtils.isNotBlank((String)secretAlias) ? MiscellaneousUtil.resolve((String)secretAlias, (SecretResolver)secretResolver) : MiscellaneousUtil.resolve((String)hash, (SecretResolver)secretResolver);
                this.applicationConfigMap.put(appName, hash);
            }
        }
    }

    public void buildIntermediateCertValidationConfigData() {
        OMElement intermediateCertValidationElement = IdentityConfigParser.getInstance().getConfigElement("IntermediateCertValidation");
        if (intermediateCertValidationElement != null) {
            this.isIntermediateCertValidationEnabled = Boolean.parseBoolean(intermediateCertValidationElement.getAttributeValue(new QName("enable")));
            if (this.isIntermediateCertValidationEnabled) {
                OMElement exemptContextElement;
                Iterator contexts;
                OMElement intermediateCertsElement = intermediateCertValidationElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "IntermediateCerts"));
                Iterator certs = intermediateCertsElement.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "CertCN"));
                if (certs != null) {
                    while (certs.hasNext()) {
                        OMElement certCNElement = (OMElement)certs.next();
                        this.intermediateCertCNList.add(certCNElement.getText());
                    }
                }
                if ((contexts = (exemptContextElement = intermediateCertValidationElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "ExemptContext"))).getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Context"))) != null) {
                    while (contexts.hasNext()) {
                        OMElement contextElement = (OMElement)contexts.next();
                        this.exemptedContextList.add(contextElement.getText());
                    }
                }
            }
        }
    }

    public String getClientAuthenticationHash(String appName) {
        return this.applicationConfigMap.get(appName);
    }

    public boolean isIntermediateCertValidationEnabled() {
        return this.isIntermediateCertValidationEnabled;
    }

    public List<String> getIntermediateCertCNList() {
        return this.intermediateCertCNList;
    }

    public List<String> getExemptedContextList() {
        return this.exemptedContextList;
    }

    public String getDefaultAccess() {
        return this.defaultAccess;
    }

    public boolean isScopeValidationEnabled() {
        if (log.isDebugEnabled()) {
            if (this.isScopeValidationEnabled) {
                log.debug((Object)"Scope validation for internal resources is enabled.");
            } else {
                log.debug((Object)"Scope validation for internal resources is disabled.");
            }
        }
        return this.isScopeValidationEnabled;
    }

    public static boolean isAuthHeaderMatch(MessageContext messageContext, String authHeaderIdentifier) {
        AuthenticationContext authenticationContext;
        if (messageContext instanceof AuthenticationContext && (authenticationContext = (AuthenticationContext)messageContext).getAuthenticationRequest() != null) {
            String authorizationHeader = authenticationContext.getAuthenticationRequest().getHeader("Authorization");
            if (StringUtils.isBlank((String)authorizationHeader)) {
                return false;
            }
            String[] splitAuthorizationHeader = authorizationHeader.split(" ");
            return splitAuthorizationHeader.length > 0 && StringUtils.isNotEmpty((String)splitAuthorizationHeader[0]) && authHeaderIdentifier.equals(splitAuthorizationHeader[0]);
        }
        return false;
    }
}

