/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.module;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceConfigKey {
    private String contextPath;
    private String httpMethod;
    private Pattern pattern;

    public ResourceConfigKey(String contextPath, String httpMethod) {
        this.contextPath = contextPath;
        this.httpMethod = httpMethod;
        this.pattern = Pattern.compile(contextPath);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConfigKey that = (ResourceConfigKey)o;
        Matcher matcher = this.pattern.matcher(that.contextPath);
        if (!matcher.matches()) {
            return false;
        }
        if (this.httpMethod.equalsIgnoreCase("all")) {
            return true;
        }
        return this.httpMethod.contains(that.httpMethod);
    }

    public int hashCode() {
        int result = this.contextPath.hashCode();
        result = 31 * result + this.httpMethod.hashCode();
        return result;
    }
}

