/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.auth.service.AuthenticationManager;
import org.wso2.carbon.identity.auth.service.factory.AuthenticationRequestBuilderFactory;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.auth.service.handler.ResourceHandler;
import org.wso2.carbon.identity.auth.service.handler.impl.BasicAuthenticationHandler;
import org.wso2.carbon.identity.auth.service.handler.impl.ClientAuthenticationHandler;
import org.wso2.carbon.identity.auth.service.handler.impl.ClientCertificateBasedAuthenticationHandler;
import org.wso2.carbon.identity.auth.service.handler.impl.OAuth2AccessTokenHandler;
import org.wso2.carbon.identity.auth.service.handler.impl.TomcatCookieAuthenticationHandler;
import org.wso2.carbon.identity.auth.service.internal.AuthenticationServiceHolder;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.core.handler.HandlerComparator;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.auth.service", immediate=true)
public class AuthenticationServiceComponent {
    private static final Log log = LogFactory.getLog(AuthenticationServiceComponent.class);

    @Activate
    protected void activate(ComponentContext cxt) {
        try {
            cxt.getBundleContext().registerService(AuthenticationHandler.class, (Object)new BasicAuthenticationHandler(), null);
            cxt.getBundleContext().registerService(AuthenticationHandler.class, (Object)new OAuth2AccessTokenHandler(), null);
            cxt.getBundleContext().registerService(AuthenticationHandler.class, (Object)new ClientCertificateBasedAuthenticationHandler(), null);
            cxt.getBundleContext().registerService(AuthenticationHandler.class, (Object)new ClientAuthenticationHandler(), null);
            cxt.getBundleContext().registerService(AuthenticationHandler.class, (Object)new TomcatCookieAuthenticationHandler(), null);
            cxt.getBundleContext().registerService(AuthenticationManager.class, (Object)AuthenticationManager.getInstance(), null);
            cxt.getBundleContext().registerService(AuthenticationRequestBuilderFactory.class, (Object)AuthenticationRequestBuilderFactory.getInstance(), null);
            AuthConfigurationUtil.getInstance().buildResourceAccessControlData();
            AuthConfigurationUtil.getInstance().buildClientAuthenticationHandlerControlData();
            AuthConfigurationUtil.getInstance().buildIntermediateCertValidationConfigData();
            if (log.isDebugEnabled()) {
                log.debug((Object)"AuthenticatorService is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthenticatorService bundle is deactivated");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService acquired");
        }
        AuthenticationServiceHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        this.setRealmService(null);
    }

    @Reference(name="org.wso2.carbon.identity.auth.service.handler.auth", service=AuthenticationHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeAuthenticationHandler")
    protected void addAuthenticationHandler(AuthenticationHandler authenticationHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthenticationHandler acquired");
        }
        AuthenticationServiceHolder.getInstance().addAuthenticationHandler(authenticationHandler);
    }

    protected void removeAuthenticationHandler(AuthenticationHandler authenticationHandler) {
        AuthenticationServiceHolder.getInstance().getAuthenticationHandlers().remove((Object)authenticationHandler);
    }

    @Reference(name="org.wso2.carbon.identity.auth.service.handler.resource", service=ResourceHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeResourceHandler")
    protected void addResourceHandler(ResourceHandler resourceHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ResourceHandler acquired");
        }
        List<ResourceHandler> resourceHandlers = AuthenticationServiceHolder.getInstance().getResourceHandlers();
        resourceHandlers.add(resourceHandler);
        Collections.sort(resourceHandlers, new HandlerComparator());
    }

    protected void removeResourceHandler(ResourceHandler resourceHandler) {
        AuthenticationServiceHolder.getInstance().getResourceHandlers().remove((Object)resourceHandler);
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

