/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.handler.impl;

import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.catalina.connector.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class TomcatCookieAuthenticationHandler
extends AuthenticationHandler {
    private static final Log log = LogFactory.getLog(TomcatCookieAuthenticationHandler.class);

    public String getName() {
        return "TomcatCookieAuthentication";
    }

    public int getPriority(MessageContext messageContext) {
        return this.getPriority(messageContext, 500);
    }

    public boolean canHandle(MessageContext messageContext) {
        AuthenticationContext authenticationContext;
        if (messageContext instanceof AuthenticationContext && (authenticationContext = (AuthenticationContext)messageContext).getAuthenticationRequest() != null) {
            String cookie = authenticationContext.getAuthenticationRequest().getHeader("Cookie");
            return StringUtils.isNotEmpty((String)cookie) && cookie.startsWith("JSESSIONID");
        }
        return false;
    }

    @Override
    protected AuthenticationResult doAuthenticate(MessageContext messageContext) {
        String userName;
        Request request;
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationStatus.FAILED);
        AuthenticationContext authenticationContext = (AuthenticationContext)messageContext;
        if (this.servletRequestExists(authenticationContext) && this.isLoggedInUserExists(request = (Request)authenticationContext.getAuthenticationRequest().getAttribute(HTTPConstants.MC_HTTP_SERVLETREQUEST)) && StringUtils.isNotBlank((String)(userName = (String)request.getSession().getAttribute("wso2carbon.admin.logged.in")))) {
            String tenantDomain = (String)request.getSession().getAttribute("tenantDomain");
            User user = this.buildUser(userName, tenantDomain);
            authenticationContext.setUser(user);
            authenticationResult.setAuthenticationStatus(AuthenticationStatus.SUCCESS);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Tomcat Cookie Authentication success.");
            }
        }
        if (AuthenticationStatus.FAILED.equals((Object)authenticationResult.getAuthenticationStatus()) && log.isDebugEnabled()) {
            log.debug((Object)"Tomcat Cookie Authentication Failed.");
        }
        return authenticationResult;
    }

    private boolean isLoggedInUserExists(Request request) {
        return request != null && request.getSession() != null && request.getSession().getAttribute("wso2carbon.admin.logged.in") != null;
    }

    private User buildUser(String userName, String tenantDomain) {
        User user = new User();
        user.setUserName(MultitenantUtils.getTenantAwareUsername((String)userName));
        user.setTenantDomain(tenantDomain);
        return user;
    }

    private boolean servletRequestExists(AuthenticationContext authenticationContext) {
        Object request = authenticationContext.getAuthenticationRequest().getAttribute(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        return request != null && request instanceof Request;
    }
}

