/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.handler.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.wso2.carbon.identity.application.common.model.ProvisioningServiceProviderType;
import org.wso2.carbon.identity.application.common.model.ThreadLocalProvisioningServiceProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationRequest;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.OAuth2TokenValidationService;
import org.wso2.carbon.identity.oauth2.dto.OAuth2ClientApplicationDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.token.bindings.TokenBinding;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuth2AccessTokenHandler
extends AuthenticationHandler {
    private static final Log log = LogFactory.getLog(OAuth2AccessTokenHandler.class);
    private final String OAUTH_HEADER = "Bearer";
    private final String CONSUMER_KEY = "consumer-key";
    private final String SERVICE_PROVIDER = "serviceProvider";
    private final String SERVICE_PROVIDER_TENANT_DOMAIN = "serviceProviderTenantDomain";
    private final String SCIM_ME_ENDPOINT_URI = "scim2/me";

    @Override
    protected AuthenticationResult doAuthenticate(MessageContext messageContext) {
        String authorizationHeader;
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationStatus.FAILED);
        AuthenticationContext authenticationContext = (AuthenticationContext)messageContext;
        AuthenticationRequest authenticationRequest = authenticationContext.getAuthenticationRequest();
        if (authenticationRequest != null && StringUtils.isNotEmpty((String)(authorizationHeader = authenticationRequest.getHeader("Authorization"))) && authorizationHeader.startsWith("Bearer")) {
            String accessToken = null;
            String[] bearerToken = authorizationHeader.split(" ");
            if (bearerToken.length == 2) {
                accessToken = bearerToken[1];
            }
            OAuth2TokenValidationService oAuth2TokenValidationService = new OAuth2TokenValidationService();
            OAuth2TokenValidationRequestDTO requestDTO = new OAuth2TokenValidationRequestDTO();
            OAuth2TokenValidationRequestDTO.OAuth2AccessToken token = new OAuth2TokenValidationRequestDTO.OAuth2AccessToken(requestDTO);
            token.setIdentifier(accessToken);
            token.setTokenType("Bearer");
            requestDTO.setAccessToken(token);
            OAuth2TokenValidationRequestDTO.TokenValidationContextParam contextParam = new OAuth2TokenValidationRequestDTO.TokenValidationContextParam(requestDTO);
            contextParam.setKey("dummy");
            contextParam.setValue("dummy");
            OAuth2TokenValidationRequestDTO.TokenValidationContextParam[] contextParams = new OAuth2TokenValidationRequestDTO.TokenValidationContextParam[]{contextParam};
            requestDTO.setContext(contextParams);
            OAuth2ClientApplicationDTO clientApplicationDTO = oAuth2TokenValidationService.findOAuthConsumerIfTokenIsValid(requestDTO);
            OAuth2TokenValidationResponseDTO responseDTO = clientApplicationDTO.getAccessTokenValidationResponse();
            if (!responseDTO.isValid()) {
                return authenticationResult;
            }
            if (!this.isTokenBindingValid(messageContext, responseDTO.getTokenBinding(), clientApplicationDTO.getConsumerKey(), accessToken)) {
                return authenticationResult;
            }
            authenticationResult.setAuthenticationStatus(AuthenticationStatus.SUCCESS);
            if (StringUtils.isNotEmpty((String)responseDTO.getAuthorizedUser())) {
                User user = new User();
                String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)responseDTO.getAuthorizedUser());
                user.setUserName(UserCoreUtil.removeDomainFromName((String)tenantAwareUsername));
                user.setUserStoreDomain(UserCoreUtil.extractDomainFromName((String)tenantAwareUsername));
                user.setTenantDomain(MultitenantUtils.getTenantDomain((String)responseDTO.getAuthorizedUser()));
                authenticationContext.setUser(user);
            }
            authenticationContext.addParameter("consumer-key", clientApplicationDTO.getConsumerKey());
            authenticationContext.addParameter("oauth2-allowed-scopes", responseDTO.getScope());
            authenticationContext.addParameter("oauth2-validate-scopes", AuthConfigurationUtil.getInstance().isScopeValidationEnabled());
            String serviceProvider = null;
            try {
                serviceProvider = OAuth2Util.getServiceProvider((String)clientApplicationDTO.getConsumerKey()).getApplicationName();
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)("Error occurred while getting the Service Provider by Consumer key: " + clientApplicationDTO.getConsumerKey()));
            }
            String serviceProviderTenantDomain = null;
            try {
                serviceProviderTenantDomain = OAuth2Util.getTenantDomainOfOauthApp((String)clientApplicationDTO.getConsumerKey());
            }
            catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
                log.error((Object)("Error occurred while getting the OAuth App tenantDomain by Consumer key: " + clientApplicationDTO.getConsumerKey()));
            }
            if (serviceProvider != null) {
                authenticationContext.addParameter("serviceProvider", serviceProvider);
                if (serviceProviderTenantDomain != null) {
                    authenticationContext.addParameter("serviceProviderTenantDomain", serviceProviderTenantDomain);
                }
                MDC.put((String)"serviceProvider", (String)serviceProvider);
                this.setProvisioningServiceProviderThreadLocal(clientApplicationDTO.getConsumerKey(), serviceProviderTenantDomain);
            }
        }
        return authenticationResult;
    }

    public void init(InitConfig initConfig) {
    }

    public String getName() {
        return "OAuthAuthentication";
    }

    public boolean isEnabled(MessageContext messageContext) {
        return true;
    }

    public int getPriority(MessageContext messageContext) {
        return this.getPriority(messageContext, 25);
    }

    public boolean canHandle(MessageContext messageContext) {
        return AuthConfigurationUtil.isAuthHeaderMatch(messageContext, "Bearer");
    }

    private boolean isTokenBindingValid(MessageContext messageContext, TokenBinding tokenBinding, String clientId, String accessToken) {
        OAuthAppDO oAuthAppDO;
        if (tokenBinding == null || StringUtils.isBlank((String)tokenBinding.getBindingReference())) {
            return true;
        }
        try {
            oAuthAppDO = OAuth2Util.getAppInformationByClientId((String)clientId);
        }
        catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
            log.error((Object)("Failed to retrieve application information by client id: " + clientId), e);
            return false;
        }
        Request authenticationRequest = ((AuthenticationContext)messageContext).getAuthenticationRequest().getRequest();
        if (!oAuthAppDO.isTokenBindingValidationEnabled()) {
            if (authenticationRequest.getRequestURI().toLowerCase().endsWith("scim2/me") && this.isSSOSessionBasedTokenBinding(tokenBinding.getBindingType())) {
                this.setCurrentSessionIdThreadLocal(this.getTokenBindingValueFromAccessToken(accessToken));
            }
            return true;
        }
        if (OAuth2Util.isValidTokenBinding((TokenBinding)tokenBinding, (HttpServletRequest)authenticationRequest)) {
            if (authenticationRequest.getRequestURI().toLowerCase().endsWith("scim2/me") && this.isSSOSessionBasedTokenBinding(tokenBinding.getBindingType())) {
                this.setCurrentSessionIdThreadLocal(tokenBinding.getBindingValue());
            }
            return true;
        }
        return false;
    }

    private String getTokenBindingValueFromAccessToken(String accessToken) {
        String tokenBindingValue = null;
        try {
            AccessTokenDO accessTokenDO = OAuth2Util.findAccessToken((String)accessToken, (boolean)false);
            if (accessTokenDO != null && accessTokenDO.getTokenBinding() != null && StringUtils.isNotBlank((String)accessTokenDO.getTokenBinding().getBindingValue()) && this.isSSOSessionBasedTokenBinding(accessTokenDO.getTokenBinding().getBindingType())) {
                tokenBindingValue = accessTokenDO.getTokenBinding().getBindingValue();
            }
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error occurred while getting the access token from the token identifier", (Throwable)e);
        }
        return tokenBindingValue;
    }

    private void setCurrentSessionIdThreadLocal(String tokenBindingValue) {
        if (StringUtils.isNotBlank((String)tokenBindingValue)) {
            ((Map)IdentityUtil.threadLocalProperties.get()).put("currentSessionIdentifier", tokenBindingValue);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current session identifier: " + tokenBindingValue + " is added to thread local."));
            }
        }
    }

    private boolean isSSOSessionBasedTokenBinding(String tokenBindingType) {
        return "sso-session".equals(tokenBindingType);
    }

    private void setProvisioningServiceProviderThreadLocal(String oauthAppConsumerKey, String serviceProviderTenantDomain) {
        if (serviceProviderTenantDomain != null) {
            ThreadLocalProvisioningServiceProvider provisioningServiceProvider = new ThreadLocalProvisioningServiceProvider();
            provisioningServiceProvider.setServiceProviderName(oauthAppConsumerKey);
            provisioningServiceProvider.setServiceProviderType(ProvisioningServiceProviderType.OAUTH);
            provisioningServiceProvider.setTenantDomain(serviceProviderTenantDomain);
            IdentityApplicationManagementUtil.setThreadLocalProvisioningServiceProvider((ThreadLocalProvisioningServiceProvider)provisioningServiceProvider);
        }
    }
}

