/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.auth.service.handler.impl;

import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.exception.AuthClientException;
import org.wso2.carbon.identity.auth.service.exception.AuthServerException;
import org.wso2.carbon.identity.auth.service.exception.AuthenticationFailException;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ClientCertificateBasedAuthenticationHandler
extends AuthenticationHandler {
    private static final Log log = LogFactory.getLog(ClientCertificateBasedAuthenticationHandler.class);
    private static final String CLIENT_CERTIFICATE_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";
    private static final String USER_HEADER_NAME = "WSO2-Identity-User";
    private static final String CERTIFICATE_ATTRIBUTE_CN = "CN";

    public void init(InitConfig initConfig) {
    }

    public String getName() {
        return "ClientCertificate";
    }

    public int getPriority(MessageContext messageContext) {
        return this.getPriority(messageContext, 10);
    }

    public boolean canHandle(MessageContext messageContext) {
        AuthenticationContext authenticationContext;
        return messageContext instanceof AuthenticationContext && (authenticationContext = (AuthenticationContext)messageContext).getAuthenticationRequest() != null && authenticationContext.getAuthenticationRequest().getAttribute(CLIENT_CERTIFICATE_ATTRIBUTE_NAME) != null;
    }

    @Override
    protected AuthenticationResult doAuthenticate(MessageContext messageContext) throws AuthServerException, AuthenticationFailException, AuthClientException {
        AuthenticationContext authenticationContext;
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationStatus.FAILED);
        if (messageContext instanceof AuthenticationContext && (authenticationContext = (AuthenticationContext)messageContext).getAuthenticationRequest() != null && authenticationContext.getAuthenticationRequest().getAttribute(CLIENT_CERTIFICATE_ATTRIBUTE_NAME) != null) {
            String username = authenticationContext.getAuthenticationRequest().getHeader(USER_HEADER_NAME);
            if (this.requireIntermediateCertValidation(authenticationContext)) {
                String certIssuerCN;
                Object object = authenticationContext.getAuthenticationRequest().getAttribute(CLIENT_CERTIFICATE_ATTRIBUTE_NAME);
                if (!(object instanceof X509Certificate[])) {
                    throw new AuthenticationFailException("Exception while casting the X509Certificate.");
                }
                X509Certificate[] certificates = (X509Certificate[])object;
                if (certificates.length == 0) {
                    throw new AuthenticationFailException("X509Certificate object is null.");
                }
                X509Certificate cert = certificates[0];
                try {
                    username = this.getCN(cert.getSubjectDN().getName());
                }
                catch (InvalidNameException e) {
                    throw new AuthenticationFailException("Error occurred when retrieving cert CN.", e);
                }
                if (StringUtils.isBlank((String)username)) {
                    log.error((Object)"Authentication failed. Username retrieved from the certificate CN is empty.");
                    return authenticationResult;
                }
                try {
                    certIssuerCN = this.getCN(cert.getIssuerDN().getName());
                }
                catch (InvalidNameException e) {
                    throw new AuthenticationFailException("Error occurred when retrieving cert issuer CN.", e);
                }
                if (StringUtils.isEmpty((String)certIssuerCN) || !AuthConfigurationUtil.getInstance().getIntermediateCertCNList().contains(certIssuerCN)) {
                    log.error((Object)("Authentication failed for certificate issuer: " + certIssuerCN + " called by user: " + username + "."));
                    return authenticationResult;
                }
            }
            if (StringUtils.isNotEmpty((String)username)) {
                String superTenantSuffix;
                String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
                if ("carbon.super".equals(tenantDomain) && username.endsWith(superTenantSuffix = "@carbon.super")) {
                    username = username.substring(0, username.length() - superTenantSuffix.length());
                }
                User user = new User();
                user.setUserName(username);
                user.setTenantDomain(tenantDomain);
                authenticationContext.setUser(user);
                authenticationResult.setAuthenticationStatus(AuthenticationStatus.SUCCESS);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Client certificate based authentication was successful. Set '%s' as the user", username));
                }
            } else {
                authenticationResult.setAuthenticationStatus(AuthenticationStatus.SUCCESS);
            }
        }
        return authenticationResult;
    }

    private boolean requireIntermediateCertValidation(AuthenticationContext authenticationContext) {
        if (!AuthConfigurationUtil.getInstance().isIntermediateCertValidationEnabled()) {
            return false;
        }
        for (String context : AuthConfigurationUtil.getInstance().getExemptedContextList()) {
            if (!authenticationContext.getAuthenticationRequest().getContextPath().contains(context)) continue;
            return false;
        }
        return true;
    }

    private String getCN(String dn) throws InvalidNameException {
        LdapName ln = new LdapName(dn);
        for (Rdn rdn : ln.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase(CERTIFICATE_ATTRIBUTE_CN)) continue;
            return String.valueOf(rdn.getValue());
        }
        return "";
    }
}

